/**
 * Scriptaculous based Accordion.
 *
 * Version: 2.0
 * URL: http://www.stickmanlabs.com
 * Author: Kevin P Miller
 * License: Accordion is freely distributable under the terms of an MIT-style license.
 */
if (typeof Effect == 'undefined') {
  throw("accordion.js requires including script.aculo.us' effects.js library!");
}

var accordion = Class.create({
  //
  //  Setup the Variables
  //
  showAccordion : null,
  currentAccordion : null,
  duration : null,
  effects : [],
  animating : false,

  //
  //  Initialize the accordions
  //
  initialize: function(container, options) {
    if (!$(container)) {
      throw(container+" doesn't exist!");
    }

    this.options = Object.extend({
      resizeSpeed : 8,
      classNames : {
        toggle : 'accordion_toggle',
        toggleActive : 'accordion_toggle_active',
        content : 'accordion_content'
      },
      defaultSize : {
        height : null,
        width : null
      },
      direction : 'vertical',
      onEvent : 'click'
    }, options || {});

    this.duration = ((11-this.options.resizeSpeed)*0.15);

    var accordions = $$('#'+container+' .'+this.options.classNames.toggle);

    accordions.each(function(accordion) {
      Event.observe(accordion, this.options.onEvent, this.activate.bind(this, accordion), false);
      if (this.options.onEvent == 'click') {
        accordion.onclick = function() {return false;};
      }
      //EVE: it was option.merge({width: '0px'}); but is deprecated in prototype 1.6 and would have a strange behaviour so replaced by Object.extend
      if (this.options.direction == 'horizontal') {
        var options = {width: '0px'};
      } else {
        var options = {height: '0px'};
      }
      Object.extend(options, {display: 'none'});

      this.currentAccordion = $(accordion.next(0)).setStyle(options);
    }.bind(this));
  },

  //
  //  Activate an accordion
  //
  activate : function(accordion) {
    if (this.animating) {
      return false;
    }

    this.effects = [];

    this.currentAccordion = $(accordion.next(0));

    this.currentAccordion.setStyle({
      display: 'block'
    });

    this.currentAccordion.previous(0).addClassName(this.options.classNames.toggleActive);

    if (this.options.direction == 'horizontal') {
      this.scaling = {
        scaleX: true,
        scaleY: false
      };
    } else {
      this.scaling = {
        scaleX: false,
        scaleY: true
      };
    }
    if (this.currentAccordion == this.showAccordion) {
      this.deactivate();
    } else {
      this._handleAccordion();
    }
  },
  //
  // Deactivate an active accordion
  //
  deactivate : function() {
    var options = {
      duration: this.duration,
      scaleContent: false,
      transition: Effect.Transitions.sinoidal,
      queue: {
        position: 'end',
        scope: 'accordionAnimation'
      },
      scaleMode: {
        originalHeight: this.options.defaultSize.height ? this.options.defaultSize.height : this.currentAccordion.scrollHeight,
        originalWidth: this.options.defaultSize.width ? this.options.defaultSize.width : this.currentAccordion.scrollWidth
      },
      afterFinish: function() {
        this.showAccordion.setStyle({
          height: '0px', //EVE: it was height: auto; but flickered when opening content second time
          display: 'none'
        });
        this.showAccordion = null;
        this.animating = false;
      }.bind(this)
    };
    Object.extend(options, this.scaling);

    this.showAccordion.previous(0).removeClassName(this.options.classNames.toggleActive);

    new Effect.Scale(this.showAccordion, 0, options);
  },

  //
  // Handle the open/close actions of the accordion
  //
  _handleAccordion : function() {
    var options = {
      sync: true,
      scaleFrom: 0,
      scaleContent: false,
      transition: Effect.Transitions.sinoidal,
      scaleMode: {
        originalHeight: this.options.defaultSize.height ? this.options.defaultSize.height : this.currentAccordion.scrollHeight,
        originalWidth: this.options.defaultSize.width ? this.options.defaultSize.width : this.currentAccordion.scrollWidth
      }
    };
    Object.extend(options, this.scaling);

    this.effects.push(
      new Effect.Scale(this.currentAccordion, 100, options)
    );

    if (this.showAccordion) {
      this.showAccordion.previous(0).removeClassName(this.options.classNames.toggleActive);

      options = {
        sync: true,
        scaleContent: false,
        transition: Effect.Transitions.sinoidal
      };
      Object.extend(options, this.scaling);

      this.effects.push(
        new Effect.Scale(this.showAccordion, 0, options)
      );
    }

    new Effect.Parallel(this.effects, {
      duration: this.duration,
      queue: {
        position: 'end',
        scope: 'accordionAnimation'
      },
      beforeStart: function() {
        this.animating = true;
      }.bind(this),
      afterFinish: function() {
        if (this.showAccordion) {
          this.showAccordion.setStyle({
            display: 'none'
          });
        }
        /*$(this.currentAccordion).setStyle({
          height: 'auto'
          });*/ //EVE: without this commented, can't set a fixed height
        this.showAccordion = this.currentAccordion;
        this.animating = false;
      }.bind(this)
    });
  }
});

/**
 * XWiki wrapper to the Accordion above.
 * Used by several velocity templates and panels to create accordions.
 *
 * @param params Configuration parameters.
 * @return
 */
function createAccordion(params) {
  var acc = new accordion(params.div, {
    resizeSpeed: 10,
    classNames: {
      toggle: "accordionTabTitleBar",
      content: "accordionTabContentBox"
    },
    defaultSize: {
      width: ('width' in params ? params.width : null),
      height: ('height' in params ? params.height : null)
    }
  });
  acc.activate($$('#'+params.div+' .accordionTabTitleBar')[params.no]);
}
