/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ldap;

import com.novell.ldap.LDAPDN;
import com.novell.ldap.LDAPException;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.user.impl.xwiki.XWikiAuthServiceImpl;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.securityfilter.realm.SimplePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.contrib.ldap.XWikiLDAPConfig;
import org.xwiki.contrib.ldap.XWikiLDAPConnection;
import org.xwiki.contrib.ldap.XWikiLDAPSearchAttribute;
import org.xwiki.contrib.ldap.XWikiLDAPUtils;
import org.xwiki.text.StringUtils;

public class XWikiLDAPAuthServiceImpl
extends XWikiAuthServiceImpl {
    private static final String LDAP_DEFAULT_UID = "cn";
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiLDAPAuthServiceImpl.class);
    private static final String CONTEXT_CONFIGURATION = "ldap.configuration";
    private final ConcurrentMap<String, String> lockMap = new ConcurrentHashMap<String, String>();
    private Execution execution;

    protected ExecutionContext getExecutionContext() {
        if (this.execution == null) {
            this.execution = (Execution)Utils.getComponent(Execution.class);
        }
        return this.execution.getContext();
    }

    @Deprecated
    protected XWikiLDAPConfig initConfiguration(String authInput, XWikiContext xcontext) {
        return this.initConfiguration(authInput);
    }

    protected XWikiLDAPConfig initConfiguration(String authInput) {
        ExecutionContext econtext = this.getExecutionContext();
        if (econtext != null) {
            XWikiLDAPConfig configuration = this.createXWikiLDAPConfig(authInput);
            econtext.setProperty(CONTEXT_CONFIGURATION, (Object)configuration);
            return configuration;
        }
        return XWikiLDAPConfig.getInstance();
    }

    protected XWikiLDAPConfig createXWikiLDAPConfig(String authInput) {
        return new XWikiLDAPConfig(authInput);
    }

    protected void removeConfiguration() {
        ExecutionContext econtext = this.getExecutionContext();
        if (econtext != null) {
            econtext.removeProperty(CONTEXT_CONFIGURATION);
        }
    }

    protected XWikiLDAPConfig getConfiguration() {
        XWikiLDAPConfig configuration;
        ExecutionContext econtext = this.getExecutionContext();
        if (econtext != null && (configuration = (XWikiLDAPConfig)econtext.getProperty(CONTEXT_CONFIGURATION)) != null) {
            return configuration;
        }
        return XWikiLDAPConfig.getInstance();
    }

    public XWikiUser checkAuth(XWikiContext context) throws XWikiException {
        String httpHeader = this.getConfiguration().getHttpHeader();
        XWikiUser user = null;
        String remoteUser = StringUtils.isEmpty((CharSequence)httpHeader) ? context.getRequest().getRemoteUser() : context.getRequest().getHeader(httpHeader);
        if (remoteUser != null) {
            LOGGER.debug("REMOTE_USER: {}", (Object)remoteUser);
            user = this.checkAuthSSO(remoteUser, context);
        }
        if (user == null) {
            user = super.checkAuth(context);
        }
        LOGGER.debug("XWikiUser: {}", (Object)user);
        return user;
    }

    private Principal checkSessionPrincipal(String remoteUser, XWikiRequest request) {
        LOGGER.debug("Try to find principal in the session for remote user [{}]", (Object)remoteUser);
        Principal principal = (Principal)request.getSession().getAttribute(SecurityRequestWrapper.PRINCIPAL_SESSION_KEY);
        if (principal != null) {
            String storedRemoteUser = (String)request.getSession().getAttribute("ldap.remoteuser");
            if (remoteUser.equals(storedRemoteUser)) {
                return principal;
            }
            LOGGER.debug("  There is a principal in the sessions but it does not match remote user [{}] (stored remote user is [{}])", (Object)remoteUser, (Object)storedRemoteUser);
        } else {
            LOGGER.debug("  There is no principal at all in the session");
        }
        return null;
    }

    private XWikiUser checkAuthSSO(String remoteUser, XWikiContext context) {
        XWikiUser user;
        XWikiRequest request = context.getRequest();
        Principal principal = this.checkSessionPrincipal(remoteUser, request);
        if (principal == null) {
            principal = this.checkAuthSSOSync(remoteUser, request, context);
            if (principal == null) {
                return null;
            }
            request.getSession().setAttribute(SecurityRequestWrapper.PRINCIPAL_SESSION_KEY, (Object)principal);
            request.getSession().setAttribute("ldap.remoteuser", (Object)remoteUser);
            user = new XWikiUser(principal.getName());
        } else {
            user = new XWikiUser(principal.getName().startsWith(context.getWikiId()) ? principal.getName().substring(context.getWikiId().length() + 1) : principal.getName());
        }
        LOGGER.debug("XWikiUser = [{}]", (Object)user);
        this.removeConfiguration();
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Principal checkAuthSSOSync(String remoteUser, XWikiRequest request, XWikiContext context) {
        String lock = this.lockMap.putIfAbsent(remoteUser, remoteUser);
        if (lock == null) {
            lock = (String)this.lockMap.get(remoteUser);
        }
        String string = lock;
        synchronized (string) {
            Principal principal = this.checkSessionPrincipal(remoteUser, request);
            if (principal == null) {
                principal = this.ldapAuthenticate(remoteUser, null, true, false, context);
            }
            return principal;
        }
    }

    public Principal authenticate(String userId, String password, XWikiContext context) throws XWikiException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Starting LDAP authentication");
        }
        if (userId == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The provided user is null. We don't try to authenticate, it probably means the user is in non logged mode.");
            }
            return null;
        }
        if (userId.equals("")) {
            context.put((Object)"message", (Object)"nousername");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("LDAP authentication failed: login empty");
            }
            return null;
        }
        if (password == null || password.trim().equals("")) {
            context.put((Object)"message", (Object)"nopassword");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("LDAP authentication failed: password null or empty");
            }
            return null;
        }
        if (this.isSuperAdmin(userId)) {
            return this.authenticateSuperAdmin(password, context);
        }
        Principal principal = this.ldapAuthenticate(userId, password, false, true, context);
        if (principal == null) {
            principal = this.xwikiAuthenticate(userId, password, context);
        }
        if (LOGGER.isDebugEnabled()) {
            if (principal != null) {
                LOGGER.debug("LDAP authentication succeed with principal [{}]", (Object)principal.getName());
            } else {
                LOGGER.debug("LDAP authentication failed for user [{}]", (Object)userId);
            }
        }
        this.removeConfiguration();
        return principal;
    }

    @Deprecated
    protected String getValidXWikiUserName(String name) {
        return XWikiLDAPUtils.cleanXWikiUserPageName(name);
    }

    protected Principal ldapAuthenticate(String userId, String password, XWikiContext context) {
        Principal principal = this.ldapAuthenticate(userId, password, false, true, context);
        this.removeConfiguration();
        return principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Principal ldapAuthenticate(String userId, String password, boolean trusted, boolean compactPrincipal, XWikiContext context) {
        Principal principal;
        block9: {
            principal = null;
            try {
                principal = this.ldapAuthenticateInContext(userId, null, password, trusted, context, compactPrincipal);
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block9;
                LOGGER.debug("Local LDAP authentication failed.", (Throwable)e);
            }
        }
        if (principal == null && !context.isMainWiki()) {
            String db = context.getWikiId();
            try {
                context.setWikiId(context.getMainXWiki());
                try {
                    principal = this.ldapAuthenticateInContext(userId, null, password, trusted, context, false);
                }
                catch (Exception e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Global LDAP authentication failed.", (Throwable)e);
                    }
                }
            }
            finally {
                context.setWikiId(db);
            }
        }
        return principal;
    }

    protected Principal xwikiAuthenticate(String userId, String ldapPassword, XWikiContext context) throws XWikiException {
        Principal principal = null;
        String trylocal = this.getConfiguration().getLDAPParam("ldap_trylocal", "0");
        if ("1".equals(trylocal)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying authentication against XWiki DB");
            }
            principal = super.authenticate(userId, ldapPassword, context);
        }
        return principal;
    }

    protected Principal ldapAuthenticateInContext(String userId, String validXWikiUserName, String password, XWikiContext context) throws XWikiException, UnsupportedEncodingException, LDAPException {
        return this.ldapAuthenticateInContext(userId, validXWikiUserName, password, context, false);
    }

    protected Principal ldapAuthenticateInContext(String userId, String password, XWikiContext context) throws XWikiException, UnsupportedEncodingException, LDAPException {
        return this.ldapAuthenticateInContext(userId, password, context, false);
    }

    protected Principal ldapAuthenticateInContext(String userId, String password, XWikiContext context, boolean local) throws XWikiException, UnsupportedEncodingException, LDAPException {
        return this.ldapAuthenticateInContext(userId, null, password, context, local);
    }

    protected Principal ldapAuthenticateInContext(String userId, String validXWikiUserName, String password, XWikiContext context, boolean local) throws XWikiException, UnsupportedEncodingException, LDAPException {
        return this.ldapAuthenticateInContext(userId, validXWikiUserName, password, false, context, local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Principal ldapAuthenticateInContext(String authInput, String validXWikiUserName, String password, boolean trusted, XWikiContext context, boolean local) throws XWikiException, UnsupportedEncodingException, LDAPException {
        SimplePrincipal principal = null;
        String trimedAuthInput = authInput.trim();
        XWikiLDAPConfig configuration = this.initConfiguration(trimedAuthInput);
        XWikiLDAPConnection connector = new XWikiLDAPConnection(configuration);
        XWikiLDAPUtils ldapUtils = new XWikiLDAPUtils(connector, configuration);
        ldapUtils.setUidAttributeName(configuration.getLDAPParam("ldap_UID_attr", LDAP_DEFAULT_UID));
        ldapUtils.setGroupClasses(configuration.getGroupClasses());
        ldapUtils.setGroupMemberFields(configuration.getGroupMemberFields());
        ldapUtils.setBaseDN(configuration.getLDAPParam("ldap_base_DN", ""));
        ldapUtils.setUserSearchFormatString(configuration.getLDAPParam("ldap_user_search_fmt", "({0}={1})"));
        ldapUtils.setResolveSubgroups(configuration.getLDAPParamAsLong("ldap_group_sync_resolve_subgroups", 1L) == 1L);
        String uid = configuration.getMemoryConfiguration().get("uid");
        if (!configuration.isLDAPEnabled()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("LDAP authentication failed: LDAP not activ");
            }
            return principal;
        }
        if (!connector.open(trimedAuthInput, password, context)) {
            throw new XWikiException(8, 8001, "Bind to LDAP server failed.");
        }
        try {
            boolean isNewUser;
            String excludeGroupDN;
            String filterGroupDN;
            String bindDN;
            XWikiDocument userProfile = ldapUtils.getUserProfileByUid(validXWikiUserName, trimedAuthInput, context);
            if (userProfile == null && !trimedAuthInput.equals(uid) && this.getConfiguration().getTestLoginFor().contains(trimedAuthInput)) {
                userProfile = ldapUtils.getUserProfileByUid(validXWikiUserName, uid, context);
            }
            String ldapDn = null;
            String bindDNFormat = configuration.getLDAPBindDN();
            if (!bindDNFormat.equals(bindDN = configuration.getLDAPBindDN(trimedAuthInput, password)) && LDAPDN.isValid((String)bindDN)) {
                ldapDn = bindDN;
            }
            if ((filterGroupDN = configuration.getLDAPParam("ldap_user_group", "")).length() > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Checking if the user belongs to the user group: {}", (Object)filterGroupDN);
                }
                if ((ldapDn = ldapUtils.isInGroup(uid, ldapDn, filterGroupDN, context)) == null) {
                    throw new XWikiException(8, 8001, "LDAP user {0} does not belong to LDAP group {1}.", null, new Object[]{uid, filterGroupDN});
                }
            }
            if ((excludeGroupDN = configuration.getLDAPParam("ldap_exclude_group", "")).length() > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Checking if the user does not belongs to the exclude group: {}", (Object)excludeGroupDN);
                }
                if (ldapUtils.isInGroup(uid, ldapDn, excludeGroupDN, context) != null) {
                    throw new XWikiException(8, 8001, "LDAP user {0} should not belong to LDAP group {1}.", null, new Object[]{uid, filterGroupDN});
                }
            }
            List<XWikiLDAPSearchAttribute> searchAttributes = null;
            if (ldapDn == null && (searchAttributes = ldapUtils.searchUserAttributesByUid(uid, ldapUtils.getAttributeNameTable(context))) != null) {
                for (XWikiLDAPSearchAttribute searchAttribute : searchAttributes) {
                    if (!"dn".equals(searchAttribute.name)) continue;
                    ldapDn = searchAttribute.value;
                    break;
                }
            }
            if (ldapDn == null) {
                throw new XWikiException(8, 8001, "Can't find LDAP user DN for input [" + trimedAuthInput + "]");
            }
            if (!trusted) {
                if ("1".equals(configuration.getLDAPParam("ldap_validate_password", "0"))) {
                    String passwordField = configuration.getLDAPParam("ldap_password_field", "userPassword");
                    if (!connector.checkPassword(ldapDn, password, passwordField)) {
                        LOGGER.debug("Password comparison failed, are you really sure you need validate_password ? If you don't enable it, it does not mean user credentials are not validated. The goal of this property is to bypass standard LDAP bind which is usually bad unless you really know what you do.");
                        throw new XWikiException(8, 8001, "LDAP authentication failed: could not validate the password: wrong password for " + ldapDn);
                    }
                } else if (!ldapDn.equals(bindDN)) {
                    connector.bind(ldapDn, password);
                    connector.bind(bindDN, configuration.getLDAPBindPassword(trimedAuthInput, password));
                }
            }
            boolean bl = isNewUser = userProfile == null || userProfile.isNew();
            if (isNewUser) {
                userProfile = ldapUtils.getUserProfileByDn(validXWikiUserName, ldapDn, context);
                isNewUser = userProfile == null || userProfile.isNew();
            }
            userProfile = this.syncUser(userProfile, searchAttributes, ldapDn, trimedAuthInput, ldapUtils, context);
            principal = local ? new SimplePrincipal(userProfile.getFullName()) : new SimplePrincipal(userProfile.getPrefixedFullName());
            try {
                this.syncGroupsMembership(userProfile.getFullName(), ldapDn, isNewUser, ldapUtils, context);
            }
            catch (XWikiException e) {
                LOGGER.error("Failed to synchronise user's groups membership", (Throwable)e);
            }
        }
        finally {
            connector.close();
        }
        return principal;
    }

    protected XWikiDocument syncUser(XWikiDocument userProfile, List<XWikiLDAPSearchAttribute> searchAttributeListIn, String ldapDn, String authInput, XWikiLDAPUtils ldapUtils, XWikiContext context) throws XWikiException {
        return ldapUtils.syncUser(userProfile, searchAttributeListIn, ldapDn, authInput, context);
    }

    protected void syncGroupsMembership(String xwikiUserName, String ldapDn, boolean createuser, XWikiLDAPUtils ldapUtils, XWikiContext context) throws XWikiException {
        String syncmode;
        XWikiLDAPConfig configuration = this.getConfiguration();
        Map<String, Set<String>> groupMappings = configuration.getGroupMappings();
        if (groupMappings.size() > 0 && (!(syncmode = configuration.getLDAPParam("ldap_mode_group_sync", "always")).equalsIgnoreCase("create") || createuser)) {
            this.syncGroupsMembership(xwikiUserName, ldapDn, groupMappings, ldapUtils, context);
        }
    }

    protected void syncGroupsMembership(String xwikiUserName, String userDN, Map<String, Set<String>> groupMappings, XWikiLDAPUtils ldapUtils, XWikiContext context) throws XWikiException {
        ldapUtils.syncGroupsMembership(xwikiUserName, userDN, groupMappings, context);
    }
}

