/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.controls.LDAPPagedResultsControl;
import com.novell.ldap.controls.LDAPPagedResultsResponse;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.contrib.ldap.XWikiLDAPConnection;

public class PagedLDAPSearchResults
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagedLDAPSearchResults.class);
    private final XWikiLDAPConnection connection;
    private final String base;
    private final int scope;
    private final String filter;
    private final String[] attrs;
    private final boolean typesOnly;
    private final int pageSize;
    private LDAPSearchResults currentSearchResults;
    private boolean lastResult;

    public PagedLDAPSearchResults(XWikiLDAPConnection connection, String base, int scope, String filter, String[] attrs, boolean typesOnly, int pageSize) throws LDAPException {
        this.connection = connection;
        this.base = base;
        this.scope = scope;
        this.filter = filter;
        this.attrs = attrs;
        this.typesOnly = typesOnly;
        this.pageSize = pageSize;
        this.search(null);
    }

    private void search(byte[] cookie) throws LDAPException {
        LDAPPagedResultsControl control = new LDAPPagedResultsControl(this.pageSize, cookie, false);
        LDAPSearchConstraints constraints = new LDAPSearchConstraints(this.connection.getConnection().getConstraints());
        constraints.setControls((LDAPControl)control);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("LDAP pagined search: base=[{}] query=[{}] attrs=[{}] scope=[{}] typesOnly=[{}] pageSize=[{}], cookie=[{}]", new Object[]{this.base, this.filter, this.attrs != null ? Arrays.asList(this.attrs) : null, this.scope, this.typesOnly, this.pageSize, cookie != null ? Arrays.asList(new byte[][]{cookie}) : null});
        }
        this.currentSearchResults = this.connection.getConnection().search(this.base, this.scope, this.filter, this.attrs, this.typesOnly, constraints);
    }

    private LDAPSearchResults getCurrentLDAPSearchResults() throws LDAPException {
        if (!this.lastResult && !this.currentSearchResults.hasMore()) {
            LDAPControl[] controls = this.currentSearchResults.getResponseControls();
            if (controls != null) {
                for (LDAPControl resposeControl : controls) {
                    if (!(resposeControl instanceof LDAPPagedResultsResponse)) continue;
                    LDAPPagedResultsResponse pagedResponse = (LDAPPagedResultsResponse)resposeControl;
                    this.nextLDAPSearchResults(pagedResponse.getCookie());
                    return this.currentSearchResults;
                }
            }
            this.lastResult = true;
        }
        return this.currentSearchResults;
    }

    private void nextLDAPSearchResults(byte[] cookie) throws LDAPException {
        if (cookie != null) {
            this.search(cookie);
        } else {
            this.lastResult = true;
        }
    }

    public boolean hasMore() {
        LDAPSearchResults results;
        try {
            results = this.getCurrentLDAPSearchResults();
        }
        catch (LDAPException e) {
            return false;
        }
        return results.hasMore();
    }

    public LDAPEntry next() throws LDAPException {
        return this.getCurrentLDAPSearchResults().next();
    }

    @Override
    public void close() throws LDAPException {
        if (this.currentSearchResults != null) {
            this.connection.getConnection().abandon(this.currentSearchResults);
        }
    }
}

