/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPDN;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.rfc2251.RfcFilter;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.ElementInterface;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.web.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.contrib.ldap.LDAPDocumentHelper;
import org.xwiki.contrib.ldap.LDAPProfileXClass;
import org.xwiki.contrib.ldap.PagedLDAPSearchResults;
import org.xwiki.contrib.ldap.XWikiLDAPConfig;
import org.xwiki.contrib.ldap.XWikiLDAPConnection;
import org.xwiki.contrib.ldap.XWikiLDAPException;
import org.xwiki.contrib.ldap.XWikiLDAPSearchAttribute;
import org.xwiki.contrib.ldap.internal.LDAPGroupsCache;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.syntax.Syntax;

public class XWikiLDAPUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiLDAPUtils.class);
    private static final String LDAP_OBJECTCLASS = "objectClass";
    private static final String XWIKI_GROUP_MEMBERFIELD = "member";
    private static final String XWIKI_USER_SPACE = "XWiki";
    private static final String LDAP_DEFAULT_UID = "cn";
    private static final String LDAP_FIELD_DN = "dn";
    private final XWikiLDAPConnection connection;
    private final XWikiLDAPConfig configuration;
    private LDAPGroupsCache caches;
    private String uidAttributeName = "cn";
    private Collection<String> groupClasses = XWikiLDAPConfig.DEFAULT_GROUP_CLASSES;
    private Collection<String> groupMemberFields = XWikiLDAPConfig.DEFAULT_GROUP_MEMBERFIELDS;
    private String baseDN = "";
    private String userSearchFormatString = "({0}={1})";
    private boolean resolveSubgroups = true;

    @Deprecated
    public XWikiLDAPUtils(XWikiLDAPConnection connection) {
        this(connection, new XWikiLDAPConfig(null));
    }

    public XWikiLDAPUtils(XWikiLDAPConnection connection, XWikiLDAPConfig configuration) {
        this.connection = connection;
        this.configuration = configuration;
    }

    private LDAPGroupsCache getCaches() {
        if (this.caches == null) {
            this.caches = (LDAPGroupsCache)Utils.getComponent(LDAPGroupsCache.class);
        }
        return this.caches;
    }

    public void setUidAttributeName(String uidAttributeName) {
        this.uidAttributeName = uidAttributeName;
    }

    public String getUidAttributeName() {
        return this.uidAttributeName;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setUserSearchFormatString(String fmt) {
        this.userSearchFormatString = fmt;
    }

    public String getUserSearchFormatString() {
        return this.userSearchFormatString;
    }

    public void setGroupClasses(Collection<String> groupClasses) {
        this.groupClasses = groupClasses;
    }

    public Collection<String> getGroupClasses() {
        return this.groupClasses;
    }

    public void setGroupMemberFields(Collection<String> groupMemberFields) {
        this.groupMemberFields = groupMemberFields;
    }

    public Collection<String> getGroupMemberFields() {
        return this.groupMemberFields;
    }

    public boolean isResolveSubgroups() {
        return this.resolveSubgroups;
    }

    public void setResolveSubgroups(boolean resolveSubgroups) {
        this.resolveSubgroups = resolveSubgroups;
    }

    @Deprecated
    public Cache<Map<String, String>> getCache(CacheConfiguration configuration, XWikiContext context) throws CacheException {
        return this.getGroupCache(configuration, context);
    }

    public Cache<Map<String, String>> getGroupCache(CacheConfiguration configuration, XWikiContext context) throws CacheException {
        return this.getCaches().getGroupCache(this);
    }

    public static void resetGroupCache() {
        ((LDAPGroupsCache)Utils.getComponent(LDAPGroupsCache.class)).reset();
    }

    public XWikiLDAPConnection getConnection() {
        return this.connection;
    }

    public XWikiLDAPConfig getConfiguration() {
        return this.configuration;
    }

    private PagedLDAPSearchResults searchGroupsMembersByDN(String groupDN) throws LDAPException {
        String[] attrs = new String[2 + this.getGroupMemberFields().size()];
        int i = 0;
        attrs[i++] = LDAP_OBJECTCLASS;
        for (String groupMember : this.getGroupMemberFields()) {
            attrs[i++] = groupMember;
        }
        attrs[i] = this.getUidAttributeName();
        return this.getConnection().searchPaginated(groupDN, 2, null, attrs, false);
    }

    private PagedLDAPSearchResults searchGroupsMembersByFilter(String filter) throws LDAPException {
        String[] attrs = new String[2 + this.getGroupMemberFields().size()];
        int i = 0;
        attrs[i++] = LDAP_OBJECTCLASS;
        for (String groupMember : this.getGroupMemberFields()) {
            attrs[i++] = groupMember;
        }
        attrs[i] = this.getUidAttributeName();
        return this.getConnection().searchPaginated(this.getBaseDN(), 2, filter, attrs, false);
    }

    private void getGroupMembersFromSearchResult(List<XWikiLDAPSearchAttribute> searchAttributeList, Map<String, String> memberMap, List<String> subgroups, XWikiContext context) {
        for (XWikiLDAPSearchAttribute searchAttribute : searchAttributeList) {
            String member;
            String key = searchAttribute.name;
            if (!this.getGroupMemberFields().contains(key.toLowerCase()) || !StringUtils.isNotBlank((CharSequence)(member = searchAttribute.value))) continue;
            this.getGroupMembers(member, memberMap, subgroups, context);
        }
    }

    private void getGroupMembersFromLDAPEntry(LDAPEntry ldapEntry, Map<String, String> memberMap, List<String> subgroups, XWikiContext context) {
        for (String memberField : this.getGroupMemberFields()) {
            LDAPAttribute attribute = ldapEntry.getAttribute(memberField);
            if (attribute == null) continue;
            Enumeration values = attribute.getStringValues();
            while (values.hasMoreElements()) {
                String member = (String)values.nextElement();
                if (!StringUtils.isNotBlank((CharSequence)member)) continue;
                LOGGER.debug("  |- Member value [{}] found. Trying to resolve it.", (Object)member);
                this.getGroupMembers(member, memberMap, subgroups, context);
            }
        }
    }

    public boolean getGroupMembers(String groupDN, Map<String, String> memberMap, List<String> subgroups, List<XWikiLDAPSearchAttribute> searchAttributeList, XWikiContext context) {
        boolean isGroup = false;
        String id = null;
        for (XWikiLDAPSearchAttribute searchAttribute : searchAttributeList) {
            String key = searchAttribute.name;
            if (key.equalsIgnoreCase(LDAP_OBJECTCLASS)) {
                String objectName = searchAttribute.value;
                if (!this.getGroupClasses().contains(objectName.toLowerCase())) continue;
                isGroup = true;
                continue;
            }
            if (!key.equalsIgnoreCase(this.getUidAttributeName())) continue;
            id = searchAttribute.value;
        }
        if (!isGroup) {
            if (id == null) {
                LOGGER.error("Could not find attribute [{}] for LDAP dn [{}]", (Object)this.getUidAttributeName(), (Object)groupDN);
            }
            if (!memberMap.containsKey(groupDN.toLowerCase())) {
                memberMap.put(groupDN.toLowerCase(), id == null ? "" : id.toLowerCase());
            }
        } else {
            if (subgroups != null) {
                subgroups.add(groupDN.toLowerCase());
            }
            this.getGroupMembersFromSearchResult(searchAttributeList, memberMap, subgroups, context);
        }
        return isGroup;
    }

    public boolean getGroupMembers(Map<String, String> memberMap, List<String> subgroups, LDAPEntry ldapEntry, XWikiContext context) throws LDAPException {
        boolean isGroup = false;
        LDAPAttribute classAttribute = ldapEntry.getAttribute(LDAP_OBJECTCLASS);
        if (classAttribute != null) {
            Enumeration values = classAttribute.getStringValues();
            Collection<String> groupClasses = this.getGroupClasses();
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (!groupClasses.contains(value.toLowerCase())) continue;
                isGroup = true;
            }
        }
        if (isGroup) {
            LOGGER.debug("[{}] is a group", (Object)ldapEntry.getDN());
            if (subgroups != null) {
                subgroups.add(ldapEntry.getDN().toLowerCase());
            }
            this.getGroupMembersFromLDAPEntry(ldapEntry, memberMap, subgroups, context);
        } else {
            LOGGER.debug("[{}] is a user", (Object)ldapEntry.getDN());
            LDAPAttribute uidAttribute = ldapEntry.getAttribute(this.getUidAttributeName());
            if (uidAttribute != null) {
                String uid = uidAttribute.getStringValue();
                if (!memberMap.containsKey(ldapEntry.getDN().toLowerCase())) {
                    memberMap.put(ldapEntry.getDN().toLowerCase(), uid.toLowerCase());
                }
            } else {
                LOGGER.debug("Probably a organization unit or a search");
            }
        }
        return isGroup;
    }

    public boolean getGroupMembers(String userOrGroup, Map<String, String> memberMap, List<String> subgroups, XWikiContext context) {
        boolean isGroup;
        block8: {
            isGroup = false;
            int nbMembers = memberMap.size();
            if (LDAPDN.isValid((String)userOrGroup)) {
                LOGGER.debug("[{}] is a valid DN, lets try to get corresponding entry.", (Object)userOrGroup);
                if (memberMap.containsKey(userOrGroup.toLowerCase())) {
                    LOGGER.debug("[{}] is already resolved", (Object)userOrGroup);
                    return false;
                }
                if (!subgroups.isEmpty() && !this.isResolveSubgroups()) {
                    LOGGER.debug("Group members resolve is disabled to add [{}] as group member directly", (Object)userOrGroup);
                    memberMap.put(userOrGroup.toLowerCase(), userOrGroup);
                    return false;
                }
                isGroup = this.getGroupMembersFromDN(userOrGroup, memberMap, subgroups, context);
            }
            if (!isGroup && nbMembers == memberMap.size()) {
                LOGGER.debug("Looks like [{}] is not a DN, lets try filter or id", (Object)userOrGroup);
                try {
                    new RfcFilter(userOrGroup);
                    isGroup = this.getGroupMembersFromFilter(userOrGroup, memberMap, subgroups, context);
                }
                catch (LDAPException e) {
                    LOGGER.debug("[{}] is not a valid LDAP filter, lets try id", (Object)userOrGroup, (Object)e);
                    List<XWikiLDAPSearchAttribute> searchAttributeList = this.searchUserAttributesByUid(userOrGroup, new String[]{LDAP_FIELD_DN});
                    if (searchAttributeList == null || searchAttributeList.isEmpty()) break block8;
                    String dn = searchAttributeList.get((int)0).value;
                    if (memberMap.containsKey(dn.toLowerCase())) {
                        LOGGER.debug("[{}] is already resolved", (Object)dn);
                        return false;
                    }
                    if (!subgroups.isEmpty() && !this.isResolveSubgroups()) {
                        LOGGER.debug("Group members resolve is disabled to add [{}] as group member directly", (Object)dn);
                        memberMap.put(dn.toLowerCase(), dn);
                        return false;
                    }
                    isGroup = this.getGroupMembers(dn, memberMap, subgroups, context);
                }
            }
        }
        return isGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getGroupMembersFromDN(String userOrGroupDN, Map<String, String> memberMap, List<String> subgroups, XWikiContext context) {
        PagedLDAPSearchResults result;
        boolean isGroup = false;
        if (subgroups != null && subgroups.contains(userOrGroupDN.toLowerCase())) {
            LOGGER.debug("[{}] groups already resolved.", (Object)userOrGroupDN);
            return true;
        }
        try {
            result = this.searchGroupsMembersByDN(userOrGroupDN);
        }
        catch (LDAPException e) {
            LOGGER.debug("Failed to search for [{}]", (Object)userOrGroupDN, (Object)e);
            return false;
        }
        try {
            isGroup = this.getGroupMembersSearchResult(result, memberMap, subgroups, context);
        }
        finally {
            if (result.hasMore()) {
                try {
                    result.close();
                }
                catch (LDAPException e) {
                    LOGGER.debug("LDAP Search clean up failed", (Throwable)e);
                }
            }
        }
        return isGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getGroupMembersFromFilter(String filter, Map<String, String> memberMap, List<String> subgroups, XWikiContext context) {
        PagedLDAPSearchResults result;
        boolean isGroup = false;
        try {
            result = this.searchGroupsMembersByFilter(filter);
        }
        catch (LDAPException e) {
            LOGGER.debug("Failed to search for [{}]", (Object)filter, (Object)e);
            return false;
        }
        try {
            isGroup = this.getGroupMembersSearchResult(result, memberMap, subgroups, context);
        }
        finally {
            if (result.hasMore()) {
                try {
                    result.close();
                }
                catch (LDAPException e) {
                    LOGGER.debug("LDAP Search clean up failed", (Throwable)e);
                }
            }
        }
        return isGroup;
    }

    @Deprecated
    public boolean getGroupMembersSearchResult(LDAPSearchResults result, Map<String, String> memberMap, List<String> subgroups, XWikiContext context) {
        boolean isGroup = false;
        LDAPEntry resultEntry = null;
        if (result.hasMore()) {
            try {
                resultEntry = result.next();
            }
            catch (LDAPException e) {
                LOGGER.debug("Failed to get group members", (Throwable)e);
            }
        }
        if (resultEntry != null) {
            do {
                try {
                    isGroup |= this.getGroupMembers(memberMap, subgroups, resultEntry, context);
                    resultEntry = result.hasMore() ? result.next() : null;
                }
                catch (LDAPException e) {
                    LOGGER.debug("Failed to get group members", (Throwable)e);
                }
            } while (resultEntry != null);
        }
        return isGroup;
    }

    public boolean getGroupMembersSearchResult(PagedLDAPSearchResults result, Map<String, String> memberMap, List<String> subgroups, XWikiContext context) {
        boolean isGroup = false;
        if (result.hasMore()) {
            LDAPEntry resultEntry = null;
            try {
                resultEntry = result.next();
            }
            catch (LDAPException e) {
                LOGGER.debug("Failed to get group members", (Throwable)e);
            }
            if (resultEntry != null) {
                do {
                    try {
                        isGroup |= this.getGroupMembers(memberMap, subgroups, resultEntry, context);
                        resultEntry = result.hasMore() ? result.next() : null;
                    }
                    catch (LDAPException e) {
                        LOGGER.debug("Failed to get group members", (Throwable)e);
                    }
                } while (resultEntry != null);
            } else {
                LOGGER.debug("The LDAP request returned no result (hasMore() is true but first next() call returned nothing)");
            }
        } else {
            LOGGER.debug("The LDAP request returned no result (hasMore is false)");
        }
        return isGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getGroupMembers(String groupDN, XWikiContext context) throws XWikiException {
        HashMap<String, String> groupMembers = null;
        try {
            Cache<Map<String, String>> cache;
            Cache<Map<String, String>> cache2 = cache = this.getCaches().getGroupCache(this);
            synchronized (cache2) {
                groupMembers = (HashMap<String, String>)cache.get(groupDN);
                if (groupMembers == null) {
                    HashMap<String, String> members = new HashMap<String, String>();
                    LOGGER.debug("Retrieving Members of the group [{}]", (Object)groupDN);
                    boolean isGroup = this.getGroupMembers(groupDN, members, new ArrayList<String>(), context);
                    if (isGroup || !members.isEmpty()) {
                        groupMembers = members;
                        cache.set(groupDN, groupMembers);
                    }
                } else {
                    LOGGER.debug("Found cache entry for group [{}]", (Object)groupDN);
                }
            }
        }
        catch (CacheException e) {
            throw new XWikiException("Unknown error with cache", (Throwable)e);
        }
        LOGGER.debug("Found group [{}] members [{}]", (Object)groupDN, (Object)groupMembers);
        return groupMembers;
    }

    public boolean isMemberOfGroup(String memberDN, String groupDN, XWikiContext context) throws XWikiException {
        Map<String, String> groupMembers = this.getGroupMembers(groupDN, context);
        if (groupMembers != null) {
            for (String memberDNEntry : groupMembers.keySet()) {
                if (!memberDNEntry.equals(memberDN.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMemberOfGroups(String memberDN, Collection<String> groupDNList, XWikiContext context) throws XWikiException {
        for (String groupDN : groupDNList) {
            if (!this.isMemberOfGroup(memberDN, groupDN, context)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public CacheConfiguration getGroupCacheConfiguration() {
        return this.getCaches().createCacheConfiguration(this.getConfiguration());
    }

    @Deprecated
    public static CacheConfiguration getGroupCacheConfiguration(XWikiContext context) {
        return ((LDAPGroupsCache)Utils.getComponent(LDAPGroupsCache.class)).createCacheConfiguration(XWikiLDAPConfig.getInstance());
    }

    @Deprecated
    protected String findInGroup(String userName, Map<String, String> groupMembers, XWikiContext context) {
        return this.findUidInGroup(userName, groupMembers);
    }

    protected String findUidInGroup(String userName, Map<String, String> groupMembers) {
        Pattern ldapuserPattern = Pattern.compile("^" + Pattern.quote(this.getUidAttributeName()) + "=" + Pattern.quote(userName.toLowerCase()) + " *,");
        for (Map.Entry<String, String> entry : groupMembers.entrySet()) {
            if (!userName.equalsIgnoreCase(entry.getValue()) && !ldapuserPattern.matcher(entry.getKey()).find()) continue;
            return entry.getKey();
        }
        return null;
    }

    protected String findDNInGroup(String userDN, Map<String, String> groupMembers) {
        if (groupMembers.containsKey(userDN.toLowerCase())) {
            return userDN;
        }
        return null;
    }

    public String isInGroup(String uid, String dn, String groupDN, XWikiContext context) throws XWikiException {
        String userDN = null;
        if (groupDN.length() > 0) {
            Map<String, String> groupMembers = null;
            try {
                groupMembers = this.getGroupMembers(groupDN, context);
            }
            catch (Exception e) {
                LOGGER.debug("Unable to retrieve group members of group [{}]", (Object)groupDN, (Object)e);
            }
            if (groupMembers != null) {
                userDN = dn == null ? this.findUidInGroup(uid, groupMembers) : this.findDNInGroup(dn, groupMembers);
                LOGGER.debug("Found user dn in user group [{}]", (Object)userDN);
            }
        }
        return userDN;
    }

    public String isUidInGroup(String userName, String groupDN, XWikiContext context) throws XWikiException {
        return this.isInGroup(userName, null, groupDN, context);
    }

    public String isDNInGroup(String dn, String groupDN, XWikiContext context) throws XWikiException {
        return this.isInGroup(null, dn, groupDN, context);
    }

    public List<XWikiLDAPSearchAttribute> searchUserAttributesByUid(String uid, String[] attributeNameTable) {
        String filter = MessageFormat.format(this.userSearchFormatString, XWikiLDAPConnection.escapeLDAPSearchFilter(this.getUidAttributeName()), XWikiLDAPConnection.escapeLDAPSearchFilter(uid));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Searching for the user in LDAP: user [{}] base [{}] query [{}] uid [{}]", new Object[]{uid, this.baseDN, filter, this.getUidAttributeName()});
        }
        return this.getConnection().searchLDAP(this.baseDN, filter, attributeNameTable, 2);
    }

    public String searchUserDNByUid(String uid) {
        String userDN = null;
        List<XWikiLDAPSearchAttribute> searchAttributes = this.searchUserAttributesByUid(uid, new String[]{LDAP_FIELD_DN});
        if (searchAttributes != null && !searchAttributes.isEmpty()) {
            userDN = searchAttributes.get((int)0).value;
        }
        return userDN;
    }

    public XWikiDocument syncUser(XWikiDocument userProfile, List<XWikiLDAPSearchAttribute> attributes, String ldapDn, String authInput, XWikiContext context) throws XWikiException {
        if (userProfile == null || userProfile.isNew() || this.configuration.getLDAPParam("ldap_update_user", "0", context).equals("1")) {
            LOGGER.debug("LDAP attributes will be used to update XWiki attributes.");
            if (attributes == null) {
                attributes = this.getConnection().searchLDAP(ldapDn, null, this.getAttributeNameTable(context), 0);
            }
            if (attributes == null) {
                LOGGER.error("Can't find any attributes for user [{}]", (Object)ldapDn);
            }
            if (userProfile == null) {
                userProfile = this.getAvailableUserProfile(attributes, context);
            }
            if (userProfile.isNew()) {
                LOGGER.debug("Creating new XWiki user based on LDAP attribues located at [{}]", (Object)ldapDn);
                this.createUserFromLDAP(userProfile, attributes, ldapDn, authInput, context);
                LOGGER.debug("New XWiki user created: [{}]", (Object)userProfile.getDocumentReference());
            } else {
                LOGGER.debug("Updating existing user with LDAP attribues located at [{}]", (Object)ldapDn);
                try {
                    this.updateUserFromLDAP(userProfile, attributes, ldapDn, authInput, context);
                }
                catch (XWikiException e) {
                    LOGGER.error("Failed to synchronise user's informations", (Throwable)e);
                }
            }
        }
        return userProfile;
    }

    public static String cleanXWikiUserPageName(String pageName) {
        String cleanPageName = StringUtils.remove((String)pageName, (char)'.');
        cleanPageName = StringUtils.remove((String)cleanPageName, (char)' ');
        cleanPageName = StringUtils.remove((String)cleanPageName, (char)'/');
        return cleanPageName;
    }

    public void syncGroupsMembership(String xwikiUserName, String userDN, Map<String, Set<String>> groupMappings, XWikiContext context) throws XWikiException {
        LOGGER.debug("Updating group membership for the user [{}]", (Object)xwikiUserName);
        Collection xwikiUserGroupList = context.getWiki().getGroupService(context).getAllGroupsNamesForMember(xwikiUserName, 0, 0, context);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The user belongs to following XWiki groups: ");
            for (String userGroupName : xwikiUserGroupList) {
                LOGGER.debug(userGroupName);
            }
        }
        for (Map.Entry<String, Set<String>> entry : groupMappings.entrySet()) {
            String xwikiGroupName = entry.getKey();
            Set<String> groupDNSet = entry.getValue();
            if (xwikiUserGroupList.contains(xwikiGroupName)) {
                if (this.isMemberOfGroups(userDN, groupDNSet, context)) continue;
                this.removeUserFromXWikiGroup(xwikiUserName, xwikiGroupName, context);
                continue;
            }
            if (!this.isMemberOfGroups(userDN, groupDNSet, context)) continue;
            this.addUserToXWikiGroup(xwikiUserName, xwikiGroupName, context);
        }
    }

    public String[] getAttributeNameTable(XWikiContext context) {
        LOGGER.debug("Getting the list of user fields to synchronize");
        String[] attributeNameTable = null;
        ArrayList<String> attributeNameList = new ArrayList<String>();
        this.configuration.getUserMappings(attributeNameList);
        if (this.configuration.getLDAPParam("ldap_update_photo", "0").equals("1")) {
            LOGGER.debug("LDAP avatar photo synchronisation is enabled");
            String ldapPhotoAttribute = this.configuration.getLDAPParam("ldap_photo_attribute", "thumbnailPhoto");
            LOGGER.debug("LDAP avatar photo field name: {}", (Object)ldapPhotoAttribute);
            attributeNameList.add(ldapPhotoAttribute);
        } else {
            LOGGER.debug("LDAP avatar photo synchronisation is disabled");
        }
        attributeNameList.add(this.getUidAttributeName());
        int lsize = attributeNameList.size();
        if (lsize > 0) {
            attributeNameTable = attributeNameList.toArray(new String[lsize]);
        }
        LOGGER.debug("LDAP user fields to synchronize: {}", attributeNameList);
        return attributeNameTable;
    }

    private void set(List<XWikiLDAPSearchAttribute> searchAttributes, Map<String, String> userMappings, BaseObject userObject, XWikiContext xcontext) throws XWikiException {
        if (searchAttributes != null) {
            Map<String, Object> map = this.toMap(searchAttributes, userMappings, xcontext);
            userObject.getXClass(xcontext).fromMap(map, (BaseCollection)userObject);
        }
    }

    private Map<String, Object> toMap(List<XWikiLDAPSearchAttribute> searchAttributes, Map<String, String> userMappings, XWikiContext xcontext) throws XWikiException {
        BaseClass userClass = xcontext.getWiki().getUserClass(xcontext);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (searchAttributes != null) {
            for (XWikiLDAPSearchAttribute lattr : searchAttributes) {
                PropertyClass pclass;
                String lval = lattr.value;
                String xattr = userMappings.get(lattr.name.toLowerCase());
                if (xattr == null || (pclass = (PropertyClass)userClass.get(xattr)) == null) continue;
                if (pclass instanceof ListClass) {
                    Object mapValue = map.get(xattr);
                    if (mapValue == null) {
                        mapValue = new ArrayList();
                        map.put(xattr, mapValue);
                    }
                    ((List)mapValue).add(lval);
                    continue;
                }
                map.put(xattr, lval);
            }
        }
        return map;
    }

    protected void createUserFromLDAP(XWikiDocument userProfile, List<XWikiLDAPSearchAttribute> attributes, String ldapDN, String ldapUid, XWikiContext context) throws XWikiException {
        Map<String, String> userMappings = this.configuration.getUserMappings(null, context);
        LOGGER.debug("Start first synchronization of LDAP profile [{}] with new user profile based on mapping [{}]", attributes, userMappings);
        Map<String, Object> map = this.toMap(attributes, userMappings, context);
        map.put("active", "1");
        XWikiException createUserError = null;
        try {
            context.getWiki().createUser(userProfile.getDocumentReference().getName(), map, context);
        }
        catch (XWikiException e) {
            createUserError = e;
        }
        XWikiDocument createdUserProfile = context.getWiki().getDocument(userProfile.getDocumentReference(), context);
        if (createdUserProfile.isNew()) {
            if (createUserError != null) {
                throw createUserError;
            }
            throw new XWikiLDAPException("User [" + userProfile.getDocumentReference() + "] hasn't been created for unknown reason");
        }
        if (createUserError != null) {
            LOGGER.error("Unexpected error when creating user [{}]", (Object)userProfile.getDocumentReference(), (Object)createUserError);
        }
        LDAPProfileXClass ldapXClass = new LDAPProfileXClass(context);
        this.updateAvatarFromLdap(attributes, createdUserProfile, context);
        if (ldapXClass.updateLDAPObject(createdUserProfile, ldapDN, ldapUid)) {
            context.getWiki().saveDocument(createdUserProfile, "Created user profile from LDAP server", context);
        }
    }

    protected void updateUserFromLDAP(XWikiDocument userProfile, List<XWikiLDAPSearchAttribute> attributes, String ldapDN, String ldapUid, XWikiContext context) throws XWikiException {
        Map<String, String> userMappings = this.configuration.getUserMappings(null);
        BaseClass userClass = context.getWiki().getUserClass(context);
        BaseObject userObj = userProfile.getXObject(userClass.getDocumentReference());
        LOGGER.debug("Start synchronization of LDAP profile [{}] with existing user profile based on mapping [{}]", attributes, userMappings);
        BaseObject clonedUser = userObj.clone();
        this.set(attributes, userMappings, clonedUser, context);
        boolean needsUpdate = userObj.apply((ElementInterface)clonedUser, false);
        needsUpdate |= this.updateAvatarFromLdap(attributes, userProfile, context);
        LDAPProfileXClass ldaXClass = new LDAPProfileXClass(context);
        if (needsUpdate |= ldaXClass.updateLDAPObject(userProfile, ldapDN, ldapUid)) {
            context.getWiki().saveDocument(userProfile, "Synchronized user profile with LDAP server", true, context);
        }
    }

    private boolean updateAvatarFromLdap(List<XWikiLDAPSearchAttribute> ldapAttributes, XWikiDocument userProfile, XWikiContext context) throws XWikiException {
        if (!this.configuration.getLDAPParam("ldap_update_photo", "0").equals("1")) {
            return false;
        }
        BaseClass userClass = context.getWiki().getUserClass(context);
        BaseObject userObj = userProfile.getXObject(userClass.getDocumentReference());
        String userAvatar = userObj.getStringValue("avatar");
        XWikiAttachment currentPhoto = null;
        if (userAvatar != null) {
            currentPhoto = userProfile.getAttachment(userAvatar);
        }
        String photoAttachmentName = this.configuration.getLDAPParam("ldap_photo_attachment_name", "ldapPhoto");
        if (StringUtils.isEmpty((CharSequence)userAvatar) || photoAttachmentName.equals(FilenameUtils.getBaseName((String)userAvatar)) || currentPhoto == null) {
            byte[] ldapPhoto = null;
            if (ldapAttributes != null) {
                String ldapPhotoAttribute = this.configuration.getLDAPParam("ldap_photo_attribute", "thumbnailPhoto");
                for (XWikiLDAPSearchAttribute attribute : ldapAttributes) {
                    if (!attribute.name.equals(ldapPhotoAttribute)) continue;
                    ldapPhoto = attribute.byteValue;
                }
            }
            if (ldapPhoto != null) {
                ByteArrayInputStream ldapPhotoInputStream = new ByteArrayInputStream(ldapPhoto);
                String ldapPhotoType = this.guessImageType(ldapPhotoInputStream);
                ldapPhotoInputStream.reset();
                if (ldapPhotoType != null) {
                    String photoAttachmentFullName = photoAttachmentName + "." + ldapPhotoType.toLowerCase();
                    if (!StringUtils.isEmpty((CharSequence)userAvatar) && currentPhoto != null) {
                        try {
                            if (!IOUtils.contentEquals((InputStream)currentPhoto.getContentInputStream(context), (InputStream)ldapPhotoInputStream)) {
                                ldapPhotoInputStream.reset();
                                return this.addAvatarToProfile(userProfile, context, ldapPhotoInputStream, photoAttachmentFullName);
                            }
                        }
                        catch (IOException ex) {
                            LOGGER.error(ex.getMessage());
                        }
                    } else if (this.addAvatarToProfile(userProfile, context, ldapPhotoInputStream, photoAttachmentFullName)) {
                        PropertyClass avatarProperty = (PropertyClass)userClass.getField("avatar");
                        userObj.safeput("avatar", (PropertyInterface)avatarProperty.fromString(photoAttachmentFullName));
                        return true;
                    }
                } else {
                    LOGGER.info("Unable to determine LDAP photo image type.");
                }
            } else if (currentPhoto != null) {
                PropertyClass avatarProperty = (PropertyClass)userClass.getField("avatar");
                userObj.safeput("avatar", (PropertyInterface)avatarProperty.fromString(""));
                return true;
            }
        }
        return false;
    }

    private boolean addAvatarToProfile(XWikiDocument userProfile, XWikiContext context, InputStream photoInputStream, String attachmentName) {
        XWikiAttachment attachment;
        try {
            attachment = userProfile.addAttachment(attachmentName, photoInputStream, context);
        }
        catch (XWikiException | IOException ex) {
            LOGGER.error(ex.getMessage());
            return false;
        }
        attachment.resetMimeType(context);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessImageType(InputStream imageInputStream) {
        ImageInputStream imageStream;
        try {
            imageStream = ImageIO.createImageInputStream(imageInputStream);
        }
        catch (IOException ex) {
            LOGGER.error(ex.getMessage());
            return null;
        }
        Iterator<ImageReader> it = ImageIO.getImageReaders(imageStream);
        if (!it.hasNext()) {
            LOGGER.warn("No image readers found for provided stream.");
            return null;
        }
        ImageReader imageReader = it.next();
        imageReader.setInput(imageStream);
        try {
            String string = imageReader.getFormatName();
            return string;
        }
        catch (IOException ex) {
            LOGGER.error(ex.getMessage());
            String string = null;
            return string;
        }
        finally {
            imageReader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUserToXWikiGroup(String xwikiUserName, String groupName, XWikiContext context) {
        try {
            XWikiDocument groupDoc;
            LOGGER.debug("Adding user [{}] to xwiki group [{}]", (Object)xwikiUserName, (Object)groupName);
            BaseClass groupClass = context.getWiki().getGroupClass(context);
            XWikiDocument xWikiDocument = groupDoc = context.getWiki().getDocument(groupName, context);
            synchronized (xWikiDocument) {
                List xobjects = groupDoc.getXObjects(groupClass.getDocumentReference());
                if (xobjects != null) {
                    for (BaseObject memberObj : xobjects) {
                        String existingMember;
                        if (memberObj == null || (existingMember = memberObj.getStringValue(XWIKI_GROUP_MEMBERFIELD)) == null || !existingMember.equals(xwikiUserName)) continue;
                        LOGGER.warn("User [{}] already exist in group [{}]", (Object)xwikiUserName, (Object)groupDoc.getDocumentReference());
                        return;
                    }
                }
                BaseObject memberObj = groupDoc.newXObject((EntityReference)groupClass.getDocumentReference(), context);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(XWIKI_GROUP_MEMBERFIELD, xwikiUserName);
                groupClass.fromMap(map, (BaseCollection)memberObj);
                if (groupDoc.isNew()) {
                    groupDoc.setSyntax(Syntax.XWIKI_2_0);
                    groupDoc.setContent("{{include reference='XWiki.XWikiGroupSheet' /}}");
                }
                context.getWiki().saveDocument(groupDoc, context);
            }
            LOGGER.debug("Finished adding user [{}] to xwiki group [{}]", (Object)xwikiUserName, (Object)groupName);
        }
        catch (Exception e) {
            LOGGER.error("Failed to add a user [{}] to a group [{}]", new Object[]{xwikiUserName, groupName, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUserFromXWikiGroup(String xwikiUserName, String groupName, XWikiContext context) {
        try {
            XWikiDocument groupDoc;
            BaseClass groupClass = context.getWiki().getGroupClass(context);
            XWikiDocument xWikiDocument = groupDoc = context.getWiki().getDocument(groupName, context);
            synchronized (xWikiDocument) {
                BaseObject groupObj = groupDoc.getXObject(groupClass.getDocumentReference(), XWIKI_GROUP_MEMBERFIELD, xwikiUserName);
                if (groupObj != null) {
                    groupDoc.removeXObject(groupObj);
                }
                context.getWiki().saveDocument(groupDoc, context);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to remove a user from a group [{}] group: [{}]", new Object[]{xwikiUserName, groupName, e});
        }
    }

    public XWikiDocument getUserProfileByUid(String validXWikiUserName, String userId, XWikiContext context) throws XWikiException {
        return this.getUserProfileByUniqueAttribute(validXWikiUserName, userId, false, context);
    }

    public XWikiDocument getUserProfileByDn(String validXWikiUserName, String userId, XWikiContext context) throws XWikiException {
        return this.getUserProfileByUniqueAttribute(validXWikiUserName, userId, true, context);
    }

    private XWikiDocument getUserProfileByUniqueAttribute(String validXWikiUserName, String userId, boolean tryDn, XWikiContext context) throws XWikiException {
        LDAPProfileXClass ldapXClass = new LDAPProfileXClass(context);
        XWikiDocument userProfile = validXWikiUserName != null ? context.getWiki().getDocument(new DocumentReference(context.getWikiId(), XWIKI_USER_SPACE, validXWikiUserName), context) : null;
        if (!userId.equalsIgnoreCase(tryDn ? ldapXClass.getDn(userProfile) : ldapXClass.getUid(userProfile))) {
            XWikiDocument xWikiDocument = userProfile = tryDn ? ldapXClass.searchDocumentByDn(userId) : ldapXClass.searchDocumentByUid(userId);
            if (userProfile == null && validXWikiUserName != null) {
                userProfile = this.getAvailableUserProfile(validXWikiUserName, context);
            }
        }
        return userProfile;
    }

    private XWikiDocument getAvailableUserProfile(String validXWikiUserName, XWikiContext context) throws XWikiException {
        DocumentReference userReference = new DocumentReference(context.getWikiId(), XWIKI_USER_SPACE, validXWikiUserName);
        int i = 0;
        while (true) {
            XWikiDocument doc;
            if (i > 0) {
                userReference = new DocumentReference(context.getWikiId(), XWIKI_USER_SPACE, validXWikiUserName + "_" + i);
            }
            if ((doc = context.getWiki().getDocument(userReference, context)).isNew()) {
                return doc;
            }
            ++i;
        }
    }

    public XWikiDocument getAvailableUserProfile(List<XWikiLDAPSearchAttribute> attributes, XWikiContext context) throws XWikiException {
        String pageName = this.getUserPageName(attributes, context);
        return this.getAvailableUserProfile(pageName, context);
    }

    public String getUserPageName(List<XWikiLDAPSearchAttribute> attributes, XWikiContext context) {
        LDAPDocumentHelper ldapDocumentHelper = (LDAPDocumentHelper)Utils.getComponent(LDAPDocumentHelper.class);
        String userPageName = this.getConfiguration().getLDAPParam("ldap_userPageName", "${uid}");
        return ldapDocumentHelper.getDocumentName(userPageName, this.getUidAttributeName(), attributes, this.getConfiguration());
    }
}

