/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPDN;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPReferralHandler;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.xpn.xwiki.XWikiContext;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.contrib.ldap.LDAPPluginReferralHandler;
import org.xwiki.contrib.ldap.PagedLDAPSearchResults;
import org.xwiki.contrib.ldap.XWikiLDAPConfig;
import org.xwiki.contrib.ldap.XWikiLDAPException;
import org.xwiki.contrib.ldap.XWikiLDAPSearchAttribute;

public class XWikiLDAPConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiLDAPConnection.class);
    private LDAPConnection connection;
    private Set<String> binaryAttributes = new HashSet<String>();
    private final XWikiLDAPConfig configuration;

    @Deprecated
    public XWikiLDAPConnection() {
        this(new XWikiLDAPConfig(null));
    }

    public XWikiLDAPConnection(XWikiLDAPConfig configuration) {
        this.configuration = configuration;
    }

    public XWikiLDAPConnection(XWikiLDAPConnection connection) {
        this();
        this.connection = connection.connection;
        this.binaryAttributes = connection.binaryAttributes;
    }

    private int getTimeout(XWikiContext context) {
        return this.configuration.getLDAPTimeout();
    }

    private int getMaxResults(XWikiContext context) {
        return this.configuration.getLDAPMaxResults();
    }

    public LDAPConnection getConnection() {
        return this.connection;
    }

    public boolean open(String ldapUserName, String password, XWikiContext context) throws XWikiLDAPException {
        boolean bind;
        int ldapPort = this.configuration.getLDAPPort();
        String ldapHost = this.configuration.getLDAPParam("ldap_server", "localhost");
        String bindDN = this.configuration.getLDAPBindDN(ldapUserName, password);
        String bindPassword = this.configuration.getLDAPBindPassword(ldapUserName, password);
        if ("1".equals(this.configuration.getLDAPParam("ldap_ssl", "0"))) {
            String keyStore = this.configuration.getLDAPParam("ldap_ssl.keystore", "");
            LOGGER.debug("Connecting to LDAP using SSL");
            bind = this.open(ldapHost, ldapPort, bindDN, bindPassword, keyStore, true, context);
        } else {
            bind = this.open(ldapHost, ldapPort, bindDN, bindPassword, null, false, context);
        }
        return bind;
    }

    public boolean open(String ldapHost, int ldapPort, String loginDN, String password, String pathToKeys, boolean ssl, XWikiContext context) throws XWikiLDAPException {
        int port = ldapPort;
        if (port <= 0) {
            port = ssl ? 636 : 389;
        }
        this.setBinaryAttributes(this.configuration.getBinaryAttributes());
        try {
            if (ssl) {
                Provider secureProvider = this.configuration.getSecureProvider();
                if (secureProvider != null) {
                    Security.addProvider(secureProvider);
                }
                if (pathToKeys != null && pathToKeys.length() > 0) {
                    System.setProperty("javax.net.ssl.trustStore", pathToKeys);
                }
                LDAPJSSESecureSocketFactory ssf = new LDAPJSSESecureSocketFactory();
                this.connection = new LDAPConnection((LDAPSocketFactory)ssf);
            } else {
                this.connection = new LDAPConnection();
            }
            boolean doServiceDiscovery = "1".equals(this.configuration.getLDAPParam("ldap_service_discovery", "1"));
            this.connect(ldapHost, port, doServiceDiscovery, ssl);
            LDAPSearchConstraints constraints = new LDAPSearchConstraints(this.connection.getConstraints());
            constraints.setTimeLimit(this.getTimeout(context));
            constraints.setMaxResults(this.getMaxResults(context));
            if (this.configuration.isFollowReferrals()) {
                constraints.setReferralFollowing(true);
                constraints.setReferralHandler((LDAPReferralHandler)new LDAPPluginReferralHandler(loginDN, password, context));
            }
            this.connection.setConstraints((LDAPConstraints)constraints);
            this.bind(loginDN, password);
        }
        catch (UnsupportedEncodingException e) {
            throw new XWikiLDAPException("LDAP bind failed with UnsupportedEncodingException.", e);
        }
        catch (LDAPException e) {
            throw new XWikiLDAPException("LDAP bind failed with LDAPException.", (Exception)((Object)e));
        }
        return true;
    }

    private void connect(String ldapHost, int port, boolean doServiceDiscovery, boolean ssl) throws LDAPException {
        List<SRVRecord> ldapSRVRecords;
        if (doServiceDiscovery && (ldapSRVRecords = this.discoverLDAPService(ldapHost, ssl)) != null && !ldapSRVRecords.isEmpty()) {
            LOGGER.debug("{} SRV record(s) discovered", (Object)ldapSRVRecords.size());
            StringBuilder ldapHostListBuilder = new StringBuilder();
            String SEPARATOR = " ";
            for (SRVRecord ldapSRVRecord : ldapSRVRecords) {
                ldapHostListBuilder.append(ldapSRVRecord.getTarget());
                ldapHostListBuilder.append(":");
                ldapHostListBuilder.append(ldapSRVRecord.getPort());
                ldapHostListBuilder.append(" ");
            }
            ldapHost = ldapHostListBuilder.toString();
        }
        LOGGER.debug("Connection to LDAP server [{}:{}]", (Object)ldapHost, (Object)port);
        this.connection.connect(ldapHost, port);
    }

    private List<SRVRecord> discoverLDAPService(String realm, boolean ldaps) {
        Attributes attributes;
        String service = ldaps ? "_ldaps" : "_ldap";
        String proto = "_tcp";
        String lookup = service + "." + proto + "." + realm;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            attributes = ctx.getAttributes(lookup, new String[]{"SRV"});
        }
        catch (NameNotFoundException e) {
            LOGGER.debug("No SRV record for {} found.", (Object)lookup);
            return null;
        }
        catch (NamingException e) {
            LOGGER.debug("DNS lookup failed.", (Throwable)e);
            return null;
        }
        Attribute attribute = attributes.get("SRV");
        if (attribute == null) {
            LOGGER.debug("No SRV record found in {}.", (Object)attribute);
            return null;
        }
        ArrayList<SRVRecord> list = new ArrayList<SRVRecord>(attribute.size());
        for (int i = 0; i < attribute.size(); ++i) {
            try {
                Object value = attribute.get(i);
                if (value == null) continue;
                SRVRecord srvRecord = new SRVRecord(value.toString().split(" "));
                LOGGER.trace("SRV record found: {}", (Object)srvRecord.toString());
                list.add(srvRecord);
                continue;
            }
            catch (NamingException e) {
                LOGGER.debug("Unable to get {}-th value from attributes.", (Object)i, (Object)e);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Unable to create SRVRecord object.", (Throwable)e);
            }
        }
        Collections.sort(list, SRVRecordComparator.COMPARATOR);
        return list;
    }

    public void bind(String loginDN, String password) throws UnsupportedEncodingException, LDAPException {
        LOGGER.debug("Binding to LDAP server with credentials login=[{}]", (Object)loginDN);
        this.connection.bind(3, loginDN, password.getBytes("UTF8"));
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
        catch (LDAPException e) {
            LOGGER.debug("LDAP close failed.", (Throwable)e);
        }
    }

    public boolean checkPassword(String userDN, String password) {
        return this.checkPassword(userDN, password, "userPassword");
    }

    public boolean checkPassword(String userDN, String password, String passwordField) {
        try {
            LDAPAttribute attribute = new LDAPAttribute(passwordField, password);
            return this.connection.compare(userDN, attribute);
        }
        catch (LDAPException e) {
            if (e.getResultCode() == 32) {
                LOGGER.debug("Unable to locate user_dn [{}]", (Object)userDN, (Object)e);
            } else if (e.getResultCode() == 16) {
                LOGGER.debug("Unable to verify password because userPassword attribute not found.", (Throwable)e);
            } else {
                LOGGER.debug("Unable to verify password", (Throwable)e);
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<XWikiLDAPSearchAttribute> searchLDAP(String baseDN, String filter, String[] attr, int ldapScope) {
        ArrayList<XWikiLDAPSearchAttribute> searchAttributeList = null;
        try (PagedLDAPSearchResults searchResults = this.searchPaginated(baseDN, ldapScope, filter, attr, false);){
            if (!searchResults.hasMore()) {
                List<XWikiLDAPSearchAttribute> list = null;
                return list;
            }
            LDAPEntry nextEntry = searchResults.next();
            String foundDN = nextEntry.getDN();
            searchAttributeList = new ArrayList<XWikiLDAPSearchAttribute>();
            searchAttributeList.add(new XWikiLDAPSearchAttribute("dn", foundDN));
            LDAPAttributeSet attributeSet = nextEntry.getAttributeSet();
            this.ldapToXWikiAttribute(searchAttributeList, attributeSet);
        }
        catch (LDAPException e) {
            LOGGER.debug("LDAP Search failed", (Throwable)e);
        }
        LOGGER.debug("LDAP search found attributes [{}]", searchAttributeList);
        return searchAttributeList;
    }

    public LDAPSearchResults search(String baseDN, String filter, String[] attr, int ldapScope) throws LDAPException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("LDAP search: baseDN=[{}] query=[{}] attr=[{}] ldapScope=[{}]", new Object[]{baseDN, filter, attr != null ? Arrays.asList(attr) : null, ldapScope});
        }
        return this.connection.search(baseDN, ldapScope, filter, attr, false);
    }

    public PagedLDAPSearchResults searchPaginated(String base, int scope, String filter, String[] attrs, boolean typesOnly) throws LDAPException {
        int pageSize = this.configuration.getSearchPageSize();
        return new PagedLDAPSearchResults(this, base, scope, filter, attrs, typesOnly, pageSize);
    }

    public void ldapToXWikiAttribute(List<XWikiLDAPSearchAttribute> searchAttributeList, LDAPAttributeSet attributeSet) {
        for (LDAPAttribute attribute : attributeSet) {
            Object value;
            Enumeration allValues;
            String attributeName = attribute.getName();
            if (!this.isBinaryAttribute(attributeName)) {
                LOGGER.debug("  - values for attribute [{}]", (Object)attributeName);
                allValues = attribute.getStringValues();
                if (allValues == null) continue;
                while (allValues.hasMoreElements()) {
                    value = (String)allValues.nextElement();
                    LOGGER.debug("    |- [{}]", value);
                    searchAttributeList.add(new XWikiLDAPSearchAttribute(attributeName, (String)value));
                }
                continue;
            }
            LOGGER.debug("  - attribute [{}] is binary", (Object)attributeName);
            allValues = attribute.getByteValues();
            if (allValues == null) continue;
            while (allValues.hasMoreElements()) {
                value = (byte[])allValues.nextElement();
                searchAttributeList.add(new XWikiLDAPSearchAttribute(attributeName, (byte[])value));
            }
        }
    }

    public static String escapeLDAPDNValue(String value) {
        return StringUtils.isBlank((CharSequence)value) ? value : LDAPDN.escapeRDN((String)("key=" + value)).substring(4);
    }

    public static String escapeLDAPSearchFilter(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < value.length(); ++i) {
            char curChar = value.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    private void setBinaryAttributes(Set<String> binaryAttributes) {
        this.binaryAttributes = binaryAttributes;
    }

    private boolean isBinaryAttribute(String attributeName) {
        return this.binaryAttributes.contains(attributeName);
    }

    private static class SRVRecordComparator
    implements Comparator<SRVRecord> {
        private static final SRVRecordComparator COMPARATOR = new SRVRecordComparator();

        private SRVRecordComparator() {
        }

        @Override
        public int compare(SRVRecord o1, SRVRecord o2) {
            if (o1.getPriority() == o2.getPriority()) {
                return Integer.compare(o2.getWeight(), o1.getWeight());
            }
            return Integer.compare(o1.getPriority(), o2.getPriority());
        }
    }

    private static class SRVRecord {
        private int priority;
        private int weight;
        private int port;
        private String target;

        public SRVRecord(String[] attributes) {
            if (attributes.length != 4) {
                throw new IllegalArgumentException("attributes array needs exactly 4 entries: priority, weight, port and server name");
            }
            this.priority = Integer.parseInt(attributes[0]);
            this.weight = Integer.parseInt(attributes[1]);
            this.port = Integer.parseInt(attributes[2]);
            this.target = attributes[3];
        }

        public int getPriority() {
            return this.priority;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getPort() {
            return this.port;
        }

        public String getTarget() {
            return this.target;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.priority).append(" ");
            sb.append(this.weight).append(" ");
            sb.append(this.port).append(" ");
            sb.append(this.target);
            return sb.toString();
        }
    }
}

