/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ldap;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.ElementInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import com.xpn.xwiki.web.Utils;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.contrib.ldap.XWikiLDAPAuthServiceImpl;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;

public class LDAPProfileXClass {
    public static final String LDAP_XCLASS = "XWiki.LDAPProfileClass";
    public static final String LDAP_XFIELD_DN = "dn";
    public static final String LDAP_XFIELDPN_DN = "LDAP DN";
    public static final String LDAP_XFIELD_UID = "uid";
    public static final String LDAP_XFIELDPN_UID = "LDAP user unique identifier";
    public static final EntityReference LDAPPROFILECLASS_REFERENCE = new EntityReference("LDAPProfileClass", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    private static final String XWIKI_USER_SPACE = "XWiki";
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiLDAPAuthServiceImpl.class);
    private XWikiContext context;
    private final BaseClass ldapClass;

    public LDAPProfileXClass(XWikiContext context) throws XWikiException {
        this.context = context;
        XWikiDocument ldapClassDoc = context.getWiki().getDocument(LDAPPROFILECLASS_REFERENCE, context);
        this.ldapClass = ldapClassDoc.getXClass();
        boolean needsUpdate = this.updateClass();
        if (ldapClassDoc.getCreatorReference() == null) {
            needsUpdate = true;
            ldapClassDoc.setCreator("superadmin");
        }
        if (ldapClassDoc.getAuthorReference() == null) {
            needsUpdate = true;
            ldapClassDoc.setAuthorReference(ldapClassDoc.getCreatorReference());
        }
        if (!ldapClassDoc.isHidden().booleanValue()) {
            needsUpdate = true;
            ldapClassDoc.setHidden(Boolean.valueOf(true));
        }
        if (needsUpdate) {
            context.getWiki().saveDocument(ldapClassDoc, "Update LDAP user profile class", context);
        }
    }

    private boolean updateClass() {
        BaseClass newClass = new BaseClass();
        newClass.setDocumentReference(this.ldapClass.getDocumentReference());
        this.createClass(newClass);
        return this.ldapClass.apply((ElementInterface)newClass, false);
    }

    private void createClass(BaseClass newClass) {
        newClass.addTextAreaField(LDAP_XFIELD_DN, LDAP_XFIELDPN_DN, 80, 1);
        TextAreaClass textAreaClass = (TextAreaClass)newClass.get(LDAP_XFIELD_DN);
        textAreaClass.setContentType("PureText");
        newClass.addTextField(LDAP_XFIELD_UID, LDAP_XFIELDPN_UID, 80);
    }

    public String getDn(XWikiDocument userDocument) {
        BaseObject ldapObject = userDocument == null ? null : userDocument.getXObject(this.ldapClass.getDocumentReference());
        return ldapObject == null ? null : this.getDn(ldapObject);
    }

    public String getDn(BaseObject ldapObject) {
        String dn = ldapObject.getStringValue(LDAP_XFIELD_DN);
        return dn.length() == 0 ? null : dn;
    }

    public String getUid(XWikiDocument userDocument) {
        BaseObject ldapObject;
        String uid = null;
        if (userDocument != null && (ldapObject = userDocument.getXObject(this.ldapClass.getDocumentReference())) != null) {
            uid = this.getUid(ldapObject);
        }
        return uid;
    }

    public String getUid(BaseObject ldapObject) {
        String uid = ldapObject.getStringValue(LDAP_XFIELD_UID);
        return uid.length() == 0 ? null : uid;
    }

    public void updateLDAPObject(String xwikiUserName, String dn, String uid) throws XWikiException {
        XWikiDocument userDocument = this.context.getWiki().getDocument((EntityReference)new LocalDocumentReference(XWIKI_USER_SPACE, xwikiUserName), this.context);
        boolean needsUpdate = this.updateLDAPObject(userDocument, dn, uid);
        if (needsUpdate) {
            this.context.getWiki().saveDocument(userDocument, "Update LDAP user profile", this.context);
        }
    }

    public boolean updateLDAPObject(XWikiDocument userDocument, String dn, String uid) {
        String objUid;
        BaseObject ldapObject = userDocument.getXObject(this.ldapClass.getDocumentReference(), true, this.context);
        HashMap<String, String> map = new HashMap<String, String>();
        boolean needsUpdate = false;
        String objDn = this.getDn(ldapObject);
        if (!dn.equalsIgnoreCase(objDn)) {
            map.put(LDAP_XFIELD_DN, dn);
            needsUpdate = true;
        }
        if (!uid.equalsIgnoreCase(objUid = this.getUid(ldapObject))) {
            map.put(LDAP_XFIELD_UID, uid);
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.ldapClass.fromMap(map, (BaseCollection)ldapObject);
        }
        return needsUpdate;
    }

    public XWikiDocument searchDocumentByUid(String uid) {
        return this.searchDocumentByLdapProfileClassAttribute(LDAP_XFIELD_UID, uid);
    }

    public XWikiDocument searchDocumentByDn(String dn) {
        return this.searchDocumentByLdapProfileClassAttribute(LDAP_XFIELD_DN, dn);
    }

    private XWikiDocument searchDocumentByLdapProfileClassAttribute(String attrName, String attrValue) {
        XWikiDocument doc = null;
        try {
            QueryManager queryManager = (QueryManager)Utils.getComponent(QueryManager.class);
            String hql = String.format(", BaseObject as ldap, StringProperty as dn where doc.fullName = ldap.name and ldap.className = '%s' and ldap.id = dn.id.id and dn.id.name = '%s' and lower(str(dn.value)) = :value", LDAP_XCLASS, attrName);
            List documentList = queryManager.createQuery(hql, "hql").addFilter((QueryFilter)Utils.getComponent(QueryFilter.class, (String)"unique")).bindValue("value", (Object)attrValue.toLowerCase()).execute();
            if (documentList.size() > 1) {
                LOGGER.error("There is more than one user profile for LDAP {} [{}]", (Object)attrName, (Object)attrValue);
            }
            if (!documentList.isEmpty()) {
                doc = this.context.getWiki().getDocument((String)documentList.get(0), this.context);
            }
        }
        catch (XWikiException | QueryException e) {
            LOGGER.error("Fail to search for document containing ldap " + attrName + " [" + attrValue + "]", e);
        }
        return doc;
    }

    public String searchDn(String uid) {
        XWikiDocument document = this.searchDocumentByUid(uid);
        return document == null ? null : this.getDn(document);
    }
}

