/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ldap;

import com.novell.ldap.LDAPAuthHandler;
import com.novell.ldap.LDAPAuthProvider;
import com.xpn.xwiki.XWikiContext;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPPluginReferralHandler
implements LDAPAuthHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LDAPPluginReferralHandler.class);
    private String bindDN;
    private String bindPassword;

    public LDAPPluginReferralHandler(String bindDN, String bindPassword, XWikiContext context) {
        this.bindDN = bindDN;
        this.bindPassword = bindPassword;
    }

    public LDAPAuthProvider getAuthProvider(String host, int port) {
        try {
            LOGGER.debug("Looking for auth for referral to {}:{}", (Object)host, (Object)port);
            return new LDAPAuthProvider(this.bindDN, this.bindPassword.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.error("Failed to create LDAPAuthProvider for referral {}:{}", (Object)host, (Object)port);
            return null;
        }
    }
}

