/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ldap.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.contrib.ldap.XWikiLDAPConfig;
import org.xwiki.contrib.ldap.XWikiLDAPUtils;

@Component(roles={LDAPGroupsCache.class})
@Singleton
public class LDAPGroupsCache
implements Disposable {
    private static final String CACHE_NAME_GROUPS = "ldap.groups";
    @Inject
    private CacheManager cacheManager;
    private Map<String, Map<String, Cache<Map<String, String>>>> cachePool = new HashMap<String, Map<String, Cache<Map<String, String>>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache<Map<String, String>> getGroupCache(XWikiLDAPUtils utils) throws CacheException {
        Cache cache;
        String cacheKey = utils.getUidAttributeName() + "." + utils.getConnection().getConnection().getHost() + ":" + utils.getConnection().getConnection().getPort();
        Map<String, Map<String, Cache<Map<String, String>>>> map = this.cachePool;
        synchronized (map) {
            Map<Object, Object> cacheMap;
            if (this.cachePool.containsKey(cacheKey)) {
                cacheMap = this.cachePool.get(cacheKey);
            } else {
                cacheMap = new HashMap();
                this.cachePool.put(cacheKey, cacheMap);
            }
            LRUCacheConfiguration cacheConfiguration = this.createCacheConfiguration(utils.getConfiguration(), cacheKey);
            cache = (Cache)cacheMap.get(cacheConfiguration.getConfigurationId());
            if (cache == null) {
                cache = this.cacheManager.createNewCache((CacheConfiguration)cacheConfiguration);
                cacheMap.put(cacheConfiguration.getConfigurationId(), cache);
            }
        }
        return cache;
    }

    @Deprecated
    public LRUCacheConfiguration createCacheConfiguration(XWikiLDAPConfig config) {
        return this.createCacheConfiguration(config, null);
    }

    private LRUCacheConfiguration createCacheConfiguration(XWikiLDAPConfig config, String cacheKeySuffix) {
        LRUCacheConfiguration cacheConfiguration = new LRUCacheConfiguration(cacheKeySuffix == null ? CACHE_NAME_GROUPS : "ldap.groups." + cacheKeySuffix);
        cacheConfiguration.getLRUEvictionConfiguration().setLifespan(config.getCacheExpiration());
        return cacheConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<String, Map<String, Cache<Map<String, String>>>> map = this.cachePool;
        synchronized (map) {
            for (Map<String, Cache<Map<String, String>>> caches : this.cachePool.values()) {
                for (Cache<Map<String, String>> cache : caches.values()) {
                    cache.dispose();
                }
            }
        }
        this.cachePool.clear();
    }

    public void dispose() throws ComponentLifecycleException {
        this.reset();
    }
}

