/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ldap;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.Utils;
import java.security.Provider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.contrib.ldap.XWikiLDAPConnection;
import org.xwiki.contrib.ldap.XWikiLDAPException;
import org.xwiki.stability.Unstable;

public class XWikiLDAPConfig {
    public static final String DEFAULT_SEPARATOR = ",";
    public static final String CFG_LDAP_SUFFIX = "xwiki.authentication.ldap.";
    public static final String CFG_LDAP_PORT = "xwiki.authentication.ldap.port";
    public static final String PREF_LDAP_SUFFIX = "ldap_";
    public static final String PREF_LDAP_PORT = "ldap_port";
    public static final String PREF_LDAP_UID = "ldap_UID_attr";
    public static final String PREF_LDAP_UPDATE_PHOTO = "ldap_update_photo";
    public static final String PREF_LDAP_PHOTO_ATTACHMENT_NAME = "ldap_photo_attachment_name";
    public static final String PREF_LDAP_PHOTO_ATTRIBUTE = "ldap_photo_attribute";
    public static final String USERMAPPING_SEP = ",";
    public static final String USERMAPPING_XWIKI_LDAP_LINK = "=";
    public static final Set<String> DEFAULT_GROUP_CLASSES = new HashSet<String>();
    public static final Set<String> DEFAULT_GROUP_MEMBERFIELDS = new HashSet<String>();
    public static final String DEFAULT_PHOTO_ATTRIBUTE = "thumbnailPhoto";
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiLDAPConfig.class);
    private static final String DEFAULT_SECUREPROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    private static XWikiLDAPConfig instance;
    private final Map<String, String> memoryConfiguration = new HashMap<String, String>();
    private ConfigurationSource configurationSource;
    private ConfigurationSource cfgConfigurationSource;
    private final Map<String, String> finalMemoryConfiguration;

    @Deprecated
    public XWikiLDAPConfig(String userId, XWikiContext xcontext) {
        this(userId);
    }

    public XWikiLDAPConfig(String userId) {
        this(userId, (ConfigurationSource)Utils.getComponent(ConfigurationSource.class, (String)"wiki"));
    }

    public XWikiLDAPConfig(String userId, ConfigurationSource configurationSource) {
        this.configurationSource = configurationSource;
        this.cfgConfigurationSource = (ConfigurationSource)Utils.getComponent(ConfigurationSource.class, (String)"xwikicfg");
        this.finalMemoryConfiguration = new HashMap<String, String>();
        if (userId != null) {
            this.parseRemoteUser(userId);
        }
    }

    @Deprecated
    public static XWikiLDAPConfig getInstance() {
        if (instance == null) {
            instance = new XWikiLDAPConfig(null);
        }
        return instance;
    }

    public Map<String, String> getMemoryConfiguration() {
        return this.memoryConfiguration;
    }

    private void parseRemoteUser(String ssoRemoteUser) {
        Matcher marcher;
        this.memoryConfiguration.put("auth.input", ssoRemoteUser);
        this.memoryConfiguration.put("uid", ssoRemoteUser.trim());
        Pattern remoteUserParser = this.getRemoteUserPattern();
        LOGGER.debug("remoteUserParser: {}", (Object)remoteUserParser);
        if (remoteUserParser != null && (marcher = remoteUserParser.matcher(ssoRemoteUser)).find()) {
            int groupCount = marcher.groupCount();
            if (groupCount == 0) {
                this.memoryConfiguration.put("uid", marcher.group().trim());
            } else {
                for (int g = 1; g <= groupCount; ++g) {
                    String groupValue = marcher.group(g);
                    List<String> remoteUserMapping = this.getRemoteUserMapping(g);
                    for (String configName : remoteUserMapping) {
                        this.memoryConfiguration.put(configName, this.convertRemoteUserMapping(configName, groupValue));
                    }
                }
            }
        }
    }

    private String convertRemoteUserMapping(String propertyName, String propertyValue) {
        Map<String, String> hostConvertor = this.getRemoteUserMapping(propertyName, true);
        LOGGER.debug("hostConvertor: {}", hostConvertor);
        String converted = hostConvertor.get(propertyValue.toLowerCase());
        return converted != null ? converted : propertyValue;
    }

    @Deprecated
    public String getLDAPParam(String name, String cfgName, String def, XWikiContext context) {
        return this.getLDAPParam(name, cfgName, def);
    }

    public String getLDAPParam(String name, String cfgName, String def) {
        if (this.memoryConfiguration.containsKey(name)) {
            return this.memoryConfiguration.get(name);
        }
        String param = (String)this.configurationSource.getProperty(name, String.class);
        if (param == null || "".equals(param)) {
            param = (String)this.cfgConfigurationSource.getProperty(cfgName);
        }
        if (param == null) {
            param = this.finalMemoryConfiguration.get(name);
        }
        if (param == null) {
            param = def;
        }
        return param;
    }

    @Deprecated
    public String getLDAPParam(String name, String def, XWikiContext context) {
        return this.getLDAPParam(name, def);
    }

    public String getLDAPParam(String name, String def) {
        return this.getLDAPParam(name, name.replaceFirst(PREF_LDAP_SUFFIX, CFG_LDAP_SUFFIX), def);
    }

    @Deprecated
    public long getLDAPParamAsLong(String name, long def, XWikiContext context) {
        return this.getLDAPParamAsLong(name, def);
    }

    public long getLDAPParamAsLong(String name, String cfgName, long def) {
        long value;
        String paramStr = this.getLDAPParam(name, name.replace(PREF_LDAP_SUFFIX, CFG_LDAP_SUFFIX), String.valueOf(def));
        try {
            value = Long.valueOf(paramStr);
        }
        catch (Exception e) {
            value = def;
        }
        return value;
    }

    public long getLDAPParamAsLong(String name, long def) {
        return this.getLDAPParamAsLong(name, name.replace(PREF_LDAP_SUFFIX, CFG_LDAP_SUFFIX), def);
    }

    @Deprecated
    public Collection<String> getGroupClasses(XWikiContext context) {
        return this.getGroupClasses();
    }

    public Collection<String> getGroupClasses() {
        Set<String> set;
        String param = this.getLDAPParam("ldap_group_classes", null);
        if (param != null) {
            String[] table = param.split(",");
            set = new HashSet<String>();
            for (String name : table) {
                set.add(name.toLowerCase());
            }
        } else {
            set = DEFAULT_GROUP_CLASSES;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ldap_group_classes: " + set);
        }
        return set;
    }

    @Deprecated
    public Collection<String> getGroupMemberFields(XWikiContext context) {
        return this.getGroupMemberFields();
    }

    public Collection<String> getGroupMemberFields() {
        Set<String> set;
        String param = this.getLDAPParam("ldap_group_memberfields", null);
        if (param != null) {
            String[] table = param.split(",");
            set = new HashSet<String>();
            for (String name : table) {
                set.add(name.toLowerCase());
            }
        } else {
            set = DEFAULT_GROUP_MEMBERFIELDS;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ldap_group_memberfields: " + set);
        }
        return set;
    }

    @Deprecated
    public Provider getSecureProvider(XWikiContext context) throws XWikiLDAPException {
        return this.getSecureProvider();
    }

    public Provider getSecureProvider() throws XWikiLDAPException {
        Provider provider;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String className = this.getLDAPParam("ldap_ssl.secure_provider", DEFAULT_SECUREPROVIDER);
        try {
            provider = (Provider)cl.loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new XWikiLDAPException("Fail to load secure ssl provider.", e);
        }
        return provider;
    }

    @Deprecated
    public boolean isLDAPEnabled(XWikiContext context) {
        return this.isLDAPEnabled();
    }

    public boolean isLDAPEnabled() {
        String param = this.getLDAPParam("ldap", "xwiki.authentication.ldap", "0");
        return param != null && param.equals("1");
    }

    public int getLDAPPort() {
        return (int)this.getLDAPParamAsLong(PREF_LDAP_PORT, CFG_LDAP_PORT, 0L);
    }

    @Deprecated
    public int getLDAPPort(XWikiContext context) {
        return this.getLDAPPort();
    }

    @Deprecated
    public Map<String, Set<String>> getGroupMappings(XWikiContext context) {
        return this.getGroupMappings();
    }

    public Map<String, Set<String>> getGroupMappings() {
        String param = this.getLDAPParam("ldap_group_mapping", "");
        HashMap<String, Set<String>> groupMappings = new HashMap<String, Set<String>>();
        if (param.trim().length() > 0) {
            char[] buffer = param.trim().toCharArray();
            boolean escaped = false;
            StringBuilder mapping = new StringBuilder(param.length());
            for (int i = 0; i < buffer.length; ++i) {
                char c = buffer[i];
                if (escaped) {
                    mapping.append(c);
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == '|') {
                    this.addGroupMapping(mapping.toString(), groupMappings);
                    mapping.setLength(0);
                    continue;
                }
                mapping.append(c);
            }
            if (mapping.length() > 0) {
                this.addGroupMapping(mapping.toString(), groupMappings);
            }
        }
        return groupMappings;
    }

    private void addGroupMapping(String mapping, Map<String, Set<String>> groupMappings) {
        int splitIndex = mapping.indexOf(61);
        if (splitIndex < 1) {
            LOGGER.error("Error parsing ldap_group_mapping attribute [{}]", (Object)mapping);
        } else {
            String xwikigroup = mapping.substring(0, splitIndex);
            String ldapgroup = mapping.substring(splitIndex + 1);
            Set<String> ldapGroups = groupMappings.get(xwikigroup);
            if (ldapGroups == null) {
                ldapGroups = new HashSet<String>();
                groupMappings.put(xwikigroup, ldapGroups);
            }
            ldapGroups.add(ldapgroup);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Groupmapping found [{}] [{}]", (Object)xwikigroup, ldapGroups);
            }
        }
    }

    @Deprecated
    public Map<String, String> getUserMappings(List<String> attrListToFill, XWikiContext context) {
        return this.getUserMappings(attrListToFill);
    }

    public Map<String, String> getUserMappings(List<String> attrListToFill) {
        HashMap<String, String> userMappings = new HashMap<String, String>();
        String ldapFieldMapping = this.getLDAPParam("ldap_fields_mapping", null);
        if (ldapFieldMapping != null && ldapFieldMapping.length() > 0) {
            String[] fields = ldapFieldMapping.split(",");
            for (int j = 0; j < fields.length; ++j) {
                String[] field = fields[j].split(USERMAPPING_XWIKI_LDAP_LINK);
                if (2 == field.length) {
                    String xwikiattr = field[0].replace(" ", "");
                    String ldapattr = field[1].replace(" ", "");
                    userMappings.put(ldapattr.toLowerCase(), xwikiattr);
                    if (attrListToFill == null) continue;
                    attrListToFill.add(ldapattr);
                    continue;
                }
                LOGGER.error("Error parsing LDAP fields mapping attribute from configuration, got [{}]", (Object)fields[j]);
            }
        }
        return userMappings;
    }

    @Deprecated
    public int getCacheExpiration(XWikiContext context) {
        return this.getCacheExpiration();
    }

    public int getCacheExpiration() {
        return (int)this.getLDAPParamAsLong("ldap_groupcache_expiration", 21600L);
    }

    @Deprecated
    public String getLDAPBindDN(XWikiContext context) {
        return this.getLDAPBindDN();
    }

    public String getLDAPBindDN() {
        return this.getLDAPParam("ldap_bind_DN", "{0}");
    }

    @Deprecated
    public String getLDAPBindDN(String input, String password, XWikiContext context) {
        return this.getLDAPBindDN(input, password);
    }

    public String getLDAPBindDN(String input, String password) {
        return MessageFormat.format(this.getLDAPBindDN(), XWikiLDAPConnection.escapeLDAPDNValue(input), XWikiLDAPConnection.escapeLDAPDNValue(password));
    }

    @Deprecated
    public String getLDAPBindPassword(XWikiContext context) {
        return this.getLDAPBindPassword();
    }

    public String getLDAPBindPassword() {
        return this.getLDAPParam("ldap_bind_pass", "{1}");
    }

    @Deprecated
    public String getLDAPBindPassword(String input, String password, XWikiContext context) {
        return this.getLDAPBindPassword(input, password);
    }

    public String getLDAPBindPassword(String input, String password) {
        return MessageFormat.format(this.getLDAPBindPassword(), input, password);
    }

    @Deprecated
    public int getLDAPTimeout(XWikiContext context) {
        return this.getLDAPTimeout();
    }

    public int getLDAPTimeout() {
        return (int)this.getLDAPParamAsLong("ldap_timeout", 0L);
    }

    @Deprecated
    public int getLDAPMaxResults(XWikiContext context) {
        return this.getLDAPMaxResults();
    }

    public int getLDAPMaxResults() {
        return (int)this.getLDAPParamAsLong("ldap_maxresults", 1000L);
    }

    @Deprecated
    public Set<String> getBinaryAttributes(XWikiContext context) {
        return this.getBinaryAttributes();
    }

    public Set<String> getBinaryAttributes() {
        HashSet<String> binaryAttributes = new HashSet<String>();
        binaryAttributes.add(this.getLDAPParam(PREF_LDAP_PHOTO_ATTRIBUTE, DEFAULT_PHOTO_ATTRIBUTE));
        return binaryAttributes;
    }

    @Deprecated
    public List<String> getLDAPListParam(String name, List<String> def, XWikiContext context) {
        return this.getLDAPListParam(name, def);
    }

    public List<String> getLDAPListParam(String name, List<String> def) {
        return this.getLDAPListParam(name, ',', def);
    }

    @Deprecated
    public List<String> getLDAPListParam(String name, char separator, List<String> def, XWikiContext context) {
        return this.getLDAPListParam(name, separator, def);
    }

    public List<String> getLDAPListParam(String name, char separator, List<String> def) {
        List<String> list = def;
        String str = this.getLDAPParam(name, null);
        if (str != null) {
            list = !StringUtils.isEmpty((CharSequence)str) ? this.splitParam(str, separator) : Collections.emptyList();
        }
        return list;
    }

    @Deprecated
    public Map<String, String> getLDAPMapParam(String name, Map<String, String> def, boolean forceLowerCaseKey, XWikiContext context) {
        return this.getLDAPMapParam(name, def, forceLowerCaseKey);
    }

    public Map<String, String> getLDAPMapParam(String name, Map<String, String> def, boolean forceLowerCaseKey) {
        return this.getLDAPMapParam(name, '|', def, forceLowerCaseKey);
    }

    @Deprecated
    public Map<String, String> getLDAPMapParam(String name, char separator, Map<String, String> def, boolean forceLowerCaseKey, XWikiContext context) {
        return this.getLDAPMapParam(name, separator, def, forceLowerCaseKey);
    }

    public Map<String, String> getLDAPMapParam(String name, char separator, Map<String, String> def, boolean forceLowerCaseKey) {
        Map<String, String> mappings = def;
        List<String> list = this.getLDAPListParam(name, separator, null);
        if (list != null) {
            if (list.isEmpty()) {
                mappings = Collections.emptyMap();
            } else {
                mappings = new LinkedHashMap<String, String>();
                for (String fieldStr : list) {
                    int index = fieldStr.indexOf(61);
                    if (index != -1) {
                        String key = fieldStr.substring(0, index);
                        String value = index + 1 == fieldStr.length() ? "" : fieldStr.substring(index + 1);
                        mappings.put(forceLowerCaseKey ? key.toLowerCase() : key, value);
                        continue;
                    }
                    LOGGER.warn("Error parsing LDAP [{}] attribute from configuration, got [{}]", (Object)name, (Object)fieldStr);
                }
            }
        }
        return mappings;
    }

    private List<String> splitParam(String text, char delimiter) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean escaped = false;
        StringBuilder sb = new StringBuilder();
        for (char ch : text.toCharArray()) {
            if (escaped) {
                sb.append(ch);
                escaped = false;
                continue;
            }
            if (ch == delimiter) {
                if (sb.length() <= 0) continue;
                tokens.add(sb.toString());
                sb.delete(0, sb.length());
                continue;
            }
            if (ch == '\\') {
                escaped = true;
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            tokens.add(sb.toString());
        }
        return tokens;
    }

    @Deprecated
    public Pattern getRemoteUserPattern(XWikiContext context) {
        return this.getRemoteUserPattern();
    }

    public Pattern getRemoteUserPattern() {
        String param = this.getLDAPParam("ldap_remoteUserParser", null);
        return param != null ? Pattern.compile(param) : null;
    }

    @Deprecated
    public List<String> getRemoteUserMapping(int groupId, XWikiContext context) {
        return this.getRemoteUserMapping(groupId);
    }

    public List<String> getRemoteUserMapping(int groupId) {
        return this.getLDAPListParam("ldap_remoteUserMapping." + groupId, ',', Collections.emptyList());
    }

    @Deprecated
    public Map<String, String> getRemoteUserMapping(String propertyName, boolean forceLowerCaseKey, XWikiContext context) {
        return this.getRemoteUserMapping(propertyName, forceLowerCaseKey);
    }

    public Map<String, String> getRemoteUserMapping(String propertyName, boolean forceLowerCaseKey) {
        return this.getLDAPMapParam("ldap_remoteUserMapping." + propertyName, '|', Collections.emptyMap(), forceLowerCaseKey);
    }

    @Deprecated
    public Set<String> getTestLoginFor(XWikiContext context) {
        return this.getTestLoginFor();
    }

    public Set<String> getTestLoginFor() {
        List<String> list = this.getLDAPListParam("ldap_testLoginFor", ',', Collections.emptyList());
        HashSet<String> set = new HashSet<String>(list.size());
        for (String uid : list) {
            set.add(StrSubstitutor.replace((Object)uid, this.memoryConfiguration));
        }
        LOGGER.debug("TestLoginFor: {}", set);
        return set;
    }

    @Deprecated
    public String getHttpHeader(XWikiContext context) {
        return this.getHttpHeader();
    }

    public String getHttpHeader() {
        return (String)this.cfgConfigurationSource.getProperty("xwiki.authentication.ldap.httpHeader");
    }

    @Unstable
    public void setFinalProperty(String key, String value) {
        this.finalMemoryConfiguration.put(key, value);
    }

    public int getSearchPageSize() {
        return (int)this.getLDAPParamAsLong("ldap_searchPageSize", 500L);
    }

    static {
        DEFAULT_GROUP_CLASSES.add("group".toLowerCase());
        DEFAULT_GROUP_CLASSES.add("groupOfNames".toLowerCase());
        DEFAULT_GROUP_CLASSES.add("groupOfUniqueNames".toLowerCase());
        DEFAULT_GROUP_CLASSES.add("dynamicGroup".toLowerCase());
        DEFAULT_GROUP_CLASSES.add("dynamicGroupAux".toLowerCase());
        DEFAULT_GROUP_CLASSES.add("groupWiseDistributionList".toLowerCase());
        DEFAULT_GROUP_CLASSES.add("posixGroup".toLowerCase());
        DEFAULT_GROUP_CLASSES.add("apple-group".toLowerCase());
        DEFAULT_GROUP_MEMBERFIELDS.add("member".toLowerCase());
        DEFAULT_GROUP_MEMBERFIELDS.add("uniqueMember".toLowerCase());
        DEFAULT_GROUP_MEMBERFIELDS.add("memberUid".toLowerCase());
    }
}

