/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ldap.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.ldap.LDAPDocumentHelper;
import org.xwiki.contrib.ldap.XWikiLDAPConfig;
import org.xwiki.contrib.ldap.XWikiLDAPSearchAttribute;
import org.xwiki.contrib.ldap.XWikiLDAPUtils;

@Component
@Singleton
public class DefaultLDAPDocumentHelper
implements LDAPDocumentHelper {
    @Inject
    private Logger logger;

    @Override
    public String getDocumentName(String documentNameFormat, String uidAttributeName, List<XWikiLDAPSearchAttribute> attributes, XWikiLDAPConfig config) {
        Map<String, String> memoryConfiguration = config.getMemoryConfiguration();
        HashMap<String, String> valueMap = new HashMap<String, String>();
        if (attributes != null) {
            for (Map.Entry<String, String> entry : memoryConfiguration.entrySet()) {
                this.putVariable(valueMap, entry.getKey(), entry.getValue());
            }
            for (XWikiLDAPSearchAttribute attribute : attributes) {
                this.putVariable(valueMap, "ldap." + attribute.name, attribute.value);
                if (!attribute.name.equals(uidAttributeName)) continue;
                this.putVariable(valueMap, "uid", attribute.value);
            }
        }
        this.logger.debug("User page name format: {}", (Object)documentNameFormat);
        this.logger.debug("User page name subtitution map: {}", valueMap);
        String documentName = StrSubstitutor.replace((Object)documentNameFormat, valueMap);
        this.logger.debug("User page name : [{}]", (Object)documentName);
        documentName = XWikiLDAPUtils.cleanXWikiUserPageName(documentName);
        this.logger.debug("Cleaned user page name : [{}]", (Object)documentName);
        return documentName;
    }

    private void putVariable(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
            map.put(key + "._lowerCase", value.toLowerCase());
            map.put(key + "._upperCase", value.toUpperCase());
            String cleanValue = this.clean(value);
            map.put(key + "._clean", cleanValue);
            map.put(key + "._clean._lowerCase", cleanValue.toLowerCase());
            map.put(key + "._clean._upperCase", cleanValue.toUpperCase());
        }
    }

    private String clean(String str) {
        return StringUtils.removePattern((String)str, (String)"[\\.\\:\\s,@\\^\\/]");
    }
}

