/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.rfc2251;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.client.Debug;
import com.novell.ldap.rfc2251.RfcAddResponse;
import com.novell.ldap.rfc2251.RfcBindResponse;
import com.novell.ldap.rfc2251.RfcCompareResponse;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcDelResponse;
import com.novell.ldap.rfc2251.RfcExtendedResponse;
import com.novell.ldap.rfc2251.RfcIntermediateResponse;
import com.novell.ldap.rfc2251.RfcMessageID;
import com.novell.ldap.rfc2251.RfcModifyDNResponse;
import com.novell.ldap.rfc2251.RfcModifyResponse;
import com.novell.ldap.rfc2251.RfcRequest;
import com.novell.ldap.rfc2251.RfcSearchResultDone;
import com.novell.ldap.rfc2251.RfcSearchResultEntry;
import com.novell.ldap.rfc2251.RfcSearchResultReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RfcLDAPMessage
extends ASN1Sequence {
    private ASN1Object op;
    private RfcControls controls;
    private LDAPMessage requestMessage = null;

    RfcLDAPMessage(ASN1Object[] origContent, RfcRequest origRequest, String dn, String filter, boolean reference) throws LDAPException {
        super(origContent, origContent.length);
        this.set(0, new RfcMessageID());
        RfcRequest req = (RfcRequest)((Object)origContent[1]);
        RfcRequest newreq = req.dupRequest(dn, filter, reference);
        this.op = (ASN1Object)((Object)newreq);
        this.set(1, (ASN1Object)((Object)newreq));
        Debug.trace("Referrals", "RfcLDAPMessage created copy of msg with new id " + this.getMessageID() + ",dn=" + dn + ", filter=" + filter + ", reference=" + reference);
    }

    public RfcLDAPMessage(RfcRequest op) {
        this(op, null);
    }

    public RfcLDAPMessage(RfcRequest op, RfcControls controls) {
        super(3);
        this.op = (ASN1Object)((Object)op);
        this.controls = controls;
        this.add(new RfcMessageID());
        this.add((ASN1Object)((Object)op));
        if (controls != null) {
            this.add(controls);
        }
    }

    public RfcLDAPMessage(ASN1Sequence op) {
        this(op, null);
    }

    public RfcLDAPMessage(ASN1SequenceOf op) {
        super(2);
        this.op = op;
        this.add(new RfcMessageID());
        this.add(op);
    }

    public RfcLDAPMessage(ASN1Sequence op, RfcControls controls) {
        super(3);
        this.op = op;
        this.controls = controls;
        this.add(new RfcMessageID());
        this.add(op);
        if (controls != null) {
            this.add(controls);
        }
    }

    public RfcLDAPMessage(ASN1Decoder dec, InputStream in, int len) throws IOException {
        super(dec, in, len);
        ASN1Tagged protocolOp = (ASN1Tagged)this.get(1);
        ASN1Identifier protocolOpId = protocolOp.getIdentifier();
        byte[] content = ((ASN1OctetString)protocolOp.taggedValue()).byteValue();
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        Debug.trace("Messages", "RfcLDAPMessage: input message w/tag " + protocolOpId.getTag());
        switch (protocolOpId.getTag()) {
            case 4: {
                this.set(1, new RfcSearchResultEntry(dec, bais, content.length));
                break;
            }
            case 5: {
                this.set(1, new RfcSearchResultDone(dec, bais, content.length));
                break;
            }
            case 19: {
                this.set(1, new RfcSearchResultReference(dec, bais, content.length));
                break;
            }
            case 9: {
                this.set(1, new RfcAddResponse(dec, bais, content.length));
                break;
            }
            case 1: {
                this.set(1, new RfcBindResponse(dec, bais, content.length));
                break;
            }
            case 15: {
                this.set(1, new RfcCompareResponse(dec, bais, content.length));
                break;
            }
            case 11: {
                this.set(1, new RfcDelResponse(dec, bais, content.length));
                break;
            }
            case 24: {
                this.set(1, new RfcExtendedResponse(dec, bais, content.length));
                break;
            }
            case 25: {
                this.set(1, new RfcIntermediateResponse(dec, bais, content.length));
                break;
            }
            case 7: {
                this.set(1, new RfcModifyResponse(dec, bais, content.length));
                break;
            }
            case 13: {
                this.set(1, new RfcModifyDNResponse(dec, bais, content.length));
                break;
            }
            default: {
                throw new RuntimeException("RfcLDAPMessage: Invalid tag: " + protocolOpId.getTag());
            }
        }
        if (this.size() > 2) {
            ASN1Tagged controls = (ASN1Tagged)this.get(2);
            content = ((ASN1OctetString)controls.taggedValue()).byteValue();
            bais = new ByteArrayInputStream(content);
            this.set(2, new RfcControls(dec, bais, content.length));
        }
    }

    public final int getMessageID() {
        return ((ASN1Integer)this.get(0)).intValue();
    }

    public final int getType() {
        return this.get(1).getIdentifier().getTag();
    }

    public final ASN1Object getResponse() {
        return this.get(1);
    }

    public final RfcRequest getRequest() {
        return (RfcRequest)((Object)this.get(1));
    }

    public boolean isRequest() {
        return this.get(1) instanceof RfcRequest;
    }

    public final RfcControls getControls() {
        if (this.size() > 2) {
            return (RfcControls)this.get(2);
        }
        return null;
    }

    public final Object dupMessage(String dn, String filter, boolean reference) throws LDAPException {
        if (this.op == null) {
            Debug.trace("Referrals", "RfcLDAPMessage op == null, cannot dupMessage");
            throw new LDAPException("DUP_ERROR", 82, null);
        }
        RfcLDAPMessage newMsg = new RfcLDAPMessage(this.toArray(), (RfcRequest)((Object)this.get(1)), dn, filter, reference);
        return newMsg;
    }

    public final String getRequestDN() {
        return ((RfcRequest)((Object)this.op)).getRequestDN();
    }

    public final void setRequestingMessage(LDAPMessage msg) {
        this.requestMessage = msg;
    }

    public final LDAPMessage getRequestingMessage() {
        return this.requestMessage;
    }
}

