/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AndroidAutoDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    public static final Implementation IMPL = new Implementation(AndroidAutoDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.MANIFEST, Scope.JAVA_FILE), new EnumSet[]{Scope.RESOURCE_FILE_SCOPE});
    public static final Issue INVALID_USES_TAG_ISSUE = Issue.create((String)"InvalidUsesTagAttribute", (String)"Invalid `name` attribute for `uses` element", (String)"The <uses> element in `<automotiveApp>` should contain a valid value for the `name` attribute. Valid values are `media`, `notification`, or `sms`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPL).addMoreInfo("https://developer.android.com/training/auto/start/index.html#auto-metadata");
    public static final Issue MISSING_MEDIA_BROWSER_SERVICE_ACTION_ISSUE = Issue.create((String)"MissingMediaBrowserServiceIntentFilter", (String)"Missing MediaBrowserService intent-filter", (String)"An Automotive Media App requires an exported service that extends `android.service.media.MediaBrowserService` with an `intent-filter` for the action `android.media.browse.MediaBrowserService` to be able to browse and play media.\n\nTo do this, add\n```xml\n`<intent-filter>`\n    `<action android:name=\"android.media.browse.MediaBrowserService\" />`\n`</intent-filter>`\n```\nto the service that extends `android.service.media.MediaBrowserService`", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPL).addMoreInfo("https://developer.android.com/training/auto/audio/index.html#config_manifest");
    public static final Issue MISSING_INTENT_FILTER_FOR_MEDIA_SEARCH = Issue.create((String)"MissingIntentFilterForMediaSearch", (String)"Missing MEDIA_PLAY_FROM_SEARCH intent-filter", (String)"To support voice searches on Android Auto, you should also register an `intent-filter` for the action `android.media.action.MEDIA_PLAY_FROM_SEARCH`.\n\nTo do this, add\n```xml\n`<intent-filter>`\n    `<action android:name=\"android.media.action.MEDIA_PLAY_FROM_SEARCH\" />`\n`</intent-filter>`\n```\nto your `<activity>` or `<service>`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPL).addMoreInfo("https://developer.android.com/training/auto/audio/index.html#support_voice");
    public static final Issue MISSING_ON_PLAY_FROM_SEARCH = Issue.create((String)"MissingOnPlayFromSearch", (String)"Missing `onPlayFromSearch`", (String)"To support voice searches on Android Auto, in addition to adding an `intent-filter` for the action `onPlayFromSearch`, you also need to override and implement `onPlayFromSearch(String query, Bundle bundle)`", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPL).addMoreInfo("https://developer.android.com/training/auto/audio/index.html#support_voice");
    private static final String CAR_APPLICATION_METADATA_NAME = "com.google.android.gms.car.application";
    private static final String VAL_NAME_MEDIA = "media";
    private static final String VAL_NAME_NOTIFICATION = "notification";
    private static final String VAL_NAME_SMS = "sms";
    private static final String VAL_NAME_TEMPLATE = "template";
    private static final String TAG_AUTOMOTIVE_APP = "automotiveApp";
    private static final String ATTR_RESOURCE = "resource";
    private static final String TAG_USES = "uses";
    private static final String ACTION_MEDIA_BROWSER_SERVICE = "android.media.browse.MediaBrowserService";
    private static final String ACTION_MEDIA_PLAY_FROM_SEARCH = "android.media.action.MEDIA_PLAY_FROM_SEARCH";
    private static final String CLASS_MEDIA_SESSION_CALLBACK = "android.media.session.MediaSession.Callback";
    private static final String CLASS_V4MEDIA_SESSION_COMPAT_CALLBACK = "android.support.v4.media.session.MediaSessionCompat.Callback";
    private static final String METHOD_MEDIA_SESSION_PLAY_FROM_SEARCH = "onPlayFromSearch";
    private static final String BUNDLE_ARG = "android.os.Bundle";
    private boolean mDoAutomotiveAppCheck;
    private boolean mMediaIntentFilterFound;
    private boolean mMediaSearchIntentFilterFound;
    private String mAutomotiveResourceFileName;
    private boolean mIsAutomotiveMediaApp;
    private Location.Handle mMainApplicationHandle;

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.XML;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList(TAG_AUTOMOTIVE_APP, "meta-data", "service", "intent-filter", "application");
    }

    public void beforeCheckRootProject(Context context) {
        this.mIsAutomotiveMediaApp = false;
        this.mAutomotiveResourceFileName = null;
        this.mMediaIntentFilterFound = false;
        this.mMediaSearchIntentFilterFound = false;
    }

    public void visitElement(XmlContext context, Element element) {
        String tagName = element.getTagName();
        if ("meta-data".equals(tagName) && !this.mDoAutomotiveAppCheck) {
            this.checkAutoMetadataTag(element);
        } else if (TAG_AUTOMOTIVE_APP.equals(tagName)) {
            this.checkAutomotiveAppElement(context, element);
        } else if ("application".equals(tagName)) {
            if (!context.getProject().isLibrary()) {
                this.mMainApplicationHandle = context.createLocationHandle((Node)element);
                this.mMainApplicationHandle.setClientData((Object)element);
            }
        } else if ("service".equals(tagName)) {
            this.checkServiceForBrowserServiceIntentFilter(element);
        } else if ("intent-filter".equals(tagName)) {
            this.checkForMediaSearchIntentFilter(element);
        }
    }

    private void checkAutoMetadataTag(Element element) {
        String autoFileName;
        String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (CAR_APPLICATION_METADATA_NAME.equals(name) && (autoFileName = element.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_RESOURCE)) != null && autoFileName.startsWith("@xml/")) {
            this.mDoAutomotiveAppCheck = true;
            this.mAutomotiveResourceFileName = autoFileName.substring("@xml/".length()) + ".xml";
        }
    }

    private void checkAutomotiveAppElement(XmlContext context, Element element) {
        boolean isMetadataResource = this.mAutomotiveResourceFileName != null && this.mAutomotiveResourceFileName.equals(context.file.getName());
        for (Element child : XmlUtils.getSubTags((Node)element)) {
            Attr node;
            if (!TAG_USES.equals(child.getTagName())) continue;
            String attrValue = child.getAttribute("name");
            if (VAL_NAME_MEDIA.equals(attrValue)) {
                this.mIsAutomotiveMediaApp |= isMetadataResource;
                continue;
            }
            if (VAL_NAME_TEMPLATE.equals(attrValue) || VAL_NAME_NOTIFICATION.equals(attrValue) || !context.isEnabled(INVALID_USES_TAG_ISSUE) || (node = child.getAttributeNode("name")) == null) continue;
            context.report(INVALID_USES_TAG_ISSUE, (Node)node, context.getLocation((Node)node), "Expecting one of `media`, `notification`, `sms`, or `template` for the name attribute in uses tag");
        }
        if (this.mIsAutomotiveMediaApp && !context.getProject().isLibrary() && this.mMainApplicationHandle != null && this.mDoAutomotiveAppCheck) {
            Element node = (Element)this.mMainApplicationHandle.getClientData();
            if (!this.mMediaIntentFilterFound && context.isEnabled(MISSING_MEDIA_BROWSER_SERVICE_ACTION_ISSUE)) {
                context.report(MISSING_MEDIA_BROWSER_SERVICE_ACTION_ISSUE, (Node)node, this.mMainApplicationHandle.resolve(), "Missing `intent-filter` for action `android.media.browse.MediaBrowserService` that is required for android auto support");
            }
            if (!this.mMediaSearchIntentFilterFound && context.isEnabled(MISSING_INTENT_FILTER_FOR_MEDIA_SEARCH)) {
                context.report(MISSING_INTENT_FILTER_FOR_MEDIA_SEARCH, (Node)node, this.mMainApplicationHandle.resolve(), "Missing `intent-filter` for action `android.media.action.MEDIA_PLAY_FROM_SEARCH`.");
            }
        }
    }

    private void checkServiceForBrowserServiceIntentFilter(Element element) {
        if ("service".equals(element.getTagName()) && !this.mMediaIntentFilterFound) {
            for (Element child : XmlUtils.getSubTags((Node)element)) {
                String tagName = child.getTagName();
                if (!"intent-filter".equals(tagName)) continue;
                for (Element filterChild : XmlUtils.getSubTags((Node)child)) {
                    String actionValue;
                    if (!"action".equals(filterChild.getTagName()) || !ACTION_MEDIA_BROWSER_SERVICE.equals(actionValue = filterChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
                    this.mMediaIntentFilterFound = true;
                    return;
                }
            }
        }
    }

    private void checkForMediaSearchIntentFilter(Element element) {
        if (!this.mMediaSearchIntentFilterFound) {
            for (Element filterChild : XmlUtils.getSubTags((Node)element)) {
                String actionValue;
                if (!"action".equals(filterChild.getTagName()) || !ACTION_MEDIA_PLAY_FROM_SEARCH.equals(actionValue = filterChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
                this.mMediaSearchIntentFilterFound = true;
                break;
            }
        }
    }

    public List<String> applicableSuperClasses() {
        return this.mIsAutomotiveMediaApp ? Arrays.asList(CLASS_MEDIA_SESSION_CALLBACK, CLASS_V4MEDIA_SESSION_COMPAT_CALLBACK) : null;
    }

    public void visitClass(JavaContext context, UClass declaration) {
        if (!context.getEvaluator().isAbstract((PsiModifierListOwner)declaration)) {
            MediaSessionCallbackVisitor visitor2 = new MediaSessionCallbackVisitor(context);
            declaration.accept((UastVisitor)visitor2);
            if (!visitor2.isPlayFromSearchMethodFound() && context.isEnabled(MISSING_ON_PLAY_FROM_SEARCH)) {
                context.report(MISSING_ON_PLAY_FROM_SEARCH, declaration, context.getNameLocation(declaration), "This class does not override `onPlayFromSearch` from `MediaSession.Callback` The method should be overridden and implemented to support Voice search on Android Auto.");
            }
        }
    }

    public static String[] getAllowedAutomotiveAppTypes() {
        return new String[]{VAL_NAME_MEDIA, VAL_NAME_NOTIFICATION, VAL_NAME_SMS, VAL_NAME_TEMPLATE};
    }

    private static class MediaSessionCallbackVisitor
    extends AbstractUastVisitor {
        private final JavaContext mContext;
        private boolean mOnPlayFromSearchFound;

        public MediaSessionCallbackVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean isPlayFromSearchMethodFound() {
            return this.mOnPlayFromSearchFound;
        }

        public boolean visitMethod(UMethod method) {
            if (AndroidAutoDetector.METHOD_MEDIA_SESSION_PLAY_FROM_SEARCH.equals(method.getName()) && this.mContext.getEvaluator().parametersMatch((PsiMethod)method, new String[]{"java.lang.String", AndroidAutoDetector.BUNDLE_ARG})) {
                this.mOnPlayFromSearchFound = true;
            }
            return super.visitMethod(method);
        }
    }
}

