/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl.elements;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.artifact.elements.JpsLibraryFilesPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElementFactory;
import org.jetbrains.jps.model.artifact.elements.ex.JpsComplexPackagingElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.JpsOrderRootType;

public class JpsLibraryFilesPackagingElementImpl
extends JpsComplexPackagingElementBase<JpsLibraryFilesPackagingElementImpl>
implements JpsLibraryFilesPackagingElement {
    private static final JpsElementChildRole<JpsLibraryReference> LIBRARY_REFERENCE_CHILD_ROLE = JpsElementChildRoleBase.create("library reference");

    public JpsLibraryFilesPackagingElementImpl(@NotNull JpsLibraryReference reference) {
        if (reference == null) {
            JpsLibraryFilesPackagingElementImpl.$$$reportNull$$$0(0);
        }
        this.myContainer.setChild(LIBRARY_REFERENCE_CHILD_ROLE, reference);
    }

    private JpsLibraryFilesPackagingElementImpl(JpsLibraryFilesPackagingElementImpl original) {
        super(original);
    }

    @Override
    @NotNull
    public JpsLibraryFilesPackagingElementImpl createCopy() {
        return new JpsLibraryFilesPackagingElementImpl(this);
    }

    @Override
    @NotNull
    public JpsLibraryReference getLibraryReference() {
        JpsLibraryReference jpsLibraryReference = this.myContainer.getChild(LIBRARY_REFERENCE_CHILD_ROLE);
        if (jpsLibraryReference == null) {
            JpsLibraryFilesPackagingElementImpl.$$$reportNull$$$0(1);
        }
        return jpsLibraryReference;
    }

    @Override
    public List<JpsPackagingElement> getSubstitution() {
        JpsLibrary library = (JpsLibrary)this.getLibraryReference().resolve();
        if (library == null) {
            return Collections.emptyList();
        }
        ArrayList<JpsPackagingElement> result2 = new ArrayList<JpsPackagingElement>();
        for (File file2 : library.getFiles(JpsOrderRootType.COMPILED)) {
            String path = FileUtil.toSystemIndependentName(file2.getAbsolutePath());
            if (file2.isDirectory()) {
                result2.add(JpsPackagingElementFactory.getInstance().createDirectoryCopy(path));
                continue;
            }
            result2.add(JpsPackagingElementFactory.getInstance().createFileCopy(path, null));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/artifact/impl/elements/JpsLibraryFilesPackagingElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/artifact/impl/elements/JpsLibraryFilesPackagingElementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

