/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.Function;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.CompletablePromise;
import org.jetbrains.concurrency.InternalPromiseUtilKt;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B%\b\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u000f\u0010\u0017\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J \u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0016J \u0010 \u001a\u0004\u0018\u00018\u00002\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\"H\u0082\b\u00a2\u0006\u0002\u0010#J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010%\u001a\n\u0012\u0006\b\u0000\u0012\u00020'0&H\u0016J \u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0010\u0010)\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u00000&H\u0016J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010+\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000&H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u000e\u0010-\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000,H\u0016J\u000e\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u000200J\u0010\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020'H\u0016J\u0017\u00101\u001a\u00020\u00152\b\u00102\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020\nH\u0014J,\u00105\u001a\b\u0012\u0004\u0012\u0002H60,\"\u0004\b\u0001\u001062\u0016\u00107\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u0002H608H\u0016J2\u00109\u001a\b\u0012\u0004\u0012\u0002H60,\"\u0004\b\u0001\u001062\u001c\u0010:\u001a\u0018\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H60,08H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/concurrency/AsyncPromise;", "T", "Lorg/jetbrains/concurrency/CancellablePromise;", "Lorg/jetbrains/concurrency/CompletablePromise;", "()V", "f", "Ljava/util/concurrent/CompletableFuture;", "hasErrorHandler", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addExceptionHandler", "", "(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/atomic/AtomicBoolean;Z)V", "getF$intellij_platform_concurrency", "()Ljava/util/concurrent/CompletableFuture;", "blockingGet", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(ILjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "cancel", "", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "", "unit", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getState", "Lorg/jetbrains/concurrency/Promise$State;", "isCancelled", "isDone", "nullizeCancelled", "value", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "onError", "rejected", "Ljava/util/function/Consumer;", "", "onProcessed", "processed", "onSuccess", "handler", "Lorg/jetbrains/concurrency/Promise;", "child", "setError", "error", "", "setResult", "t", "(Ljava/lang/Object;)V", "shouldLogErrors", "then", "SUB_RESULT", "done", "Lcom/intellij/util/Function;", "thenAsync", "doneF", "intellij.platform.concurrency"})
public class AsyncPromise<T>
implements CancellablePromise<T>,
CompletablePromise<T> {
    @NotNull
    private final CompletableFuture<T> f;
    private final AtomicBoolean hasErrorHandler;

    @NotNull
    public final CompletableFuture<T> getF$intellij_platform_concurrency() {
        return this.f;
    }

    @Override
    public boolean isDone() {
        return this.f.isDone();
    }

    @Override
    @Nullable
    public T get() {
        Object v0;
        AsyncPromise this_$iv = this;
        boolean $i$f$nullizeCancelled = false;
        if (this_$iv.isCancelled()) {
            v0 = null;
        } else {
            Object var4_5;
            try {
                boolean bl = false;
                var4_5 = this.f.get();
            }
            catch (CancellationException e$iv) {
                var4_5 = null;
            }
            v0 = var4_5;
        }
        return v0;
    }

    @Override
    @Nullable
    public T get(long timeout, @NotNull TimeUnit unit) {
        Object v0;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        AsyncPromise this_$iv = this;
        boolean $i$f$nullizeCancelled = false;
        if (this_$iv.isCancelled()) {
            v0 = null;
        } else {
            Object var7_6;
            try {
                boolean bl = false;
                var7_6 = this.f.get(timeout, unit);
            }
            catch (CancellationException e$iv) {
                var7_6 = null;
            }
            v0 = var7_6;
        }
        return v0;
    }

    private final T nullizeCancelled(Function0<? extends T> value) {
        Object object;
        int $i$f$nullizeCancelled = 0;
        if (this.isCancelled()) {
            return null;
        }
        try {
            object = value.invoke();
        }
        catch (CancellationException e) {
            object = null;
        }
        return (T)object;
    }

    @Override
    public boolean isCancelled() {
        return this.f.isCancelled();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return !this.isCancelled() && this.f.completeExceptionally(AsyncPromiseKt.access$getCANCELED$p());
    }

    @Override
    public void cancel() {
        this.cancel(true);
    }

    @Override
    @NotNull
    public Promise.State getState() {
        return !this.f.isDone() ? Promise.State.PENDING : (this.f.isCompletedExceptionally() ? Promise.State.REJECTED : Promise.State.SUCCEEDED);
    }

    @Override
    @NotNull
    public AsyncPromise<T> onSuccess(@NotNull Consumer<? super T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        CompletionStage completionStage = this.f.whenComplete(new BiConsumer(handler){
            final /* synthetic */ Consumer $handler;

            public final void accept(T value, Throwable error) {
                if (error != null) {
                    throw error;
                }
                if (!InternalPromiseUtilKt.isHandlerObsolete(this.$handler)) {
                    this.$handler.accept(value);
                }
            }
            {
                this.$handler = consumer;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"f.whenComplete { value, \u2026cept(value)\n      }\n    }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler, true);
    }

    @Override
    @NotNull
    public AsyncPromise<T> onError(@NotNull Consumer<? super Throwable> rejected2) {
        Intrinsics.checkNotNullParameter(rejected2, (String)"rejected");
        this.hasErrorHandler.set(true);
        CompletionStage completionStage = this.f.whenComplete(new BiConsumer(rejected2){
            final /* synthetic */ Consumer $rejected;

            public final void accept(T $noName_0, Throwable exception) {
                if (exception != null && !InternalPromiseUtilKt.isHandlerObsolete(this.$rejected)) {
                    Throwable throwable;
                    Throwable throwable2 = exception;
                    if (!(throwable2 instanceof CompletionException)) {
                        throwable2 = null;
                    }
                    if ((throwable = (CompletionException)throwable2) == null || (throwable = throwable.getCause()) == null) {
                        throwable = exception;
                    }
                    this.$rejected.accept(throwable);
                }
            }
            {
                this.$rejected = consumer;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"f.whenComplete { _, exce\u2026)\n        }\n      }\n    }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler, false);
    }

    @Override
    @NotNull
    public AsyncPromise<T> onProcessed(@NotNull Consumer<? super T> processed2) {
        Intrinsics.checkNotNullParameter(processed2, (String)"processed");
        CompletionStage completionStage = this.f.whenComplete(new BiConsumer(processed2){
            final /* synthetic */ Consumer $processed;

            public final void accept(T value, Throwable $noName_1) {
                if (!InternalPromiseUtilKt.isHandlerObsolete(this.$processed)) {
                    this.$processed.accept(value);
                }
            }
            {
                this.$processed = consumer;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"f.whenComplete { value, \u2026cept(value)\n      }\n    }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler, true);
    }

    @Override
    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        try {
            return this.get(timeout, timeUnit);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throw (Throwable)e;
            }
            Throwable cause = throwable;
            if (cause == InternalPromiseUtilKt.getOBSOLETE_ERROR()) {
                return null;
            }
            ExceptionUtilRt.rethrowUnchecked(cause);
            throw (Throwable)e;
        }
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done2) {
        Intrinsics.checkNotNullParameter(done2, (String)"done");
        CompletionStage completionStage = this.f.thenApply(new java.util.function.Function(done2){
            final /* synthetic */ Function $done;

            public final SUB_RESULT apply(T it) {
                return (SUB_RESULT)this.$done.fun(it);
            }
            {
                this.$done = function;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"f.thenApply { done.`fun`(it) }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler, true);
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, ? extends Promise<SUB_RESULT>> doneF) {
        Intrinsics.checkNotNullParameter(doneF, (String)"doneF");
        CompletionStage completionStage = this.f.thenCompose(new java.util.function.Function(doneF){
            final /* synthetic */ Function $doneF;

            public final CompletionStage<SUB_RESULT> apply(T it) {
                Promise promise = (Promise)this.$doneF.fun(it);
                CompletableFuture<T> future = new CompletableFuture<T>();
                promise.onSuccess(new Consumer(future){
                    final /* synthetic */ CompletableFuture $future;

                    public final void accept(SUB_RESULT value) {
                        this.$future.complete(value);
                    }
                    {
                        this.$future = completableFuture;
                    }
                }).onError(new Consumer(future){
                    final /* synthetic */ CompletableFuture $future;

                    public final void accept(Throwable error) {
                        this.$future.completeExceptionally(error);
                    }
                    {
                        this.$future = completableFuture;
                    }
                });
                return future;
            }
            {
                this.$doneF = function;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"f.thenCompose {\n      va\u2026ror) }\n      future\n    }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler, true);
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull Promise<? super T> child) {
        Intrinsics.checkNotNullParameter(child, (String)"child");
        if (!(child instanceof AsyncPromise)) {
            return this;
        }
        return ((AsyncPromise)this.onSuccess(new Consumer(child){
            final /* synthetic */ Promise $child;

            public final void accept(T it) {
                ((AsyncPromise)this.$child).setResult(it);
            }
            {
                this.$child = promise;
            }
        })).onError(new Consumer(child){
            final /* synthetic */ Promise $child;

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((AsyncPromise)this.$child).setError(it);
            }
            {
                this.$child = promise;
            }
        });
    }

    @Override
    public void setResult(@Nullable T t) {
        this.f.complete(t);
    }

    @Override
    public boolean setError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (!this.f.completeExceptionally(error)) {
            return false;
        }
        if (this.shouldLogErrors()) {
            Logger logger = Logger.getInstance(AsyncPromise.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(AsyncPromise::class.java)");
            Promises.errorIfNotMessage(logger, error);
        }
        return true;
    }

    protected boolean shouldLogErrors() {
        return !this.hasErrorHandler.get();
    }

    public final boolean setError(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return this.setError(Promises.createError$default(error, false, 2, null));
    }

    private AsyncPromise(CompletableFuture<T> f, AtomicBoolean hasErrorHandler, boolean addExceptionHandler) {
        CompletionStage<T> completionStage;
        this.hasErrorHandler = hasErrorHandler;
        if (addExceptionHandler) {
            CompletionStage completionStage2 = f.exceptionally(new java.util.function.Function(){

                public final T apply(Throwable originalError) {
                    Throwable error;
                    Throwable throwable;
                    Throwable throwable2 = originalError;
                    if (!(throwable2 instanceof CompletionException)) {
                        throwable2 = null;
                    }
                    if ((throwable = (CompletionException)throwable2) == null || (throwable = throwable.getCause()) == null) {
                        throwable = error = originalError;
                    }
                    if (this.shouldLogErrors()) {
                        Throwable throwable3;
                        Logger logger = Logger.getInstance(AsyncPromise.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(AsyncPromise::class.java)");
                        Throwable throwable4 = error;
                        if (!(throwable4 instanceof CompletionException)) {
                            throwable4 = throwable3 = null;
                        }
                        if (throwable4 == null || (throwable3 = throwable3.getCause()) == null) {
                            throwable3 = error;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)throwable3, (String)"(error as? CompletionException)?.cause ?: error");
                        Promises.errorIfNotMessage(logger, throwable3);
                    }
                    Throwable throwable5 = error;
                    Intrinsics.checkNotNullExpressionValue((Object)throwable5, (String)"error");
                    throw throwable5;
                }
            });
            completionStage = completionStage2;
            Intrinsics.checkNotNullExpressionValue((Object)completionStage2, (String)"f.exceptionally { origin\u2026    throw error\n        }");
        } else {
            completionStage = f;
        }
        this.f = completionStage;
    }

    public AsyncPromise() {
        this(new CompletableFuture(), new AtomicBoolean(), false);
    }
}

