/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResizeableMappedFile
implements Forceable {
    private static final Logger LOG = Logger.getInstance(ResizeableMappedFile.class);
    private static final boolean truncateOnClose = SystemProperties.getBooleanProperty("idea.resizeable.file.truncate.on.close", false);
    private volatile long myLogicalSize;
    private volatile long myLastWrittenLogicalSize;
    private final PagedFileStorage myStorage;
    private final int myInitialSize;
    static final int DEFAULT_ALLOCATION_ROUND_FACTOR = 4096;
    private int myRoundFactor;

    public ResizeableMappedFile(@NotNull Path file2, int initialSize, @Nullable StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        if (file2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(0);
        }
        this(file2, initialSize, lockContext, pageSize, valuesAreBufferAligned, false);
    }

    public ResizeableMappedFile(@NotNull Path file2, int initialSize, @Nullable StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, boolean nativeBytesOrder) throws IOException {
        if (file2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(1);
        }
        this.myRoundFactor = 4096;
        this.myStorage = new PagedFileStorage(file2, lockContext, pageSize, valuesAreBufferAligned, nativeBytesOrder);
        this.ensureParentDirectoryExists();
        this.myInitialSize = initialSize;
        this.myLastWrittenLogicalSize = this.myLogicalSize = this.readLength();
    }

    public void clear() throws IOException {
        this.myStorage.resize(0L);
        this.myLogicalSize = 0L;
        this.myLastWrittenLogicalSize = 0L;
    }

    public long length() {
        return this.myLogicalSize;
    }

    private long realSize() {
        return this.myStorage.length();
    }

    void ensureSize(long pos) {
        this.myLogicalSize = Math.max(pos, this.myLogicalSize);
        this.expand(pos);
    }

    public void setRoundFactor(int roundFactor) {
        this.myRoundFactor = roundFactor;
    }

    private void expand(long max) {
        long suggestedSize;
        long realSize = this.realSize();
        if (max <= realSize) {
            return;
        }
        if (realSize == 0L) {
            suggestedSize = this.doRoundToFactor(Math.max((long)this.myInitialSize, max));
        } else {
            suggestedSize = Math.max(realSize + 1L, 2L);
            while (max > suggestedSize) {
                long newSuggestedSize = suggestedSize * 13L >> 3;
                if (newSuggestedSize >= Integer.MAX_VALUE) {
                    suggestedSize += suggestedSize / 5L;
                    continue;
                }
                suggestedSize = newSuggestedSize;
            }
            suggestedSize = this.doRoundToFactor(suggestedSize);
        }
        try {
            this.myStorage.resize(suggestedSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long doRoundToFactor(long suggestedSize) {
        int roundFactor = this.myRoundFactor;
        if (suggestedSize % (long)roundFactor != 0L) {
            suggestedSize = (suggestedSize / (long)roundFactor + 1L) * (long)roundFactor;
        }
        return suggestedSize;
    }

    private Path getLengthFile() {
        Path file2 = this.myStorage.getFile();
        return file2.resolveSibling(file2.getFileName() + ".len");
    }

    private void writeLength(long len) {
        Path lengthFile = this.getLengthFile();
        try (DataOutputStream stream = FileUtilRt.doIOOperation(lastAttempt -> {
            try {
                return new DataOutputStream(Files.newOutputStream(lengthFile, new OpenOption[0]));
            }
            catch (NoSuchFileException ex) {
                this.ensureParentDirectoryExists();
                if (!lastAttempt) {
                    return null;
                }
                throw ex;
            }
        });){
            if (stream != null) {
                stream.writeLong(len);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Override
    public boolean isDirty() {
        return this.myStorage.isDirty();
    }

    @Override
    public void force() throws IOException {
        this.ensureLengthWritten();
        this.myStorage.force();
    }

    private void ensureLengthWritten() {
        if (this.myLastWrittenLogicalSize != this.myLogicalSize) {
            this.writeLength(this.myLogicalSize);
            this.myLastWrittenLogicalSize = this.myLogicalSize;
        }
    }

    private void ensureParentDirectoryExists() throws IOException {
        Path parent = this.getLengthFile().getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    private long readLength() throws IOException {
        long l;
        Path lengthFile = this.getLengthFile();
        long zero = 0L;
        if (!(Files.exists(lengthFile, new LinkOption[0]) || Files.exists(this.myStorage.getFile(), new LinkOption[0]) && Files.size(this.myStorage.getFile()) != zero)) {
            this.writeLength(zero);
            return zero;
        }
        DataInputStream stream = new DataInputStream(Files.newInputStream(lengthFile, StandardOpenOption.READ));
        try {
            l = stream.readLong();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                long realSize = this.realSize();
                this.writeLength(realSize);
                LOG.error("storage size = " + realSize + ", file size = " + Files.size(this.myStorage.getFile()), e);
                return realSize;
            }
        }
        stream.close();
        return l;
    }

    public int getInt(long index) throws IOException {
        return this.myStorage.getInt(index);
    }

    public void putInt(long index, int value) throws IOException {
        this.ensureSize(index + 4L);
        this.myStorage.putInt(index, value);
    }

    public long getLong(long index) throws IOException {
        return this.myStorage.getLong(index);
    }

    public void putLong(long index, long value) throws IOException {
        this.ensureSize(index + 8L);
        this.myStorage.putLong(index, value);
    }

    public byte get(long index) throws IOException {
        return this.myStorage.get(index);
    }

    public void get(long index, byte[] dst, int offset, int length) throws IOException {
        this.myStorage.get(index, dst, offset, length);
    }

    public void put(long index, byte[] src, int offset, int length) throws IOException {
        this.ensureSize(index + (long)length);
        this.myStorage.put(index, src, offset, length);
    }

    public void close() throws IOException {
        SmartList exceptions = new SmartList();
        ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(() -> {
            if (!this.getLengthFile().getFileSystem().isReadOnly()) {
                this.writeLength(this.myLogicalSize);
            } else assert (this.myLogicalSize == this.myLastWrittenLogicalSize);
            this.myStorage.force();
            if (truncateOnClose && this.myLogicalSize < this.myStorage.length()) {
                this.myStorage.resize(this.myLogicalSize);
            }
        }));
        ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(() -> this.myStorage.close()));
        if (!exceptions.isEmpty()) {
            throw new IOException(new CompoundRuntimeException(exceptions));
        }
    }

    @NotNull
    public PagedFileStorage getPagedFileStorage() {
        PagedFileStorage pagedFileStorage = this.myStorage;
        if (pagedFileStorage == null) {
            ResizeableMappedFile.$$$reportNull$$$0(2);
        }
        return pagedFileStorage;
    }

    @NotNull
    public StorageLockContext getStorageLockContext() {
        StorageLockContext storageLockContext = this.myStorage.getStorageLockContext();
        if (storageLockContext == null) {
            ResizeableMappedFile.$$$reportNull$$$0(3);
        }
        return storageLockContext;
    }

    @NotNull
    public <R> R readInputStream(@NotNull ThrowableNotNullFunction<? super InputStream, R, ? extends IOException> consumer) throws IOException {
        if (consumer == null) {
            ResizeableMappedFile.$$$reportNull$$$0(4);
        }
        R r = this.myStorage.readInputStream(consumer);
        if (r == null) {
            ResizeableMappedFile.$$$reportNull$$$0(5);
        }
        return r;
    }

    @NotNull
    public <R> R readChannel(@NotNull ThrowableNotNullFunction<? super ReadableByteChannel, R, ? extends IOException> consumer) throws IOException {
        if (consumer == null) {
            ResizeableMappedFile.$$$reportNull$$$0(6);
        }
        R r = this.myStorage.readChannel(consumer);
        if (r == null) {
            ResizeableMappedFile.$$$reportNull$$$0(7);
        }
        return r;
    }

    public void lockRead() {
        this.myStorage.lockRead();
    }

    public void unlockRead() {
        this.myStorage.unlockRead();
    }

    public void lockWrite() {
        this.myStorage.lockWrite();
    }

    public void unlockWrite() {
        this.myStorage.unlockWrite();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/ResizeableMappedFile";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/ResizeableMappedFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPagedFileStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageLockContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readInputStream";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readChannel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readInputStream";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readChannel";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

