/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ByteBufferUtil;
import com.intellij.util.io.DirectByteBufferAllocator;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectBufferWrapper {
    @NotNull
    private static final ByteOrder ourNativeByteOrder = ByteOrder.nativeOrder();
    @NotNull
    private final PagedFileStorage myFile;
    private final long myPosition;
    private final int myLength;
    private final boolean myReadOnly;
    private volatile ByteBuffer myBuffer;
    private volatile boolean myDirty;
    private volatile boolean myReleased;

    /*
     * WARNING - void declaration
     */
    DirectBufferWrapper(@NotNull PagedFileStorage file2, long offset, int length, boolean bl) throws IOException {
        void readOnly;
        if (file2 == null) {
            DirectBufferWrapper.$$$reportNull$$$0(0);
        }
        this.myReleased = false;
        this.myFile = file2;
        this.myPosition = offset;
        this.myLength = length;
        this.myReadOnly = readOnly;
        this.myBuffer = DirectByteBufferAllocator.allocate(() -> this.create());
        this.myFile.getStorageLockContext().assertUnderSegmentAllocationLock();
    }

    private void markDirty() throws IOException {
        if (this.myReadOnly) {
            throw new IOException("Read-only byte buffer can't be modified. File: " + this.myFile);
        }
        if (!this.myDirty) {
            this.myDirty = true;
            this.myFile.markDirty();
        }
    }

    boolean isDirty() {
        return this.myDirty;
    }

    public ByteBuffer copy() {
        try {
            return DirectByteBufferAllocator.allocate(() -> {
                ByteBuffer duplicate = this.myBuffer.duplicate();
                duplicate.order(this.myBuffer.order());
                return duplicate;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte get(int index) {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkReadAccess();
        return this.myBuffer.get(index);
    }

    public long getLong(int index) {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkReadAccess();
        return this.myBuffer.getLong(index);
    }

    public ByteBuffer putLong(int index, long value) throws IOException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        return this.myBuffer.putLong(index, value);
    }

    public int getInt(int index) {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkReadAccess();
        return this.myBuffer.getInt(index);
    }

    public ByteBuffer putInt(int index, int value) throws IOException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        return this.myBuffer.putInt(index, value);
    }

    public void position(int newPosition) {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.myBuffer.position(newPosition);
    }

    public int position() {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkReadAccess();
        return this.myBuffer.position();
    }

    public void put(ByteBuffer src) throws IOException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        this.myBuffer.put(src);
    }

    public void put(int index, byte b) throws IOException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        this.myBuffer.put(index, b);
    }

    public void readToArray(byte[] dst, int o, int page_offset, int page_len) throws IllegalArgumentException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkReadAccess();
        this.myBuffer.position(page_offset);
        this.myBuffer.get(dst, o, page_len);
    }

    public void putFromArray(byte[] src, int o, int page_offset, int page_len) throws IOException, IllegalArgumentException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        this.myBuffer.position(page_offset);
        this.myBuffer.put(src, o, page_len);
    }

    private ByteBuffer create() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.myLength);
        return this.myFile.useChannel(ch -> {
            ch.read(buffer, this.myPosition);
            return buffer;
        }, this.myReadOnly);
    }

    void release() throws IOException {
        this.myFile.getStorageLockContext().assertUnderSegmentAllocationLock();
        if (this.isDirty()) {
            this.force();
        }
        if (this.myBuffer != null) {
            ByteBufferUtil.cleanBuffer(this.myBuffer);
            this.myBuffer = null;
            this.myReleased = true;
        }
    }

    boolean isReleased() {
        return this.myReleased;
    }

    void force() throws IOException {
        this.myFile.getStorageLockContext().assertUnderSegmentAllocationLock();
        assert (!this.myReadOnly);
        if (!this.isReleased() && this.isDirty()) {
            ByteBuffer buffer = this.myBuffer;
            buffer.rewind();
            this.myFile.useChannel(ch -> {
                ch.write(buffer, this.myPosition);
                return null;
            }, this.myReadOnly);
            this.myDirty = false;
        }
    }

    int getLength() {
        return this.myLength;
    }

    public String toString() {
        return "Buffer for " + this.myFile + ", offset:" + this.myPosition + ", size: " + this.myLength;
    }

    public void useNativeByteOrder() {
        if (this.myBuffer.order() != ourNativeByteOrder) {
            this.myBuffer.order(ourNativeByteOrder);
        }
    }

    boolean belongs(@NotNull StorageLockContext context2) {
        if (context2 == null) {
            DirectBufferWrapper.$$$reportNull$$$0(1);
        }
        return this.myFile.getStorageLockContext() == context2;
    }

    public static DirectBufferWrapper readWriteDirect(PagedFileStorage file2, long offset, int length) throws IOException {
        return new DirectBufferWrapper(file2, offset, length, false);
    }

    public static DirectBufferWrapper readOnlyDirect(PagedFileStorage file2, long offset, int length) throws IOException {
        return new DirectBufferWrapper(file2, offset, length, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/DirectBufferWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "belongs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

