/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Chunk;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GraphAlgorithms {
    public static GraphAlgorithms getInstance() {
        return ApplicationManager.getApplication().getService(GraphAlgorithms.class);
    }

    @NotNull
    public abstract <Node> Collection<Node> findNodesWhichBelongToAnyPathBetweenTwoNodes(@NotNull Graph<Node> var1, @NotNull Node var2, @NotNull Node var3);

    @NotNull
    public abstract <Node> Collection<Node> findNodeNeighbourhood(@NotNull Graph<Node> var1, @NotNull Node var2, int var3);

    @Nullable
    public abstract <Node> List<Node> findShortestPath(@NotNull InboundSemiGraph<Node> var1, @NotNull Node var2, @NotNull Node var3);

    @NotNull
    public abstract <Node> List<List<Node>> findKShortestPaths(@NotNull Graph<Node> var1, @NotNull Node var2, @NotNull Node var3, int var4, @NotNull ProgressIndicator var5);

    @NotNull
    public abstract <Node> Set<List<Node>> findCycles(@NotNull Graph<Node> var1, @NotNull Node var2);

    public abstract <Node> void iterateOverAllSimpleCycles(@NotNull Graph<Node> var1, @NotNull Consumer<List<Node>> var2);

    @NotNull
    public abstract <Node> List<List<Node>> removePathsWithCycles(@NotNull List<? extends List<Node>> var1);

    @NotNull
    public abstract <Node> Graph<Node> invertEdgeDirections(@NotNull Graph<Node> var1);

    @NotNull
    public abstract <Node> Collection<Chunk<Node>> computeStronglyConnectedComponents(@NotNull Graph<Node> var1);

    @NotNull
    public abstract <Node> Graph<Chunk<Node>> computeSCCGraph(@NotNull Graph<Node> var1);

    public abstract <Node> void collectOutsRecursively(@NotNull Graph<Node> var1, Node var2, Set<? super Node> var3);
}

