/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fmap;

import com.intellij.util.fmap.FMap;
import com.intellij.util.fmap.MapBackedFMap;
import com.intellij.util.fmap.TwoKeysFMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ArrayBackedFMap<@NotNull K, @NotNull V>
implements FMap<K, V> {
    static final int ARRAY_THRESHOLD = 8;
    @NotNull
    private final @NotNull Object @NotNull [] myData;

    ArrayBackedFMap(Object ... data) {
        if (data == null) {
            ArrayBackedFMap.$$$reportNull$$$0(0);
        }
        assert (6 <= data.length);
        assert (data.length <= 16);
        this.myData = data;
    }

    ArrayBackedFMap(@NotNull Map<K, V> map2) {
        if (map2 == null) {
            ArrayBackedFMap.$$$reportNull$$$0(1);
        }
        assert (map2.size() <= 8);
        Object[] data = new Object[map2.size() * 2];
        int i = 0;
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            data[i++] = entry.getKey();
            data[i++] = entry.getValue();
        }
        assert (i == data.length);
        this.myData = data;
    }

    @Override
    @NotNull
    public FMap<K, V> plus(K key, V value) {
        for (int i = 0; i < this.myData.length; i += 2) {
            if (!this.myData[i].equals(key)) continue;
            if (this.myData[i + 1].equals(value)) {
                ArrayBackedFMap arrayBackedFMap = this;
                if (arrayBackedFMap == null) {
                    ArrayBackedFMap.$$$reportNull$$$0(2);
                }
                return arrayBackedFMap;
            }
            Object[] newData = (Object[])this.myData.clone();
            newData[i + 1] = value;
            return new ArrayBackedFMap<K, V>(newData);
        }
        if (this.size() < 8) {
            int length = this.myData.length;
            Object[] newData = Arrays.copyOf(this.myData, length + 2);
            newData[length] = key;
            newData[length + 1] = value;
            return new ArrayBackedFMap<K, V>(newData);
        }
        Map<K, V> map2 = this.toMapInner();
        map2.put(key, value);
        return new MapBackedFMap<K, V>(map2);
    }

    @Override
    @NotNull
    public FMap<K, V> minus(K key) {
        for (int i = 0; i < this.myData.length; i += 2) {
            if (!this.myData[i].equals(key)) continue;
            if (this.size() == 3) {
                if (i == 0) {
                    return new TwoKeysFMap<Object, Object>(this.myData[2], this.myData[3], this.myData[4], this.myData[5]);
                }
                if (i == 2) {
                    return new TwoKeysFMap<Object, Object>(this.myData[0], this.myData[1], this.myData[4], this.myData[5]);
                }
                assert (i == 4);
                return new TwoKeysFMap<Object, Object>(this.myData[0], this.myData[1], this.myData[2], this.myData[3]);
            }
            Object[] newData = new Object[this.myData.length - 2];
            System.arraycopy(this.myData, 0, newData, 0, i);
            System.arraycopy(this.myData, i + 2, newData, i, this.myData.length - 2 - i);
            return new ArrayBackedFMap<K, V>(newData);
        }
        ArrayBackedFMap arrayBackedFMap = this;
        if (arrayBackedFMap == null) {
            ArrayBackedFMap.$$$reportNull$$$0(3);
        }
        return arrayBackedFMap;
    }

    @Override
    @Nullable
    public V get(K key) {
        for (int i = 0; i < this.myData.length; i += 2) {
            if (!this.myData[i].equals(key)) continue;
            return (V)this.myData[i + 1];
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.myData.length / 2;
    }

    @Override
    @NotNull
    public Collection<K> keys() {
        ArrayList<Object> result2 = new ArrayList<Object>(this.size());
        for (int i = 0; i < this.myData.length; i += 2) {
            result2.add(this.myData[i]);
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            ArrayBackedFMap.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Map<K, V> toMap() {
        Map<K, V> map2 = Collections.unmodifiableMap(this.toMapInner());
        if (map2 == null) {
            ArrayBackedFMap.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @NotNull
    private Map<K, V> toMapInner() {
        HashMap<Object, Object> map2 = new HashMap<Object, Object>(this.size());
        for (int i = 0; i < this.myData.length; i += 2) {
            map2.put(this.myData[i], this.myData[i + 1]);
        }
        HashMap<Object, Object> hashMap = map2;
        if (hashMap == null) {
            ArrayBackedFMap.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayBackedFMap map2 = (ArrayBackedFMap)o;
        if (this.size() != map2.size()) {
            return false;
        }
        return this.toMapInner().equals(map2.toMapInner());
    }

    public int hashCode() {
        int keysHash = 0;
        int valuesHash = 0;
        for (int i = 0; i < this.myData.length; i += 2) {
            keysHash ^= this.myData[i].hashCode();
            valuesHash ^= this.myData[i + 1].hashCode();
        }
        return keysHash + 31 * valuesHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (int i = 0; i < this.myData.length; i += 2) {
            sb.append("  ").append(this.myData[i]).append(": ").append(this.myData[i + 1]).append(",\n");
        }
        sb.append("]");
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/fmap/ArrayBackedFMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/fmap/ArrayBackedFMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "plus";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toMapInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

