/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.core.JavaPsiBundle;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeCompatibilityConstraint
implements ConstraintFormula {
    private PsiType myT;
    private PsiType myS;

    public TypeCompatibilityConstraint(@NotNull PsiType t, @NotNull PsiType s) {
        if (t == null) {
            TypeCompatibilityConstraint.$$$reportNull$$$0(0);
        }
        if (s == null) {
            TypeCompatibilityConstraint.$$$reportNull$$$0(1);
        }
        this.myT = t.annotate(TypeAnnotationProvider.EMPTY);
        this.myS = s.annotate(TypeAnnotationProvider.EMPTY);
    }

    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        PsiClassType boxedType;
        if (session.isProperType(this.myT) && session.isProperType(this.myS)) {
            boolean assignable = TypeConversionUtil.isAssignable(this.myT, this.myS);
            if (!assignable) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.not.convertible", session.getPresentableText(this.myS), session.getPresentableText(this.myT)));
            }
            return assignable;
        }
        if (this.myS instanceof PsiPrimitiveType && !PsiType.VOID.equals(this.myS) && (boxedType = ((PsiPrimitiveType)this.myS).getBoxedType(session.getManager(), session.getScope())) != null) {
            constraints.add(new TypeCompatibilityConstraint(this.myT, boxedType));
            return true;
        }
        if (this.myT instanceof PsiPrimitiveType && !PsiType.VOID.equals(this.myT) && (boxedType = ((PsiPrimitiveType)this.myT).getBoxedType(session.getManager(), session.getScope())) != null) {
            constraints.add(new TypeEqualityConstraint(boxedType, this.myS));
            return true;
        }
        if (TypeCompatibilityConstraint.isUncheckedConversion(this.myT, this.myS, session)) {
            session.setErased();
            return true;
        }
        constraints.add(new StrictSubtypingConstraint(this.myT, this.myS));
        return true;
    }

    public static boolean isUncheckedConversion(PsiType t, PsiType s, InferenceSession session) {
        if (t instanceof PsiClassType && !((PsiClassType)t).isRaw()) {
            PsiClassType.ClassResolveResult tResult = ((PsiClassType)t).resolveGenerics();
            PsiClass tClass = tResult.getElement();
            if (s instanceof PsiClassType && TypeCompatibilityConstraint.isUncheckedConversion(tClass, (PsiClassType)s, session)) {
                return true;
            }
            if (s instanceof PsiIntersectionType) {
                for (PsiType conjunct : ((PsiIntersectionType)s).getConjuncts()) {
                    if (!(conjunct instanceof PsiClassType) || !TypeCompatibilityConstraint.isUncheckedConversion(tClass, (PsiClassType)conjunct, session)) continue;
                    return true;
                }
            }
        } else if (t instanceof PsiArrayType && s != null && t.getArrayDimensions() == s.getArrayDimensions()) {
            return TypeCompatibilityConstraint.isUncheckedConversion(t.getDeepComponentType(), s.getDeepComponentType(), session);
        }
        return false;
    }

    private static boolean isUncheckedConversion(PsiClass tClass, PsiClassType s, InferenceSession session) {
        PsiClassType.ClassResolveResult sResult = s.resolveGenerics();
        PsiClass sClass = sResult.getElement();
        if (tClass != null && sClass != null && !(sClass instanceof InferenceVariable)) {
            PsiSubstitutor sSubstitutor = TypeConversionUtil.getClassSubstitutor(tClass, sClass, sResult.getSubstitutor());
            if (sSubstitutor != null) {
                if (PsiUtil.isRawSubstitutor(tClass, sSubstitutor)) {
                    return true;
                }
            } else if (tClass instanceof InferenceVariable && s.isRaw()) {
                for (PsiType bound : ((InferenceVariable)tClass).getBounds(InferenceBound.UPPER)) {
                    PsiClass boundClass;
                    if (session.isProperType(bound) || !InheritanceUtil.isInheritorOrSelf(boundClass = PsiUtil.resolveClassInClassTypeOnly(bound), sClass, true)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.myT = substitutor.substitute(this.myT);
        this.myS = substitutor.substitute(this.myS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeCompatibilityConstraint that = (TypeCompatibilityConstraint)o;
        if (!this.myS.equals(that.myS)) {
            return false;
        }
        return this.myT.equals(that.myT);
    }

    public int hashCode() {
        int result2 = this.myT.hashCode();
        result2 = 31 * result2 + this.myS.hashCode();
        return result2;
    }

    public String toString() {
        return this.myS.getPresentableText() + " -> " + this.myT.getPresentableText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "t";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "s";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/resolve/graphInference/constraints/TypeCompatibilityConstraint";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

