/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface SideEffectGuard {
    public static final ExtensionPointName<SideEffectGuard> EP_NAME = ExtensionPointName.create("com.intellij.sideEffectGuard");

    public boolean isAllowed(@NotNull EffectType var1);

    public static void checkSideEffectAllowed(@NotNull EffectType effectType) {
        if (effectType == null) {
            SideEffectGuard.$$$reportNull$$$0(0);
        }
        if (EP_NAME.extensions().anyMatch(guard -> !guard.isAllowed(effectType))) {
            throw new SideEffectNotAllowedException(effectType);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectType", "com/intellij/model/SideEffectGuard", "checkSideEffectAllowed"));
    }

    public static enum EffectType {
        PROJECT_MODEL,
        SETTINGS,
        EXEC;

    }

    public static final class SideEffectNotAllowedException
    extends IllegalStateException
    implements ControlFlowException {
        public SideEffectNotAllowedException(@NotNull EffectType effectType) {
            if (effectType == null) {
                SideEffectNotAllowedException.$$$reportNull$$$0(0);
            }
            super("Side effect not allowed: " + effectType.name());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectType", "com/intellij/model/SideEffectGuard$SideEffectNotAllowedException", "<init>"));
        }
    }
}

