/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ClassLoaderConfigurator;
import com.intellij.ide.plugins.ClassLoaderConfiguratorKt;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.UrlClassLoader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\b\u0010\u0012\u001a\u00020\u0011H\u0002\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0019\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e\u00a2\u0006\u0002\u0010\u001f\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"DEFAULT_CLASSLOADER_CONFIGURATION", "Lcom/intellij/util/lang/UrlClassLoader$Builder;", "Lorg/jetbrains/annotations/NotNull;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog$annotations", "()V", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "configureUsingIdeaClassloader", "Ljava/lang/ClassLoader;", "classPath", "", "Ljava/nio/file/Path;", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "createModuleContentBasedScope", "Lcom/intellij/ide/plugins/cl/PluginClassLoader$ResolveScopeManager;", "createModuleResolveScopeManager", "createPluginDependencyAndContentBasedScope", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "createScopeWithExtraPackage", "customPackage", "", "getContentPackagePrefixes", "getDependencyPackagePrefixes", "sortDependenciesInPlace", "", "dependencies", "", "([Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)V", "intellij.platform.core.impl"})
public final class ClassLoaderConfiguratorKt {
    private static final UrlClassLoader.Builder DEFAULT_CLASSLOADER_CONFIGURATION;

    private static /* synthetic */ void getLog$annotations() {
    }

    private static final Logger getLog() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026e.plugins.PluginManager\")");
        return logger;
    }

    private static final PluginClassLoader.ResolveScopeManager createModuleResolveScopeManager() {
        return createModuleResolveScopeManager.1.INSTANCE;
    }

    private static final PluginClassLoader.ResolveScopeManager createScopeWithExtraPackage(String customPackage) {
        return new PluginClassLoader.ResolveScopeManager(customPackage){
            final /* synthetic */ String $customPackage;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final String isDefinitelyAlienClass(String name, String packagePrefix, boolean force) {
                if (force) return null;
                String string2 = name;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                String string3 = packagePrefix;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"packagePrefix");
                if (StringsKt.startsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null)) return null;
                if (StringsKt.startsWith$default((String)name, (String)"com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null)) return null;
                if (StringsKt.startsWith$default((String)name, (String)this.$customPackage, (boolean)false, (int)2, null)) return null;
                return "";
            }
            {
                this.$customPackage = string2;
            }
        };
    }

    private static final PluginClassLoader.ResolveScopeManager createPluginDependencyAndContentBasedScope(IdeaPluginDescriptorImpl descriptor, PluginSet pluginSet) {
        List<String> contentPackagePrefixes = ClassLoaderConfiguratorKt.getContentPackagePrefixes(descriptor);
        List<String> dependencyPackagePrefixes = ClassLoaderConfiguratorKt.getDependencyPackagePrefixes(descriptor, pluginSet);
        if (contentPackagePrefixes.isEmpty() && dependencyPackagePrefixes.isEmpty()) {
            return null;
        }
        String string2 = descriptor.getPluginId().getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"descriptor.pluginId.idString");
        String pluginId = string2;
        return new PluginClassLoader.ResolveScopeManager(contentPackagePrefixes, pluginId, dependencyPackagePrefixes){
            final /* synthetic */ List $contentPackagePrefixes;
            final /* synthetic */ String $pluginId;
            final /* synthetic */ List $dependencyPackagePrefixes;

            public final String isDefinitelyAlienClass(String name, String $noName_1, boolean force) {
                if (force) {
                    return null;
                }
                for (String prefix : this.$contentPackagePrefixes) {
                    String string2 = name;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                    if (!StringsKt.startsWith$default((String)string2, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return "Class " + name + " must be not requested from main classloader of " + this.$pluginId + " plugin";
                }
                for (String prefix : this.$dependencyPackagePrefixes) {
                    String string3 = name;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
                    if (!StringsKt.startsWith$default((String)string3, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return "";
                }
                return null;
            }
            {
                this.$contentPackagePrefixes = list;
                this.$pluginId = string2;
                this.$dependencyPackagePrefixes = list2;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> getContentPackagePrefixes(IdeaPluginDescriptorImpl descriptor) {
        List<PluginContentDescriptor.ModuleItem> modules = descriptor.content.modules;
        if (modules.isEmpty()) {
            List<String> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.emptyList()");
            return list;
        }
        int n = modules.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string2;
            void it;
            int n3 = n2;
            int n4 = n2++;
            String[] stringArray2 = stringArray;
            boolean bl = false;
            IdeaPluginDescriptorImpl module = modules.get((int)it).requireDescriptor();
            String string3 = module.packagePrefix;
            if (string3 == null) {
                throw (Throwable)new PluginException("Package is not specified (module=" + module + ')', module.getPluginId());
            }
            stringArray2[n4] = string2 = string3 + '.';
        }
        String[] result2 = stringArray;
        List<String> list = Arrays.asList(Arrays.copyOf(result2, result2.length));
        Intrinsics.checkNotNullExpressionValue(list, (String)"Arrays.asList(*result)");
        return list;
    }

    private static final List<String> getDependencyPackagePrefixes(IdeaPluginDescriptorImpl descriptor, PluginSet pluginSet) {
        List<ModuleDependenciesDescriptor.ModuleReference> dependencies = descriptor.dependencies.modules;
        if (dependencies.isEmpty()) {
            List<String> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.emptyList()");
            return list;
        }
        ArrayList<String> result2 = new ArrayList<String>(dependencies.size());
        for (ModuleDependenciesDescriptor.ModuleReference item : dependencies) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = pluginSet.findEnabledModule(item.name);
            if (ideaPluginDescriptorImpl == null) {
                continue;
            }
            String packagePrefix = ideaPluginDescriptorImpl.packagePrefix;
            if (packagePrefix == null || !(Intrinsics.areEqual((Object)item.name, (Object)"intellij.platform.commercial.verifier") ^ true)) continue;
            result2.add(packagePrefix + '.');
        }
        return result2;
    }

    private static final PluginClassLoader.ResolveScopeManager createModuleContentBasedScope(IdeaPluginDescriptorImpl descriptor) {
        ArrayList<String> packagePrefixes = new ArrayList<String>(descriptor.content.modules.size());
        for (PluginContentDescriptor.ModuleItem item : descriptor.content.modules) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = item.requireDescriptor().packagePrefix;
            Intrinsics.checkNotNull((Object)string2);
            packagePrefixes.add(stringBuilder.append(string2).append('.').toString());
        }
        return new PluginClassLoader.ResolveScopeManager(packagePrefixes){
            final /* synthetic */ ArrayList $packagePrefixes;

            public final String isDefinitelyAlienClass(String name, String packagePrefix, boolean $noName_2) {
                String string2 = name;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                String string3 = packagePrefix;
                Intrinsics.checkNotNull((Object)string3);
                if (StringsKt.startsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null)) {
                    return null;
                }
                Iterator<E> iterator = this.$packagePrefixes.iterator();
                while (iterator.hasNext()) {
                    String prefix;
                    String string4 = prefix = (String)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"prefix");
                    if (!StringsKt.startsWith$default((String)name, (String)string4, (boolean)false, (int)2, null)) continue;
                    return null;
                }
                return "";
            }
            {
                this.$packagePrefixes = arrayList;
            }
        };
    }

    private static final ClassLoader configureUsingIdeaClassloader(List<? extends Path> classPath, IdeaPluginDescriptorImpl descriptor) {
        ClassLoaderConfiguratorKt.getLog().warn(descriptor.getPluginId() + " uses deprecated `use-idea-classloader` attribute");
        ClassLoader loader = ClassLoaderConfigurator.class.getClassLoader();
        try {
            MethodHandle addFiles = MethodHandles.lookup().findVirtual(loader.getClass(), "addFiles", MethodType.methodType(Void.TYPE, List.class));
            addFiles.invoke(loader, classPath);
            ClassLoader classLoader = loader;
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"loader");
            return classLoader;
        }
        catch (Throwable e) {
            throw (Throwable)new IllegalStateException("An unexpected core classloader: " + loader, e);
        }
    }

    public static final void sortDependenciesInPlace(@NotNull IdeaPluginDescriptorImpl[] dependencies) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        if (dependencies.length <= 1) {
            return;
        }
        sortDependenciesInPlace.1 $fun$getWeight$1 = sortDependenciesInPlace.1.INSTANCE;
        Arrays.sort(dependencies, sortDependenciesInPlace.2.INSTANCE);
    }

    static {
        UrlClassLoader.Builder builder = UrlClassLoader.build().useCache();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"UrlClassLoader.build().useCache()");
        DEFAULT_CLASSLOADER_CONFIGURATION = builder;
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return ClassLoaderConfiguratorKt.getLog();
    }

    public static final /* synthetic */ UrlClassLoader.Builder access$getDEFAULT_CLASSLOADER_CONFIGURATION$p() {
        return DEFAULT_CLASSLOADER_CONFIGURATION;
    }

    public static final /* synthetic */ ClassLoader access$configureUsingIdeaClassloader(List classPath, IdeaPluginDescriptorImpl descriptor) {
        return ClassLoaderConfiguratorKt.configureUsingIdeaClassloader(classPath, descriptor);
    }

    public static final /* synthetic */ PluginClassLoader.ResolveScopeManager access$createModuleResolveScopeManager() {
        return ClassLoaderConfiguratorKt.createModuleResolveScopeManager();
    }

    public static final /* synthetic */ PluginClassLoader.ResolveScopeManager access$createPluginDependencyAndContentBasedScope(IdeaPluginDescriptorImpl descriptor, PluginSet pluginSet) {
        return ClassLoaderConfiguratorKt.createPluginDependencyAndContentBasedScope(descriptor, pluginSet);
    }

    public static final /* synthetic */ PluginClassLoader.ResolveScopeManager access$createScopeWithExtraPackage(String customPackage) {
        return ClassLoaderConfiguratorKt.createScopeWithExtraPackage(customPackage);
    }

    public static final /* synthetic */ PluginClassLoader.ResolveScopeManager access$createModuleContentBasedScope(IdeaPluginDescriptorImpl descriptor) {
        return ClassLoaderConfiguratorKt.createModuleContentBasedScope(descriptor);
    }
}

