/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.plugins.BundledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.NioFiles;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ide/plugins/BundledPluginsState;", "", "()V", "Companion", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class BundledPluginsState {
    @NotNull
    public static final String BUNDLED_PLUGINS_FILENAME = "bundled_plugins.txt";
    private static final String SAVED_VERSION_KEY = "bundled.plugins.list.saved.version";
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public BundledPluginsState() {
        if (Companion.shouldSave()) {
            ProcessIOExecutorService.INSTANCE.execute(1.INSTANCE);
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(this::class.java)");
        BundledPluginsState.logger = logger;
    }

    @JvmStatic
    @Nullable
    public static final List<Pair<PluginId, String>> getBundledPlugins(@NotNull Path configDir) {
        return Companion.getBundledPlugins(configDir);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\n\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0018\u00010\u0004j\u0002`\u000e0\f\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002J\u0014\u0010\u0016\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/plugins/BundledPluginsState$Companion;", "", "()V", "BUNDLED_PLUGINS_FILENAME", "", "Lorg/jetbrains/annotations/NonNls;", "SAVED_VERSION_KEY", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getBundledPlugins", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/Category;", "configDir", "Ljava/nio/file/Path;", "saveBundledPlugins", "", "file", "plugins", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "saveBundledPluginsOrLog", "shouldSave", "", "intellij.platform.core.impl"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean shouldSave() {
            String string2;
            String string3 = PropertiesComponent.getInstance().getValue(BundledPluginsState.SAVED_VERSION_KEY);
            Object object = string3;
            if (string3 == null) return true;
            String it = string2 = object;
            boolean bl = false;
            BuildNumber buildNumber = BuildNumber.fromString(it);
            object = buildNumber;
            if (buildNumber == null) return true;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PropertiesComponent.getI\u2026ring(it) } ?: return true");
            Object savedVersion = object;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                if (PluginManagerCore.isRunningFromSources()) return true;
            }
            ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
            if (((BuildNumber)savedVersion).compareTo(applicationInfo.getBuild()) >= 0) return false;
            return true;
        }

        public final void saveBundledPluginsOrLog(@NotNull List<? extends IdeaPluginDescriptor> plugins) {
            Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
            Path file2 = PathManager.getConfigDir().resolve(BundledPluginsState.BUNDLED_PLUGINS_FILENAME);
            try {
                Path path = file2;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                this.saveBundledPlugins(path, plugins);
                PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
                ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
                propertiesComponent.setValue(BundledPluginsState.SAVED_VERSION_KEY, applicationInfo.getBuild().asString());
            }
            catch (IOException e) {
                logger.warn("Unable to save bundled plugins list", e);
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final List<Pair<PluginId, String>> getBundledPlugins(@NotNull Path configDir) {
            Path file2;
            Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
            Path path = file2 = configDir.resolve(BundledPluginsState.BUNDLED_PLUGINS_FILENAME);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
            Path path2 = path;
            Object object = new LinkOption[]{};
            if (!Files.exists(path2, Arrays.copyOf(object, ((LinkOption[])object).length))) {
                return null;
            }
            if (!Files.isRegularFile(file2, new LinkOption[0])) {
                return null;
            }
            List bundledPlugins = new ArrayList();
            try {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                object = file2;
                Charset charset = Charsets.UTF_8;
                List<String> list = Files.readAllLines((Path)object, charset);
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(this, charset)");
                object = list;
                boolean $i$f$map = false;
                list = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void id;
                    List list2;
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string3 = it;
                    List splitResult = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string3)).toString(), (String[])new String[]{"|"}, (boolean)false, (int)0, (int)6, null);
                    if (splitResult.size() != 2) {
                        logger.warn("Incompatible format for bundled plugins list: " + file2);
                        return null;
                    }
                    List list3 = list2 = splitResult;
                    string3 = (String)list3.get(0);
                    list3 = list2;
                    String category = (String)list3.get(1);
                    Boolean bl2 = bundledPlugins.add(new Pair((Object)PluginId.getId((String)id), (Object)(Intrinsics.areEqual((Object)category, (Object)"null") ? null : category)));
                    collection.add(bl2);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
            catch (IOException e) {
                logger.warn("Unable to load bundled plugins list from " + file2, e);
            }
            if (bundledPlugins.isEmpty()) {
                return null;
            }
            return bundledPlugins;
        }

        private final void saveBundledPlugins(Path file2, List<? extends IdeaPluginDescriptor> plugins) {
            NioFiles.createDirectories(file2.getParent());
            PathsKt.writeText$default((Path)file2, (CharSequence)CollectionsKt.joinToString$default((Iterable)plugins, (CharSequence)"", null, null, (int)0, null, (Function1)saveBundledPlugins.1.INSTANCE, (int)30, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

