/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByWordRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class ByCharRt {
    @NotNull
    public static FairDiffIterable compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByCharRt.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            ByCharRt.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            ByCharRt.$$$reportNull$$$0(2);
        }
        indicator.checkCanceled();
        int[] codePoints1 = ByCharRt.getAllCodePoints(text1);
        int[] codePoints2 = ByCharRt.getAllCodePoints(text2);
        FairDiffIterable iterable = DiffIterableUtil.diff(codePoints1, codePoints2, indicator);
        int offset1 = 0;
        int offset2 = 0;
        DiffIterableUtil.ChangeBuilder builder = new DiffIterableUtil.ChangeBuilder(text1.length(), text2.length());
        for (Pair<Range, Boolean> pair : DiffIterableUtil.iterateAll(iterable)) {
            Range range = (Range)pair.first;
            boolean equals = (Boolean)pair.second;
            int end1 = offset1 + ByCharRt.countChars(codePoints1, range.start1, range.end1);
            int end2 = offset2 + ByCharRt.countChars(codePoints2, range.start2, range.end2);
            if (equals) {
                builder.markEqual(offset1, offset2, end1, end2);
            }
            offset1 = end1;
            offset2 = end2;
        }
        assert (offset1 == text1.length());
        assert (offset2 == text2.length());
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(builder.finish());
        if (fairDiffIterable == null) {
            ByCharRt.$$$reportNull$$$0(3);
        }
        return fairDiffIterable;
    }

    @NotNull
    public static FairDiffIterable compareTwoStep(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByCharRt.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            ByCharRt.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            ByCharRt.$$$reportNull$$$0(6);
        }
        indicator.checkCanceled();
        CodePointsOffsets codePoints1 = ByCharRt.getNonSpaceCodePoints(text1);
        CodePointsOffsets codePoints2 = ByCharRt.getNonSpaceCodePoints(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(codePoints1.codePoints, codePoints2.codePoints, indicator);
        return ByCharRt.matchAdjustmentSpaces(codePoints1, codePoints2, text1, text2, nonSpaceChanges, indicator);
    }

    @NotNull
    public static DiffIterable compareTrimWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByCharRt.$$$reportNull$$$0(7);
        }
        if (text2 == null) {
            ByCharRt.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            ByCharRt.$$$reportNull$$$0(9);
        }
        FairDiffIterable iterable = ByCharRt.compareTwoStep(text1, text2, indicator);
        DiffIterable diffIterable = new ByWordRt.TrimSpacesCorrector(iterable, text1, text2, indicator).build();
        if (diffIterable == null) {
            ByCharRt.$$$reportNull$$$0(10);
        }
        return diffIterable;
    }

    @NotNull
    public static DiffIterable compareIgnoreWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByCharRt.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            ByCharRt.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            ByCharRt.$$$reportNull$$$0(13);
        }
        indicator.checkCanceled();
        CodePointsOffsets codePoints1 = ByCharRt.getNonSpaceCodePoints(text1);
        CodePointsOffsets codePoints2 = ByCharRt.getNonSpaceCodePoints(text2);
        FairDiffIterable changes = DiffIterableUtil.diff(codePoints1.codePoints, codePoints2.codePoints, indicator);
        return ByCharRt.matchAdjustmentSpacesIW(codePoints1, codePoints2, text1, text2, changes);
    }

    @NotNull
    public static FairDiffIterable comparePunctuation(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByCharRt.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            ByCharRt.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            ByCharRt.$$$reportNull$$$0(16);
        }
        indicator.checkCanceled();
        CodePointsOffsets chars1 = ByCharRt.getPunctuationChars(text1);
        CodePointsOffsets chars2 = ByCharRt.getPunctuationChars(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(chars1.codePoints, chars2.codePoints, indicator);
        return ByCharRt.transferPunctuation(chars1, chars2, text1, text2, nonSpaceChanges, indicator);
    }

    @NotNull
    private static FairDiffIterable transferPunctuation(@NotNull CodePointsOffsets chars1, @NotNull CodePointsOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
        if (chars1 == null) {
            ByCharRt.$$$reportNull$$$0(17);
        }
        if (chars2 == null) {
            ByCharRt.$$$reportNull$$$0(18);
        }
        if (text1 == null) {
            ByCharRt.$$$reportNull$$$0(19);
        }
        if (text2 == null) {
            ByCharRt.$$$reportNull$$$0(20);
        }
        if (changes == null) {
            ByCharRt.$$$reportNull$$$0(21);
        }
        if (indicator == null) {
            ByCharRt.$$$reportNull$$$0(22);
        }
        DiffIterableUtil.ChangeBuilder builder = new DiffIterableUtil.ChangeBuilder(text1.length(), text2.length());
        for (Range range : changes.iterateUnchanged()) {
            int count2 = range.end1 - range.start1;
            for (int i = 0; i < count2; ++i) {
                int offset1 = chars1.offsets[range.start1 + i];
                int offset2 = chars2.offsets[range.start2 + i];
                builder.markEqual(offset1, offset2);
            }
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(builder.finish());
        if (fairDiffIterable == null) {
            ByCharRt.$$$reportNull$$$0(23);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable matchAdjustmentSpaces(@NotNull CodePointsOffsets codePoints1, @NotNull CodePointsOffsets codePoints2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
        if (codePoints1 == null) {
            ByCharRt.$$$reportNull$$$0(24);
        }
        if (codePoints2 == null) {
            ByCharRt.$$$reportNull$$$0(25);
        }
        if (text1 == null) {
            ByCharRt.$$$reportNull$$$0(26);
        }
        if (text2 == null) {
            ByCharRt.$$$reportNull$$$0(27);
        }
        if (changes == null) {
            ByCharRt.$$$reportNull$$$0(28);
        }
        if (indicator == null) {
            ByCharRt.$$$reportNull$$$0(29);
        }
        FairDiffIterable fairDiffIterable = new ChangeCorrector.DefaultCharChangeCorrector(codePoints1, codePoints2, text1, text2, changes, indicator).build();
        if (fairDiffIterable == null) {
            ByCharRt.$$$reportNull$$$0(30);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static DiffIterable matchAdjustmentSpacesIW(@NotNull CodePointsOffsets codePoints1, @NotNull CodePointsOffsets codePoints2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes) {
        if (codePoints1 == null) {
            ByCharRt.$$$reportNull$$$0(31);
        }
        if (codePoints2 == null) {
            ByCharRt.$$$reportNull$$$0(32);
        }
        if (text1 == null) {
            ByCharRt.$$$reportNull$$$0(33);
        }
        if (text2 == null) {
            ByCharRt.$$$reportNull$$$0(34);
        }
        if (changes == null) {
            ByCharRt.$$$reportNull$$$0(35);
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Range ch : changes.iterateChanges()) {
            int startOffset2;
            int endOffset2;
            int startOffset1;
            int endOffset1;
            if (ch.start1 == ch.end1) {
                startOffset1 = endOffset1 = ByCharRt.expandForwardW(codePoints1, codePoints2, text1, text2, ch, true);
            } else {
                startOffset1 = codePoints1.charOffset(ch.start1);
                endOffset1 = codePoints1.charOffsetAfter(ch.end1 - 1);
            }
            if (ch.start2 == ch.end2) {
                startOffset2 = endOffset2 = ByCharRt.expandForwardW(codePoints1, codePoints2, text1, text2, ch, false);
            } else {
                startOffset2 = codePoints2.charOffset(ch.start2);
                endOffset2 = codePoints2.charOffsetAfter(ch.end2 - 1);
            }
            ranges.add(new Range(startOffset1, endOffset1, startOffset2, endOffset2));
        }
        DiffIterable diffIterable = DiffIterableUtil.create(ranges, text1.length(), text2.length());
        if (diffIterable == null) {
            ByCharRt.$$$reportNull$$$0(36);
        }
        return diffIterable;
    }

    private static int expandForwardW(@NotNull CodePointsOffsets codePoints1, @NotNull CodePointsOffsets codePoints2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range ch, boolean left) {
        if (codePoints1 == null) {
            ByCharRt.$$$reportNull$$$0(37);
        }
        if (codePoints2 == null) {
            ByCharRt.$$$reportNull$$$0(38);
        }
        if (text1 == null) {
            ByCharRt.$$$reportNull$$$0(39);
        }
        if (text2 == null) {
            ByCharRt.$$$reportNull$$$0(40);
        }
        if (ch == null) {
            ByCharRt.$$$reportNull$$$0(41);
        }
        int offset1 = ch.start1 == 0 ? 0 : codePoints1.charOffsetAfter(ch.start1 - 1);
        int offset2 = ch.start2 == 0 ? 0 : codePoints2.charOffsetAfter(ch.start2 - 1);
        int start = left ? offset1 : offset2;
        return start + TrimUtil.expandWhitespacesForward(text1, text2, offset1, offset2, text1.length(), text2.length());
    }

    private static int @NotNull [] getAllCodePoints(@NotNull CharSequence text) {
        int charCount;
        if (text == null) {
            ByCharRt.$$$reportNull$$$0(42);
        }
        IntArrayList list = new IntArrayList(text.length());
        int len = text.length();
        for (int offset = 0; offset < len; offset += charCount) {
            int ch = Character.codePointAt(text, offset);
            charCount = Character.charCount(ch);
            list.add(ch);
        }
        int[] nArray = list.toIntArray();
        if (nArray == null) {
            ByCharRt.$$$reportNull$$$0(43);
        }
        return nArray;
    }

    @NotNull
    private static CodePointsOffsets getNonSpaceCodePoints(@NotNull CharSequence text) {
        int charCount;
        if (text == null) {
            ByCharRt.$$$reportNull$$$0(44);
        }
        IntArrayList codePoints = new IntArrayList(text.length());
        IntArrayList offsets = new IntArrayList(text.length());
        int len = text.length();
        for (int offset = 0; offset < len; offset += charCount) {
            int ch = Character.codePointAt(text, offset);
            charCount = Character.charCount(ch);
            if (TrimUtil.isWhiteSpaceCodePoint(ch)) continue;
            codePoints.add(ch);
            offsets.add(offset);
        }
        return new CodePointsOffsets(codePoints.toIntArray(), offsets.toIntArray());
    }

    @NotNull
    private static CodePointsOffsets getPunctuationChars(@NotNull CharSequence text) {
        if (text == null) {
            ByCharRt.$$$reportNull$$$0(45);
        }
        IntArrayList codePoints = new IntArrayList(text.length());
        IntArrayList offsets = new IntArrayList(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!TrimUtil.isPunctuation(c)) continue;
            codePoints.add(c);
            offsets.add(i);
        }
        return new CodePointsOffsets(codePoints.toIntArray(), offsets.toIntArray());
    }

    private static int countChars(int[] codePoints, int start, int end) {
        int count2 = 0;
        for (int i = start; i < end; ++i) {
            count2 += Character.charCount(codePoints[i]);
        }
        return count2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 23: 
            case 30: 
            case 36: 
            case 43: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 23: 
            case 30: 
            case 36: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: 
            case 15: 
            case 20: 
            case 27: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 10: 
            case 23: 
            case 30: 
            case 36: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ByCharRt";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars1";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars2";
                break;
            }
            case 21: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 24: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codePoints1";
                break;
            }
            case 25: 
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codePoints2";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ch";
                break;
            }
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ByCharRt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compare";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "compareTrimWhitespaces";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "transferPunctuation";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "matchAdjustmentSpaces";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "matchAdjustmentSpacesIW";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCodePoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 3: 
            case 10: 
            case 23: 
            case 30: 
            case 36: 
            case 43: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareTwoStep";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTrimWhitespaces";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compareIgnoreWhitespaces";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "comparePunctuation";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "transferPunctuation";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "matchAdjustmentSpaces";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "matchAdjustmentSpacesIW";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "expandForwardW";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAllCodePoints";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getNonSpaceCodePoints";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getPunctuationChars";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 10: 
            case 23: 
            case 30: 
            case 36: 
            case 43: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class CodePointsOffsets {
        public final int[] codePoints;
        public final int[] offsets;

        CodePointsOffsets(int[] codePoints, int[] offsets) {
            this.codePoints = codePoints;
            this.offsets = offsets;
        }

        public int charOffset(int index) {
            return this.offsets[index];
        }

        public int charOffsetAfter(int index) {
            return this.offsets[index] + Character.charCount(this.codePoints[index]);
        }
    }
}

