/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFunctionDelegateMemberNameClashChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "functionDelegateName", "Lorg/jetbrains/kotlin/name/Name;", "getFunctionDelegateName", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirJvmFunctionDelegateMemberNameClashChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmFunctionDelegateMemberNameClashChecker INSTANCE = new FirJvmFunctionDelegateMemberNameClashChecker();
    @NotNull
    private static final Name functionDelegateName;
    @NotNull
    private static final Name getFunctionDelegateName;

    private FirJvmFunctionDelegateMemberNameClashChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
                if (!(declaration instanceof FirCallableDeclaration)) {
                    return;
                }
                FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(declaration, context.getSession());
                FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                if (firRegularClassSymbol == null) {
                    return;
                }
                FirRegularClassSymbol containingClassSymbol = firRegularClassSymbol;
                FirClassSymbol $this$isFun$iv = containingClassSymbol;
                boolean $i$f$isFun = false;
                if (!$this$isFun$iv.getResolvedStatus().isFun()) {
                    return;
                }
                if (FirCallableSymbolKt.isExtension(((FirCallableDeclaration)declaration).getSymbol())) break block7;
                Object object = declaration instanceof FirFunction ? (FirFunction)declaration : null;
                boolean bl = object != null && (object = ((FirFunction)object).getValueParameters()) != null ? !((Collection)object).isEmpty() : false;
                if (!bl) break block8;
            }
            return;
        }
        if (declaration instanceof FirSimpleFunction && Intrinsics.areEqual((Object)((FirSimpleFunction)declaration).getName(), (Object)getFunctionDelegateName) || declaration instanceof FirProperty && Intrinsics.areEqual((Object)((FirProperty)declaration).getName(), (Object)functionDelegateName)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getFUNCTION_DELEGATE_MEMBER_NAME_CLASH(), (DiagnosticContext)context, null, 8, null);
        }
    }

    static {
        Name name2 = Name.identifier("functionDelegate");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"functionDelegate\")");
        functionDelegateName = name2;
        Name name3 = Name.identifier("getFunctionDelegate");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(\"getFunctionDelegate\")");
        getFunctionDelegateName = name3;
    }
}

