/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J;\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001aJ=\u0010\u001b\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001cR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "allowedSourceKinds", "", "Lorg/jetbrains/kotlin/KtSourceElementKind;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getWorstDeprecation", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "callSite", "Lorg/jetbrains/kotlin/fir/FirElement;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "reportDeprecation", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "referencedSymbol", "deprecationInfo", "reportDeprecation$checkers", "reportDeprecationIfNeeded", "reportDeprecationIfNeeded$checkers", "checkers"})
public final class FirDeprecationChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirDeprecationChecker INSTANCE = new FirDeprecationChecker();
    @NotNull
    private static final Set<KtSourceElementKind> allowedSourceKinds;

    private FirDeprecationChecker() {
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        KtSourceElement ktSourceElement = expression2.getSource();
        if (!CollectionsKt.contains((Iterable)allowedSourceKinds, (Object)(ktSourceElement != null ? ktSourceElement.getKind() : null))) {
            return;
        }
        if (expression2 instanceof FirAnnotation || expression2 instanceof FirDelegatedConstructorCall) {
            return;
        }
        FirResolvable firResolvable = expression2 instanceof FirResolvable ? (FirResolvable)((Object)expression2) : null;
        if (firResolvable == null) {
            return;
        }
        FirResolvable resolvable = firResolvable;
        FirResolvedNamedReference firResolvedNamedReference = UtilsKt.getResolved(resolvable.getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference = firResolvedNamedReference;
        FirBasedSymbol<?> referencedSymbol2 = reference.getResolvedSymbol();
        this.reportDeprecationIfNeeded$checkers(reference.getSource(), referencedSymbol2, expression2, context, reporter2);
    }

    public final void reportDeprecationIfNeeded$checkers(@Nullable KtSourceElement source, @NotNull FirBasedSymbol<?> referencedSymbol2, @Nullable FirElement callSite, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter(referencedSymbol2, (String)"referencedSymbol");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        DeprecationInfo deprecationInfo = this.getWorstDeprecation(callSite, referencedSymbol2, context);
        if (deprecationInfo == null) {
            return;
        }
        DeprecationInfo deprecation2 = deprecationInfo;
        this.reportDeprecation$checkers(source, referencedSymbol2, deprecation2, reporter2, context);
    }

    public final void reportDeprecation$checkers(@Nullable KtSourceElement source, @NotNull FirBasedSymbol<?> referencedSymbol2, @NotNull DeprecationInfo deprecationInfo, @NotNull DiagnosticReporter reporter2, @NotNull CheckerContext context) {
        KtDiagnosticFactory2<FirBasedSymbol<?>, String> ktDiagnosticFactory2;
        Intrinsics.checkNotNullParameter(referencedSymbol2, (String)"referencedSymbol");
        Intrinsics.checkNotNullParameter((Object)deprecationInfo, (String)"deprecationInfo");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        switch (WhenMappings.$EnumSwitchMapping$0[deprecationInfo.getDeprecationLevel().ordinal()]) {
            case 1: 
            case 2: {
                ktDiagnosticFactory2 = FirErrors.INSTANCE.getDEPRECATION_ERROR();
                break;
            }
            case 3: {
                ktDiagnosticFactory2 = FirErrors.INSTANCE.getDEPRECATION();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KtDiagnosticFactory2<FirBasedSymbol<?>, String> diagnostic = ktDiagnosticFactory2;
        AbstractKtSourceElement abstractKtSourceElement = source;
        String string2 = deprecationInfo.getMessage();
        if (string2 == null) {
            string2 = "";
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, abstractKtSourceElement, diagnostic, referencedSymbol2, (Object)string2, (DiagnosticContext)context, null, 32, null);
    }

    private final DeprecationInfo getWorstDeprecation(FirElement callSite, FirBasedSymbol<?> symbol2, CheckerContext context) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirResolvedTypeRef firResolvedTypeRef;
        FirConstructorSymbol firConstructorSymbol;
        Object[] objectArray = new DeprecationInfo[2];
        objectArray[0] = DeprecationUtilsKt.getDeprecation(symbol2, callSite);
        FirBasedSymbol<?> $this$safeAs$iv = symbol2;
        boolean $i$f$safeAs = false;
        FirBasedSymbol<?> firBasedSymbol = $this$safeAs$iv;
        if (!(firBasedSymbol instanceof FirConstructorSymbol)) {
            firBasedSymbol = null;
        }
        objectArray[1] = (firConstructorSymbol = (FirConstructorSymbol)firBasedSymbol) != null && (firResolvedTypeRef = firConstructorSymbol.getResolvedReturnTypeRef()) != null && (firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(firResolvedTypeRef, context.getSession())) != null ? DeprecationUtilsKt.getDeprecation(firRegularClassSymbol, callSite) : null;
        List deprecationInfos = CollectionsKt.listOfNotNull((Object[])objectArray);
        return (DeprecationInfo)CollectionsKt.maxOrNull((Iterable)deprecationInfos);
    }

    static {
        Object[] objectArray = new KtSourceElementKind[]{KtRealSourceElementKind.INSTANCE, KtFakeSourceElementKind.DesugaredIncrementOrDecrement.INSTANCE};
        allowedSourceKinds = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeprecationLevelValue.values().length];
            nArray[DeprecationLevelValue.ERROR.ordinal()] = 1;
            nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 2;
            nArray[DeprecationLevelValue.WARNING.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

