/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.ESLambda;
import org.jetbrains.kotlin.contracts.ESReceiverWithDataFlowValue;
import org.jetbrains.kotlin.contracts.ESVariableWithDataFlowValue;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESTypeSubstitution;
import org.jetbrains.kotlin.contracts.model.Functor;
import org.jetbrains.kotlin.contracts.model.functors.AndFunctor;
import org.jetbrains.kotlin.contracts.model.functors.EqualsFunctor;
import org.jetbrains.kotlin.contracts.model.functors.IsFunctor;
import org.jetbrains.kotlin.contracts.model.functors.NotFunctor;
import org.jetbrains.kotlin.contracts.model.functors.OrFunctor;
import org.jetbrains.kotlin.contracts.model.structure.CallComputation;
import org.jetbrains.kotlin.contracts.model.structure.ESBooleanType;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.ESType;
import org.jetbrains.kotlin.contracts.model.structure.TypesKt;
import org.jetbrains.kotlin.contracts.model.structure.UNKNOWN_COMPUTATION;
import org.jetbrains.kotlin.contracts.model.visitors.Reducer;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.inference.components.EmptySubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutorByConstructorMap;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.UnsignedErrorValueTypeConstant;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015J\u001d\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\"J\u001f\u0010#\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020$2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010%J\u001d\u0010&\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010(J\u001f\u0010)\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020*2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010+J\u001d\u0010,\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020-2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010.J\u000e\u0010/\u001a\u0004\u0018\u000100*\u000201H\u0002J\f\u0010/\u001a\u000200*\u000202H\u0002J\u0018\u00103\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u000104*\u0006\u0012\u0002\b\u000305H\u0002J\u000e\u00106\u001a\u0004\u0018\u000107*\u000208H\u0002J\u0010\u00109\u001a\u00020:*\u0006\u0012\u0002\b\u000305H\u0002J\u0010\u0010;\u001a\u00020<*\u0006\u0012\u0002\b\u000305H\u0002J\u000e\u0010=\u001a\u0004\u0018\u00010\u0002*\u00020>H\u0002J\u000e\u0010=\u001a\u0004\u0018\u00010\u0002*\u00020?H\u0002J\f\u0010=\u001a\u00020\u0002*\u00020@H\u0002R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/contracts/EffectsExtractingVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "reducer", "Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "extractOrGetCached", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "data", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "(Lorg/jetbrains/kotlin/psi/KtIsExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitKtElement", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "(Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitSafeQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "(Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "(Lorg/jetbrains/kotlin/psi/KtUnaryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExtensionReceiver;", "getCallArgumentsAsComputations", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getFunctor", "Lorg/jetbrains/kotlin/contracts/model/Functor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getTypeSubstitution", "Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;", "isCallWithUnsupportedReceiver", "", "toComputation", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "frontend"})
public final class EffectsExtractingVisitor
extends KtVisitor<Computation, Unit> {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final Reducer reducer;

    public EffectsExtractingVisitor(@NotNull BindingTrace trace, @NotNull ModuleDescriptor moduleDescriptor, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.trace = trace;
        this.moduleDescriptor = moduleDescriptor;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.languageVersionSettings = languageVersionSettings;
        this.reducer = new Reducer(this.getBuiltIns());
    }

    private final KotlinBuiltIns getBuiltIns() {
        return this.moduleDescriptor.getBuiltIns();
    }

    @NotNull
    public final Computation extractOrGetCached(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Computation computation = (Computation)this.trace.get(BindingContext.EXPRESSION_EFFECTS, element);
        if (computation != null) {
            Computation it = computation;
            boolean bl = false;
            return it;
        }
        Object r = element.accept(this, Unit.INSTANCE);
        Computation it = (Computation)r;
        boolean bl = false;
        this.trace.record(BindingContext.EXPRESSION_EFFECTS, element, it);
        return (Computation)r;
    }

    @Override
    @NotNull
    public Computation visitKtElement(@NotNull KtElement element, @NotNull Unit data) {
        Computation computation;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element, bindingContext);
        if (resolvedCall2 == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (this.isCallWithUnsupportedReceiver(resolvedCall3)) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        List<Computation> list2 = this.getCallArgumentsAsComputations(resolvedCall3);
        if (list2 == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        List<Computation> arguments2 = list2;
        ESTypeSubstitution typeSubstitution = this.getTypeSubstitution(resolvedCall3);
        CallableDescriptor descriptor2 = resolvedCall3.getResultingDescriptor();
        if (PsiContractsUtilsKt.isEqualsDescriptor(descriptor2)) {
            computation = new CallComputation(ESBooleanType.INSTANCE, new EqualsFunctor(false).invokeWithArguments(arguments2, typeSubstitution, this.reducer));
        } else if (descriptor2 instanceof ValueDescriptor) {
            DataFlowValue dataFlowValue2 = this.createDataFlowValue((KtExpression)element);
            if (dataFlowValue2 == null) {
                return UNKNOWN_COMPUTATION.INSTANCE;
            }
            computation = new ESVariableWithDataFlowValue((ValueDescriptor)descriptor2, dataFlowValue2);
        } else if (descriptor2 instanceof FunctionDescriptor) {
            KotlinType kotlinType = ((FunctionDescriptor)descriptor2).getReturnType();
            ESType esType = kotlinType != null ? TypesKt.toESType(kotlinType) : null;
            Object object = this.getFunctor((FunctionDescriptor)descriptor2);
            if (object == null || (object = object.invokeWithArguments(arguments2, typeSubstitution, this.reducer)) == null) {
                object = kotlin.collections.CollectionsKt.emptyList();
            }
            computation = new CallComputation(esType, (List<? extends ESEffect>)object);
        } else {
            computation = UNKNOWN_COMPUTATION.INSTANCE;
        }
        return computation;
    }

    @Override
    @NotNull
    public Computation visitLambdaExpression(@NotNull KtLambdaExpression expression2, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return UNKNOWN_COMPUTATION.INSTANCE;
    }

    @Override
    @NotNull
    public Computation visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtExpression ktExpression = KtPsiUtil.deparenthesize(expression2);
        Computation computation = ktExpression != null ? (Computation)ktExpression.accept(this, data) : null;
        if (computation == null) {
            computation = UNKNOWN_COMPUTATION.INSTANCE;
        }
        return computation;
    }

    @Override
    @NotNull
    public Computation visitConstantExpression(@NotNull KtConstantExpression expression2, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        KotlinType kotlinType = bindingContext2.getType(expression2);
        if (kotlinType == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        KotlinType type2 = kotlinType;
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)bindingContext2.get(BindingContext.COMPILE_TIME_VALUE, expression2);
        if (compileTimeConstant == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        CompileTimeConstant compileTimeConstant2 = compileTimeConstant;
        if (compileTimeConstant2.isError() || compileTimeConstant2 instanceof UnsignedErrorValueTypeConstant) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        Object value2 = compileTimeConstant2.getValue(type2);
        Object t = value2;
        return t instanceof Boolean ? (Computation)ESConstants.INSTANCE.booleanValue((Boolean)value2) : (t == null ? (Computation)ESConstants.INSTANCE.getNullValue() : (Computation)UNKNOWN_COMPUTATION.INSTANCE);
    }

    @Override
    @NotNull
    public Computation visitIsExpression(@NotNull KtIsExpression expression2, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = (KotlinType)this.trace.get(BindingContext.TYPE, expression2.getTypeReference());
        if (object == null || (object = TypesKt.toESType((KotlinType)object)) == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        Object rightType = object;
        KtExpression ktExpression = expression2.getLeftHandSide();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"expression.leftHandSide");
        Computation arg = this.extractOrGetCached(ktExpression);
        return new CallComputation(ESBooleanType.INSTANCE, new IsFunctor((ESType)rightType, expression2.isNegated()).invokeWithArguments(kotlin.collections.CollectionsKt.listOf((Object)arg), ESTypeSubstitution.Companion.empty(this.getBuiltIns()), this.reducer));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Computation visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, @Nullable Unit data) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Computation computation = (Computation)super.visitSafeQualifiedExpression(expression2, data);
        if (computation == UNKNOWN_COMPUTATION.INSTANCE) {
            Intrinsics.checkNotNullExpressionValue((Object)computation, (String)"computation");
            return computation;
        }
        Iterable $this$filter$iv = computation.getEffects();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ESEffect it = (ESEffect)element$iv$iv;
            boolean bl = false;
            if (!(!EffectsExtractingVisitor.visitSafeQualifiedExpression$containsReturnsNull(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List effectsWithoutReturnsNull = (List)destination$iv$iv;
        return new CallComputation(computation.getType(), effectsWithoutReturnsNull);
    }

    @Override
    @NotNull
    public Computation visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        Computation left = this.extractOrGetCached(ktExpression);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        Computation right = this.extractOrGetCached(ktExpression2);
        Computation[] computationArray = new Computation[]{left, right};
        List args = kotlin.collections.CollectionsKt.listOf((Object[])computationArray);
        computationArray = expression2.getOperationToken();
        return Intrinsics.areEqual((Object)computationArray, (Object)((Object)KtTokens.EXCLEQ)) ? (Computation)new CallComputation(ESBooleanType.INSTANCE, new EqualsFunctor(true).invokeWithArguments(args, ESTypeSubstitution.Companion.empty(this.getBuiltIns()), this.reducer)) : (Intrinsics.areEqual((Object)computationArray, (Object)((Object)KtTokens.EQEQ)) ? (Computation)new CallComputation(ESBooleanType.INSTANCE, new EqualsFunctor(false).invokeWithArguments(args, ESTypeSubstitution.Companion.empty(this.getBuiltIns()), this.reducer)) : (Intrinsics.areEqual((Object)computationArray, (Object)((Object)KtTokens.ANDAND)) ? (Computation)new CallComputation(ESBooleanType.INSTANCE, new AndFunctor().invokeWithArguments(args, ESTypeSubstitution.Companion.empty(this.getBuiltIns()), this.reducer)) : (Intrinsics.areEqual((Object)computationArray, (Object)((Object)KtTokens.OROR)) ? (Computation)new CallComputation(ESBooleanType.INSTANCE, new OrFunctor().invokeWithArguments(args, ESTypeSubstitution.Companion.empty(this.getBuiltIns()), this.reducer)) : (Computation)UNKNOWN_COMPUTATION.INSTANCE)));
    }

    @Override
    @NotNull
    public Computation visitUnaryExpression(@NotNull KtUnaryExpression expression2, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtExpression ktExpression = expression2.getBaseExpression();
        if (ktExpression == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        Computation arg = this.extractOrGetCached(ktExpression);
        return Intrinsics.areEqual((Object)expression2.getOperationToken(), (Object)((Object)KtTokens.EXCL)) ? (Computation)new CallComputation(ESBooleanType.INSTANCE, new NotFunctor().invokeWithArguments(arg)) : (Computation)UNKNOWN_COMPUTATION.INSTANCE;
    }

    private final Computation toComputation(ReceiverValue $this$toComputation) {
        ReceiverValue receiverValue = $this$toComputation;
        return receiverValue instanceof ExpressionReceiver ? this.extractOrGetCached(((ExpressionReceiver)$this$toComputation).getExpression()) : (receiverValue instanceof ExtensionReceiver ? (this.languageVersionSettings.supportsFeature(LanguageFeature.ContractsOnCallsWithImplicitReceiver) ? (Computation)new ESReceiverWithDataFlowValue($this$toComputation, this.createDataFlowValue((ExtensionReceiver)$this$toComputation)) : (Computation)UNKNOWN_COMPUTATION.INSTANCE) : (Computation)UNKNOWN_COMPUTATION.INSTANCE);
    }

    private final DataFlowValue createDataFlowValue(ExtensionReceiver $this$createDataFlowValue) {
        ReceiverValue receiverValue = $this$createDataFlowValue;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        CallableDescriptor callableDescriptor = $this$createDataFlowValue.getDeclarationDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"this.declarationDescriptor");
        return this.dataFlowValueFactory.createDataFlowValue(receiverValue, bindingContext, callableDescriptor);
    }

    private final DataFlowValue createDataFlowValue(KtExpression $this$createDataFlowValue) {
        KotlinType kotlinType = this.trace.getType($this$createDataFlowValue);
        if (kotlinType == null) {
            return null;
        }
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        return this.dataFlowValueFactory.createDataFlowValue($this$createDataFlowValue, kotlinType, bindingContext, this.moduleDescriptor);
    }

    private final Functor getFunctor(FunctionDescriptor $this$getFunctor) {
        Object object = (AbstractContractProvider)$this$getFunctor.getUserData(ContractProviderKey.INSTANCE);
        if (object == null || (object = ((AbstractContractProvider)object).getContractDescription()) == null) {
            return null;
        }
        Object contractDescription = object;
        return ((ContractDescription)contractDescription).getFunctor(this.moduleDescriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCallWithUnsupportedReceiver(ResolvedCall<?> $this$isCallWithUnsupportedReceiver) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall3;
        ReceiverValue receiverValue = $this$isCallWithUnsupportedReceiver.getExtensionReceiver();
        Object object = receiverValue instanceof ExpressionReceiver ? (ExpressionReceiver)receiverValue : null;
        if (object != null && (object = object.getExpression()) != null) {
            KtElement ktElement = (KtElement)object;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            resolvedCall3 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        } else {
            resolvedCall3 = null;
        }
        if (Intrinsics.areEqual(resolvedCall3, $this$isCallWithUnsupportedReceiver)) return true;
        receiverValue = $this$isCallWithUnsupportedReceiver.getDispatchReceiver();
        Object object2 = receiverValue instanceof ExpressionReceiver ? (ExpressionReceiver)receiverValue : null;
        if (object2 != null && (object2 = object2.getExpression()) != null) {
            KtElement ktElement = (KtElement)object2;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        } else {
            resolvedCall2 = null;
        }
        if (Intrinsics.areEqual(resolvedCall2, $this$isCallWithUnsupportedReceiver)) return true;
        if ($this$isCallWithUnsupportedReceiver.getExplicitReceiverKind() != ExplicitReceiverKind.BOTH_RECEIVERS) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Computation> getCallArgumentsAsComputations(ResolvedCall<?> $this$getCallArgumentsAsComputations) {
        List arguments2 = new ArrayList();
        ReceiverValue receiverValue = $this$getCallArgumentsAsComputations.getExtensionReceiver();
        CollectionsKt.addIfNotNull(arguments2, receiverValue != null ? this.toComputation(receiverValue) : null);
        ReceiverValue receiverValue2 = $this$getCallArgumentsAsComputations.getDispatchReceiver();
        CollectionsKt.addIfNotNull(arguments2, receiverValue2 != null ? this.toComputation(receiverValue2) : null);
        List<ResolvedValueArgument> list2 = $this$getCallArgumentsAsComputations.getValueArgumentsByIndex();
        if (list2 == null) {
            return null;
        }
        List<ResolvedValueArgument> passedValueArguments = list2;
        Iterable $this$mapTo$iv = passedValueArguments;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            ResolvedValueArgument resolvedValueArgument = (ResolvedValueArgument)item$iv;
            Collection collection = arguments2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Computation computation = this.toComputation((ResolvedValueArgument)it);
            if (computation == null) {
                return null;
            }
            collection.add(computation);
        }
        return arguments2;
    }

    private final ESTypeSubstitution getTypeSubstitution(ResolvedCall<?> $this$getTypeSubstitution) {
        Map substitution = new LinkedHashMap();
        Map<TypeParameterDescriptor, KotlinType> map = $this$getTypeSubstitution.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"typeArguments");
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : map.entrySet()) {
            TypeConstructor typeConstructor2;
            TypeParameterDescriptor typeParameter = entry.getKey();
            KotlinType typeArgument = entry.getValue();
            Map map2 = substitution;
            Intrinsics.checkNotNullExpressionValue((Object)typeParameter.getTypeConstructor(), (String)"typeParameter.typeConstructor");
            UnwrappedType unwrappedType = typeArgument.unwrap();
            map2.put(typeConstructor2, unwrappedType);
        }
        NewTypeSubstitutor substitutor2 = !substitution.isEmpty() ? (NewTypeSubstitutor)new NewTypeSubstitutorByConstructorMap(substitution) : (NewTypeSubstitutor)EmptySubstitutor.INSTANCE;
        return new ESTypeSubstitution(substitutor2, this.getBuiltIns());
    }

    private final Computation toComputation(ResolvedValueArgument $this$toComputation) {
        Computation computation;
        ResolvedValueArgument resolvedValueArgument = $this$toComputation;
        if (resolvedValueArgument instanceof DefaultValueArgument) {
            computation = UNKNOWN_COMPUTATION.INSTANCE;
        } else if (resolvedValueArgument instanceof VarargValueArgument) {
            computation = null;
        } else if (resolvedValueArgument instanceof ExpressionValueArgument) {
            ValueArgument valueArgument = ((ExpressionValueArgument)$this$toComputation).getValueArgument();
            computation = valueArgument != null ? this.toComputation(valueArgument) : null;
        } else {
            throw new IllegalStateException("Unexpected ResolvedValueArgument " + $this$toComputation);
        }
        return computation;
    }

    private final Computation toComputation(ValueArgument $this$toComputation) {
        Computation computation;
        ValueArgument valueArgument = $this$toComputation;
        if (valueArgument instanceof KtLambdaArgument) {
            ESLambda eSLambda;
            KtLambdaExpression ktLambdaExpression = ((KtLambdaArgument)$this$toComputation).getLambdaExpression();
            if (ktLambdaExpression != null) {
                KtLambdaExpression it = ktLambdaExpression;
                boolean bl = false;
                eSLambda = new ESLambda(it);
            } else {
                eSLambda = null;
            }
            computation = eSLambda;
        } else if (valueArgument instanceof KtValueArgument) {
            KtExpression ktExpression = $this$toComputation.getArgumentExpression();
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                computation = it instanceof KtLambdaExpression ? (Computation)new ESLambda((KtLambdaExpression)it) : this.extractOrGetCached(it);
            } else {
                computation = null;
            }
        } else {
            computation = null;
        }
        return computation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean visitSafeQualifiedExpression$containsReturnsNull(ESEffect $this$visitSafeQualifiedExpression_u24containsReturnsNull) {
        ESEffect $this$isReturns$iv = $this$visitSafeQualifiedExpression_u24containsReturnsNull;
        boolean $i$f$isReturns = false;
        if ($this$isReturns$iv instanceof ESReturns) {
            ESReturns $this$visitSafeQualifiedExpression_u24containsReturnsNull_u24lambda_u2d2 = (ESReturns)$this$isReturns$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)$this$visitSafeQualifiedExpression_u24containsReturnsNull_u24lambda_u2d2.getValue(), (Object)ESConstants.INSTANCE.getNullValue())) {
                return true;
            }
        }
        boolean bl = false;
        if (bl) return true;
        if (!($this$visitSafeQualifiedExpression_u24containsReturnsNull instanceof ConditionalEffect)) return false;
        if (!EffectsExtractingVisitor.visitSafeQualifiedExpression$containsReturnsNull(((ConditionalEffect)$this$visitSafeQualifiedExpression_u24containsReturnsNull).getSimpleEffect())) return false;
        return true;
    }
}

