/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.impl;

import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/impl/BaseKtModuleByCompilerConfiguration;", "", "compilerConfig", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lcom/intellij/openapi/project/Project;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "directFriendDependencies", "", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getDirectFriendDependencies", "()Ljava/util/List;", "directRefinementDependencies", "getDirectRefinementDependencies", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "moduleName", "", "getModuleName", "()Ljava/lang/String;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "analysis-api-standalone"})
public abstract class BaseKtModuleByCompilerConfiguration {
    @NotNull
    private final CompilerConfiguration compilerConfig;
    @NotNull
    private final Project project;

    public BaseKtModuleByCompilerConfiguration(@NotNull CompilerConfiguration compilerConfig, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.compilerConfig = compilerConfig;
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PlatformDependentAnalyzerServices getAnalyzerServices() {
        return JvmPlatformAnalyzerServices.INSTANCE;
    }

    @NotNull
    public final List<KtModule> getDirectFriendDependencies() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final List<KtModule> getDirectRefinementDependencies() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST, null, null, 12, null);
    }

    @NotNull
    public final String getModuleName() {
        String string2 = this.compilerConfig.get(CommonConfigurationKeys.MODULE_NAME);
        if (string2 == null) {
            string2 = "<no module name provided>";
        }
        return string2;
    }

    @NotNull
    public final TargetPlatform getPlatform() {
        return new TargetPlatform(SetsKt.setOf((Object)new JdkPlatform(JvmTarget.DEFAULT)));
    }
}

