/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.state;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.DiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.DiagnosticsCollector;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.FirFileBuilder;
import org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.FirLazyDeclarationResolver;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.state.LLFirResolvableModuleResolveState;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.analysis.utils.errors.ErrorsKt;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ#\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0010\u00a2\u0006\u0002\b\u001aJ#\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0010\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/state/LLFirSourceModuleResolveState;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/state/LLFirResolvableModuleResolveState;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "sessionProvider", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionProvider;", "firFileBuilder", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/FirFileBuilder;", "firLazyDeclarationResolver", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/FirLazyDeclarationResolver;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionProvider;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/FirFileBuilder;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/FirLazyDeclarationResolver;)V", "diagnosticsCollector", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/DiagnosticsCollector;", "getModule", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getProject", "()Lcom/intellij/openapi/project/Project;", "collectDiagnosticsForFile", "", "Lorg/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "filter", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;", "collectDiagnosticsForFile$low_level_api_fir", "getDiagnostics", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getDiagnostics$low_level_api_fir", "getModuleKind", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/state/LLFirResolvableModuleResolveState$ModuleKind;", "low-level-api-fir"})
public final class LLFirSourceModuleResolveState
extends LLFirResolvableModuleResolveState {
    @NotNull
    private final Project project;
    @NotNull
    private final KtModule module;
    @NotNull
    private final DiagnosticsCollector diagnosticsCollector;

    public LLFirSourceModuleResolveState(@NotNull Project project, @NotNull KtModule module2, @NotNull LLFirSessionProvider sessionProvider, @NotNull FirFileBuilder firFileBuilder, @NotNull FirLazyDeclarationResolver firLazyDeclarationResolver) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)sessionProvider, (String)"sessionProvider");
        Intrinsics.checkNotNullParameter((Object)firFileBuilder, (String)"firFileBuilder");
        Intrinsics.checkNotNullParameter((Object)firLazyDeclarationResolver, (String)"firLazyDeclarationResolver");
        super(sessionProvider, firFileBuilder, firLazyDeclarationResolver);
        this.project = project;
        this.module = module2;
        this.diagnosticsCollector = new DiagnosticsCollector(this.getFileStructureCache(), this.getCache());
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public KtModule getModule() {
        return this.module;
    }

    @Override
    @NotNull
    public List<KtPsiDiagnostic> getDiagnostics$low_level_api_fir(@NotNull KtElement element, @NotNull DiagnosticCheckerFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)filter2), (String)"filter");
        return this.diagnosticsCollector.getDiagnosticsFor(element, filter2);
    }

    @Override
    @NotNull
    public Collection<KtPsiDiagnostic> collectDiagnosticsForFile$low_level_api_fir(@NotNull KtFile ktFile, @NotNull DiagnosticCheckerFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)((Object)filter2), (String)"filter");
        return this.diagnosticsCollector.collectDiagnosticsForFile(ktFile, filter2);
    }

    @Override
    @NotNull
    protected LLFirResolvableModuleResolveState.ModuleKind getModuleKind(@NotNull KtModule module2) {
        LLFirResolvableModuleResolveState.ModuleKind moduleKind;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        KtModule ktModule = module2;
        if (ktModule instanceof KtSourceModule) {
            moduleKind = LLFirResolvableModuleResolveState.ModuleKind.RESOLVABLE_MODULE;
        } else if (ktModule instanceof KtLibraryModule) {
            moduleKind = LLFirResolvableModuleResolveState.ModuleKind.BINARY_MODULE;
        } else {
            ErrorsKt.unexpectedElementError("module", module2);
            throw null;
        }
        return moduleKind;
    }
}

