/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.DiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnosticList;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.FirFileBuilder;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.ModuleFileCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileElementFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.ReanalyzableStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.RootStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.FirLazyDeclarationResolver;
import org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.NonLocalDeclarationUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DeclarationUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.UtilsKt;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J(\u0010\"\u001a\u00020#*\b\u0012\u0004\u0012\u00020\u001a0$2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "firLazyDeclarationResolver", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/FirLazyDeclarationResolver;", "firFileBuilder", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/FirFileBuilder;", "moduleFileCache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/ModuleFileCache;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/FirLazyDeclarationResolver;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/FirFileBuilder;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/ModuleFileCache;)V", "firProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "structureElements", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "createDeclarationStructure", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "createStructureElement", "container", "getAllDiagnosticsForFile", "", "Lorg/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "diagnosticCheckerFilter", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;", "getAllStructureElements", "getStructureElementFor", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getStructureElementForDeclaration", "collectDiagnosticsFromStructureElements", "", "", "Companion", "low-level-api-fir"})
public final class FileStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtFile ktFile;
    @NotNull
    private final FirFile firFile;
    @NotNull
    private final FirLazyDeclarationResolver firLazyDeclarationResolver;
    @NotNull
    private final FirFileBuilder firFileBuilder;
    @NotNull
    private final ModuleFileCache moduleFileCache;
    @NotNull
    private final FirProvider firProvider;
    @NotNull
    private final ConcurrentHashMap<KtAnnotated, FileStructureElement> structureElements;

    private FileStructure(KtFile ktFile, FirFile firFile, FirLazyDeclarationResolver firLazyDeclarationResolver, FirFileBuilder firFileBuilder, ModuleFileCache moduleFileCache) {
        this.ktFile = ktFile;
        this.firFile = firFile;
        this.firLazyDeclarationResolver = firLazyDeclarationResolver;
        this.firFileBuilder = firFileBuilder;
        this.moduleFileCache = moduleFileCache;
        this.firProvider = FirProviderKt.getFirProvider(this.firFile.getModuleData().getSession());
        this.structureElements = new ConcurrentHashMap();
    }

    @NotNull
    public final FileStructureElement getStructureElementFor(@NotNull KtElement element) {
        KtAnnotated ktAnnotated;
        KtNamedDeclaration ktNamedDeclaration;
        block3: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement $this$getNonLocalContainingOrThisDeclaration_u24default$iv = (PsiElement)element;
            boolean $i$f$getNonLocalContainingOrThisDeclaration = false;
            for (PsiElement container$iv = $this$getNonLocalContainingOrThisDeclaration_u24default$iv; container$iv != null && !(container$iv instanceof KtFile); container$iv = container$iv.getParent()) {
                if (!(container$iv instanceof KtNamedDeclaration) || !UtilsKt.isNonAnonymousClassOrObject((KtDeclaration)container$iv) && !(container$iv instanceof KtDeclarationWithBody) && !(container$iv instanceof KtProperty) && !(container$iv instanceof KtTypeAlias) || container$iv instanceof KtPrimaryConstructor || !NonLocalDeclarationUtilsKt.declarationCanBeLazilyResolved((KtDeclaration)container$iv) || container$iv instanceof KtFunctionLiteral || KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)container$iv) instanceof KtEnumEntry) continue;
                PsiElement psiElement = container$iv;
                boolean bl = false;
                KtDeclaration it = (KtDeclaration)psiElement;
                if (!true) continue;
                ktNamedDeclaration = (KtNamedDeclaration)container$iv;
                break block3;
            }
            ktNamedDeclaration = null;
        }
        if (ktNamedDeclaration != null) {
            ktAnnotated = ktNamedDeclaration;
        } else {
            KtFile ktFile = element.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
            ktAnnotated = ktFile;
        }
        KtAnnotated container = ktAnnotated;
        return this.getStructureElementForDeclaration(container);
    }

    private final FileStructureElement getStructureElementForDeclaration(KtAnnotated declaration) {
        FileStructureElement structureElement;
        FileStructureElement fileStructureElement = structureElement = this.structureElements.compute(declaration, (arg_0, arg_1) -> FileStructure.getStructureElementForDeclaration$lambda-0(this, declaration, arg_0, arg_1));
        if (fileStructureElement == null) {
            throw new IllegalStateException(("FileStructureElement for was not defined for \n" + UtilsKt.getElementTextInContext(declaration)).toString());
        }
        return fileStructureElement;
    }

    @NotNull
    public final Collection<KtPsiDiagnostic> getAllDiagnosticsForFile(@NotNull DiagnosticCheckerFilter diagnosticCheckerFilter) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)((Object)diagnosticCheckerFilter), (String)"diagnosticCheckerFilter");
        Collection<FileStructureElement> structureElements = this.getAllStructureElements();
        List $this$getAllDiagnosticsForFile_u24lambda_u2d1 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.collectDiagnosticsFromStructureElements($this$getAllDiagnosticsForFile_u24lambda_u2d1, structureElements, diagnosticCheckerFilter);
        return CollectionsKt.build((List)list2);
    }

    private final void collectDiagnosticsFromStructureElements(Collection<KtPsiDiagnostic> $this$collectDiagnosticsFromStructureElements, Collection<? extends FileStructureElement> structureElements, DiagnosticCheckerFilter diagnosticCheckerFilter) {
        Iterable $this$forEach$iv = structureElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            List diagnostics2;
            boolean $i$f$forEach2;
            Iterable $this$forEach$iv$iv$iv;
            boolean $i$f$forEach3;
            FileStructureElementDiagnosticList this_$iv$iv;
            FileStructureElement structureElement = (FileStructureElement)element$iv;
            boolean bl2 = false;
            FileStructureElementDiagnostics this_$iv = structureElement.getDiagnostics();
            boolean $i$f$forEach4 = false;
            if (diagnosticCheckerFilter.getRunCommonCheckers()) {
                this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByCommonCheckers(this_$iv);
                $i$f$forEach3 = false;
                $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
                $i$f$forEach2 = false;
                for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    diagnostics2 = (List)element$iv$iv$iv;
                    bl = false;
                    $this$collectDiagnosticsFromStructureElements.addAll(diagnostics2);
                }
            }
            if (!diagnosticCheckerFilter.getRunExtendedCheckers()) continue;
            this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByExtendedCheckers(this_$iv);
            $i$f$forEach3 = false;
            $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
            $i$f$forEach2 = false;
            for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                diagnostics2 = (List)element$iv$iv$iv;
                bl = false;
                $this$collectDiagnosticsFromStructureElements.addAll(diagnostics2);
            }
        }
    }

    @NotNull
    public final Collection<FileStructureElement> getAllStructureElements() {
        Object[] objectArray = new FileStructureElement[]{this.getStructureElementFor(this.ktFile)};
        Set structureElements = SetsKt.mutableSetOf((Object[])objectArray);
        this.ktFile.accept(new KtVisitorVoid(this, structureElements){
            final /* synthetic */ FileStructure this$0;
            final /* synthetic */ Set<FileStructureElement> $structureElements;
            {
                this.this$0 = $receiver;
                this.$structureElements = $structureElements;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.acceptChildren((PsiElementVisitor)this);
            }

            public void visitDeclaration(@NotNull KtDeclaration dcl) {
                Intrinsics.checkNotNullParameter((Object)dcl, (String)"dcl");
                FileStructureElement structureElement = this.this$0.getStructureElementFor(dcl);
                ((Collection)this.$structureElements).add(structureElement);
                if (!(structureElement instanceof ReanalyzableStructureElement)) {
                    dcl.acceptChildren(this);
                }
            }
        });
        return structureElements;
    }

    private final FileStructureElement createDeclarationStructure(KtDeclaration declaration) {
        FirDeclaration firDeclaration = DeclarationUtilsKt.findSourceNonLocalFirDeclaration(declaration, this.firFileBuilder, this.firProvider.getSymbolProvider(), this.moduleFileCache, this.firFile);
        this.firLazyDeclarationResolver.lazyResolveDeclaration(firDeclaration, this.moduleFileCache, new ScopeSession(), FirResolvePhase.BODY_RESOLVE, true);
        return FileElementFactory.INSTANCE.createFileStructureElement(firDeclaration, declaration, this.firFile, this.moduleFileCache.getFirFileLockProvider());
    }

    private final FileStructureElement createStructureElement(KtAnnotated container) {
        FileStructureElement fileStructureElement;
        KtAnnotated ktAnnotated = container;
        if (ktAnnotated instanceof KtFile) {
            FirFile firFile = this.firFileBuilder.buildRawFirFileWithCaching(this.ktFile, this.moduleFileCache);
            FirLazyDeclarationResolver.resolveFileAnnotations$default(this.firLazyDeclarationResolver, firFile, firFile.getAnnotations(), this.moduleFileCache, new ScopeSession(), true, null, 32, null);
            fileStructureElement = new RootStructureElement(firFile, (KtFile)container, this.moduleFileCache.getFirFileLockProvider());
        } else if (ktAnnotated instanceof KtDeclaration) {
            fileStructureElement = this.createDeclarationStructure((KtDeclaration)container);
        } else {
            throw new IllegalStateException(("Invalid container " + container).toString());
        }
        return fileStructureElement;
    }

    private static final FileStructureElement getStructureElementForDeclaration$lambda-0(FileStructure this$0, KtAnnotated $declaration, KtAnnotated ktAnnotated, FileStructureElement structureElement) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$declaration, (String)"$declaration");
        Intrinsics.checkNotNullParameter((Object)ktAnnotated, (String)"<anonymous parameter 0>");
        return structureElement == null ? this$0.createStructureElement($declaration) : (structureElement instanceof ReanalyzableStructureElement && !((ReanalyzableStructureElement)structureElement).isUpToDate() ? (FileStructureElement)((ReanalyzableStructureElement)structureElement).reanalyze((KtDeclaration)$declaration, this$0.moduleFileCache, this$0.firLazyDeclarationResolver) : structureElement);
    }

    public /* synthetic */ FileStructure(KtFile ktFile, FirFile firFile, FirLazyDeclarationResolver firLazyDeclarationResolver, FirFileBuilder firFileBuilder, ModuleFileCache moduleFileCache, DefaultConstructorMarker $constructor_marker) {
        this(ktFile, firFile, firLazyDeclarationResolver, firFileBuilder, moduleFileCache);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure$Companion;", "", "()V", "build", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "firLazyDeclarationResolver", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/FirLazyDeclarationResolver;", "firFileBuilder", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/FirFileBuilder;", "moduleFileCache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/ModuleFileCache;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileStructure build(@NotNull KtFile ktFile, @NotNull FirLazyDeclarationResolver firLazyDeclarationResolver, @NotNull FirFileBuilder firFileBuilder, @NotNull ModuleFileCache moduleFileCache) {
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            Intrinsics.checkNotNullParameter((Object)firLazyDeclarationResolver, (String)"firLazyDeclarationResolver");
            Intrinsics.checkNotNullParameter((Object)firFileBuilder, (String)"firFileBuilder");
            Intrinsics.checkNotNullParameter((Object)moduleFileCache, (String)"moduleFileCache");
            FirFile firFile = firFileBuilder.buildRawFirFileWithCaching(ktFile, moduleFileCache);
            return new FileStructure(ktFile, firFile, firLazyDeclarationResolver, firFileBuilder, moduleFileCache, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

