/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.DiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.ModuleFileCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructure;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/DiagnosticsCollector;", "", "fileStructureCache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureCache;", "cache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/ModuleFileCache;", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureCache;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/ModuleFileCache;)V", "collectDiagnosticsForFile", "", "Lorg/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "filter", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;", "getDiagnosticsFor", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "low-level-api-fir"})
public final class DiagnosticsCollector {
    @NotNull
    private final FileStructureCache fileStructureCache;
    @NotNull
    private final ModuleFileCache cache;

    public DiagnosticsCollector(@NotNull FileStructureCache fileStructureCache, @NotNull ModuleFileCache cache2) {
        Intrinsics.checkNotNullParameter((Object)fileStructureCache, (String)"fileStructureCache");
        Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
        this.fileStructureCache = fileStructureCache;
        this.cache = cache2;
    }

    @NotNull
    public final List<KtPsiDiagnostic> getDiagnosticsFor(@NotNull KtElement element, @NotNull DiagnosticCheckerFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)filter2), (String)"filter");
        KtFile ktFile = element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
        FileStructure fileStructure = this.fileStructureCache.getFileStructure(ktFile, this.cache);
        FileStructureElement structureElement = fileStructure.getStructureElementFor(element);
        FileStructureElementDiagnostics diagnostics2 = structureElement.getDiagnostics();
        return diagnostics2.diagnosticsFor(filter2, (PsiElement)element);
    }

    @NotNull
    public final Collection<KtPsiDiagnostic> collectDiagnosticsForFile(@NotNull KtFile ktFile, @NotNull DiagnosticCheckerFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)((Object)filter2), (String)"filter");
        FileStructure fileStructure = this.fileStructureCache.getFileStructure(ktFile, this.cache);
        return fileStructure.getAllDiagnosticsForFile(filter2);
    }
}

