/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.KtTypeRendererOptions;
import org.jetbrains.kotlin.analysis.api.fir.renderer.FirAnnotationsIdeRendererKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDeclarationDesignationKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedError;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeRendererKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J2\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u001dJ\u001c\u0010\u001e\u001a\u00020\u001f*\u00060 j\u0002`!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\b*\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u001f*\u00060 j\u0002`!2\u0006\u0010\u0014\u001a\u00020\u001dH\u0002J\u0018\u0010'\u001a\u00020\u001f*\u00060 j\u0002`!2\u0006\u0010\u0014\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\u001f*\u00060 j\u0002`!2\u0006\u0010\u0014\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020\u001f*\u00060 j\u0002`!2\u0006\u0010\u0014\u001a\u00020\u001dH\u0002J\u0018\u0010,\u001a\u00020\u001f*\u00060 j\u0002`!2\u0006\u0010\u0014\u001a\u00020*H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/renderer/ConeTypeIdeRenderer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "options", "Lorg/jetbrains/kotlin/analysis/api/components/KtTypeRendererOptions;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/analysis/api/components/KtTypeRendererOptions;)V", "collectDesignationPathForLocal", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "differsOnlyInNullability", "", "lower", "", "upper", "renderFlexibleType", "lowerRendered", "upperRendered", "renderType", "type", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "renderTypeProjection", "typeProjection", "replacePrefixes", "lowerPrefix", "upperPrefix", "foldedPrefix", "shouldRenderAsPrettyFunctionType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "appendError", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "message", "collectForLocal", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "renderAnnotationList", "renderErrorType", "Lorg/jetbrains/kotlin/fir/types/ConeErrorType;", "renderFunctionType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "renderNullability", "renderTypeConstructorAndArguments", "Companion", "analysis-api-fir"})
public final class ConeTypeIdeRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final KtTypeRendererOptions options;
    @NotNull
    public static final String ERROR_TYPE_TEXT = "ERROR_TYPE";

    public ConeTypeIdeRenderer(@NotNull FirSession session2, @NotNull KtTypeRendererOptions options) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.session = session2;
        this.options = options;
    }

    private final void appendError(StringBuilder $this$appendError, String message) {
        $this$appendError.append(ERROR_TYPE_TEXT);
        if (message != null) {
            $this$appendError.append(" <" + message + '>');
        }
    }

    static /* synthetic */ void appendError$default(ConeTypeIdeRenderer coneTypeIdeRenderer, StringBuilder stringBuilder2, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        coneTypeIdeRenderer.appendError(stringBuilder2, string2);
    }

    private final void renderAnnotationList(StringBuilder $this$renderAnnotationList, ConeKotlinType type2) {
        if (this.options.getRenderTypeAnnotations()) {
            FirAnnotationsIdeRendererKt.renderAnnotations($this$renderAnnotationList, this, CustomAnnotationTypeAttributeKt.getCustomAnnotations(type2), this.session, true);
        }
    }

    @NotNull
    public final String renderType(@NotNull ConeTypeProjection type2) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        StringBuilder $this$renderType_u24lambda_u2d0 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        ConeTypeProjection coneTypeProjection = type2;
        if (coneTypeProjection instanceof ConeErrorType) {
            this.renderErrorType($this$renderType_u24lambda_u2d0, (ConeErrorType)type2);
        } else if (coneTypeProjection instanceof ConeClassLikeType) {
            if (this.options.getRenderFunctionType() && this.shouldRenderAsPrettyFunctionType((ConeKotlinType)type2)) {
                this.renderAnnotationList($this$renderType_u24lambda_u2d0, (ConeKotlinType)type2);
                this.renderFunctionType($this$renderType_u24lambda_u2d0, (ConeClassLikeType)type2);
            } else {
                this.renderAnnotationList($this$renderType_u24lambda_u2d0, (ConeKotlinType)type2);
                this.renderTypeConstructorAndArguments($this$renderType_u24lambda_u2d0, (ConeClassLikeType)type2);
            }
        } else if (coneTypeProjection instanceof ConeTypeParameterType) {
            this.renderAnnotationList($this$renderType_u24lambda_u2d0, (ConeKotlinType)type2);
            $this$renderType_u24lambda_u2d0.append(((ConeTypeParameterType)type2).getLookupTag().getName().asString());
            this.renderNullability($this$renderType_u24lambda_u2d0, ((ConeTypeParameterType)type2).getType());
        } else if (coneTypeProjection instanceof ConeIntersectionType) {
            this.renderAnnotationList($this$renderType_u24lambda_u2d0, (ConeKotlinType)type2);
            CollectionsKt.joinTo$default((Iterable)((ConeIntersectionType)type2).getIntersectedTypes(), (Appendable)$this$renderType_u24lambda_u2d0, (CharSequence)"&", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<ConeKotlinType, CharSequence>(this){
                final /* synthetic */ ConeTypeIdeRenderer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull ConeKotlinType it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.renderType(it);
                }
            }), (int)48, null);
            this.renderNullability($this$renderType_u24lambda_u2d0, ((ConeIntersectionType)type2).getType());
        } else if (coneTypeProjection instanceof ConeFlexibleType) {
            this.renderAnnotationList($this$renderType_u24lambda_u2d0, (ConeKotlinType)type2);
            $this$renderType_u24lambda_u2d0.append(this.renderFlexibleType(this.renderType(((ConeFlexibleType)type2).getLowerBound()), this.renderType(((ConeFlexibleType)type2).getUpperBound())));
        } else if (coneTypeProjection instanceof ConeCapturedType) {
            this.renderAnnotationList($this$renderType_u24lambda_u2d0, (ConeKotlinType)type2);
            $this$renderType_u24lambda_u2d0.append(TypeRendererKt.render((ConeKotlinType)type2));
            this.renderNullability($this$renderType_u24lambda_u2d0, ((ConeCapturedType)type2).getType());
        } else if (coneTypeProjection instanceof ConeDefinitelyNotNullType) {
            this.renderAnnotationList($this$renderType_u24lambda_u2d0, (ConeKotlinType)type2);
            $this$renderType_u24lambda_u2d0.append(this.renderType(((ConeDefinitelyNotNullType)type2).getOriginal()));
            $this$renderType_u24lambda_u2d0.append("!!");
        } else {
            this.appendError($this$renderType_u24lambda_u2d0, "Unexpected cone type " + Reflection.getOrCreateKotlinClass(type2.getClass()).getQualifiedName());
        }
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final void renderErrorType(StringBuilder $this$renderErrorType, ConeErrorType type2) {
        ConeDiagnostic diagnostic = type2.getDiagnostic();
        if (this.options.getRenderUnresolvedTypeAsResolved() && diagnostic instanceof ConeUnresolvedError) {
            String string2;
            String string3;
            String string4 = ((ConeUnresolvedError)diagnostic).getQualifier();
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                string3 = RenderingUtilsKt.render(new FqName(it));
            } else {
                string3 = string2 = null;
            }
            if (string3 == null) {
                string2 = "";
            }
            String qualifierRendered = string2;
            $this$renderErrorType.append(qualifierRendered);
        } else {
            this.appendError($this$renderErrorType, diagnostic.getReason());
        }
    }

    private final void renderNullability(StringBuilder $this$renderNullability, ConeKotlinType type2) {
        if (type2.getNullability() == ConeNullability.NULLABLE) {
            $this$renderNullability.append("?");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldRenderAsPrettyFunctionType(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!InferenceUtilsKt.isBuiltinFunctionalType(type2.getType(), this.session)) return false;
        ConeTypeProjection[] $this$none$iv = type2.getTypeArguments();
        boolean $i$f$none = false;
        int n = 0;
        int n2 = $this$none$iv.length;
        while (n < n2) {
            ConeTypeProjection element$iv;
            ConeTypeProjection it = element$iv = $this$none$iv[n];
            boolean bl = false;
            if (it.getKind() == ProjectionKind.STAR) {
                return false;
            }
            boolean bl2 = false;
            if (bl2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final boolean differsOnlyInNullability(String lower2, String upper) {
        return Intrinsics.areEqual((Object)lower2, (Object)StringsKt.replace$default((String)upper, (String)"?", (String)"", (boolean)false, (int)4, null)) || StringsKt.endsWith$default((String)upper, (String)"?", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)(lower2 + '?'), (Object)upper) || Intrinsics.areEqual((Object)('(' + lower2 + ")?"), (Object)upper);
    }

    private final String renderFlexibleType(String lowerRendered, String upperRendered) {
        String array2;
        String mutableEntry;
        String simpleCollection;
        if (this.differsOnlyInNullability(lowerRendered, upperRendered)) {
            if (StringsKt.startsWith$default((String)upperRendered, (String)"(", (boolean)false, (int)2, null)) {
                return '(' + lowerRendered + ")!";
            }
            return lowerRendered + '!';
        }
        String kotlinCollectionsPrefix = "kotlin.collections.";
        String mutablePrefix = "Mutable";
        String string2 = simpleCollection = this.replacePrefixes(lowerRendered, kotlinCollectionsPrefix + mutablePrefix, upperRendered, kotlinCollectionsPrefix, kotlinCollectionsPrefix + '(' + mutablePrefix + ')');
        if (string2 != null) {
            return string2;
        }
        String string3 = mutableEntry = this.replacePrefixes(lowerRendered, kotlinCollectionsPrefix + "MutableMap.MutableEntry", upperRendered, kotlinCollectionsPrefix + "Map.Entry", kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry");
        if (string3 != null) {
            return string3;
        }
        String kotlinPrefix = "kotlin.";
        String string4 = array2 = this.replacePrefixes(lowerRendered, kotlinPrefix + "Array<", upperRendered, kotlinPrefix + "Array<out ", kotlinPrefix + "Array<(out) ");
        if (string4 != null) {
            return string4;
        }
        return '(' + lowerRendered + ".." + upperRendered + ')';
    }

    private final String replacePrefixes(String lowerRendered, String lowerPrefix, String upperRendered, String upperPrefix, String foldedPrefix) {
        if (StringsKt.startsWith$default((String)lowerRendered, (String)lowerPrefix, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)upperRendered, (String)upperPrefix, (boolean)false, (int)2, null)) {
            String string2 = lowerRendered.substring(lowerPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String lowerWithoutPrefix = string2;
            String string3 = upperRendered.substring(upperPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            String upperWithoutPrefix = string3;
            String flexibleCollectionName = foldedPrefix + lowerWithoutPrefix;
            if (Intrinsics.areEqual((Object)lowerWithoutPrefix, (Object)upperWithoutPrefix)) {
                return flexibleCollectionName;
            }
            if (this.differsOnlyInNullability(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName + '!';
            }
        }
        return null;
    }

    private final List<FirClassLikeDeclaration> collectForLocal(FirRegularClass $this$collectForLocal) {
        FirClassLikeDeclaration $this$isLocal$iv = $this$collectForLocal;
        boolean $i$f$isLocal2 = false;
        if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) {
            String $i$f$isLocal2 = "Failed requirement.";
            throw new IllegalArgumentException($i$f$isLocal2.toString());
        }
        ConeClassLikeLookupTag containingClassLookUp = ClassMembersKt.containingClassForLocal($this$collectForLocal);
        Object[] objectArray = new FirClassLikeDeclaration[]{$this$collectForLocal};
        List designation2 = CollectionsKt.mutableListOf((Object[])objectArray);
        while (containingClassLookUp != null && containingClassLookUp.getClassId().isLocal() && LookupTagUtilsKt.toFirRegularClass(containingClassLookUp, $this$collectForLocal.getModuleData().getSession()) != null) {
            FirRegularClass currentClass;
            designation2.add(currentClass);
            containingClassLookUp = ClassMembersKt.containingClassForLocal(currentClass);
        }
        return designation2;
    }

    private final List<FirDeclaration> collectDesignationPathForLocal(FirDeclaration declaration) {
        FirRegularClass firRegularClass;
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirCallableDeclaration) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass((FirCallableDeclaration)declaration);
            firRegularClass = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClass(coneClassLikeLookupTag, declaration.getModuleData().getSession()) : null;
        } else {
            if (firDeclaration instanceof FirAnonymousObject) {
                return CollectionsKt.listOf((Object)declaration);
            }
            if (firDeclaration instanceof FirClassLikeDeclaration) {
                FirClassLikeDeclaration it = (FirClassLikeDeclaration)declaration;
                boolean bl = false;
                FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)declaration;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                    return null;
                }
                Object object = it instanceof FirRegularClass ? (FirRegularClass)it : null;
                firRegularClass = object != null && (object = ClassMembersKt.containingClassForLocal((FirRegularClass)object)) != null ? LookupTagUtilsKt.toFirRegularClass((ConeClassLikeLookupTag)object, declaration.getModuleData().getSession()) : null;
            } else {
                throw new IllegalStateException(("Invalid declaration " + FirRendererKt.renderWithType$default(declaration, null, 1, null)).toString());
            }
        }
        if (firRegularClass == null) {
            return CollectionsKt.listOf((Object)declaration);
        }
        FirRegularClass containingClass = firRegularClass;
        FirClassLikeDeclaration $this$isLocal$iv = containingClass;
        boolean $i$f$isLocal = false;
        return $this$isLocal$iv.getSymbol().getClassId().isLocal() ? CollectionsKt.reversed((Iterable)this.collectForLocal(containingClass)) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTypeConstructorAndArguments(StringBuilder $this$renderTypeConstructorAndArguments, ConeClassLikeType type2) {
        void $this$forEachIndexed$iv;
        void $this$filterIsInstanceTo$iv$iv;
        FirClassLikeSymbol<?> classSymbolToRender = LookupTagUtilsKt.toSymbol(type2.getLookupTag(), this.session);
        if (classSymbolToRender == null) {
            this.appendError($this$renderTypeConstructorAndArguments, "Unresolved type");
            return;
        }
        if (!this.options.getShortQualifiedNames() && !classSymbolToRender.getClassId().isLocal()) {
            String string2 = classSymbolToRender.getClassId().getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classSymbolToRender.clas\u2026.packageFqName.asString()");
            String packageName = string2;
            if (((CharSequence)packageName).length() > 0) {
                $this$renderTypeConstructorAndArguments.append(packageName).append(".");
            }
        }
        if (!(classSymbolToRender instanceof FirRegularClassSymbol)) {
            $this$renderTypeConstructorAndArguments.append(classSymbolToRender.getClassId().getShortClassName());
            if (ArraysKt.any((Object[])type2.getTypeArguments())) {
                ArraysKt.joinTo$default((Object[])type2.getTypeArguments(), (Appendable)$this$renderTypeConstructorAndArguments, (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)((Function1)new Function1<ConeTypeProjection, CharSequence>(this){
                    final /* synthetic */ ConeTypeIdeRenderer this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull ConeTypeProjection it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return ConeTypeIdeRenderer.access$renderTypeProjection(this.this$0, it);
                    }
                }), (int)48, null);
            }
            return;
        }
        FirRegularClass it = (FirRegularClass)((FirRegularClassSymbol)classSymbolToRender).getFir();
        boolean bl = false;
        Object nonLocalDesignation = FirDeclarationDesignationKt.tryCollectDesignation(it);
        Object object = nonLocalDesignation;
        if ((object == null || (object = object.toSequence(true)) == null || (object = SequencesKt.toList(object)) == null) && (object = this.collectDesignationPathForLocal(it)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object designation2 = object;
        Ref.IntRef typeParametersLeft = new Ref.IntRef();
        typeParametersLeft.element = type2.getTypeArguments().length;
        Iterable $this$filterIsInstance$iv = (Iterable)designation2;
        boolean $i$f$filterIsInstance = false;
        nonLocalDesignation = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirRegularClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            void currentClass;
            int n2;
            Object element$iv$iv;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (FirRegularClass)item$iv;
            int index2 = n2;
            boolean bl2 = false;
            if (index2 != 0) {
                $this$renderTypeConstructorAndArguments.append(".");
            }
            $this$renderTypeConstructorAndArguments.append(currentClass.getName());
            if (!ConeTypeIdeRenderer.renderTypeConstructorAndArguments$needToRenderTypeParameters(typeParametersLeft, designation2, index2)) continue;
            Iterable $this$count$iv = currentClass.getTypeParameters();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    FirTypeParameterRef it2 = (FirTypeParameterRef)element$iv;
                    boolean bl3 = false;
                    if (!(it2 instanceof FirTypeParameter) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int typeParametersCount2 = n;
            int begin = typeParametersLeft.element - typeParametersCount2;
            int end = typeParametersLeft.element;
            if (!(begin >= 0)) {
                String string3 = "Check failed.";
                throw new IllegalStateException(string3.toString());
            }
            typeParametersLeft.element -= typeParametersCount2;
            ConeTypeIdeRenderer.renderTypeConstructorAndArguments$renderTypeArguments($this$renderTypeConstructorAndArguments, this, type2.getTypeArguments(), RangesKt.until((int)begin, (int)end));
        }
        this.renderNullability($this$renderTypeConstructorAndArguments, type2);
    }

    private final String renderTypeProjection(ConeTypeProjection typeProjection) {
        Object object;
        Object object2;
        block9: {
            block8: {
                object2 = ConeTypeProjectionKt.getType(typeProjection);
                if (object2 == null) break block8;
                ConeTypeProjection p0 = (ConeTypeProjection)object2;
                boolean bl = false;
                String string2 = this.renderType(p0);
                object2 = string2;
                if (string2 != null) break block9;
            }
            object2 = "???";
        }
        Object type2 = object2;
        switch (WhenMappings.$EnumSwitchMapping$0[typeProjection.getKind().ordinal()]) {
            case 1: {
                object = "*";
                break;
            }
            case 2: {
                object = "in " + (String)type2;
                break;
            }
            case 3: {
                object = "out " + (String)type2;
                break;
            }
            case 4: {
                object = type2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderFunctionType(StringBuilder $this$renderFunctionType, ConeClassLikeType type2) {
        List list2;
        void $this$applyIf$iv;
        boolean needParenthesis;
        int lengthBefore = $this$renderFunctionType.length();
        boolean hasAnnotations = $this$renderFunctionType.length() != lengthBefore;
        boolean isSuspend = InferenceUtilsKt.isSuspendFunctionType(type2, this.session);
        boolean isNullable = ConeTypeUtilsKt.isMarkedNullable(type2);
        ConeKotlinType receiverType = InferenceUtilsKt.receiverType(type2, this.session);
        boolean bl = needParenthesis = isNullable || hasAnnotations && receiverType != null;
        if (needParenthesis) {
            if (isSuspend) {
                $this$renderFunctionType.insert(lengthBefore, '(');
            } else {
                if (hasAnnotations) {
                    if (!(StringsKt.last((CharSequence)$this$renderFunctionType) == ' ')) {
                        String string2 = "Check failed.";
                        throw new IllegalStateException(string2.toString());
                    }
                    if ($this$renderFunctionType.charAt(StringsKt.getLastIndex((CharSequence)$this$renderFunctionType) - 1) != ')') {
                        $this$renderFunctionType.insert(StringsKt.getLastIndex((CharSequence)$this$renderFunctionType), "()");
                    }
                }
                $this$renderFunctionType.append("(");
            }
        }
        if (isSuspend) {
            $this$renderFunctionType.append("suspend");
            $this$renderFunctionType.append(" ");
        }
        if (receiverType != null) {
            boolean surroundReceiver;
            boolean bl2 = surroundReceiver = this.shouldRenderAsPrettyFunctionType(receiverType) && !ConeTypeUtilsKt.isMarkedNullable(receiverType) || InferenceUtilsKt.isSuspendFunctionType(receiverType, this.session);
            if (surroundReceiver) {
                $this$renderFunctionType.append("(");
            }
            $this$renderFunctionType.append(this.renderType(receiverType));
            if (surroundReceiver) {
                $this$renderFunctionType.append(")");
            }
            $this$renderFunctionType.append(".");
        }
        $this$renderFunctionType.append("(");
        List<ConeKotlinType> list3 = InferenceUtilsKt.valueParameterTypesIncludingReceiver(type2, this.session);
        boolean if$iv = receiverType != null;
        boolean $i$f$applyIf = false;
        if (if$iv) {
            void $this$renderFunctionType_u24lambda_u2d7 = $this$applyIf$iv;
            boolean bl3 = false;
            list2 = CollectionsKt.drop((Iterable)((Iterable)$this$renderFunctionType_u24lambda_u2d7), (int)1);
        } else {
            list2 = $this$applyIf$iv;
        }
        void notNullParametersType = list2;
        Iterable $this$forEachIndexed$iv = (Iterable)notNullParametersType;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void typeProjection;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ConeKotlinType coneKotlinType = (ConeKotlinType)item$iv;
            int index2 = n;
            boolean bl4 = false;
            if (index2 != 0) {
                $this$renderFunctionType.append(", ");
            }
            $this$renderFunctionType.append(this.renderTypeProjection((ConeTypeProjection)typeProjection));
        }
        $this$renderFunctionType.append(") -> ");
        ConeKotlinType returnType2 = InferenceUtilsKt.returnType(type2, this.session);
        $this$renderFunctionType.append(this.renderType(returnType2));
        if (needParenthesis) {
            $this$renderFunctionType.append(")");
        }
        this.renderNullability($this$renderFunctionType, type2);
    }

    private static final void renderTypeConstructorAndArguments$renderTypeArguments(StringBuilder $this_renderTypeConstructorAndArguments, ConeTypeIdeRenderer this$0, ConeTypeProjection[] typeArguments2, IntRange range) {
        if (CollectionsKt.any((Iterable)((Iterable)range))) {
            CollectionsKt.joinTo$default((Iterable)ArraysKt.slice((Object[])typeArguments2, (IntRange)range), (Appendable)$this_renderTypeConstructorAndArguments, (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)((Function1)new Function1<ConeTypeProjection, CharSequence>(this$0){
                final /* synthetic */ ConeTypeIdeRenderer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull ConeTypeProjection it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return ConeTypeIdeRenderer.access$renderTypeProjection(this.this$0, it);
                }
            }), (int)48, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean renderTypeConstructorAndArguments$needToRenderTypeParameters(Ref.IntRef typeParametersLeft, List<? extends FirDeclaration> designation2, int index2) {
        boolean bl;
        boolean $i$f$isInner;
        FirDeclaration $this$isInner$iv;
        if (typeParametersLeft.element <= 0) {
            return false;
        }
        if (index2 == CollectionsKt.getLastIndex(designation2)) return true;
        FirDeclaration firDeclaration = designation2.get(index2);
        FirRegularClass firRegularClass = firDeclaration instanceof FirRegularClass ? (FirRegularClass)firDeclaration : null;
        if (firRegularClass != null) {
            $this$isInner$iv = firRegularClass;
            $i$f$isInner = false;
            if (((FirMemberDeclaration)$this$isInner$iv).getStatus().isInner()) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        $this$isInner$iv = designation2.get(index2 + 1);
        if (!($this$isInner$iv instanceof FirRegularClass)) return false;
        FirRegularClass firRegularClass2 = (FirRegularClass)$this$isInner$iv;
        if (firRegularClass2 == null) return false;
        $this$isInner$iv = firRegularClass2;
        $i$f$isInner = false;
        if (!((FirMemberDeclaration)$this$isInner$iv).getStatus().isInner()) return false;
        return true;
    }

    public static final /* synthetic */ String access$renderTypeProjection(ConeTypeIdeRenderer $this, ConeTypeProjection typeProjection) {
        return $this.renderTypeProjection(typeProjection);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/renderer/ConeTypeIdeRenderer$Companion;", "", "()V", "ERROR_TYPE_TEXT", "", "analysis-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProjectionKind.values().length];
            nArray[ProjectionKind.STAR.ordinal()] = 1;
            nArray[ProjectionKind.IN.ordinal()] = 2;
            nArray[ProjectionKind.OUT.ordinal()] = 3;
            nArray[ProjectionKind.INVARIANT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

