/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.components;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.DefaultTypeClassIds;
import org.jetbrains.kotlin.analysis.api.components.KtAnalysisSessionMixIn;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtTypeAliasSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtFlexibleType;
import org.jetbrains.kotlin.analysis.api.types.KtNonErrorClassType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.api.types.KtTypeNullability;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0014\u0010.\u001a\u00020\u0003*\u00020\u00042\u0006\u0010/\u001a\u000200H\u0016R\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0018\u0010\u0015\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006R\u0018\u0010\u0016\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u0018\u0010\u0017\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006R\u0018\u0010\u0018\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0018\u0010\u0019\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006R\u0018\u0010\u001a\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0006R\u0018\u0010\u001b\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0006R\u0018\u0010\u001c\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0006R\u0018\u0010\u001d\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0006R\u0018\u0010\u001e\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0006R\u0018\u0010\u001f\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0006R\u0018\u0010 \u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006R\u0018\u0010!\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0006R\u0018\u0010\"\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0006R\u0018\u0010#\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0006R\u0018\u0010$\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0006R\u0018\u0010%\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0006R\u0018\u0010&\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0006R\u0018\u0010'\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0006R\u0018\u0010(\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0006R\u0018\u0010)\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0006R\u0018\u0010*\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0006R\u0018\u0010+\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0006R\u0018\u0010,\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0006R\u0018\u0010-\u001a\u00020\u0003*\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0006\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/analysis/api/components/KtTypeInfoProviderMixIn;", "Lorg/jetbrains/kotlin/analysis/api/components/KtAnalysisSessionMixIn;", "canBeNull", "", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "getCanBeNull", "(Lorg/jetbrains/kotlin/analysis/api/types/KtType;)Z", "defaultInitializer", "", "getDefaultInitializer", "(Lorg/jetbrains/kotlin/analysis/api/types/KtType;)Ljava/lang/String;", "expandedClassSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassOrObjectSymbol;", "getExpandedClassSymbol", "(Lorg/jetbrains/kotlin/analysis/api/types/KtType;)Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassOrObjectSymbol;", "functionClassKind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "getFunctionClassKind", "(Lorg/jetbrains/kotlin/analysis/api/types/KtType;)Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "hasFlexibleNullability", "getHasFlexibleNullability", "isAny", "isBoolean", "isByte", "isChar", "isCharSequence", "isDenotable", "isDouble", "isFloat", "isFunctionType", "isFunctionalInterfaceType", "isInt", "isKFunctionType", "isKSuspendFunctionType", "isLong", "isMarkedNullable", "isNothing", "isPrimitive", "isShort", "isString", "isSuspendFunctionType", "isUByte", "isUInt", "isULong", "isUShort", "isUnit", "isClassTypeWithClassId", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "analysis-api"})
public interface KtTypeInfoProviderMixIn
extends KtAnalysisSessionMixIn {
    public boolean isDenotable(@NotNull KtType var1);

    public boolean isFunctionalInterfaceType(@NotNull KtType var1);

    @Nullable
    public FunctionClassKind getFunctionClassKind(@NotNull KtType var1);

    public boolean isFunctionType(@NotNull KtType var1);

    public boolean isKFunctionType(@NotNull KtType var1);

    public boolean isSuspendFunctionType(@NotNull KtType var1);

    public boolean isKSuspendFunctionType(@NotNull KtType var1);

    public boolean getCanBeNull(@NotNull KtType var1);

    public boolean isMarkedNullable(@NotNull KtType var1);

    public boolean getHasFlexibleNullability(@NotNull KtType var1);

    public boolean isUnit(@NotNull KtType var1);

    public boolean isInt(@NotNull KtType var1);

    public boolean isLong(@NotNull KtType var1);

    public boolean isShort(@NotNull KtType var1);

    public boolean isByte(@NotNull KtType var1);

    public boolean isFloat(@NotNull KtType var1);

    public boolean isDouble(@NotNull KtType var1);

    public boolean isChar(@NotNull KtType var1);

    public boolean isBoolean(@NotNull KtType var1);

    public boolean isString(@NotNull KtType var1);

    public boolean isCharSequence(@NotNull KtType var1);

    public boolean isAny(@NotNull KtType var1);

    public boolean isNothing(@NotNull KtType var1);

    public boolean isUInt(@NotNull KtType var1);

    public boolean isULong(@NotNull KtType var1);

    public boolean isUShort(@NotNull KtType var1);

    public boolean isUByte(@NotNull KtType var1);

    @Nullable
    public KtClassOrObjectSymbol getExpandedClassSymbol(@NotNull KtType var1);

    public boolean isClassTypeWithClassId(@NotNull KtType var1, @NotNull ClassId var2);

    public boolean isPrimitive(@NotNull KtType var1);

    @Nullable
    public String getDefaultInitializer(@NotNull KtType var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean isDenotable(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.getAnalysisSession().getTypeInfoProvider$analysis_api().isDenotable($receiver);
        }

        public static boolean isFunctionalInterfaceType(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.getAnalysisSession().getTypeInfoProvider$analysis_api().isFunctionalInterfaceType($receiver);
        }

        @Nullable
        public static FunctionClassKind getFunctionClassKind(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.getAnalysisSession().getTypeInfoProvider$analysis_api().getFunctionClassKind($receiver);
        }

        public static boolean isFunctionType(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.getFunctionClassKind($receiver) == FunctionClassKind.Function;
        }

        public static boolean isKFunctionType(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.getFunctionClassKind($receiver) == FunctionClassKind.KFunction;
        }

        public static boolean isSuspendFunctionType(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.getFunctionClassKind($receiver) == FunctionClassKind.SuspendFunction;
        }

        public static boolean isKSuspendFunctionType(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.getFunctionClassKind($receiver) == FunctionClassKind.KSuspendFunction;
        }

        public static boolean getCanBeNull(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.getAnalysisSession().getTypeInfoProvider$analysis_api().canBeNull($receiver);
        }

        public static boolean isMarkedNullable(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $receiver.getNullability() == KtTypeNullability.NULLABLE;
        }

        public static boolean getHasFlexibleNullability(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $receiver instanceof KtFlexibleType && $this.isMarkedNullable(((KtFlexibleType)$receiver).getUpperBound()) != $this.isMarkedNullable(((KtFlexibleType)$receiver).getLowerBound());
        }

        public static boolean isUnit(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getUNIT());
        }

        public static boolean isInt(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getINT());
        }

        public static boolean isLong(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getLONG());
        }

        public static boolean isShort(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getSHORT());
        }

        public static boolean isByte(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getBYTE());
        }

        public static boolean isFloat(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getFLOAT());
        }

        public static boolean isDouble(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getDOUBLE());
        }

        public static boolean isChar(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getCHAR());
        }

        public static boolean isBoolean(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getBOOLEAN());
        }

        public static boolean isString(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getSTRING());
        }

        public static boolean isCharSequence(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getCHAR_SEQUENCE());
        }

        public static boolean isAny(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getANY());
        }

        public static boolean isNothing(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, DefaultTypeClassIds.INSTANCE.getNOTHING());
        }

        public static boolean isUInt(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, StandardNames.FqNames.uInt);
        }

        public static boolean isULong(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, StandardNames.FqNames.uLong);
        }

        public static boolean isUShort(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, StandardNames.FqNames.uShort);
        }

        public static boolean isUByte(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isClassTypeWithClassId($receiver, StandardNames.FqNames.uByte);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public static KtClassOrObjectSymbol getExpandedClassSymbol(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            KtClassOrObjectSymbol ktClassOrObjectSymbol;
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            if (!($receiver instanceof KtNonErrorClassType)) return null;
            KtClassLikeSymbol classSymbol2 = ((KtNonErrorClassType)$receiver).getClassSymbol();
            if (classSymbol2 instanceof KtClassOrObjectSymbol) {
                ktClassOrObjectSymbol = (KtClassOrObjectSymbol)classSymbol2;
                return ktClassOrObjectSymbol;
            } else {
                if (!(classSymbol2 instanceof KtTypeAliasSymbol)) throw new NoWhenBranchMatchedException();
                ktClassOrObjectSymbol = $this.getExpandedClassSymbol(((KtTypeAliasSymbol)classSymbol2).getExpandedType());
            }
            return ktClassOrObjectSymbol;
        }

        public static boolean isClassTypeWithClassId(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver, @NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            if (!($receiver instanceof KtNonErrorClassType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((KtNonErrorClassType)$receiver).getClassId(), (Object)classId);
        }

        public static boolean isPrimitive(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            if (!($receiver instanceof KtNonErrorClassType)) {
                return false;
            }
            return DefaultTypeClassIds.INSTANCE.getPRIMITIVES().contains(((KtNonErrorClassType)$receiver).getClassId());
        }

        @Nullable
        public static String getDefaultInitializer(@NotNull KtTypeInfoProviderMixIn $this, @NotNull KtType $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.isMarkedNullable($receiver) ? "null" : ($this.isInt($receiver) || $this.isLong($receiver) || $this.isShort($receiver) || $this.isByte($receiver) ? "0" : ($this.isFloat($receiver) ? "0.0f" : ($this.isDouble($receiver) ? "0.0" : ($this.isChar($receiver) ? "'\\u0000'" : ($this.isBoolean($receiver) ? "false" : ($this.isUnit($receiver) ? "Unit" : ($this.isString($receiver) ? "\"\"" : ($this.isUInt($receiver) ? "0.toUInt()" : ($this.isULong($receiver) ? "0.toULong()" : ($this.isUShort($receiver) ? "0.toUShort()" : ($this.isUByte($receiver) ? "0.toUByte()" : null)))))))))));
        }
    }
}

