/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.function.IntUnaryOperator;
import javaslang.collection.IndexedSeq;

interface IndexedSeqModule {

    public static interface Search {
        public static <T> int binarySearch(IndexedSeq<T> seq, IntUnaryOperator comparison) {
            int low = 0;
            int high = seq.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int cmp = comparison.applyAsInt(mid);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }
    }

    public static interface LastIndexOfSlice {
        public static <T> int lastIndexOfSlice(IndexedSeq<T> t, IndexedSeq<T> slice, int end) {
            if (end < 0) {
                return -1;
            }
            if (t.isEmpty()) {
                return slice.isEmpty() ? 0 : -1;
            }
            if (slice.isEmpty()) {
                int len = t.length();
                return len < end ? len : end;
            }
            int p = 0;
            int result2 = -1;
            int maxPtr = t.length() - slice.length();
            while (p <= maxPtr) {
                int r = LastIndexOfSlice.findSlice(t, p, maxPtr, slice);
                if (r < 0) {
                    return result2;
                }
                if (r <= end) {
                    result2 = r;
                    p = r + 1;
                    continue;
                }
                return result2;
            }
            return result2;
        }

        public static <T> int findSlice(IndexedSeq<T> t, int p, int maxPtr, IndexedSeq<T> slice) {
            while (p <= maxPtr) {
                if (t.startsWith(slice, p)) {
                    return p;
                }
                ++p;
            }
            return -1;
        }
    }
}

