/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.symbols.PartialRMergingException;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolTableKt;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Interner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b&\u0018\u0000 &2\u00020\u0001:\u0005%&'()B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u0013\u001a\u00020\u0005J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R$\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/android/ide/common/symbols/SymbolTable;", "", "()V", "resourceTypes", "", "Lcom/android/resources/ResourceType;", "getResourceTypes", "()Ljava/util/Set;", "symbols", "Lcom/google/common/collect/ImmutableTable;", "", "Lcom/android/ide/common/symbols/Symbol;", "getSymbols", "()Lcom/google/common/collect/ImmutableTable;", "tablePackage", "getTablePackage", "()Ljava/lang/String;", "containsSymbol", "", "type", "canonicalName", "filter", "table", "getSymbolByResourceType", "", "getSymbolByVisibility", "visibility", "Lcom/android/resources/ResourceVisibility;", "maybeGetStyleableParentSymbolForChild", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "start", "", "merge", "m", "rename", "withValuesFrom", "mainSymbolTable", "Builder", "Companion", "FastBuilder", "IllegalResourceVisibilityException", "SymbolTableImpl", "sdk-common"})
public abstract class SymbolTable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected SymbolTable() {
    }

    @NotNull
    public abstract String getTablePackage();

    @NotNull
    public abstract ImmutableTable<ResourceType, String, Symbol> getSymbols();

    @NotNull
    public final SymbolTable filter(@NotNull SymbolTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (ResourceType resourceType : table.getSymbols().rowKeySet()) {
            Collection collection = table.getSymbols().row((Object)resourceType).values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"table.symbols.row(resourceType).values");
            ImmutableCollection symbols2 = (ImmutableCollection)collection;
            Set set = this.getSymbols().row((Object)resourceType).keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"this.symbols.row(resourceType).keys");
            ImmutableSet filteringSymbolNames = (ImmutableSet)set;
            for (Symbol symbol : symbols2) {
                if (!filteringSymbolNames.contains((Object)symbol.getCanonicalName())) continue;
                builder.put((Object)resourceType, (Object)symbol.getCanonicalName(), this.getSymbols().get((Object)resourceType, (Object)symbol.getCanonicalName()));
            }
        }
        String string = this.getTablePackage();
        ImmutableTable immutableTable = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableTable, (String)"builder.build()");
        return new SymbolTableImpl(string, (ImmutableTable<ResourceType, String, Symbol>)immutableTable);
    }

    @NotNull
    public final SymbolTable merge(@NotNull SymbolTable m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Object[] objectArray = new SymbolTable[]{this, m};
        return Companion.merge(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final SymbolTable rename(@NotNull String tablePackage) {
        Intrinsics.checkNotNullParameter((Object)tablePackage, (String)"tablePackage");
        return new SymbolTableImpl(tablePackage, this.getSymbols());
    }

    @NotNull
    public final List<Symbol> getSymbolByResourceType(@NotNull ResourceType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ArrayList symbols2 = Lists.newArrayList((Iterable)this.getSymbols().row((Object)type).values());
        Intrinsics.checkNotNullExpressionValue((Object)symbols2, (String)"symbols");
        CollectionsKt.sortWith((List)symbols2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Symbol it = (Symbol)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getCanonicalName());
                it = (Symbol)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getCanonicalName())));
            }
        });
        List<Symbol> list = Collections.unmodifiableList(symbols2);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(symbols)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Symbol> getSymbolByVisibility(@NotNull ResourceVisibility visibility) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        ImmutableCollection immutableCollection = this.getSymbols().values();
        Intrinsics.checkNotNullExpressionValue((Object)immutableCollection, (String)"symbols.values()");
        Iterable $this$filter$iv = (Iterable)immutableCollection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Symbol it = (Symbol)element$iv$iv;
            boolean bl = false;
            if (!(it.getResourceVisibility() == visibility)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ArrayList symbols2 = Lists.newArrayList((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)symbols2, (String)"symbols");
        CollectionsKt.sortWith((List)symbols2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Symbol it = (Symbol)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getCanonicalName());
                it = (Symbol)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getCanonicalName())));
            }
        });
        List<Symbol> list = Collections.unmodifiableList(symbols2);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(symbols)");
        return list;
    }

    public final boolean containsSymbol(@NotNull ResourceType type, @NotNull String canonicalName) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
        boolean found = this.getSymbols().contains((Object)type, (Object)canonicalName);
        if (!found && type == ResourceType.STYLEABLE && StringsKt.contains$default((CharSequence)canonicalName, (char)'_', (boolean)false, (int)2, null)) {
            found = SymbolTable.maybeGetStyleableParentSymbolForChild$default(this, canonicalName, 0, 2, null) != null;
        }
        return found;
    }

    @Nullable
    public final Symbol.StyleableSymbol maybeGetStyleableParentSymbolForChild(@NotNull String canonicalName, int start) {
        Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
        Symbol.StyleableSymbol found = null;
        int index = StringsKt.indexOf$default((CharSequence)canonicalName, (char)'_', (int)start, (boolean)false, (int)4, null);
        if (index > -1) {
            String string = canonicalName.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String parentName = string;
            if (this.getSymbols().contains((Object)ResourceType.STYLEABLE, (Object)parentName)) {
                String it;
                boolean bl;
                boolean $i$f$any;
                Iterable $this$any$iv;
                Symbol parent;
                Object childName;
                block10: {
                    childName = null;
                    String string2 = canonicalName.substring(index + 1, canonicalName.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    childName = string2;
                    Symbol symbol = parent = (Symbol)this.getSymbols().get((Object)ResourceType.STYLEABLE, (Object)parentName);
                    Intrinsics.checkNotNull((Object)symbol);
                    $this$any$iv = (Iterable)symbol.getChildren();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)childName)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                Symbol.StyleableSymbol styleableSymbol = found = bl ? (Symbol.StyleableSymbol)parent : null;
                if (found == null && StringsKt.startsWith$default((String)childName, (String)"android_", (boolean)false, (int)2, null)) {
                    boolean bl3;
                    block11: {
                        String string3 = ((String)childName).substring("android_".length());
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                        childName = "android:" + string3;
                        $this$any$iv = (Iterable)parent.getChildren();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)it, (Object)childName)) continue;
                                bl3 = true;
                                break block11;
                            }
                            bl3 = false;
                        }
                    }
                    Symbol.StyleableSymbol styleableSymbol2 = found = bl3 ? (Symbol.StyleableSymbol)parent : null;
                }
            }
            if (found == null) {
                found = this.maybeGetStyleableParentSymbolForChild(canonicalName, index + 1);
            }
        }
        return found;
    }

    public static /* synthetic */ Symbol.StyleableSymbol maybeGetStyleableParentSymbolForChild$default(SymbolTable symbolTable, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: maybeGetStyleableParentSymbolForChild");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return symbolTable.maybeGetStyleableParentSymbolForChild(string, n);
    }

    @NotNull
    public final SymbolTable withValuesFrom(@NotNull SymbolTable mainSymbolTable) {
        Intrinsics.checkNotNullParameter((Object)mainSymbolTable, (String)"mainSymbolTable");
        return mainSymbolTable.filter(this).rename(this.getTablePackage());
    }

    @NotNull
    public final Set<ResourceType> getResourceTypes() {
        ImmutableSet immutableSet = this.getSymbols().rowKeySet();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"symbols.rowKeySet()");
        return (Set)immutableSet;
    }

    @JvmStatic
    @NotNull
    public static final SymbolTable merge(@NotNull List<? extends SymbolTable> tables) {
        return Companion.merge(tables);
    }

    @JvmStatic
    @NotNull
    public static final SymbolTable mergePartialTables(@NotNull List<? extends File> tables, @NotNull String packageName) {
        return Companion.mergePartialTables(tables, packageName);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J/\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0003H\u0016R&\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$SymbolTableImpl;", "Lcom/android/ide/common/symbols/SymbolTable;", "tablePackage", "", "symbols", "Lcom/google/common/collect/ImmutableTable;", "Lcom/android/resources/ResourceType;", "Lcom/android/ide/common/symbols/Symbol;", "(Ljava/lang/String;Lcom/google/common/collect/ImmutableTable;)V", "getSymbols", "()Lcom/google/common/collect/ImmutableTable;", "getTablePackage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "sdk-common"})
    private static final class SymbolTableImpl
    extends SymbolTable {
        @NotNull
        private final String tablePackage;
        @NotNull
        private final ImmutableTable<ResourceType, String, Symbol> symbols;

        public SymbolTableImpl(@NotNull String tablePackage, @NotNull ImmutableTable<ResourceType, String, Symbol> symbols2) {
            Intrinsics.checkNotNullParameter((Object)tablePackage, (String)"tablePackage");
            Intrinsics.checkNotNullParameter(symbols2, (String)"symbols");
            this.tablePackage = tablePackage;
            this.symbols = symbols2;
        }

        @Override
        @NotNull
        public String getTablePackage() {
            return this.tablePackage;
        }

        @Override
        @NotNull
        public ImmutableTable<ResourceType, String, Symbol> getSymbols() {
            return this.symbols;
        }

        @NotNull
        public String toString() {
            String string = this.getTablePackage();
            ImmutableCollection immutableCollection = this.getSymbols().values();
            Intrinsics.checkNotNullExpressionValue((Object)immutableCollection, (String)"symbols.values()");
            return "SymbolTable (" + string + ")\n  " + CollectionsKt.joinToString$default((Iterable)((Iterable)immutableCollection), (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final String component1() {
            return this.getTablePackage();
        }

        @NotNull
        public final ImmutableTable<ResourceType, String, Symbol> component2() {
            return this.getSymbols();
        }

        @NotNull
        public final SymbolTableImpl copy(@NotNull String tablePackage, @NotNull ImmutableTable<ResourceType, String, Symbol> symbols2) {
            Intrinsics.checkNotNullParameter((Object)tablePackage, (String)"tablePackage");
            Intrinsics.checkNotNullParameter(symbols2, (String)"symbols");
            return new SymbolTableImpl(tablePackage, symbols2);
        }

        public static /* synthetic */ SymbolTableImpl copy$default(SymbolTableImpl symbolTableImpl, String string, ImmutableTable immutableTable, int n, Object object) {
            if ((n & 1) != 0) {
                string = symbolTableImpl.getTablePackage();
            }
            if ((n & 2) != 0) {
                immutableTable = symbolTableImpl.getSymbols();
            }
            return symbolTableImpl.copy(string, immutableTable);
        }

        public int hashCode() {
            int result2 = this.getTablePackage().hashCode();
            result2 = result2 * 31 + this.getSymbols().hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SymbolTableImpl)) {
                return false;
            }
            SymbolTableImpl symbolTableImpl = (SymbolTableImpl)other;
            if (!Intrinsics.areEqual((Object)this.getTablePackage(), (Object)symbolTableImpl.getTablePackage())) {
                return false;
            }
            return Intrinsics.areEqual(this.getSymbols(), symbolTableImpl.getSymbols());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007J\u0014\u0010\u000b\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u0014\u0010\r\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u0015\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0006\u0010\u0012\u001a\u00020\u0010J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0007H\u0086\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0006J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0086\u0002J\u0006\u0010\u0018\u001a\u00020\u0014J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$Builder;", "", "()V", "symbols", "Lcom/google/common/collect/Table;", "Lcom/android/resources/ResourceType;", "", "Lcom/android/ide/common/symbols/Symbol;", "tablePackage", "add", "symbol", "addAll", "", "addAllIfNotExist", "addFromPartial", "table", "Lcom/android/ide/common/symbols/SymbolTable;", "addFromPartial$sdk_common", "build", "contains", "", "resourceType", "canonicalName", "get", "isEmpty", "remove", "sdk-common"})
    public static final class Builder {
        @NotNull
        private String tablePackage = "";
        @NotNull
        private final Table<ResourceType, String, Symbol> symbols;

        public Builder() {
            Table table = Tables.newCustomTable((Map)Maps.newEnumMap(ResourceType.class), (Supplier)symbols.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)table, (String)"newCustomTable(Maps.newE\u2026::class.java), ::HashMap)");
            this.symbols = table;
        }

        @NotNull
        public final Builder add(@NotNull Symbol symbol) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            if (this.symbols.contains((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName())) {
                throw new IllegalArgumentException("Duplicate symbol in table with resource type '" + symbol.getResourceType() + "' and symbol name '" + symbol.getCanonicalName() + "'");
            }
            this.symbols.put((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName(), (Object)symbol);
            return this;
        }

        @NotNull
        public final Builder addAll(@NotNull Collection<? extends Symbol> symbols2) {
            Intrinsics.checkNotNullParameter(symbols2, (String)"symbols");
            Iterable $this$forEach$iv = symbols2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Symbol it = (Symbol)element$iv;
                boolean bl = false;
                this.add(it);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder addAllIfNotExist(@NotNull Collection<? extends Symbol> symbols2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(symbols2, (String)"symbols");
            Iterable $this$filter$iv = symbols2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Symbol it = (Symbol)element$iv$iv;
                boolean bl = false;
                if (!(!this.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Symbol it = (Symbol)element$iv;
                boolean bl = false;
                this.add(it);
            }
            return this;
        }

        @NotNull
        public final Builder addFromPartial$sdk_common(@NotNull SymbolTable table) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            ImmutableCollection immutableCollection = table.getSymbols().values();
            Intrinsics.checkNotNullExpressionValue((Object)immutableCollection, (String)"table.symbols.values()");
            Iterable $this$forEach$iv = (Iterable)immutableCollection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Symbol existing;
                Symbol it = (Symbol)element$iv;
                boolean bl = false;
                if (!this.symbols.contains((Object)it.getResourceType(), (Object)it.getCanonicalName())) {
                    this.symbols.put((Object)it.getResourceType(), (Object)it.getCanonicalName(), (Object)it);
                    continue;
                }
                Symbol symbol = existing = (Symbol)this.symbols.get((Object)it.getResourceType(), (Object)it.getCanonicalName());
                Intrinsics.checkNotNull((Object)symbol);
                if (symbol.getResourceVisibility() != it.getResourceVisibility() && existing.getResourceVisibility() != ResourceVisibility.PRIVATE_XML_ONLY && it.getResourceVisibility() != ResourceVisibility.PRIVATE_XML_ONLY) {
                    throw new IllegalResourceVisibilityException("Symbol with resource type " + it.getResourceType() + " and name " + it.getCanonicalName() + " defined both as " + it.getResourceVisibility() + " and " + existing.getResourceVisibility() + ".");
                }
                if (it.getResourceType() == ResourceType.STYLEABLE) {
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.android.ide.common.symbols.Symbol.StyleableSymbol");
                    Symbol.StyleableSymbol cfr_ignored_0 = (Symbol.StyleableSymbol)it;
                    Symbol.StyleableSymbol cfr_ignored_1 = (Symbol.StyleableSymbol)existing;
                    ImmutableList children = ImmutableList.copyOf((Collection)CollectionsKt.sorted((Iterable)SetsKt.plus((Set)SetsKt.plus((Set)new LinkedHashSet(), (Iterable)((Iterable)it.getChildren())), (Iterable)((Iterable)((Symbol.StyleableSymbol)existing).getChildren()))));
                    ResourceVisibility visibility = ResourceVisibility.max((ResourceVisibility)it.getResourceVisibility(), (ResourceVisibility)((Symbol.StyleableSymbol)existing).getResourceVisibility());
                    this.symbols.remove((Object)((Symbol.StyleableSymbol)existing).getResourceType(), (Object)((Symbol.StyleableSymbol)existing).getCanonicalName());
                    ResourceType resourceType = it.getResourceType();
                    String string = it.getCanonicalName();
                    String string2 = it.getCanonicalName();
                    ImmutableList immutableList = ImmutableList.of();
                    Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of()");
                    Intrinsics.checkNotNullExpressionValue((Object)children, (String)"children");
                    Intrinsics.checkNotNullExpressionValue((Object)visibility, (String)"visibility");
                    this.symbols.put((Object)resourceType, (Object)string, (Object)Symbol.Companion.styleableSymbol$default(Symbol.Companion, string2, immutableList, children, visibility, null, 16, null));
                    continue;
                }
                if (it.getResourceVisibility().compareTo((Enum)existing.getResourceVisibility()) <= 0) continue;
                this.symbols.remove((Object)existing.getResourceType(), (Object)existing.getCanonicalName());
                this.symbols.put((Object)it.getResourceType(), (Object)it.getCanonicalName(), (Object)it);
            }
            return this;
        }

        @NotNull
        public final Builder tablePackage(@NotNull String tablePackage) {
            Intrinsics.checkNotNullParameter((Object)tablePackage, (String)"tablePackage");
            SymbolTableKt.access$verifyTablePackage(tablePackage);
            this.tablePackage = tablePackage;
            return this;
        }

        public final boolean contains(@NotNull Symbol symbol) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            return this.contains(symbol.getResourceType(), symbol.getCanonicalName());
        }

        public final boolean contains(@NotNull ResourceType resourceType, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            return this.symbols.contains((Object)resourceType, (Object)canonicalName);
        }

        @Nullable
        public final Symbol get(@NotNull Symbol symbol) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            return (Symbol)this.symbols.get((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName());
        }

        @Nullable
        public final Symbol remove(@NotNull ResourceType resourceType, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            return (Symbol)this.symbols.remove((Object)resourceType, (Object)canonicalName);
        }

        public final boolean isEmpty() {
            return this.symbols.isEmpty();
        }

        @NotNull
        public final SymbolTable build() {
            ImmutableTable immutableTable = ImmutableTable.copyOf(this.symbols);
            Intrinsics.checkNotNullExpressionValue((Object)immutableTable, (String)"copyOf(symbols)");
            return new SymbolTableImpl(this.tablePackage, (ImmutableTable<ResourceType, String, Symbol>)immutableTable);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u0014\u0010\u000e\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\n\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$FastBuilder;", "", "symbolInterner", "Lcom/google/common/collect/Interner;", "Lcom/android/ide/common/symbols/Symbol;", "(Lcom/google/common/collect/Interner;)V", "symbols", "Lcom/google/common/collect/ImmutableTable$Builder;", "Lcom/android/resources/ResourceType;", "", "tablePackage", "add", "", "symbol", "addAll", "", "build", "Lcom/android/ide/common/symbols/SymbolTable;", "sdk-common"})
    public static final class FastBuilder {
        @NotNull
        private final Interner<Symbol> symbolInterner;
        @NotNull
        private String tablePackage;
        @NotNull
        private final ImmutableTable.Builder<ResourceType, String, Symbol> symbols;

        public FastBuilder(@NotNull Interner<Symbol> symbolInterner) {
            Intrinsics.checkNotNullParameter(symbolInterner, (String)"symbolInterner");
            this.symbolInterner = symbolInterner;
            this.tablePackage = "";
            ImmutableTable.Builder builder = ImmutableTable.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
            this.symbols = builder;
        }

        public final void add(@NotNull Symbol symbol) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            this.symbols.put((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName(), this.symbolInterner.intern((Object)symbol));
        }

        public final void addAll(@NotNull Collection<? extends Symbol> symbols2) {
            Intrinsics.checkNotNullParameter(symbols2, (String)"symbols");
            Iterable $this$forEach$iv = symbols2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Symbol it = (Symbol)element$iv;
                boolean bl = false;
                this.add(it);
            }
        }

        public final void tablePackage(@NotNull String tablePackage) {
            Intrinsics.checkNotNullParameter((Object)tablePackage, (String)"tablePackage");
            SymbolTableKt.access$verifyTablePackage(tablePackage);
            this.tablePackage = tablePackage;
        }

        @NotNull
        public final SymbolTable build() {
            ImmutableTable immutableTable = this.symbols.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableTable, (String)"symbols.build()");
            return new SymbolTableImpl(this.tablePackage, (ImmutableTable<ResourceType, String, Symbol>)immutableTable);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0007J\u001e\u0010\t\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$Companion;", "", "()V", "builder", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "merge", "Lcom/android/ide/common/symbols/SymbolTable;", "tables", "", "mergePartialTables", "Ljava/io/File;", "packageName", "", "sdk-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SymbolTable merge(@NotNull List<? extends SymbolTable> tables) {
            Intrinsics.checkNotNullParameter(tables, (String)"tables");
            if (tables.size() == 1) {
                return (SymbolTable)CollectionsKt.first(tables);
            }
            ImmutableTable.Builder builder = ImmutableTable.builder();
            HashSet<String> present = new HashSet<String>();
            for (ResourceType resourceType : ResourceType.values()) {
                present.clear();
                for (SymbolTable symbolTable : tables) {
                    ImmutableMap tableSymbolMap = symbolTable.getSymbols().row((Object)resourceType);
                    if (tableSymbolMap == null || tableSymbolMap.isEmpty()) continue;
                    for (Symbol s : (ImmutableCollection)tableSymbolMap.values()) {
                        String canonicalName = s.getCanonicalName();
                        if (present.contains(canonicalName)) continue;
                        present.add(canonicalName);
                        builder.put((Object)resourceType, (Object)canonicalName, (Object)s);
                    }
                }
            }
            String packageName = tables.isEmpty() ? "" : tables.get(0).getTablePackage();
            ImmutableTable immutableTable = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableTable, (String)"builder.build()");
            return new SymbolTableImpl(packageName, (ImmutableTable<ResourceType, String, Symbol>)immutableTable);
        }

        @JvmStatic
        @NotNull
        public final SymbolTable mergePartialTables(@NotNull List<? extends File> tables, @NotNull String packageName) {
            Intrinsics.checkNotNullParameter(tables, (String)"tables");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            SymbolIo symbolIo = new SymbolIo();
            Builder builder = Companion.builder();
            builder.tablePackage(packageName);
            HashSet<String> visitedFiles = new HashSet<String>();
            try {
                Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)tables);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    if (StringsKt.startsWith$default((String)string, (String)"layout", (boolean)false, (int)2, null)) {
                        if (visitedFiles.contains(it.getName())) continue;
                        visitedFiles.add(it.getName());
                        SymbolTable symbolTable = symbolIo.readFromPartialRFile(it, null);
                        Intrinsics.checkNotNullExpressionValue((Object)symbolTable, (String)"symbolIo.readFromPartialRFile(it, null)");
                        builder.addFromPartial$sdk_common(symbolTable);
                        continue;
                    }
                    SymbolTable symbolTable = symbolIo.readFromPartialRFile(it, null);
                    Intrinsics.checkNotNullExpressionValue((Object)symbolTable, (String)"symbolIo.readFromPartialRFile(it, null)");
                    builder.addFromPartial$sdk_common(symbolTable);
                }
            }
            catch (Exception e) {
                throw new PartialRMergingException("An error occurred during merging of the partial R files", e);
            }
            return builder.build();
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$IllegalResourceVisibilityException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "description", "", "(Ljava/lang/String;)V", "sdk-common"})
    public static final class IllegalResourceVisibilityException
    extends Exception {
        public IllegalResourceVisibilityException(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            super(description);
        }
    }
}

