/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Locale {
    private static final String DEFAULT_LOCALE_LABEL = "Default (en-us)";
    private static final LocaleQualifier ANY_QUALIFIER = new LocaleQualifier("__");
    public static final Locale ANY = new Locale(ANY_QUALIFIER);
    @NotNull
    public final LocaleQualifier qualifier;
    public static final Comparator<Locale> LANGUAGE_NAME_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String name2;
            String language1 = locale1.qualifier.getLanguage();
            String language2 = locale2.qualifier.getLanguage();
            if (!locale1.qualifier.hasLanguage()) {
                return !locale2.qualifier.hasLanguage() ? 0 : -1;
            }
            if (locale2.qualifier.hasFakeValue()) {
                return 1;
            }
            assert (language1 != null && language2 != null);
            String name1 = LocaleManager.getLanguageName(language1);
            int compare = Locale.compareNullableStrings(name1, name2 = LocaleManager.getLanguageName(language2));
            if (compare == 0) {
                return REGION_NAME_COMPARATOR.compare(locale1, locale2);
            }
            return compare;
        }
    };
    public static final Comparator<Locale> LANGUAGE_CODE_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String language1 = locale1.qualifier.getLanguage();
            String language2 = locale2.qualifier.getLanguage();
            if (locale1.qualifier.hasFakeValue()) {
                return locale2.qualifier.hasFakeValue() ? 0 : -1;
            }
            if (locale2.qualifier.hasFakeValue()) {
                return 1;
            }
            int compare = Locale.compareNullableStrings(language1, language2);
            if (compare == 0) {
                return REGION_CODE_COMPARATOR.compare(locale1, locale2);
            }
            return compare;
        }
    };
    public static final Comparator<Locale> REGION_NAME_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String region1 = locale1.qualifier.getRegion();
            String region2 = locale2.qualifier.getRegion();
            if (region1 == null) {
                return region2 == null ? 0 : -1;
            }
            if (region2 == null) {
                return 1;
            }
            String regionName1 = LocaleManager.getRegionName(region1);
            String regionName2 = LocaleManager.getRegionName(region2);
            return Locale.compareNullableStrings(regionName1, regionName2);
        }
    };
    public static final Comparator<Locale> REGION_CODE_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String region1 = locale1.qualifier.getRegion();
            String region2 = locale2.qualifier.getRegion();
            if (region1 == null) {
                return region2 == null ? 0 : -1;
            }
            if (region2 == null) {
                return 1;
            }
            return Locale.compareNullableStrings(region1, region2);
        }
    };

    private Locale(@NotNull LocaleQualifier locale) {
        this.qualifier = locale;
    }

    @NotNull
    public static Locale create(@NotNull LocaleQualifier locale) {
        return new Locale(locale);
    }

    public static Locale create(FolderConfiguration folder) {
        LocaleQualifier locale = folder.getLocaleQualifier();
        if (locale == null) {
            return ANY;
        }
        return new Locale(locale);
    }

    @NotNull
    public static Locale create(@NotNull String localeString) {
        LocaleQualifier qualifier = LocaleQualifier.getQualifier(localeString);
        if (qualifier != null) {
            return new Locale(qualifier);
        }
        return ANY;
    }

    public boolean hasLanguage() {
        return !this.qualifier.hasFakeValue() && this.qualifier.hasLanguage();
    }

    public boolean hasRegion() {
        return this.qualifier.getRegion() != null && !"__".equals(this.qualifier.getRegion());
    }

    public String toLocaleId() {
        return this.qualifier == ANY_QUALIFIER ? "" : this.qualifier.getTag();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.qualifier.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Locale other = (Locale)obj;
        return this.qualifier.equals(other.qualifier);
    }

    public String toString() {
        return this.qualifier.getTag();
    }

    public static String getLocaleLabel(@Nullable Locale locale, boolean brief) {
        if (locale == null || !locale.hasLanguage()) {
            return DEFAULT_LOCALE_LABEL;
        }
        String languageCode = locale.qualifier.getLanguage();
        assert (languageCode != null);
        String languageName = LocaleManager.getLanguageName(languageCode);
        if (!locale.hasRegion()) {
            if (languageName != null) {
                return String.format("%1$s (%2$s)", languageName, languageCode);
            }
            return languageCode;
        }
        String regionCode = locale.qualifier.getRegion();
        assert (regionCode != null) : locale.qualifier;
        if (!brief && languageName != null) {
            String regionName = LocaleManager.getRegionName(regionCode);
            if (regionName != null) {
                return String.format("%1$s (%2$s) in %3$s (%4$s)", languageName, languageCode, regionName, regionCode);
            }
            return String.format("%1$s (%2$s) in %3$s", languageName, languageCode, regionCode);
        }
        return String.format("%1$s (%2$s / %3$s)", languageName, languageCode, regionCode);
    }

    private static int compareNullableStrings(@Nullable String s1, @Nullable String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }
}

