/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.TextFormat;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00072\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\f\u001a\u00020\nH\u0002\u001a\u0014\u0010\r\u001a\u00020\n*\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001c\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0005\u00a8\u0006\u0012"}, d2={"getErrorLines", "", "Lcom/android/tools/lint/detector/api/Incident;", "textProvider", "Lkotlin/Function1;", "Ljava/io/File;", "", "Lcom/android/tools/lint/detector/api/Location;", "getLine", "line", "", "getLineOfOffset", "offset", "getLineOffset", "getPath", "client", "Lcom/android/tools/lint/LintCliClient;", "file", "lint-cli"})
public final class ReporterKt {
    @NotNull
    public static final String getPath(@NotNull Incident $this$getPath, @NotNull LintCliClient client, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$getPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return $this$getPath.getProject() != null ? client.getDisplayPath($this$getPath.getProject(), file, client.getFlags().isFullPath()) : client.getDisplayPath(file, null, TextFormat.TEXT);
    }

    public static /* synthetic */ String getPath$default(Incident incident, LintCliClient lintCliClient, File file, int n, Object object) {
        if ((n & 2) != 0) {
            file = incident.getFile();
        }
        return ReporterKt.getPath(incident, lintCliClient, file);
    }

    @Nullable
    public static final String getErrorLines(@NotNull Incident $this$getErrorLines, @NotNull Function1<? super File, ? extends CharSequence> textProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$getErrorLines, (String)"<this>");
        Intrinsics.checkNotNullParameter(textProvider, (String)"textProvider");
        return ReporterKt.getErrorLines($this$getErrorLines.getLocation(), textProvider);
    }

    @Nullable
    public static final String getErrorLines(@NotNull Location $this$getErrorLines, @NotNull Function1<? super File, ? extends CharSequence> textProvider) {
        CharSequence source;
        Intrinsics.checkNotNullParameter((Object)$this$getErrorLines, (String)"<this>");
        Intrinsics.checkNotNullParameter(textProvider, (String)"textProvider");
        Location location = $this$getErrorLines;
        Position startPosition = location.getStart();
        if (startPosition != null && startPosition.getLine() >= 0 && (source = (CharSequence)textProvider.invoke((Object)$this$getErrorLines.getFile())) != null) {
            Position endPosition = location.getEnd();
            int line2 = startPosition.getLine();
            String errorLine = ReporterKt.getLine(source, line2);
            if (errorLine != null) {
                errorLine = StringsKt.replace$default((String)errorLine, (char)'\t', (char)' ', (boolean)false, (int)4, null);
                int column = startPosition.getColumn();
                if (column < 0) {
                    column = 0;
                    int i = 0;
                    while (i < errorLine.length() && Character.isWhitespace(errorLine.charAt(i))) {
                        ++i;
                        ++column;
                    }
                }
                StringBuilder sb = new StringBuilder(100);
                sb.append(errorLine);
                sb.append('\n');
                int n = column;
                for (int i = 0; i < n; ++i) {
                    sb.append(' ');
                }
                boolean displayCaret = true;
                if (endPosition != null) {
                    int endLine = endPosition.getLine();
                    int endColumn = endPosition.getColumn();
                    if (endLine == line2 && endColumn > column) {
                        for (int i = column; i < endColumn; ++i) {
                            sb.append('~');
                        }
                        displayCaret = false;
                    }
                }
                if (displayCaret) {
                    sb.append('^');
                }
                sb.append('\n');
                return sb.toString();
            }
        }
        return null;
    }

    private static final String getLine(CharSequence $this$getLine, int line2) {
        int index = ReporterKt.getLineOffset($this$getLine, line2);
        return index != -1 ? ReporterKt.getLineOfOffset($this$getLine, index) : (String)null;
    }

    private static final String getLineOfOffset(CharSequence $this$getLineOfOffset, int offset) {
        int end = StringsKt.indexOf$default((CharSequence)$this$getLineOfOffset, (char)'\n', (int)offset, (boolean)false, (int)4, null);
        if (end == -1) {
            end = StringsKt.indexOf$default((CharSequence)$this$getLineOfOffset, (char)'\r', (int)offset, (boolean)false, (int)4, null);
        } else if (end > 0 && $this$getLineOfOffset.charAt(end - 1) == '\r') {
            --end;
        }
        return ((Object)$this$getLineOfOffset.subSequence(offset, end != -1 ? end : $this$getLineOfOffset.length())).toString();
    }

    private static final int getLineOffset(CharSequence $this$getLineOffset, int line2) {
        int index = 0;
        for (int i = 0; i < line2; ++i) {
            if ((index = StringsKt.indexOf$default((CharSequence)$this$getLineOffset, (char)'\n', (int)index, (boolean)false, (int)4, null)) == -1) {
                return -1;
            }
            ++index;
        }
        return index;
    }
}

