/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.MultiProjectHtmlReporter;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/MultiProjectHtmlReporter;", "Lcom/android/tools/lint/Reporter;", "client", "Lcom/android/tools/lint/LintCliClient;", "dir", "Ljava/io/File;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;Lcom/android/tools/lint/LintCliFlags;)V", "write", "", "stats", "Lcom/android/tools/lint/LintStats;", "issues", "", "Lcom/android/tools/lint/detector/api/Incident;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "Companion", "ProjectEntry", "lint-cli"})
public final class MultiProjectHtmlReporter
extends Reporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File dir;
    @NotNull
    private final LintCliFlags flags;
    @NotNull
    private static final String INDEX_NAME = "index.html";

    public MultiProjectHtmlReporter(@NotNull LintCliClient client, @NotNull File dir, @NotNull LintCliFlags flags) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        super(client, new File(dir, INDEX_NAME));
        this.dir = dir;
        this.flags = flags;
    }

    @Override
    public void write(@NotNull LintStats stats, @NotNull List<Incident> issues, @NotNull IssueRegistry registry) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Map projectToIncidents = new HashMap();
        for (Incident incident : issues) {
            Object project;
            if (incident.getProject() == null) continue;
            Object v = projectToIncidents.computeIfAbsent(project, write.list.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(v, (String)"projectToIncidents.compu\u2026(project) { ArrayList() }");
            List list2 = (List)v;
            list2.add(incident);
        }
        HashSet hashSet = Sets.newHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet()");
        Set unique = hashSet;
        String string = INDEX_NAME;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        unique.add(string2);
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList()");
        List list2 = arrayList;
        for (Project project : projectToIncidents.keySet()) {
            String string3;
            List projectIssues;
            boolean deleted22;
            String lowercase;
            Object[] objectArray;
            String projectName = project.getName();
            int number = 1;
            String fileName = null;
            while (true) {
                String numberString = number > 1 ? String.valueOf(number) : "";
                objectArray = "%1$s%2$s.html";
                Object[] objectArray2 = new Object[]{projectName, numberString};
                Intrinsics.checkNotNullExpressionValue((Object)String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(format, *args)");
                objectArray = fileName;
                Locale locale2 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"US");
                Intrinsics.checkNotNullExpressionValue((Object)objectArray.toLowerCase(locale2), (String)"this as java.lang.String).toLowerCase(locale)");
                if (!unique.contains(lowercase)) break;
                ++number;
            }
            unique.add(lowercase);
            File output = new File(this.dir, fileName);
            if (output.exists() && !(deleted22 = output.delete())) {
                objectArray = new Object[]{output};
                this.client.log(null, "Could not delete old file %1$s", objectArray);
                continue;
            }
            if (!output.getParentFile().canWrite()) {
                Object[] deleted22 = new Object[]{output};
                this.client.log(null, "Cannot write output file %1$s", deleted22);
                continue;
            }
            Reporter reporter = Reporter.Companion.createHtmlReporter(this.client, output, this.flags);
            reporter.setUrlMap(this.getUrlMap());
            if ((List)projectToIncidents.get(project) == null) continue;
            int projectErrorCount = 0;
            int projectWarningCount = 0;
            for (Incident incident3 : projectIssues) {
                if (incident3.getSeverity().isError()) {
                    ++projectErrorCount;
                    continue;
                }
                if (incident3.getSeverity() != Severity.WARNING) continue;
                ++projectWarningCount;
            }
            String prefix = project.getReferenceDir().getPath();
            String path = project.getDir().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            Intrinsics.checkNotNullExpressionValue((Object)prefix, (String)"prefix");
            if (StringsKt.startsWith$default((String)path, (String)prefix, (boolean)false, (int)2, null) && path.length() > prefix.length()) {
                int i = prefix.length();
                if (path.charAt(i) == File.separatorChar) {
                    ++i;
                }
                String string4 = path.substring(i);
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string3 = projectName;
            }
            String relative = string3;
            String string5 = "Lint Report for %1$s";
            Object[] objectArray3 = new Object[]{relative};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string5, Arrays.copyOf(objectArray3, objectArray3.length)), (String)"format(format, *args)");
            reporter.title = reporter.title;
            reporter.setStripPrefix(relative);
            reporter.write(stats, projectIssues, registry);
            Intrinsics.checkNotNullExpressionValue((Object)relative, (String)"relative");
            list2.add(new ProjectEntry(fileName, projectErrorCount, projectWarningCount, relative));
        }
        CollectionsKt.sort((List)list2);
        File file = this.getOutput();
        Intrinsics.checkNotNull((Object)file);
        Reporter reporter = Reporter.Companion.createHtmlReporter(this.client, file, this.flags);
        reporter.writeProjectList(stats, list2);
        if (!(this.client.getFlags().isQuiet() || stats.getErrorCount() <= 0 && stats.getWarningCount() <= 0)) {
            File index = new File(this.dir, INDEX_NAME);
            String url = SdkUtils.fileToUrlString((File)index.getAbsoluteFile());
            String string6 = "Wrote overview index to %1$s";
            Object[] objectArray = new Object[]{url};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
            String string8 = string7;
            System.out.println((Object)string8);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/MultiProjectHtmlReporter$ProjectEntry;", "", "fileName", "", "errorCount", "", "warningCount", "path", "(Ljava/lang/String;IILjava/lang/String;)V", "getErrorCount", "()I", "getFileName", "()Ljava/lang/String;", "getPath", "getWarningCount", "compareTo", "other", "lint-cli"})
    public static final class ProjectEntry
    implements Comparable<ProjectEntry> {
        @NotNull
        private final String fileName;
        private final int errorCount;
        private final int warningCount;
        @NotNull
        private final String path;

        public ProjectEntry(@NotNull String fileName, int errorCount, int warningCount, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.fileName = fileName;
            this.errorCount = errorCount;
            this.warningCount = warningCount;
            this.path = path;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        public final int getErrorCount() {
            return this.errorCount;
        }

        public final int getWarningCount() {
            return this.warningCount;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Override
        public int compareTo(@NotNull ProjectEntry other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int delta = other.errorCount - this.errorCount;
            if (delta != 0) {
                return delta;
            }
            delta = other.warningCount - this.warningCount;
            return delta != 0 ? delta : this.path.compareTo(other.path);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/MultiProjectHtmlReporter$Companion;", "", "()V", "INDEX_NAME", "", "lint-cli"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

