/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.LintModelVariant;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000J\u0016\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019H\u0002J\u0013\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u001e\u001a\u00020\rH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0015H\u0014J\b\u0010\"\u001a\u00020\tH\u0016J\b\u0010#\u001a\u00020\tH\u0016J\u001c\u0010$\u001a\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010&\u001a\u00020\tJ\u000e\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0007J\u0016\u0010)\u001a\u00020\u00152\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+J\"\u0010-\u001a\u00020\u00152\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019J\u000e\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u00152\u0006\u00100\u001a\u000203J\u0014\u00104\u001a\u00020\u00152\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019J\u0010\u00106\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00010\rJ\"\u00107\u001a\u00020\u00152\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019J\"\u0010:\u001a\u00020\u00152\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019J\"\u0010;\u001a\u00020\u00152\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019J\b\u0010<\u001a\u00020\u0007H\u0016R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006="}, d2={"Lcom/android/tools/lint/ManualProject;", "Lcom/android/tools/lint/detector/api/Project;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "name", "", "library", "", "android", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/lang/String;ZZ)V", "resourceVisibility", "Lcom/android/ide/common/repository/ResourceVisibilityLookup;", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "getVariant", "()Lcom/android/tools/lint/model/LintModelVariant;", "setVariant", "(Lcom/android/tools/lint/model/LintModelVariant;)V", "addDirectDependency", "", "project", "addFilteredFiles", "sources", "", "equals", "other", "", "getBuildVariant", "getResourceVisibility", "hashCode", "", "initialize", "isAndroidProject", "isGradleProject", "setClasspath", "allClasses", "useForAnalysis", "setCompileSdkVersion", "buildApi", "setDesugaring", "desugaring", "", "Lcom/android/tools/lint/detector/api/Desugaring;", "setGeneratedSources", "sourceRoots", "setJavaLanguageLevel", "level", "Lcom/intellij/pom/java/LanguageLevel;", "setKotlinLanguageLevel", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "setManifests", "manifests", "setResourceVisibility", "setResources", "resourceRoots", "resources", "setSources", "setTestSources", "toString", "lint-cli"})
final class ManualProject
extends Project {
    private boolean android;
    @Nullable
    private LintModelVariant variant;
    @Nullable
    private ResourceVisibilityLookup resourceVisibility;

    public ManualProject(@NotNull LintClient client, @NotNull File dir, @NotNull String name, boolean library, boolean android) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(client, dir, dir);
        this.android = android;
        this.setName(name);
        this.directLibraries = new ArrayList();
        this.library = library;
        this.buildSdk = 33;
        this.mergeManifests = true;
    }

    @Nullable
    public final LintModelVariant getVariant() {
        return this.variant;
    }

    public final void setVariant(@Nullable LintModelVariant lintModelVariant) {
        this.variant = lintModelVariant;
    }

    protected void initialize() {
    }

    public final void addDirectDependency(@NotNull ManualProject project) {
        Intrinsics.checkNotNullParameter((Object)((Object)project), (String)"project");
        this.directLibraries.add(project);
    }

    public boolean isAndroidProject() {
        return this.android;
    }

    public boolean isGradleProject() {
        return false;
    }

    @NotNull
    public String toString() {
        return "Project [name=" + this.name + "]";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), other.getClass())) {
            return false;
        }
        Project project = (Project)other;
        return Intrinsics.areEqual((Object)this.name, (Object)project.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public final void setJavaLanguageLevel(@NotNull LanguageLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.javaLanguageLevel = level;
    }

    public final void setKotlinLanguageLevel(@NotNull LanguageVersionSettings level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.kotlinLanguageLevel = level;
    }

    public final void setManifests(@NotNull List<? extends File> manifests) {
        Intrinsics.checkNotNullParameter(manifests, (String)"manifests");
        this.manifestFiles = manifests;
        this.addFilteredFiles(manifests);
    }

    public final void setResources(@NotNull List<? extends File> resourceRoots, @NotNull List<? extends File> resources) {
        Intrinsics.checkNotNullParameter(resourceRoots, (String)"resourceRoots");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        this.resourceFolders = resourceRoots;
        this.addFilteredFiles(resources);
    }

    public final void setSources(@NotNull List<? extends File> sourceRoots, @NotNull List<? extends File> sources) {
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        this.javaSourceFolders = sourceRoots;
        this.addFilteredFiles(sources);
    }

    public final void setTestSources(@NotNull List<? extends File> sourceRoots, @NotNull List<? extends File> sources) {
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        this.testSourceFolders = sourceRoots;
        this.addFilteredFiles(sources);
    }

    public final void setGeneratedSources(@NotNull List<? extends File> sourceRoots, @NotNull List<? extends File> sources) {
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        this.generatedSourceFolders = sourceRoots;
        this.addFilteredFiles(sources);
    }

    private final void addFilteredFiles(List<? extends File> sources) {
        if (!sources.isEmpty()) {
            if (this.files == null) {
                this.files = new ArrayList();
            }
            this.files.addAll((Collection)sources);
        }
    }

    public final void setClasspath(@NotNull List<? extends File> allClasses, boolean useForAnalysis) {
        Intrinsics.checkNotNullParameter(allClasses, (String)"allClasses");
        if (useForAnalysis) {
            this.javaClassFolders = allClasses;
        } else {
            this.javaLibraries = allClasses;
        }
    }

    public final void setCompileSdkVersion(@NotNull String buildApi) {
        Intrinsics.checkNotNullParameter((Object)buildApi, (String)"buildApi");
        if (!(((CharSequence)buildApi).length() == 0)) {
            this.buildTargetHash = Character.isDigit(buildApi.charAt(0)) ? "android-" + buildApi : buildApi;
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)buildApi);
            if (version != null) {
                this.buildSdk = version.getFeatureLevel();
            } else {
                Object[] objectArray = new Object[]{buildApi};
                this.client.log(Severity.WARNING, null, "Unexpected build target format: %1$s", objectArray);
            }
        }
    }

    public final void setDesugaring(@Nullable Set<? extends Desugaring> desugaring) {
        this.desugaring = desugaring;
    }

    public final void setResourceVisibility(@Nullable ResourceVisibilityLookup resourceVisibility) {
        this.resourceVisibility = resourceVisibility;
    }

    @NotNull
    public ResourceVisibilityLookup getResourceVisibility() {
        ResourceVisibilityLookup resourceVisibilityLookup = this.resourceVisibility;
        if (resourceVisibilityLookup == null) {
            ResourceVisibilityLookup resourceVisibilityLookup2 = super.getResourceVisibility();
            resourceVisibilityLookup = resourceVisibilityLookup2;
            Intrinsics.checkNotNullExpressionValue((Object)resourceVisibilityLookup2, (String)"super.getResourceVisibility()");
        }
        return resourceVisibilityLookup;
    }

    @Nullable
    public LintModelVariant getBuildVariant() {
        return this.variant;
    }
}

