/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.resources.ResourceFolderType;
import com.android.support.AndroidxNameUtils;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintIssueDocGenerator;
import com.android.tools.lint.Main;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.UastEnvironment;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.CompositeIssueRegistry;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.CodeSource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 \u0085\u00012\u00020\u0001:\f\u0085\u0001\u0086\u0001\u0087\u0001\u0088\u0001\u0089\u0001\u008a\u0001B\u0097\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u000f\u0012\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u000f\u0012\u0006\u0010\u0011\u001a\u00020\n\u0012\u0006\u0010\u0012\u001a\u00020\n\u0012\u0006\u0010\u0013\u001a\u00020\n\u0012\u0006\u0010\u0014\u001a\u00020\n\u0012\u0006\u0010\u0015\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001d0\u000fH\u0002J\u0010\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0018H\u0002J\b\u0010&\u001a\u00020'H\u0002J6\u0010(\u001a \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0+0)0)2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\bH\u0002J\u0018\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u0018H\u0002J\u0010\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\bH\u0002J\b\u00101\u001a\u00020\u001aH\u0002J\u001c\u00102\u001a\u00020'2\n\u00103\u001a\u000604j\u0002`52\u0006\u0010%\u001a\u00020\u0018H\u0002J\b\u00106\u001a\u00020'H\u0002J\u0010\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bH\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\b2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u00020\u0003H\u0002J:\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010=\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00182\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\nH\u0002J`\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010=\u001a\u00020\u00032\u0006\u0010B\u001a\u00020C2$\u0010F\u001a \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0+0)0)2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010@\u001a\u00020A2\u0006\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\nH\u0002J2\u0010G\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020A2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010H\u001a\u00020\u001d2\u0006\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\nH\u0002J\u0082\u0001\u0010I\u001a\u00020'2\u000e\u0010J\u001a\n\u0012\u0006\b\u0001\u0012\u00020L0K2\u0006\u0010M\u001a\u00020\b2$\u0010\u000e\u001a \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u000f0\u000f2:\u0010N\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u0003\u00a2\u0006\f\bP\u0012\b\bQ\u0012\u0004\b\b(=\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\bP\u0012\b\bQ\u0012\u0004\b\b(R\u0012\u0004\u0012\u00020'0OH\u0002JP\u0010S\u001aJ\u0012\"\u0012 \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u000f0\u000f\u0012\"\u0012 \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u000f0\u000f0TH\u0002J'\u0010S\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0T0U2\u0006\u0010%\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010VJ\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010W\u001a\u00020\u0003H\u0002J@\u0010S\u001a \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u000f0\u000f2\u0018\u0010X\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u000fH\u0002J\u0006\u0010Y\u001a\u00020'J>\u0010Z\u001a*\u0012\u0004\u0012\u00020\\\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180+0[j\u0014\u0012\u0004\u0012\u00020\\\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180+`]2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007H\u0002J$\u0010^\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020L0K\u0012\u0004\u0012\u00020\b0T2\u0006\u0010%\u001a\u00020\u0018H\u0002J\u0012\u0010_\u001a\u00020\b2\b\u0010`\u001a\u0004\u0018\u00010\bH\u0002J\u0014\u0010a\u001a\u0004\u0018\u00010C2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J>\u0010d\u001a*\u0012\u0004\u0012\u00020e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180+0[j\u0014\u0012\u0004\u0012\u00020e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180+`]2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007H\u0002J>\u0010f\u001a*\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180+0[j\u0014\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180+`]2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007H\u0002J\u0010\u0010g\u001a\u00020'2\u0006\u0010H\u001a\u00020\u001dH\u0002J`\u0010h\u001a\u00020'2\u0006\u0010H\u001a\u00020\u001d2N\u0010i\u001aJ\u0012\"\u0012 \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u000f0\u000f\u0012\"\u0012 \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u000f0\u000f0TH\u0002J\u0010\u0010j\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0018H\u0002J\u0010\u0010k\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0018H\u0002J\u0010\u0010k\u001a\u00020\n2\u0006\u0010l\u001a\u00020\bH\u0002J\u0010\u0010m\u001a\u00020\b2\u0006\u0010n\u001a\u00020\bH\u0002J(\u0010o\u001a\u00020'2\n\u00103\u001a\u000604j\u0002`52\b\b\u0002\u0010p\u001a\u00020\b2\b\b\u0002\u0010q\u001a\u00020\nH\u0002J\u0010\u0010r\u001a\u00020'2\u0006\u0010l\u001a\u00020\bH\u0002J,\u0010s\u001a\u00020'2\n\u00103\u001a\u000604j\u0002`52\u0006\u0010H\u001a\u00020\u001d2\u0006\u0010t\u001a\u00020?2\u0006\u0010%\u001a\u00020\u0018H\u0002J\u0010\u0010u\u001a\u00020'2\u0006\u0010v\u001a\u00020wH\u0002J$\u0010x\u001a\u00020'2\n\u00103\u001a\u000604j\u0002`52\u0006\u0010t\u001a\u00020?2\u0006\u0010%\u001a\u00020\u0018H\u0002J\u0010\u0010y\u001a\u00020'2\u0006\u0010%\u001a\u00020\u0018H\u0002J*\u0010z\u001a\u00020'2\n\u00103\u001a\u000604j\u0002`52\u0006\u0010%\u001a\u00020\u00182\f\u0010{\u001a\b\u0012\u0004\u0012\u00020|0\u0007H\u0002J\b\u0010}\u001a\u00020'H\u0002J$\u0010~\u001a\u00020'2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010t\u001a\u00020?2\n\u00103\u001a\u000604j\u0002`5H\u0002JS\u0010\u007f\u001a\u00020'2\n\u00103\u001a\u000604j\u0002`52/\u0010\u0080\u0001\u001a*\u0012\u0004\u0012\u00020\\\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180+0[j\u0014\u0012\u0004\u0012\u00020\\\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180+`]2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007H\u0002J\t\u0010\u0081\u0001\u001a\u00020'H\u0002J/\u0010\u0082\u0001\u001a\u00020'2\n\u00103\u001a\u000604j\u0002`52\u0006\u0010%\u001a\u00020\u00182\u0006\u0010l\u001a\u00020\b2\b\u0010t\u001a\u0004\u0018\u00010?H\u0002J\u001d\u0010\u0083\u0001\u001a\u000604j\u0002`5*\u000604j\u0002`52\u0006\u00108\u001a\u00020\bH\u0002J\u0011\u0010\u0084\u0001\u001a\u00020\n*\u0006\u0012\u0002\b\u00030KH\u0002R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00180\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001d0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008b\u0001"}, d2={"Lcom/android/tools/lint/LintIssueDocGenerator;", "", "output", "Ljava/io/File;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "onlyIssues", "", "", "singleDoc", "", "format", "Lcom/android/tools/lint/LintIssueDocGenerator$DocFormat;", "includeStats", "sourcePath", "", "testPath", "includeIndices", "includeSuppressInfo", "includeExamples", "includeSourceLinks", "includeSeverityColor", "(Ljava/io/File;Lcom/android/tools/lint/client/api/IssueRegistry;Ljava/util/List;ZLcom/android/tools/lint/LintIssueDocGenerator$DocFormat;ZLjava/util/Map;Ljava/util/Map;ZZZZZ)V", "aliases", "Lcom/android/tools/lint/detector/api/Issue;", "environment", "Lcom/android/tools/lint/UastEnvironment;", "gt", "issueMap", "Lcom/android/tools/lint/LintIssueDocGenerator$IssueData;", "issues", "knownIds", "", "lt", "singleIssueDetectors", "analyzeSource", "canAnalyzeInEditor", "issue", "checkIssueFilter", "", "computeResultMap", "", "", "", "expected", "containsSuppress", "source", "convertToAndroidX", "original", "createUastEnvironment", "describeIssue", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "disposeUastEnvironment", "escapeXml", "s", "evaluateString", "element", "Lorg/jetbrains/uast/UElement;", "findCopyrightYear", "file", "findExample", "Lcom/android/tools/lint/LintIssueDocGenerator$Example;", "method", "Lorg/jetbrains/uast/UMethod;", "node", "Lorg/jetbrains/uast/UCallExpression;", "inferred", "suppress", "outputMap", "findExampleInMethod", "issueData", "findSource", "detectorClass", "Ljava/lang/Class;", "Lcom/android/tools/lint/detector/api/Detector;", "detectorName", "store", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "url", "findSourceFiles", "Lkotlin/Pair;", "", "(Lcom/android/tools/lint/detector/api/Issue;)[Lkotlin/Pair;", "root", "prefixMap", "generate", "getCategories", "Ljava/util/HashMap;", "Lcom/android/tools/lint/detector/api/Category;", "Lkotlin/collections/HashMap;", "getDetectorRelativePath", "getLanguage", "path", "getTestFileDeclaration", "argument", "Lorg/jetbrains/uast/UExpression;", "getVendors", "Lcom/android/tools/lint/client/api/Vendor;", "getYears", "initializeExamples", "initializeSources", "sources", "singleIssueDetector", "skipIssue", "id", "wrap", "text", "writeCodeLine", "language", "lineNumbers", "writeDeletedIssuePage", "writeExample", "example", "writeIndexPage", "type", "Lcom/android/tools/lint/LintIssueDocGenerator$IndexType;", "writeInferredExampleMessage", "writeIssuePage", "writeOptions", "options", "Lcom/android/tools/lint/detector/api/Option;", "writeSinglePage", "writeSourceFiles", "writeStats", "categories", "writeStatsPage", "writeSuppressInfo", "appendXml", "isKotlinClass", "Companion", "DocFormat", "Example", "ExampleFile", "IndexType", "IssueData", "lint-cli"})
public final class LintIssueDocGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File output;
    @NotNull
    private final IssueRegistry registry;
    @NotNull
    private final List<String> onlyIssues;
    private final boolean singleDoc;
    @NotNull
    private final DocFormat format;
    private final boolean includeStats;
    @NotNull
    private final Map<String, List<File>> sourcePath;
    @NotNull
    private final Map<String, List<File>> testPath;
    private boolean includeIndices;
    private boolean includeSuppressInfo;
    private boolean includeExamples;
    private boolean includeSourceLinks;
    private boolean includeSeverityColor;
    @NotNull
    private final Map<String, Issue> aliases;
    @NotNull
    private final Set<Issue> singleIssueDetectors;
    @NotNull
    private final Set<String> knownIds;
    @NotNull
    private final List<Issue> issues;
    @NotNull
    private UastEnvironment environment;
    @NotNull
    private final Map<String, IssueData> issueMap;
    @NotNull
    private final String lt;
    @NotNull
    private final String gt;
    @NotNull
    private static final Pattern MESSAGE_PATTERN;
    @NotNull
    private static final Pattern LOCATION_PATTERN;
    private static final Pattern YEAR_PATTERN;
    private static final Pattern ANDROID_SUPPORT_SYMBOL_PATTERN;
    @NotNull
    private static final String AOSP_CS = "https://cs.android.com/android-studio/platform/tools/base/+/mirror-goog-studio-main";
    private static final Pattern PACKAGE_PATTERN;
    private static final Pattern CLASS_PATTERN;
    private static final Pattern NUMBER_PATTERN;
    @NotNull
    private static final String ARG_HELP = "--help";
    @NotNull
    private static final String ARG_SINGLE_DOC = "--single-doc";
    @NotNull
    private static final String ARG_MD = "--md";
    @NotNull
    private static final String ARG_LINT_JARS = "--lint-jars";
    @NotNull
    private static final String ARG_ISSUES = "--issues";
    @NotNull
    private static final String ARG_SOURCE_URL = "--source-url";
    @NotNull
    private static final String ARG_TEST_SOURCE_URL = "--test-url";
    @NotNull
    private static final String ARG_INCLUDE_STATS = "--include-stats";
    @NotNull
    private static final String ARG_NO_SUPPRESS_INFO = "--no-suppress-info";
    @NotNull
    private static final String ARG_NO_EXAMPLES = "--no-examples";
    @NotNull
    private static final String ARG_NO_SOURCE_LINKS = "--no-links";
    @NotNull
    private static final String ARG_INCLUDE_BUILTINS = "--builtins";
    @NotNull
    private static final String ARG_NO_SEVERITY = "--no-severity";
    @NotNull
    private static final String ARG_NO_INDEX = "--no-index";
    @NotNull
    private static final String ARG_OUTPUT = "--output";

    /*
     * WARNING - void declaration
     */
    public LintIssueDocGenerator(@NotNull File output, @NotNull IssueRegistry registry, @NotNull List<String> onlyIssues, boolean singleDoc, @NotNull DocFormat format, boolean includeStats, @NotNull Map<String, ? extends List<? extends File>> sourcePath, @NotNull Map<String, ? extends List<? extends File>> testPath, boolean includeIndices, boolean includeSuppressInfo, boolean includeExamples, boolean includeSourceLinks, boolean includeSeverityColor) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Issue it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Class clz;
        Object element$iv2;
        Object issue2;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter(onlyIssues, (String)"onlyIssues");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter(sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter(testPath, (String)"testPath");
        this.output = output;
        this.registry = registry;
        this.onlyIssues = onlyIssues;
        this.singleDoc = singleDoc;
        this.format = format;
        this.includeStats = includeStats;
        this.sourcePath = sourcePath;
        this.testPath = testPath;
        this.includeIndices = includeIndices;
        this.includeSuppressInfo = includeSuppressInfo;
        this.includeExamples = includeExamples;
        this.includeSourceLinks = includeSourceLinks;
        this.includeSeverityColor = includeSeverityColor;
        Map aliases = new LinkedHashMap();
        for (Object issue2 : this.registry.getIssues()) {
            List list2 = issue2.getAliases();
            if (list2 == null) continue;
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                String it2 = (String)element$iv2;
                boolean bl = false;
                aliases.put(it2, issue2);
            }
        }
        this.aliases = aliases;
        Object all = new LinkedHashMap();
        Set singleIssueDetectors = new LinkedHashSet();
        for (Issue issue3 : this.registry.getIssues()) {
            clz = issue3.getImplementation().getDetectorClass();
            Map $i$f$forEach = all;
            Intrinsics.checkNotNullExpressionValue((Object)clz, (String)"clz");
            Class clazz = clz;
            Integer n = (Integer)all.get(clz);
            element$iv2 = (n != null ? n : 0) + 1;
            $i$f$forEach.put(clazz, element$iv2);
        }
        for (Issue issue3 : this.registry.getIssues()) {
            clz = issue3.getImplementation().getDetectorClass();
            Integer n = (Integer)all.get(clz);
            int count = n != null ? n : 0;
            if (count != 1) continue;
            singleIssueDetectors.add(issue3);
        }
        this.singleIssueDetectors = singleIssueDetectors;
        all = this.registry.getIssues();
        LintIssueDocGenerator lintIssueDocGenerator = this;
        boolean $i$f$map = false;
        issue2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            element$iv2 = (Issue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        lintIssueDocGenerator.knownIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = this.registry.getIssues();
        lintIssueDocGenerator = this;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Issue)element$iv$iv;
            boolean bl = false;
            if (!(!this.skipIssue(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        lintIssueDocGenerator.issues = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        this.environment = this.createUastEnvironment();
        this.issueMap = this.analyzeSource();
        this.lt = this.format == DocFormat.MARKDEEP ? "&lt;" : "<";
        this.gt = this.format == DocFormat.MARKDEEP ? "&gt;" : ">";
    }

    public final void generate() {
        this.checkIssueFilter();
        if (this.singleDoc) {
            this.writeSinglePage();
        } else {
            boolean bl;
            Object it;
            Iterable $this$filter$iv = this.issues;
            int $i$f$filter = 0;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : iterable) {
                it = (Issue)element$iv$iv;
                bl = false;
                if (!(!this.skipIssue((Issue)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Issue issue : (List)destination$iv$iv) {
                this.writeIssuePage(issue);
            }
            if (this.includeIndices) {
                for (IndexType indexType : IndexType.values()) {
                    this.writeIndexPage(indexType);
                }
            }
            if (this.includeStats) {
                this.writeStatsPage();
            }
            $this$filter$iv = this.registry.getDeletedIssues();
            $i$f$filter = 0;
            Iterable iterable2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : iterable2) {
                it = (String)element$iv$iv;
                bl = false;
                if (!(!this.skipIssue((String)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (String id : (List)destination$iv$iv) {
                this.writeDeletedIssuePage(id);
            }
        }
        this.disposeUastEnvironment();
    }

    private final void checkIssueFilter() {
        for (String id : this.onlyIssues) {
            if (this.knownIds.contains(id)) continue;
            System.out.println((Object)("Warning: The issue registry does not contain an issue with the id `" + id + "`"));
        }
    }

    private final boolean skipIssue(Issue issue) {
        return this.skipIssue(issue.getId());
    }

    private final boolean skipIssue(String id) {
        return !((Collection)this.onlyIssues).isEmpty() && !this.onlyIssues.contains(id);
    }

    private final void writeSinglePage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.format.getHeader());
        sb.append("# Lint Issues\n");
        if (this.registry instanceof BuiltinIssueRegistry) {
            sb.append("This document lists the built-in issues for Lint. Note that lint also reads additional\n");
            sb.append("checks directly bundled with libraries, so this is a subset of the checks lint will\n");
            sb.append("perform.\n");
        }
        HashMap<Category, List<Issue>> categories2 = this.getCategories(this.issues);
        if (this.includeStats) {
            this.writeStats(sb, categories2, this.issues);
        }
        Set<Category> set = categories2.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"categories.keys");
        for (Category category : CollectionsKt.sorted((Iterable)set)) {
            sb.append("\n## " + category.getFullName() + "\n\n");
            List list2 = categories2.get(category);
            if (list2 == null || (list2 = CollectionsKt.sorted((Iterable)list2)) == null) continue;
            List categoryIssues = list2;
            for (Issue issue : categoryIssues) {
                this.describeIssue(sb, issue);
            }
        }
        sb.append(this.format.getFooter());
        FilesKt.writeText$default((File)this.output, (String)((Object)StringsKt.trim((CharSequence)sb)).toString(), null, (int)2, null);
    }

    private final HashMap<Category, List<Issue>> getCategories(List<Issue> issues) {
        HashMap<Category, List<Issue>> categories2 = new HashMap<Category, List<Issue>>();
        for (Issue issue : issues) {
            Category category = issue.getCategory();
            List list2 = categories2.get(category);
            if (list2 == null) {
                ArrayList arrayList;
                ArrayList it = arrayList = new ArrayList();
                boolean bl = false;
                ((Map)categories2).put(category, it);
                list2 = arrayList;
            }
            List list3 = list2;
            list3.add((Issue)issue);
        }
        return categories2;
    }

    private final HashMap<Vendor, List<Issue>> getVendors(List<Issue> issues) {
        Vendor unknown = new Vendor("Unknown Vendor", null, null, null, 14, null);
        HashMap<Vendor, List<Issue>> vendors = new HashMap<Vendor, List<Issue>>();
        for (Issue issue : issues) {
            Vendor vendor;
            List list2;
            Object object = issue.getVendor();
            if (object == null) {
                IssueRegistry issueRegistry = issue.getRegistry();
                object = issueRegistry != null ? issueRegistry.getVendor() : null;
                if (object == null) {
                    object = unknown;
                }
            }
            if ((list2 = vendors.get(vendor = object)) == null) {
                ArrayList arrayList;
                ArrayList it = arrayList = new ArrayList();
                boolean bl = false;
                ((Map)vendors).put(vendor, it);
                list2 = arrayList;
            }
            List list3 = list2;
            list3.add((Issue)issue);
        }
        return vendors;
    }

    private final HashMap<Integer, List<Issue>> getYears(List<Issue> issues) {
        HashMap<Integer, List<Issue>> years = new HashMap<Integer, List<Issue>>();
        for (Issue issue : issues) {
            IssueData issueData = this.issueMap.get(issue.getId());
            int year = issueData != null ? issueData.getCopyrightYear() : -1;
            List list2 = years.get(year);
            if (list2 == null) {
                ArrayList arrayList;
                ArrayList it = arrayList = new ArrayList();
                boolean bl = false;
                Integer n = year;
                ((Map)years).put(n, it);
                list2 = arrayList;
            }
            List list3 = list2;
            list3.add((Issue)issue);
        }
        return years;
    }

    private final void writeStats(StringBuilder sb, HashMap<Category, List<Issue>> categories2, List<Issue> issues) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Issue it;
        int count$iv;
        int n7;
        Iterable $this$count$iv;
        sb.append("\n## Vital Stats\n");
        sb.append("Current As Of\n:   " + DateTimeFormatter.ofPattern("yyyy-MM-dd").format(LocalDateTime.now()) + "\n");
        sb.append("Category Count\n:   " + categories2.keySet().size() + "\n");
        sb.append("Issue Count\n:   " + issues.size() + "\n");
        Iterable iterable = issues;
        StringBuilder stringBuilder = sb;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n7 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Issue)element$iv;
                boolean bl = false;
                if (!(it.getDefaultSeverity() == Severity.INFORMATIONAL) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n7 = count$iv;
        }
        int n8 = n7;
        stringBuilder.append("Informational\n:   " + n8 + "\n");
        $this$count$iv = issues;
        stringBuilder = sb;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n6 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Issue)element$iv;
                boolean bl = false;
                if (!(it.getDefaultSeverity() == Severity.WARNING) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n6 = count$iv;
        }
        n8 = n6;
        stringBuilder.append("Warnings\n:   " + n8 + "\n");
        $this$count$iv = issues;
        stringBuilder = sb;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n5 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Issue)element$iv;
                boolean bl = false;
                if (!(it.getDefaultSeverity() == Severity.ERROR) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n5 = count$iv;
        }
        n8 = n5;
        stringBuilder.append("Errors\n:   " + n8 + "\n");
        $this$count$iv = issues;
        stringBuilder = sb;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n4 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Issue)element$iv;
                boolean bl = false;
                if (!(it.getDefaultSeverity() == Severity.FATAL) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n4 = count$iv;
        }
        n8 = n4;
        stringBuilder.append("Fatal\n:   " + n8 + "\n");
        $this$count$iv = issues;
        stringBuilder = sb;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n3 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Issue)element$iv;
                boolean bl = false;
                if (!(!it.isEnabledByDefault()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n3 = count$iv;
        }
        n8 = n3;
        stringBuilder.append("Disabled By Default\n:   " + n8 + "\n");
        $this$count$iv = issues;
        stringBuilder = sb;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Issue)element$iv;
                boolean bl = false;
                if (!it.isAndroidSpecific() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        n8 = n2;
        stringBuilder.append("Android Specific\n:   " + n8 + "\n");
        $this$count$iv = issues;
        stringBuilder = sb;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Issue)element$iv;
                boolean bl = false;
                if (!(!it.isAndroidSpecific()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        n8 = n;
        stringBuilder.append("General\n:   " + n8 + "\n");
    }

    private final String wrap(String text) {
        int lineWidth = 72;
        String[] stringArray = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        StringBuilder sb = new StringBuilder();
        boolean inPreformat = false;
        String prev = "";
        for (String line2 : lines) {
            if (StringsKt.startsWith$default((String)line2, (String)"```", (boolean)false, (int)2, null)) {
                inPreformat = !inPreformat;
                sb.append(line2).append('\n');
            } else if (inPreformat) {
                sb.append(line2).append('\n');
            } else if (StringsKt.isBlank((CharSequence)line2)) {
                sb.append('\n');
            } else if (line2.length() < lineWidth) {
                sb.append(line2).append('\n');
            } else if (LintIssueDocGenerator.Companion.isListItem(line2)) {
                if (this.format == DocFormat.MARKDEEP && !StringsKt.isBlank((CharSequence)prev) && !LintIssueDocGenerator.Companion.isListItem(prev)) {
                    sb.append('\n');
                }
                String hangingIndent = "  ";
                int nextLineWidth = lineWidth - hangingIndent.length();
                sb.append(SdkUtils.wrap((String)line2, (int)lineWidth, (int)nextLineWidth, (String)hangingIndent, (boolean)false));
            } else {
                sb.append(SdkUtils.wrap((String)line2, (int)lineWidth, (int)lineWidth, (String)"", (boolean)false));
            }
            prev = line2;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final void writeIssuePage(Issue issue) {
        boolean bl;
        boolean bl2 = bl = !this.singleDoc;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        File file = new File(this.output, this.format.getFileName(issue));
        StringBuilder sb = new StringBuilder(1000);
        sb.append(this.format.getHeader());
        this.describeIssue(sb, issue);
        sb.append("\n");
        sb.append(this.format.getFooter());
        FilesKt.writeText$default((File)file, (String)((Object)StringsKt.trim((CharSequence)sb)).toString(), null, (int)2, null);
    }

    private final void writeDeletedIssuePage(String id) {
        boolean bl;
        boolean bl2 = bl = !this.singleDoc;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        File file = new File(this.output, this.format.getFileName(id));
        StringBuilder sb = new StringBuilder(1000);
        sb.append(this.format.getHeader());
        if (this.format == DocFormat.MARKDEEP) {
            sb.append("(#)");
        } else {
            sb.append("#");
        }
        sb.append(" " + id + "\n\n");
        Issue now = this.aliases.get(id);
        if (now != null) {
            sb.append(this.wrap("This issue id is an alias for [" + now.getId() + "](" + now.getId() + this.format.getExtension() + ")."));
        } else {
            sb.append(this.wrap("The issue for this id has been deleted or marked obsolete and can now be ignored."));
        }
        Vendor vendor = this.registry.getVendor();
        if (vendor != null) {
            String it;
            Vendor vendor2 = vendor;
            boolean bl3 = false;
            String string = vendor2.getVendorName();
            if (string != null) {
                it = string;
                boolean bl4 = false;
                String cfr_ignored_0 = "Vendor: " + it + "\n";
            }
            String string2 = vendor2.getIdentifier();
            if (string2 != null) {
                it = string2;
                boolean bl5 = false;
                String cfr_ignored_1 = "Identifier: " + it + "\n";
            }
            String string3 = vendor2.getContact();
            if (string3 != null) {
                it = string3;
                boolean bl6 = false;
                String cfr_ignored_2 = "Contact: " + it + "\n";
            }
            String string4 = vendor2.getFeedbackUrl();
            if (string4 != null) {
                it = string4;
                boolean bl7 = false;
                String cfr_ignored_3 = "Feedback: " + it + "\n";
            }
        }
        sb.append("\n(Additional metadata not available.)\n");
        sb.append(this.format.getFooter());
        FilesKt.writeText$default((File)file, (String)((Object)StringsKt.trim((CharSequence)sb)).toString(), null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeIndexPage(IndexType type) {
        void $this$filterTo$iv$iv;
        Object $this$sortedBy$iv;
        String it;
        Collection destination$iv$iv;
        boolean $i$f$sortedBy;
        String id;
        Iterator categories2;
        StringBuilder sb = new StringBuilder();
        sb.append(this.format.getHeader());
        if (this.format == DocFormat.MARKDEEP) {
            sb.append("(#) ");
        } else {
            sb.append("# ");
        }
        sb.append("Lint Issue Index\n\n");
        sb.append("Order: ");
        String bullet = "* ";
        for (IndexType t : IndexType.values()) {
            if (t != type) {
                sb.append("[" + t.getLabel() + "]");
                sb.append("(" + t.getFilename() + this.format.getExtension() + ")");
            } else {
                sb.append(t.getLabel());
            }
            sb.append(" | ");
        }
        sb.setLength(sb.length() - 3);
        sb.append("\n");
        if (type == IndexType.CATEGORY) {
            categories2 = this.getCategories(this.issues);
            Set<Category> set = ((HashMap)((Object)categories2)).keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"categories.keys");
            for (Category category : CollectionsKt.sorted((Iterable)set)) {
                List list2 = (List)((HashMap)((Object)categories2)).get(category);
                if (list2 == null || (list2 = CollectionsKt.sorted((Iterable)list2)) == null) continue;
                List categoryIssues = list2;
                sb.append("\n" + bullet + StringsKt.replace$default((String)category.getFullName(), (String)":", (String)": ", (boolean)false, (int)4, null) + " (" + categoryIssues.size() + ")\n\n");
                for (Issue issue : categoryIssues) {
                    id = issue.getId();
                    String summary = issue.getBriefDescription(TextFormat.RAW);
                    sb.append("  - [" + id + ": " + summary + "](" + id + this.format.getExtension() + ")\n");
                }
            }
        } else if (type == IndexType.ALPHABETICAL) {
            sb.append("\n");
            Iterable $this$sortedBy$iv2 = this.issues;
            $i$f$sortedBy = false;
            for (Issue issue : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Issue it = (Issue)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getId());
                    it = (Issue)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
                }
            })) {
                String id2 = issue.getId();
                String summary = issue.getBriefDescription(TextFormat.RAW);
                sb.append("  - [" + id2 + ": " + summary + "](" + id2 + this.format.getExtension() + ")\n");
            }
        } else if (type == IndexType.SEVERITY) {
            Iterator $this$sortedBy$iv3;
            void $this$filterTo$iv$iv2;
            Object severity;
            sb.append("\n");
            categories2 = ArraysKt.reversed((Object[])Severity.values());
            int id2 = categories2.size();
            for (int issue = 0; issue < id2; ++issue) {
                void $this$filterTo$iv$iv3;
                severity = (Severity)categories2.get(issue);
                Iterable $this$filter$iv = this.issues;
                boolean $i$f$filter = false;
                Iterable summary = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    Issue it2 = (Issue)element$iv$iv;
                    boolean bl = false;
                    if (!(it2.getDefaultSeverity() == severity)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List applicable = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
                if (!(!((Collection)applicable).isEmpty())) continue;
                sb.append("\n" + bullet + severity.getDescription() + " (" + applicable.size() + ")\n\n");
                for (Issue issue2 : CollectionsKt.sorted((Iterable)applicable)) {
                    String id3 = issue2.getId();
                    String summary2 = issue2.getBriefDescription(TextFormat.RAW);
                    sb.append("  - [" + id3 + ": " + summary2 + "](" + id3 + this.format.getExtension() + ")\n");
                }
            }
            Iterable $this$filter$iv = this.issues;
            boolean $i$f$filter = false;
            severity = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (Issue)element$iv$iv;
                boolean bl = false;
                if (!(!it.isEnabledByDefault())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$sortedBy = false;
            List disabled = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)((Object)$this$sortedBy$iv3), (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Issue it = (Issue)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getId());
                    it = (Issue)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
                }
            }));
            if (!((Collection)disabled).isEmpty()) {
                sb.append("\n" + bullet + "Disabled By Default (" + disabled.size() + ")\n\n");
                for (Issue id4 : disabled) {
                    sb.append("  - [" + id4 + "](" + id4 + this.format.getExtension() + ")\n");
                }
            }
        } else if (type == IndexType.VENDOR) {
            HashMap<Vendor, List<Issue>> vendors = this.getVendors(this.issues);
            Set<Vendor> set = vendors.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"vendors.keys");
            Iterable $this$sortedBy$iv4 = set;
            boolean $i$f$sortedBy2 = false;
            for (Vendor vendor : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv4, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Vendor it = (Vendor)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.describe(TextFormat.RAW));
                    it = (Vendor)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.describe(TextFormat.RAW))));
                }
            })) {
                Issue issue;
                List list3 = vendors.get(vendor);
                if (list3 == null) continue;
                $this$sortedBy$iv = list3;
                boolean $i$f$sortedBy3 = false;
                list3 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Issue it = (Issue)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getId());
                        it = (Issue)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
                    }
                });
                if (list3 == null) {
                    continue;
                }
                List vendorIssues = list3;
                String vendorName = vendor.getVendorName();
                String identifier = vendor.getIdentifier();
                sb.append("\n" + bullet);
                if (Intrinsics.areEqual((Object)vendor, (Object)IssueRegistry.Companion.getAOSP_VENDOR()) && ((issue = vendors.get(vendor)) != null && (issue = (Issue)CollectionsKt.first(issue)) != null ? issue.getRegistry() : null) instanceof BuiltinIssueRegistry) {
                    sb.append("Built In (" + vendorIssues.size() + ")");
                } else {
                    Object object = vendorName;
                    if (object == null && (object = vendor.getContact()) == null && (object = identifier) == null) {
                        object = vendor.getFeedbackUrl();
                    }
                    sb.append((String)object);
                    if (vendorName != null && identifier != null && !StringsKt.contains$default((CharSequence)vendorName, (CharSequence)identifier, (boolean)false, (int)2, null)) {
                        sb.append(" (" + identifier + ")");
                    }
                    sb.append(" (" + vendorIssues.size() + ")");
                }
                sb.append("\n\n");
                for (Issue issue3 : vendorIssues) {
                    String id5 = issue3.getId();
                    String summary = issue3.getBriefDescription(TextFormat.RAW);
                    sb.append("  - [" + id5 + ": " + summary + "](" + id5 + this.format.getExtension() + ")\n");
                }
            }
        } else if (type == IndexType.YEAR) {
            HashMap<Integer, List<Issue>> years = this.getYears(this.issues);
            Set<Integer> set = years.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"years.keys");
            Iterable $this$sortedByDescending$iv = set;
            boolean $i$f$sortedByDescending = false;
            for (Integer year : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                /*
                 * WARNING - void declaration
                 */
                public final int compare(T a, T b) {
                    void var3_3;
                    Integer it = (Integer)b;
                    boolean bl = false;
                    Comparable comparable = it;
                    it = (Integer)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)var3_3));
                }
            })) {
                List list4 = years.get(year);
                if (list4 == null) continue;
                $this$sortedBy$iv = list4;
                boolean $i$f$sortedBy4 = false;
                list4 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Issue it = (Issue)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getId());
                        it = (Issue)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
                    }
                });
                if (list4 == null) {
                    continue;
                }
                List issuesFromYear = list4;
                sb.append("\n" + bullet);
                Integer n = year;
                int vendorName = -1;
                if (n != null && n == vendorName) {
                    sb.append("Unknown (" + issuesFromYear.size() + ")");
                } else {
                    sb.append(year + " (" + issuesFromYear.size() + ")");
                }
                sb.append("\n\n");
                for (Issue issue : issuesFromYear) {
                    id = issue.getId();
                    String summary = issue.getBriefDescription(TextFormat.RAW);
                    sb.append("  - [" + id + ": " + summary + "](" + id + this.format.getExtension() + ")\n");
                }
            }
        }
        Iterable $this$filter$iv = this.registry.getDeletedIssues();
        boolean $i$f$filter = false;
        Iterable issuesFromYear = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!this.skipIssue(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List deleted = (List)destination$iv$iv;
        if (!((Collection)deleted).isEmpty()) {
            sb.append("\n" + bullet + "Withdrawn or Obsolete Issues (" + deleted.size() + ")\n\n");
            for (String id6 : deleted) {
                sb.append("  - [" + id6 + "](" + id6 + this.format.getExtension() + ")\n");
            }
        }
        sb.append(this.format.getFooter());
        FilesKt.writeText$default((File)new File(this.output, type.getFilename() + this.format.getExtension()), (String)((Object)StringsKt.trim((CharSequence)sb)).toString(), null, (int)2, null);
    }

    private final void writeStatsPage() {
        HashMap<Category, List<Issue>> categories2 = this.getCategories(this.issues);
        StringBuilder sb = new StringBuilder();
        sb.append(this.format.getHeader());
        this.writeStats(sb, categories2, this.issues);
        sb.append(this.format.getFooter());
        FilesKt.writeText$default((File)new File(this.output, "stats" + this.format.getExtension()), (String)StringsKt.trimIndent((String)((Object)StringsKt.trim((CharSequence)sb)).toString()), null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void describeIssue(StringBuilder sb, Issue issue) {
        List options;
        IssueData issueData;
        String table;
        Pair<String, String>[] pairArray;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        void $this$toTypedArray$iv2;
        void $this$mapTo$iv$iv2;
        Collection $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Pair[] pairArray2;
        int copyrightYear;
        void $this$toTypedArray$iv3;
        Pair pair;
        Pair pair2;
        Pair pair3;
        Pair pair4;
        Pair pair5;
        Object it2;
        Object object;
        int n;
        Object object2;
        String id = issue.getId();
        Object object3 = issue.getVendor();
        if (object3 == null) {
            IssueRegistry issueRegistry = issue.getRegistry();
            object3 = issueRegistry != null ? issueRegistry.getVendor() : null;
        }
        Vendor vendor = object3;
        Implementation implementation = issue.getImplementation();
        boolean isMarkDeep = this.format == DocFormat.MARKDEEP;
        TextFormat format = TextFormat.RAW;
        String description = issue.getBriefDescription(format);
        boolean enabledByDefault = issue.isEnabledByDefault();
        String severity = issue.getDefaultSeverity().getDescription();
        String category = StringsKt.replace$default((String)issue.getCategory().getFullName(), (String)":", (String)": ", (boolean)false, (int)4, null);
        Object[] objectArray = object2 = new Pair[4];
        int n2 = 0;
        Object object4 = vendor;
        if (object4 != null && (object4 = object4.getVendorName()) != null) {
            Object object5 = object4;
            n = n2;
            object = objectArray;
            boolean bl = false;
            pair5 = TuplesKt.to((Object)"Vendor", (Object)it2);
            objectArray = object;
            n2 = n;
            pair4 = pair5;
        } else {
            pair4 = null;
        }
        objectArray[n2] = pair4;
        Object[] objectArray2 = object2;
        int n3 = 1;
        Object object6 = vendor;
        if (object6 != null && (object6 = object6.getIdentifier()) != null) {
            it2 = object6;
            n = n3;
            object = objectArray2;
            boolean bl = false;
            pair5 = TuplesKt.to((Object)"Identifier", (Object)it2);
            objectArray2 = object;
            n3 = n;
            pair3 = pair5;
        } else {
            pair3 = null;
        }
        objectArray2[n3] = pair3;
        Object[] objectArray3 = object2;
        int n4 = 2;
        Object object7 = vendor;
        if (object7 != null && (object7 = object7.getContact()) != null) {
            it2 = object7;
            n = n4;
            object = objectArray3;
            boolean bl = false;
            pair5 = !Intrinsics.areEqual((Object)vendor, (Object)IssueRegistry.Companion.getAOSP_VENDOR()) ? TuplesKt.to((Object)"Contact", (Object)it2) : null;
            objectArray3 = object;
            n4 = n;
            pair2 = pair5;
        } else {
            pair2 = null;
        }
        objectArray3[n4] = pair2;
        Object[] objectArray4 = object2;
        int n5 = 3;
        Object object8 = vendor;
        if (object8 != null && (object8 = object8.getFeedbackUrl()) != null) {
            it2 = object8;
            n = n5;
            object = objectArray4;
            boolean bl3 = false;
            pair5 = TuplesKt.to((Object)"Feedback", (Object)it2);
            objectArray4 = object;
            n5 = n;
            pair = pair5;
        } else {
            pair = null;
        }
        objectArray4[n5] = pair;
        object2 = CollectionsKt.listOfNotNull((Object[])object2);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv3;
        Pair[] pairArray3 = thisCollection$iv.toArray(new Pair[0]);
        Intrinsics.checkNotNull((Object)pairArray3, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Pair[] vendorInfo = pairArray3;
        String it3 = issue.getExplanation(format);
        boolean bl2 = false;
        Character c = StringsKt.lastOrNull((CharSequence)((Object)StringsKt.trimEnd((CharSequence)it3)).toString());
        Object explanation = (c != null ? Character.isLetter(c.charValue()) : false) ? it3 + "." : it3;
        IssueData issueData2 = this.issueMap.get(issue.getId());
        int n6 = copyrightYear = issueData2 != null ? issueData2.getCopyrightYear() : -1;
        if (copyrightYear != -1) {
            Pair[] bl2 = new Pair[]{TuplesKt.to((Object)"Copyright Year", (Object)String.valueOf(copyrightYear))};
            pairArray2 = bl2;
        } else {
            boolean $i$f$emptyArray = false;
            pairArray2 = (Pair[])((Object[])new Pair[0]);
        }
        Pair[] copyrightYearInfo = pairArray2;
        EnumSet bl3 = issue.getPlatforms();
        String platforms = Intrinsics.areEqual((Object)bl3, (Object)Platform.ANDROID_SET) ? "Android" : (Intrinsics.areEqual((Object)bl3, (Object)Platform.JDK_SET) ? "JDK" : "Any");
        List appliesTo = new ArrayList();
        EnumSet scope = implementation.getScope();
        Iterator iterator = scope.iterator();
        block20: while (iterator.hasNext()) {
            String desc;
            String string;
            Scope type;
            Scope scope2 = type = (Scope)iterator.next();
            Intrinsics.checkNotNull((Object)scope2);
            switch (WhenMappings.$EnumSwitchMapping$0[scope2.ordinal()]) {
                case 1: 
                case 2: {
                    string = "resource files";
                    break;
                }
                case 3: {
                    string = "binary resource files";
                    break;
                }
                case 4: {
                    string = "resource folders";
                    break;
                }
                case 5: 
                case 6: {
                    string = "Kotlin and Java files";
                    break;
                }
                case 7: 
                case 8: {
                    string = "class files";
                    break;
                }
                case 9: {
                    string = "manifest files";
                    break;
                }
                case 10: {
                    string = "shrinking configuration files";
                    break;
                }
                case 11: {
                    string = "library bytecode";
                    break;
                }
                case 12: {
                    string = "Gradle build files";
                    break;
                }
                case 13: {
                    string = "property files";
                    break;
                }
                case 14: {
                    string = "test sources";
                    break;
                }
                case 15: {
                    continue block20;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (appliesTo.contains(desc = string)) continue;
            appliesTo.add(desc);
        }
        String scopeDescription = !scope.contains(Scope.OTHER) && !Intrinsics.areEqual((Object)scope, (Object)Scope.ALL) ? StringsKt.capitalize((String)Lint.formatList$default((List)appliesTo, (int)0, (boolean)false, (boolean)true, (int)6, null)) : (String)null;
        Object enable = !enabledByDefault ? "**This issue is disabled by default**; use `--enable " + id + "`" : (String)null;
        boolean onTheFly = this.canAnalyzeInEditor(issue);
        String inEditor = onTheFly ? "This check runs on the fly in the IDE editor" : "This check can *not* run live in the IDE editor";
        List moreInfo = issue.getMoreInfo();
        if (!((Collection)moreInfo).isEmpty() && moreInfo.size() != CollectionsKt.toSet((Iterable)moreInfo).size()) {
            System.out.println((Object)("Warning: Multiple identical moreInfo links for issue " + id));
        }
        List deleted = this.registry.getDeletedIssues();
        Map $this$filter$iv = this.aliases;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator2.next();
            boolean bl4 = false;
            if (!Intrinsics.areEqual(it.getValue(), (Object)issue)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv2.entrySet()) {
            it = item$iv$iv;
            object = destination$iv$iv;
            boolean bl5 = false;
            String name = deleted.contains(it.getKey()) ? "Previously" : "Alias";
            object.add(new Pair((Object)name, it.getKey()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray2 = false;
        void thisCollection$iv2 = $this$toTypedArray$iv2;
        Pair[] pairArray4 = thisCollection$iv2.toArray(new Pair[0]);
        Intrinsics.checkNotNull((Object)pairArray4, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Pair[] aliases = pairArray4;
        Iterable $this$map$iv2 = moreInfo;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it4;
            String bl5 = (String)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl6 = false;
            object.add(new Pair((Object)"See", (Object)it4));
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray3 = false;
        SpreadBuilder thisCollection$iv3 = $this$toTypedArray$iv;
        Pair[] pairArray5 = thisCollection$iv3.toArray(new Pair[0]);
        Intrinsics.checkNotNull((Object)pairArray5, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Pair[] moreInfoUrls = pairArray5;
        if (this.includeSourceLinks) {
            pairArray = this.findSourceFiles(issue);
        } else {
            boolean $i$f$emptyArray = false;
            pairArray = (Pair[])((Object[])new Pair[0]);
        }
        Pair<String, String>[] sourceUrls = pairArray;
        thisCollection$iv3 = new SpreadBuilder(13);
        thisCollection$iv3.add((Object)TuplesKt.to((Object)"Id", (Object)("`" + id + "`")));
        thisCollection$iv3.addSpread((Object)aliases);
        thisCollection$iv3.add((Object)TuplesKt.to((Object)"Summary", (Object)description));
        thisCollection$iv3.add((Object)TuplesKt.to((Object)"Note", (Object)enable));
        thisCollection$iv3.add((Object)TuplesKt.to((Object)"Severity", (Object)severity));
        thisCollection$iv3.add((Object)TuplesKt.to((Object)"Category", (Object)category));
        thisCollection$iv3.add((Object)TuplesKt.to((Object)"Platform", (Object)platforms));
        thisCollection$iv3.addSpread((Object)vendorInfo);
        thisCollection$iv3.add((Object)TuplesKt.to((Object)"Affects", (Object)scopeDescription));
        thisCollection$iv3.add((Object)TuplesKt.to((Object)"Editing", (Object)inEditor));
        thisCollection$iv3.addSpread((Object)moreInfoUrls);
        thisCollection$iv3.addSpread(sourceUrls);
        thisCollection$iv3.addSpread((Object)copyrightYearInfo);
        Pair[] array = (Pair[])thisCollection$iv3.toArray((Object[])new Pair[thisCollection$iv3.size()]);
        String string = table = isMarkDeep ? LintIssueDocGenerator.Companion.markdeepTable(Arrays.copyOf(array, array.length)) : LintIssueDocGenerator.Companion.markdownTable(Arrays.copyOf(array, array.length));
        if (this.singleDoc) {
            sb.append("###");
        } else if (isMarkDeep) {
            sb.append("(#)");
        } else {
            sb.append("#");
        }
        sb.append(" " + description + "\n");
        sb.append("\n");
        if (isMarkDeep && this.includeSeverityColor) {
            switch (WhenMappings.$EnumSwitchMapping$1[issue.getDefaultSeverity().ordinal()]) {
                case 1: {
                    sb.append(StringsKt.trimIndent((String)("\n                        !!! ERROR: " + description + "\n                           This is an error, and is also enforced at build time when\n                           supported by the build system. For Android this means it will\n                           run during release builds.\n                    ")));
                    break;
                }
                case 2: {
                    sb.append(StringsKt.trimIndent((String)("\n                        !!! ERROR: " + description + "\n                           This is an error.\n                    ")));
                    break;
                }
                case 3: {
                    sb.append(StringsKt.trimIndent((String)("\n                        !!! WARNING: " + description + "\n                           This is a warning.\n                    ")));
                    break;
                }
                case 4: {
                    sb.append(StringsKt.trimIndent((String)("\n                        !!! Tip: " + description + "\n                           Advice from this check is just a tip.\n                    ")));
                }
            }
            sb.append("\n\n");
        }
        sb.append(table);
        sb.append("\n");
        sb.append(this.wrap((String)explanation));
        sb.append("\n");
        IssueData issueData3 = issueData = this.issueMap.get(id);
        boolean bl7 = issueData3 != null ? issueData3.getQuickFixable() : false;
        if (bl7) {
            sb.append("!!! Tip\n   This lint check has an associated quickfix available in the IDE.\n\n");
        }
        if (!((Collection)(options = issue.getOptions())).isEmpty()) {
            this.writeOptions(sb, issue, options);
        }
        if (this.includeExamples) {
            StringBuilder stringBuilder;
            Object object9 = issueData;
            if (object9 != null && (object9 = ((IssueData)object9).getExample()) != null) {
                Object example = object9;
                boolean bl8 = false;
                this.writeExample(sb, issueData, (Example)example, issue);
                stringBuilder = sb.append("\n");
            } else {
                stringBuilder = null;
            }
        }
        if (this.includeSuppressInfo) {
            IssueData issueData4 = issueData;
            this.writeSuppressInfo(sb, issue, id, issueData4 != null ? issueData4.getSuppressExample() : null);
        }
    }

    private final void writeOptions(StringBuilder sb, Issue issue, List<? extends Option> options) {
        sb.append("(##) Options\n\n");
        sb.append("You can configure this lint checks using the following options:\n\n");
        for (Option option : options) {
            String explanation;
            sb.append("(###) ").append(option.getName()).append("\n\n");
            sb.append(Option.getDescription$default((Option)option, null, (int)1, null)).append(".\n");
            String string = Option.getExplanation$default((Option)option, null, (int)1, null);
            if (string == null) {
                string = "";
            }
            if (!StringsKt.isBlank((CharSequence)(explanation = string))) {
                sb.append(explanation).append("\n");
            }
            sb.append("\n");
            String defaultValue = option.defaultAsString();
            if (defaultValue != null) {
                sb.append("Default is ").append(defaultValue).append(".\n");
            }
            sb.append("\n");
            sb.append("Example `lint.xml`:\n\n");
            String string2 = issue.getId();
            String string3 = option.getName();
            String string4 = defaultValue;
            if (string4 == null) {
                string4 = "some string";
            }
            sb.append("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~xml linenumbers\n&lt;lint&gt;\n    &lt;issue id=\"" + string2 + "\"&gt;\n        &lt;option name=\"" + string3 + "\" value=\"" + string4 + "\" /&gt;\n    &lt;/issue&gt;\n&lt;/lint&gt;\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n");
        }
    }

    private final void writeCodeLine(StringBuilder sb, String language, boolean lineNumbers) {
        if (this.format == DocFormat.MARKDEEP) {
            int max = 70 - language.length() - (lineNumbers ? " linenumbers".length() : 0);
            for (int i = 0; i < max; ++i) {
                sb.append('~');
            }
            sb.append(language);
            if (lineNumbers) {
                sb.append(" linenumbers");
            }
            sb.append('\n');
        } else {
            sb.append("```" + language + "\n");
        }
    }

    static /* synthetic */ void writeCodeLine$default(LintIssueDocGenerator lintIssueDocGenerator, StringBuilder stringBuilder, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        lintIssueDocGenerator.writeCodeLine(stringBuilder, string, bl);
    }

    private final void writeExample(StringBuilder sb, IssueData issueData, Example example, Issue issue) {
        sb.append("(##) Example\n");
        sb.append('\n');
        sb.append("Here is an example of lint warnings produced by this check:\n");
        LintIssueDocGenerator.writeCodeLine$default(this, sb, "text", false, 4, null);
        sb.append(example.getOutput());
        LintIssueDocGenerator.writeCodeLine$default(this, sb, null, false, 6, null);
        sb.append('\n');
        if (example.getFiles().size() == 1) {
            sb.append("Here is the source file referenced above:\n\n");
        } else {
            sb.append("Here are the relevant source files:\n\n");
        }
        this.writeSourceFiles(issue, example, sb);
        if (issueData.getTestUrl() != null && this.includeSourceLinks) {
            sb.append("You can also visit the\n[source code](" + issueData.getTestUrl() + ")\nfor the unit tests for this check to see additional scenarios.\n");
        }
        if (example.getInferred()) {
            this.writeInferredExampleMessage(sb, example, issue);
        }
    }

    private final void writeSourceFiles(Issue issue, Example example, StringBuilder sb) {
        for (ExampleFile file : example.getFiles()) {
            String it = file.getSource();
            boolean bl = false;
            String contents = issue.getRegistry() instanceof BuiltinIssueRegistry ? this.convertToAndroidX(it) : it;
            String lang = file.getLanguage();
            sb.append("`" + file.getPath() + "`:\n");
            this.writeCodeLine(sb, lang, true);
            sb.append(contents).append('\n');
            LintIssueDocGenerator.writeCodeLine$default(this, sb, null, false, 6, null);
            sb.append("\n");
        }
    }

    private final String convertToAndroidX(String original) {
        Object s = StringsKt.replace$default((String)original, (String)"android.support.annotation.", (String)"androidx.annotation.", (boolean)false, (int)4, null);
        if (!StringsKt.contains$default((CharSequence)((CharSequence)s), (CharSequence)"android.support.", (boolean)false, (int)2, null)) {
            return s;
        }
        Matcher matcher;
        while ((matcher = ANDROID_SUPPORT_SYMBOL_PATTERN.matcher((CharSequence)s)).find()) {
            String name = matcher.group(0);
            String newName = AndroidxNameUtils.getNewName((String)name);
            if (Intrinsics.areEqual((Object)newName, (Object)name)) {
                return s;
            }
            String string = ((String)s).substring(0, matcher.start());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = ((String)s).substring(matcher.end());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            s = string + newName + string2;
        }
        return s;
    }

    private final void writeInferredExampleMessage(StringBuilder sb, Example example, Issue issue) {
        Vendor vendor;
        sb.append("\nThe above example was automatically extracted from the first unit test\nfound for this lint check, `" + example.getTestClass() + "." + example.getTestMethod() + "`.\n");
        Object object = issue.getVendor();
        if (object == null) {
            IssueRegistry issueRegistry = issue.getRegistry();
            object = issueRegistry != null ? issueRegistry.getVendor() : null;
        }
        if ((vendor = object) != null) {
            sb.append("To report a problem with this extracted sample, ");
            String url = vendor.getFeedbackUrl();
            if (url != null) {
                sb.append("visit\n" + url + ".\n");
            } else {
                String string = vendor.getContact();
                if (string == null) {
                    string = vendor.getVendorName();
                }
                String contact = string;
                sb.append("contact\n" + contact + ".\n");
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void writeSuppressInfo(StringBuilder sb, Issue issue, String id, Example example) {
        block45: {
            block43: {
                block44: {
                    block40: {
                        block42: {
                            block41: {
                                block39: {
                                    block37: {
                                        block38: {
                                            block36: {
                                                sb.append("(##) Suppressing\n\n");
                                                suppressNames = issue.getSuppressNames();
                                                if (suppressNames != null) {
                                                    if (suppressNames.isEmpty()) {
                                                        sb.append(this.wrap("This check has been explicitly marked as **not suppressible** by the check author. This is usually only done in cases where a company has a check in place to enforce a no-exceptions policy."));
                                                    } else {
                                                        sb.append(this.wrap("This check has been explicitly exempted from the normal suppression mechanisms in lint (`@Suppress`, `lint.xml`, baselines, etc). However, it can be disabled by annotating the element with " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)suppressNames)), (CharSequence)" or ", null, null, (int)0, null, (Function1)writeSuppressInfo.1.INSTANCE, (int)30, null) + "."));
                                                    }
                                                    return;
                                                }
                                                issueScope = issue.getImplementation().getScope();
                                                sb.append("You can suppress false positives using one of the following mechanisms:\n");
                                                issueData = this.issueMap.get(issue.getId());
                                                v0 = issueData;
                                                if (v0 == null || (v0 = v0.getSuppressExample()) == null || (v0 = v0.getFiles()) == null) break block38;
                                                $this$firstOrNull$iv = (Iterable)v0;
                                                $i$f$firstOrNull = false;
                                                for (T element$iv : $this$firstOrNull$iv) {
                                                    it = (ExampleFile)element$iv;
                                                    $i$a$-firstOrNull-LintIssueDocGenerator$writeSuppressInfo$language$1 = false;
                                                    if (!this.containsSuppress(it.getSource(), issue)) continue;
                                                    v1 = element$iv;
                                                    break block36;
                                                }
                                                v1 = null;
                                            }
                                            if ((v0 = (ExampleFile)v1) != null && (v0 = v0.getLanguage()) != null) break block39;
                                        }
                                        if ((v2 = issueData) == null || (v2 = v2.getExample()) == null || (v2 = v2.getFiles()) == null) ** GOTO lbl-1000
                                        $this$firstOrNull$iv = (Iterable)v2;
                                        $i$f$firstOrNull = false;
                                        for (T element$iv : $this$firstOrNull$iv) {
                                            it = (ExampleFile)element$iv;
                                            $i$a$-firstOrNull-LintIssueDocGenerator$writeSuppressInfo$language$2 = false;
                                            if (!this.containsSuppress(it.getSource(), issue)) continue;
                                            v3 = element$iv;
                                            break block37;
                                        }
                                        v3 = null;
                                    }
                                    if ((v2 = (ExampleFile)v3) != null) {
                                        v0 = v2.getLanguage();
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v0 = (v4 = issueData) != null && (v4 = v4.getExample()) != null && (v4 = v4.getFiles()) != null && (v4 = (ExampleFile)CollectionsKt.firstOrNull(v4)) != null ? v4.getLanguage() : null;
                                    }
                                }
                                language = v0;
                                kotlinOrJava = issueScope.contains(Scope.JAVA_FILE);
                                resourceFile = issueScope.contains(Scope.RESOURCE_FILE);
                                manifestFile = issueScope.contains(Scope.MANIFEST);
                                gradle = issueScope.contains(Scope.GRADLE_FILE);
                                properties = issueScope.contains(Scope.PROPERTY_FILE);
                                annotation = null;
                                comment = null;
                                attribute = null;
                                try {
                                    var18_16 = (Detector)issue.getImplementation().getDetectorClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                }
                                catch (Throwable ignore) {
                                    var18_16 = null;
                                }
                                detector = var18_16;
                                if (!kotlinOrJava) break block40;
                                v5 /* !! */  = detector;
                                if (v5 /* !! */  == null || (v5 /* !! */  = v5 /* !! */ .getApplicableMethodNames()) == null || (v5 /* !! */  = (String)CollectionsKt.firstOrNull((List)v5 /* !! */ )) == null) break block41;
                                it /* !! */  = v5 /* !! */ ;
                                $i$a$-let-LintIssueDocGenerator$writeSuppressInfo$statement$1 = false;
                                v6 = (String)it /* !! */  + "(...)";
                                v5 /* !! */  = v6;
                                if (v6 != null) break block42;
                            }
                            if ((v7 = detector) != null && (v7 = v7.getApplicableConstructorTypes()) != null && (v7 = (String)CollectionsKt.firstOrNull((List)v7)) != null) {
                                it = v7;
                                $i$a$-let-LintIssueDocGenerator$writeSuppressInfo$statement$2 = false;
                                v8 = it.substring(StringsKt.lastIndexOf$default((CharSequence)((CharSequence)it), (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
                                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"this as java.lang.String).substring(startIndex)");
                                v5 /* !! */  = "new " + v8 + "(...)";
                            } else {
                                v5 /* !! */  = "problematicStatement()";
                            }
                        }
                        statement /* !! */  = v5 /* !! */ ;
                        annotation = StringsKt.trimIndent((String)("\n                        * Using a suppression annotation like this on the enclosing\n                          element:\n\n                          ```kt\n                          // Kotlin\n                          @Suppress(\"" + id + "\")\n                          fun method() {\n                             " + StringsKt.replace$default((String)statement /* !! */ , (String)"new ", (String)"", (boolean)false, (int)4, null) + "\n                          }\n                          ```\n\n                          or\n\n                          ```java\n                          // Java\n                          @SuppressWarnings(\"" + id + "\")\n                          void method() {\n                             " + (String)statement /* !! */  + ";\n                          }\n                          ```\n                "));
                    }
                    if (kotlinOrJava || gradle) {
                        comment = StringsKt.trimIndent((String)("\n                        * Using a suppression comment like this on the line above:\n\n                          ```kt\n                          //noinspection " + id + "\n                          problematicStatement()\n                          ```\n                "));
                    } else if (properties) {
                        comment = StringsKt.trimIndent((String)("\n                        * Using a suppression comment like this on the line above:\n\n                          ```kt\n                          #noinspection " + id + "\n                          key = problematic-value\n                          ```\n                "));
                    }
                    if (resourceFile || manifestFile) {
                        v9 = LintIssueDocGenerator.writeSuppressInfo$listIndent("* Adding the suppression attribute `tools:ignore=\"" + id + "\"` on the problematic XML element (or one of its enclosing elements). You may also need to add the following namespace declaration on the root element in the XML file if it's not already there: `xmlns:tools=\"http://schemas.android.com/tools\"`.");
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"listIndent(\n            \u2026ls\\\"`.\"\n                )");
                        attribute = StringsKt.trim((CharSequence)v9).toString();
                        v10 /* !! */  = detector;
                        v11 = v10 /* !! */  != null && (v10 /* !! */  = v10 /* !! */ .getApplicableElements()) != null ? (String)CollectionsKt.firstOrNull((Iterable)((Iterable)v10 /* !! */ )) : (tag = null);
                        if (tag != null) {
                            if (resourceFile) {
                                v12 = detector instanceof ResourceXmlDetector != false ? (ResourceXmlDetector)detector : null;
                                v13 = (v12 != null ? v12.appliesTo(ResourceFolderType.VALUES) : false) ? "resources" : (manifestFile ? "manifest" : tag);
                            } else {
                                v13 = "manifest";
                            }
                            root = v13;
                            snippet = new StringBuilder("\n\n");
                            snippet.append("  ```xml\n");
                            snippet.append("  " + this.lt + "?xml version=\"1.0\" encoding=\"UTF-8\"?" + this.gt + "\n");
                            snippet.append("  " + this.lt);
                            snippet.append(root);
                            snippet.append(" xmlns:tools=\"http://schemas.android.com/tools\"");
                            if (!Intrinsics.areEqual((Object)root, (Object)tag)) {
                                snippet.append(this.gt + "\n");
                                snippet.append("      ...\n");
                                snippet.append("      " + this.lt);
                                snippet.append(tag);
                                snippet.append(" ");
                                v14 = detector.getApplicableAttributes();
                                if (v14 != null && (v14 = (String)CollectionsKt.firstOrNull((Iterable)((Iterable)v14))) != null) {
                                    it = v14;
                                    $i$a$-let-LintIssueDocGenerator$writeSuppressInfo$2 = false;
                                    snippet.append((String)it).append("=\"...\" ");
                                }
                            } else {
                                snippet.append("\n      ");
                            }
                            snippet.append("tools:ignore=\"").append(id).append("\" ...");
                            if (!Intrinsics.areEqual((Object)root, (Object)tag)) {
                                snippet.append("/");
                            }
                            snippet.append(this.gt + "\n");
                            snippet.append("    ...\n");
                            snippet.append("  " + this.lt + "/");
                            snippet.append(root);
                            snippet.append(this.gt + "\n");
                            snippet.append("  ```");
                            attribute = (String)attribute + snippet;
                        }
                    }
                    lintXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                      <lint>\n                          <issue id=\"" + id + "\" severity=\"ignore\" />\n                      </lint>";
                    general = StringsKt.trimIndent((String)("\n                    * Using a special `lint.xml` file in the source tree which turns off\n                      the check in that folder and any sub folder. A simple file might look\n                      like this:\n                      ```xml\n                      " + this.escapeXml(lintXml) + "\n                      ```\n                      Instead of `ignore` you can also change the severity here, for\n                      example from `error` to `warning`. You can find additional\n                      documentation on how to filter issues by path, regular expression and\n                      so on\n                      [here](https://googlesamples.github.io/android-custom-lint-rules/usage/lintxml.md.html).\n\n                    * In Gradle projects, using the DSL syntax to configure lint. For\n                      example, you can use something like\n                      ```gradle\n                      lintOptions {\n                          disable '" + id + "'\n                      }\n                      ```\n                      In Android projects this should be nested inside an `android { }`\n                      block.\n\n                    * For manual invocations of `lint`, using the `--ignore` flag:\n                      ```\n                      $ lint --ignore " + id + " ...`\n                      ```\n\n                    * Last, but not least, using baselines, as discussed\n                      [here](https://googlesamples.github.io/android-custom-lint-rules/usage/baselines.md.html).\n            "));
                    if (language == null) break block43;
                    switch (language.hashCode()) {
                        case 3254818: {
                            if (!language.equals("java")) {
                                ** break;
                            }
                            ** GOTO lbl170
                        }
                        case -1237466098: {
                            if (!language.equals("groovy")) {
                                ** break;
                            }
                            break block44;
                        }
                        case 118807: {
                            if (language.equals("xml")) break;
                            ** break;
                        }
                        case -1125574399: {
                            if (!language.equals("kotlin")) ** break;
lbl170:
                            // 2 sources

                            $i$a$-firstOrNull-LintIssueDocGenerator$writeSuppressInfo$language$2 = new String[]{annotation, comment, attribute, general};
                            v15 = CollectionsKt.listOfNotNull((Object[])$i$a$-firstOrNull-LintIssueDocGenerator$writeSuppressInfo$language$2);
                            break block45;
                        }
                    }
                    $i$a$-firstOrNull-LintIssueDocGenerator$writeSuppressInfo$language$2 = new String[]{attribute, annotation, comment, general};
                    v15 = CollectionsKt.listOfNotNull((Object[])$i$a$-firstOrNull-LintIssueDocGenerator$writeSuppressInfo$language$2);
                    break block45;
                }
                $i$a$-firstOrNull-LintIssueDocGenerator$writeSuppressInfo$language$2 = new String[]{comment, annotation, attribute, general};
                v15 = CollectionsKt.listOfNotNull((Object[])$i$a$-firstOrNull-LintIssueDocGenerator$writeSuppressInfo$language$2);
                break block45;
            }
            $i$a$-firstOrNull-LintIssueDocGenerator$writeSuppressInfo$language$2 = new String[]{annotation, comment, attribute, general};
            v15 = CollectionsKt.listOfNotNull((Object[])$i$a$-firstOrNull-LintIssueDocGenerator$writeSuppressInfo$language$2);
        }
        sorted = v15;
        $this$forEach$iv = sorted;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            $i$a$-forEach-LintIssueDocGenerator$writeSuppressInfo$3 = false;
            sb.append('\n').append((String)it).append('\n');
        }
        if (example != null) {
            sb.append("\n(###) Suppress Example\n\n");
            this.writeSourceFiles(issue, example, sb);
        }
    }

    private final List<File> findSourceFiles(File root) {
        List files = new ArrayList();
        LintIssueDocGenerator.findSourceFiles$addSourceFile(files, root);
        return files;
    }

    private final Pair<Map<String, Map<File, List<File>>>, Map<String, Map<File, List<File>>>> findSourceFiles() {
        return new Pair(this.findSourceFiles(this.sourcePath), this.findSourceFiles(this.testPath));
    }

    private final Map<String, Map<File, List<File>>> findSourceFiles(Map<String, ? extends List<? extends File>> prefixMap) {
        Map map = new LinkedHashMap();
        for (Map.Entry<String, ? extends List<? extends File>> entry : prefixMap.entrySet()) {
            String prefix = entry.getKey();
            List<? extends File> path = entry.getValue();
            for (File file : path) {
                Map dirMap;
                List list2;
                List<File> sources = this.findSourceFiles(file);
                Map map2 = (Map)map.get(prefix);
                if (map2 == null) {
                    Map map3;
                    Map it = map3 = (Map)new LinkedHashMap();
                    boolean bl = false;
                    map.put(prefix, it);
                    map2 = map3;
                }
                if ((list2 = (List)(dirMap = map2).get(file)) == null) {
                    List list3;
                    List it = list3 = (List)new ArrayList();
                    boolean bl = false;
                    dirMap.put(file, it);
                    list2 = list3;
                }
                List list4 = list2;
                list4.addAll((Collection)sources);
            }
        }
        return map;
    }

    private final void initializeSources(IssueData issueData, Pair<? extends Map<String, ? extends Map<File, ? extends List<? extends File>>>, ? extends Map<String, ? extends Map<File, ? extends List<? extends File>>>> sources) {
        System.out.println((Object)("Analyzing " + issueData.getIssue().getId()));
        Map sourceFiles = (Map)sources.component1();
        Map testFiles = (Map)sources.component2();
        Pair<Class<? extends Detector>, String> pair = this.getDetectorRelativePath(issueData.getIssue());
        Class detectorClass = (Class)pair.component1();
        String detectorName = (String)pair.component2();
        this.findSource(detectorClass, detectorName, sourceFiles, (Function2<? super File, ? super String, Unit>)((Function2)new Function2<File, String, Unit>(issueData, this){
            final /* synthetic */ IssueData $issueData;
            final /* synthetic */ LintIssueDocGenerator this$0;
            {
                this.$issueData = $issueData;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@Nullable File file, @Nullable String url) {
                this.$issueData.setSourceUrl(url);
                if (file != null) {
                    this.$issueData.setDetectorSource(file);
                    this.$issueData.setCopyrightYear(LintIssueDocGenerator.access$findCopyrightYear(this.this$0, file));
                }
            }
        }));
        this.findSource(detectorClass, detectorName + "Test", testFiles, (Function2<? super File, ? super String, Unit>)((Function2)new Function2<File, String, Unit>(issueData, this){
            final /* synthetic */ IssueData $issueData;
            final /* synthetic */ LintIssueDocGenerator this$0;
            {
                this.$issueData = $issueData;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@Nullable File file, @Nullable String url) {
                this.$issueData.setTestUrl(url);
                if (file != null) {
                    this.$issueData.setDetectorTestSource(file);
                    LintIssueDocGenerator.access$initializeExamples(this.this$0, this.$issueData);
                }
            }
        }));
    }

    private final int findCopyrightYear(File file) {
        List lines = FilesKt.readLines$default((File)file, null, (int)1, null);
        for (String line2 : lines) {
            if (!StringsKt.contains$default((CharSequence)line2, (CharSequence)"opyright", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)line2, (CharSequence)"(C)", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)line2, (CharSequence)"(c)", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)line2, (char)'\u00a9', (boolean)false, (int)2, null)) continue;
            Matcher matcher = YEAR_PATTERN.matcher(line2);
            int start = 0;
            int maxYear = -1;
            while (matcher.find(start)) {
                String string = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
                int year = Integer.parseInt(string);
                maxYear = Math.max(maxYear, year);
                start = matcher.end();
            }
            if (maxYear == -1) continue;
            return maxYear;
        }
        String prefix = CollectionsKt.joinToString$default((Iterable)lines.subList(0, Math.min(8, lines.size())), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        System.out.println((Object)("Couldn't find copyright year in " + file.getName() + " (" + file.getPath() + "):\n" + prefix + "\n\n"));
        return -1;
    }

    private final Pair<String, String>[] findSourceFiles(Issue issue) {
        Pair pair;
        Pair pair2;
        Pair pair3;
        String url;
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        IssueData issueData = this.issueMap.get(issue.getId());
        if (issueData == null) {
            boolean $i$f$emptyArray = false;
            return (Pair[])((Object[])new Pair[0]);
        }
        IssueData issueData2 = issueData;
        Object[] objectArray3 = objectArray2 = new Pair[2];
        int n2 = 0;
        String string = issueData2.getSourceUrl();
        if (string != null) {
            String string2 = string;
            n = n2;
            objectArray = objectArray3;
            boolean bl = false;
            pair3 = new Pair((Object)"Implementation", (Object)("[Source Code](" + url + ")"));
            objectArray3 = objectArray;
            n2 = n;
            pair2 = pair3;
        } else {
            pair2 = null;
        }
        objectArray3[n2] = pair2;
        Object[] objectArray4 = objectArray2;
        int n3 = 1;
        String string3 = issueData2.getTestUrl();
        if (string3 != null) {
            url = string3;
            n = n3;
            objectArray = objectArray4;
            boolean bl = false;
            pair3 = new Pair((Object)"Tests", (Object)("[Source Code](" + url + ")"));
            objectArray4 = objectArray;
            n3 = n;
            pair = pair3;
        } else {
            pair = null;
        }
        objectArray4[n3] = pair;
        Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object[])objectArray2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        Intrinsics.checkNotNull((Object)pairArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return pairArray;
    }

    private final Pair<Class<? extends Detector>, String> getDetectorRelativePath(Issue issue) {
        String string;
        Class detectorClass = issue.getImplementation().getDetectorClass();
        String string2 = detectorClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"detectorClass.name");
        String it = StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null);
        boolean bl = false;
        int innerClass = StringsKt.indexOf$default((CharSequence)it, (char)'$', (int)0, (boolean)false, (int)6, null);
        if (innerClass == -1) {
            string = it;
        } else {
            String string3 = it.substring(0, innerClass);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        String detectorName = string;
        return new Pair((Object)detectorClass, (Object)detectorName);
    }

    private final void findSource(Class<? extends Detector> detectorClass, String detectorName, Map<String, ? extends Map<File, ? extends List<? extends File>>> sourcePath, Function2<? super File, ? super String, Unit> store) {
        Map<File, ? extends List<? extends File>> path;
        String prefix;
        String relative = StringsKt.replace$default((String)detectorName, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
        String relativeKt = relative + ".kt";
        String relativeJava = relative + ".java";
        for (Map.Entry<String, ? extends Map<File, ? extends List<? extends File>>> entry : sourcePath.entrySet()) {
            prefix = entry.getKey();
            path = entry.getValue();
            for (Map.Entry<File, ? extends List<? extends File>> entry2 : path.entrySet()) {
                File root = entry2.getKey();
                List<? extends File> files = entry2.getValue();
                for (File file : files) {
                    String string;
                    boolean bl;
                    String filePath = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
                    if (!StringsKt.endsWith$default((String)filePath, (String)relativeKt, (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)filePath, (String)relativeJava, (boolean)false, (int)2, null)) continue;
                    String string2 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
                    String string3 = root.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"root.path");
                    boolean bl2 = bl = StringsKt.startsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null) && file.getPath().length() > root.getPath().length();
                    if (_Assertions.ENABLED && !bl) {
                        String string4 = "Assertion failed";
                        throw new AssertionError((Object)string4);
                    }
                    String string4 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"file.path");
                    String string6 = string4;
                    int n = root.getPath().length();
                    String string5 = string6.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                    String urlRelative = StringsKt.replace$default((String)string5, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                    if (StringsKt.endsWith$default((String)prefix, (String)"/", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)urlRelative, (String)"/", (boolean)false, (int)2, null)) {
                        String string7 = urlRelative.substring(1);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
                        string = prefix + string7;
                    } else {
                        string = prefix + urlRelative;
                    }
                    String url = string;
                    store.invoke((Object)file, (Object)(((CharSequence)prefix).length() == 0 ? null : url));
                    return;
                }
            }
        }
        for (Map.Entry<String, ? extends Map<File, ? extends List<? extends File>>> entry : sourcePath.entrySet()) {
            prefix = entry.getKey();
            path = entry.getValue();
            if (((CharSequence)prefix).length() == 0 || !path.isEmpty()) continue;
            String full = this.isKotlinClass(detectorClass) ? relative + ".kt" : relative + ".java";
            store.invoke(null, (Object)(prefix + full));
            return;
        }
    }

    private final boolean isKotlinClass(Class<?> $this$isKotlinClass) {
        boolean bl;
        block1: {
            Annotation[] annotationArray = $this$isKotlinClass.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"this.declaredAnnotations");
            Object[] $this$any$iv = annotationArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Annotation it = (Annotation)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)JvmClassMappingKt.getAnnotationClass((Annotation)it), (Object)Reflection.getOrCreateKotlinClass(Metadata.class))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final void initializeExamples(IssueData issueData) {
        Object v5;
        Set preferred;
        Set curated2;
        Set curated1;
        List methods;
        File source;
        block9: {
            Object[] className;
            File file = issueData.getDetectorTestSource();
            if (file == null) {
                return;
            }
            source = file;
            String string = source.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.path");
            List ktFiles = StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null) ? CollectionsKt.listOf((Object)source) : CollectionsKt.emptyList();
            this.environment.analyzeFiles(ktFiles);
            VirtualFileSystem local = StandardFileSystems.local();
            VirtualFile virtualFile = local.findFileByPath(source.getPath());
            if (virtualFile == null) {
                throw new IllegalStateException(("Could not find virtual file for " + source).toString());
            }
            VirtualFile virtualFile2 = virtualFile;
            PsiFile psiFile = PsiManager.getInstance((Project)((Project)this.environment.getIdeaProject())).findFile(virtualFile2);
            if (psiFile == null) {
                throw new IllegalStateException(("Could not find PSI file for " + source).toString());
            }
            PsiFile psiFile2 = psiFile;
            PsiElement $this$toUElementOfType$iv = (PsiElement)psiFile2;
            boolean $i$f$toUElementOfType = false;
            UFile uFile = (UFile)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UFile.class);
            if (uFile == null) {
                throw new IllegalStateException(("Could not create UAST file for " + source).toString());
            }
            UFile file2 = uFile;
            methods = new ArrayList();
            for (UClass testClass : file2.getClasses()) {
                if (testClass.getName() == null || !StringsKt.endsWith$default((String)className, (String)"Test", (boolean)false, (int)2, null)) continue;
                for (UMethod method : testClass.getMethods()) {
                    methods.add(method);
                }
            }
            String id = issueData.getIssue().getId();
            className = new String[]{"testDocumentationExample" + id, "testExample" + id, "example" + id};
            curated1 = SetsKt.setOf((Object[])className);
            Object[] objectArray = new String[]{"testDocumentationExample", "testExample", "example", "testSample"};
            curated2 = SetsKt.setOf((Object[])objectArray);
            Object[] objectArray2 = new String[]{"testBasic", "test"};
            preferred = SetsKt.setOf((Object[])objectArray2);
            Object[] objectArray3 = new String[]{"testSuppressExample", "testSuppressExample" + id, "suppressExample"};
            Set suppressExampleNames = SetsKt.setOf((Object[])objectArray3);
            Iterable $this$firstOrNull$iv = methods;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UMethod it = (UMethod)element$iv;
                boolean bl = false;
                if (!suppressExampleNames.contains(it.getName())) continue;
                v5 = element$iv;
                break block9;
            }
            v5 = null;
        }
        UMethod suppressExample = v5;
        if (suppressExample != null) {
            methods.remove(suppressExample);
            issueData.setSuppressExample(this.findExampleInMethod(suppressExample, source, issueData, false, true));
        }
        CollectionsKt.sortWith((List)methods, (Comparator)new Comparator<UMethod>((Set<String>)curated1, (Set<String>)curated2, (Set<String>)preferred){
            final /* synthetic */ Set<String> $curated1;
            final /* synthetic */ Set<String> $curated2;
            final /* synthetic */ Set<String> $preferred;
            {
                this.$curated1 = $curated1;
                this.$curated2 = $curated2;
                this.$preferred = $preferred;
            }

            public int compare(@NotNull UMethod o1, @NotNull UMethod o2) {
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                int rank1 = LintIssueDocGenerator.access$initializeExamples$rank(o1, this.$curated1, this.$curated2, this.$preferred);
                int rank2 = LintIssueDocGenerator.access$initializeExamples$rank(o2, this.$curated1, this.$curated2, this.$preferred);
                int delta = rank1 - rank2;
                if (delta != 0) {
                    return delta;
                }
                PsiElement psiElement = o1.getSourcePsi();
                PsiElement psiElement2 = o2.getSourcePsi();
                return (psiElement != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement) : 0) - (psiElement2 != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement2) : 0);
            }
        });
        for (UMethod method : methods) {
            boolean inferred = LintIssueDocGenerator.initializeExamples$rank(method, curated1, curated2, preferred) >= 3;
            issueData.setExample(this.findExampleInMethod(method, source, issueData, inferred, false));
            if (issueData.getExample() == null) continue;
            break;
        }
    }

    private final Example findExampleInMethod(UMethod method, File source, IssueData issueData, boolean inferred, boolean suppress) {
        Issue issue = issueData.getIssue();
        Ref.ObjectRef example = new Ref.ObjectRef();
        method.accept((UastVisitor)new AbstractUastVisitor((Ref.ObjectRef<Example>)example, this, source, issue, method, inferred, suppress, issueData){
            final /* synthetic */ Ref.ObjectRef<Example> $example;
            final /* synthetic */ LintIssueDocGenerator this$0;
            final /* synthetic */ File $source;
            final /* synthetic */ Issue $issue;
            final /* synthetic */ UMethod $method;
            final /* synthetic */ boolean $inferred;
            final /* synthetic */ boolean $suppress;
            final /* synthetic */ IssueData $issueData;
            {
                this.$example = $example;
                this.this$0 = $receiver;
                this.$source = $source;
                this.$issue = $issue;
                this.$method = $method;
                this.$inferred = $inferred;
                this.$suppress = $suppress;
                this.$issueData = $issueData;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                String name;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                String string = node.getMethodName();
                if (string == null) {
                    UIdentifier uIdentifier = node.getMethodIdentifier();
                    string = name = uIdentifier != null ? uIdentifier.getName() : null;
                }
                if (this.$example.element == null && Intrinsics.areEqual((Object)name, (Object)"expect")) {
                    this.$example.element = LintIssueDocGenerator.access$findExample(this.this$0, this.$source, this.$issue, this.$method, node, this.$inferred, this.$suppress);
                }
                if ((Intrinsics.areEqual((Object)name, (Object)"expectFixDiffs") || Intrinsics.areEqual((Object)name, (Object)"verifyFixes")) && LintIssueDocGenerator.access$singleIssueDetector(this.this$0, this.$issue)) {
                    UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
                    if (uExpression != null) {
                        UExpression uExpression2 = uExpression;
                        LintIssueDocGenerator lintIssueDocGenerator = this.this$0;
                        UExpression it = uExpression2;
                        boolean bl = false;
                        String output = LintIssueDocGenerator.access$evaluateString(lintIssueDocGenerator, (UElement)it);
                        if (output != null && StringsKt.contains$default((CharSequence)output, (CharSequence)"Show URL for", (boolean)false, (int)2, null)) {
                            return super.visitCallExpression(node);
                        }
                    }
                    this.$issueData.setQuickFixable(true);
                }
                return super.visitCallExpression(node);
            }
        });
        return (Example)example.element;
    }

    private final boolean singleIssueDetector(Issue issue) {
        return this.singleIssueDetectors.contains(issue);
    }

    private final UastEnvironment createUastEnvironment() {
        UastEnvironment.Configuration config = UastEnvironment.Configuration.Companion.create$default(UastEnvironment.Configuration.Companion, false, false, 3, null);
        config.addSourceRoots(CollectionsKt.flatten((Iterable)this.testPath.values()));
        List libs = new ArrayList();
        String string = System.getProperty("java.class.path");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"java.class.path\")");
        String classPath = string;
        CharSequence charSequence = classPath;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        for (String path : StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            File file = new File(path);
            String name = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            if (StringsKt.endsWith$default((String)name, (String)".jar", (boolean)false, (int)2, null)) {
                libs.add(file);
                continue;
            }
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
            if (StringsKt.endsWith$default((String)string2, (String)"android.sdktools.base.lint.checks-base", (boolean)false, (int)2, null)) continue;
            String string3 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.path");
            if (StringsKt.endsWith$default((String)string3, (String)"android.sdktools.base.lint.studio-checks", (boolean)false, (int)2, null)) continue;
            libs.add(file);
        }
        config.addClasspathRoots(libs);
        return UastEnvironment.Companion.create(config);
    }

    private final void disposeUastEnvironment() {
        this.environment.dispose();
    }

    private final Map<String, IssueData> analyzeSource() {
        Map map = new LinkedHashMap();
        if (!this.sourcePath.isEmpty() || !this.testPath.isEmpty()) {
            System.out.println((Object)"Searching through source path");
        }
        Pair<Map<String, Map<File, List<File>>>, Map<String, Map<File, List<File>>>> sources = this.findSourceFiles();
        for (Issue issue : this.issues) {
            IssueData data = new IssueData(issue);
            data.setQuickFixable(Reporter.Companion.hasAutoFix(issue));
            map.put(issue.getId(), data);
            if (!this.includeSuppressInfo && !this.includeExamples && !this.includeSourceLinks) continue;
            this.initializeSources(data, sources);
        }
        return map;
    }

    private final Example findExample(File file, Issue issue, UMethod method, UCallExpression node, boolean inferred, boolean suppress) {
        Ref.ObjectRef example;
        block4: {
            UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
            if (uExpression == null) {
                return null;
            }
            UExpression valueArgument = uExpression;
            String string = this.evaluateString((UElement)valueArgument);
            if (string == null) {
                return null;
            }
            String expected = string;
            if (!suppress && StringsKt.contains$default((CharSequence)expected, (CharSequence)"No warnings", (boolean)false, (int)2, null)) {
                return null;
            }
            Map<String, Map<Integer, List<String>>> map = this.computeResultMap(issue, expected);
            if (!suppress && map.isEmpty()) {
                return null;
            }
            example = new Ref.ObjectRef();
            UExpression uExpression2 = node.getReceiver();
            if (uExpression2 == null) break block4;
            uExpression2.accept((UastVisitor)new AbstractUastVisitor((Ref.ObjectRef<Example>)example, this, file, map, issue, method, inferred, suppress){
                final /* synthetic */ Ref.ObjectRef<Example> $example;
                final /* synthetic */ LintIssueDocGenerator this$0;
                final /* synthetic */ File $file;
                final /* synthetic */ Map<String, Map<Integer, List<String>>> $map;
                final /* synthetic */ Issue $issue;
                final /* synthetic */ UMethod $method;
                final /* synthetic */ boolean $inferred;
                final /* synthetic */ boolean $suppress;
                {
                    this.$example = $example;
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$map = $map;
                    this.$issue = $issue;
                    this.$method = $method;
                    this.$inferred = $inferred;
                    this.$suppress = $suppress;
                }

                public boolean visitCallExpression(@NotNull UCallExpression node) {
                    String name;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    String string = node.getMethodName();
                    if (string == null) {
                        UIdentifier uIdentifier = node.getMethodIdentifier();
                        string = name = uIdentifier != null ? uIdentifier.getName() : null;
                    }
                    if (this.$example.element == null && Intrinsics.areEqual((Object)name, (Object)"files")) {
                        this.$example.element = LintIssueDocGenerator.access$findExample(this.this$0, this.$file, node, this.$map, this.$issue, this.$method, this.$inferred, this.$suppress);
                    }
                    return super.visitCallExpression(node);
                }
            });
        }
        return (Example)example.element;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final UCallExpression getTestFileDeclaration(UExpression argument) {
        if (argument == null) {
            return null;
        }
        if (argument instanceof UParenthesizedExpression) {
            return this.getTestFileDeclaration(((UParenthesizedExpression)argument).getExpression());
        }
        if (argument instanceof UCallExpression) {
            String name;
            String string = ((UCallExpression)argument).getMethodName();
            if (string == null) {
                UIdentifier uIdentifier = ((UCallExpression)argument).getMethodIdentifier();
                string = uIdentifier != null ? uIdentifier.getName() : null;
            }
            if (!Intrinsics.areEqual((Object)(name = string), (Object)"compiled")) return (UCallExpression)argument;
            return this.getTestFileDeclaration((UExpression)((UCallExpression)argument).getValueArguments().get(1));
        }
        if (argument instanceof UQualifiedReferenceExpression) {
            UCallExpression uCallExpression;
            UExpression selector = ((UQualifiedReferenceExpression)argument).getSelector();
            if (selector instanceof UCallExpression) {
                String string = ((UCallExpression)selector).getMethodName();
                if (string == null) {
                    UIdentifier uIdentifier = ((UCallExpression)selector).getMethodIdentifier();
                    string = uIdentifier != null ? uIdentifier.getName() : null;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"indented")) {
                    uCallExpression = this.getTestFileDeclaration(((UCallExpression)selector).getReceiver());
                    return uCallExpression;
                }
            }
            uCallExpression = this.getTestFileDeclaration(selector);
            return uCallExpression;
        }
        if (!(argument instanceof USimpleNameReferenceExpression)) return null;
        PsiElement psiElement = ((USimpleNameReferenceExpression)argument).resolve();
        UElement element = psiElement != null ? UastContextKt.toUElement((PsiElement)psiElement) : null;
        if (!(element instanceof UVariable)) return null;
        return this.getTestFileDeclaration(((UVariable)element).getUastInitializer());
    }

    /*
     * Unable to fully structure code
     */
    private final Example findExample(File file, UCallExpression node, Map<String, Map<Integer, List<String>>> outputMap, Issue issue, UMethod method, boolean inferred, boolean suppress) {
        exampleFiles = new ArrayList<E>();
        for (UExpression argument : node.getValueArguments()) {
            block35: {
                block37: {
                    block38: {
                        block36: {
                            block34: {
                                if (this.getTestFileDeclaration(argument) == null) continue;
                                v0 = testFile.getMethodName();
                                if (v0 == null) {
                                    v1 = testFile.getMethodIdentifier();
                                    v0 = fileType = v1 != null ? v1.getName() : null;
                                }
                                if (!(((Collection)(testArgs = testFile.getValueArguments())).isEmpty() == false) || this.evaluateString((UElement)CollectionsKt.last((List)testArgs)) == null) continue;
                                path = null;
                                if (testArgs.size() <= 1) break block34;
                                first = (UExpression)CollectionsKt.first((List)testArgs);
                                path = this.evaluateString((UElement)first);
                                if (path != null) break block35;
                                v2 = first.getSourcePsi();
                                text = v2 != null ? v2.getText() : null;
                                v3 = text;
                                if (v3 == null) ** GOTO lbl-1000
                                var19_26 = v3;
                                v4 = Locale.US;
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"US");
                                v5 = var19_26.toUpperCase(v4);
                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"this as java.lang.String).toUpperCase(locale)");
                                v3 = v5;
                                if (v5 != null) {
                                    v6 = StringsKt.contains$default((CharSequence)((CharSequence)v3), (CharSequence)"MANIFEST", (boolean)false, (int)2, null);
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v6 = false;
                                }
                                if (!v6) break block35;
                                path = "AndroidManifest.xml";
                                if (outputMap.containsKey("src/main/AndroidManifest.xml")) {
                                    path = "src/main/AndroidManifest.xml";
                                }
                                break block35;
                            }
                            if (!Intrinsics.areEqual((Object)fileType, (Object)"gradle")) break block36;
                            path = "build.gradle";
                            break block35;
                        }
                        relative = null;
                        text = fileType;
                        if (text == null) break block37;
                        switch (text.hashCode()) {
                            case 3254818: {
                                if (text.equals("java")) break;
                                ** break;
                            }
                            case 130625071: {
                                if (!text.equals("manifest")) {
                                    ** break;
                                }
                                break block38;
                            }
                            case -1125574399: {
                                if (!text.equals("kotlin")) ** break;
                                className = new Companion.ClassName(source);
                                relative = className.relativePath(".kt");
                                ** break;
                            }
                        }
                        className = new Companion.ClassName(source);
                        relative = className.relativePath(".java");
                        ** break;
                    }
                    relative = "AndroidManifest.xml";
                }
                if (relative != null && outputMap.get(path = "src/" + relative) == null) {
                    for (String p : outputMap.keySet()) {
                        if (!StringsKt.endsWith$default((String)p, (String)relative, (boolean)false, (int)2, null)) continue;
                        path = p;
                        break;
                    }
                }
            }
            if (StringsKt.contains$default((CharSequence)source, (CharSequence)"HIDE-FROM-DOCUMENTATION", (boolean)false, (int)2, null)) continue;
            lang = this.getLanguage((String)path);
            contents = Intrinsics.areEqual((Object)lang, (Object)"xml") != false ? this.escapeXml(source) : source;
            exampleFile = new ExampleFile((String)path, contents, lang);
            exampleFiles.add(exampleFile);
        }
        if (suppress) {
            block31: {
                $this$any$iv = exampleFiles;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v7 = false;
                } else {
                    for (E element$iv : $this$any$iv) {
                        it = (ExampleFile)element$iv;
                        $i$a$-any-LintIssueDocGenerator$findExample$2 = false;
                        if (!this.containsSuppress(it.getSource(), issue)) continue;
                        v7 = true;
                        break block31;
                    }
                    v7 = false;
                }
            }
            if (v7) {
                v8 = issue.getImplementation().getDetectorClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"issue.implementation.detectorClass.simpleName");
                return new Example(v8, method.getName(), file, exampleFiles, null, inferred);
            }
            return null;
        }
        errors = new StringBuilder();
        for (ExampleFile exampleFile : exampleFiles) {
            if (exampleFile.getPath() == null) continue;
            v9 = outputMap.get(path);
            if (v9 == null) {
                $this$findExample_u24lambda_u2d54 = this;
                $i$a$-run-LintIssueDocGenerator$findExample$warnings$1 = false;
                m = empty = MapsKt.emptyMap();
                for (Map.Entry<String, Map<Integer, List<String>>> var21_29 : outputMap.entrySet()) {
                    p = var21_29.getKey();
                    v = var21_29.getValue();
                    if (!StringsKt.endsWith$default((String)p, (String)path, (boolean)false, (int)2, null)) continue;
                    m = v;
                    break;
                }
                if (m == empty) {
                    for (Map.Entry<String, Map<Integer, List<String>>> var21_29 : outputMap.entrySet()) {
                        p = var21_29.getKey();
                        v = var21_29.getValue();
                        if (!StringsKt.startsWith$default((String)path, (String)p, (boolean)false, (int)2, null)) continue;
                        m = v;
                        break;
                    }
                }
                v9 = m;
            }
            warnings = v9;
            if (inferred && warnings.isEmpty()) continue;
            var14_15 = CollectionsKt.sorted((Iterable)warnings.keySet()).iterator();
            while (var14_15.hasNext()) {
                line = ((Number)var14_15.next()).intValue();
                if ((List)warnings.get(line) == null) continue;
                wrapped = line != -1 ? this.wrap(path + ":" + line + ":" + list.get(0)) : this.wrap(path + ":" + list.get(0));
                errors.append(wrapped).append('\n');
                if (list.size() >= 3) {
                    block33: {
                        block32: {
                            sourceLine = (String)list.get(1);
                            underline = (String)list.get(2);
                            $this$indexOfFirst$iv = (CharSequence)sourceLine;
                            $i$f$indexOfFirst = false;
                            var24_37 = $this$indexOfFirst$iv.length();
                            for (index$iv = 0; index$iv < var24_37; ++index$iv) {
                                it = $this$indexOfFirst$iv.charAt(index$iv);
                                $i$a$-indexOfFirst-LintIssueDocGenerator$findExample$index1$1 = false;
                                if (!(CharsKt.isWhitespace((char)it) == false)) continue;
                                v10 = index$iv;
                                break block32;
                            }
                            v10 = -1;
                        }
                        index1 = v10;
                        $this$indexOfFirst$iv = (CharSequence)underline;
                        $i$f$indexOfFirst = false;
                        var25_38 = $this$indexOfFirst$iv.length();
                        for (index$iv = 0; index$iv < var25_38; ++index$iv) {
                            it = $this$indexOfFirst$iv.charAt(index$iv);
                            $i$a$-indexOfFirst-LintIssueDocGenerator$findExample$index2$1 = false;
                            if (!(CharsKt.isWhitespace((char)it) == false)) continue;
                            v11 = index$iv;
                            break block33;
                        }
                        v11 = -1;
                    }
                    index2 = v11;
                    index = Math.min(index1, index2);
                    minIndent = 4;
                    if (index > minIndent) {
                        v12 = sourceLine.substring(0, minIndent);
                        Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        v13 = sourceLine.substring(index);
                        Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"this as java.lang.String).substring(startIndex)");
                        sourceLine = v12 + v13;
                        v14 = underline.substring(0, minIndent);
                        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        v15 = underline.substring(index);
                        Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"this as java.lang.String).substring(startIndex)");
                        underline = v14 + v15;
                    }
                    this.appendXml(errors, (String)sourceLine).append('\n');
                    if (this.format == DocFormat.MARKDEEP) {
                        errors.append(StringsKt.replace$default((String)underline, (char)'~', (char)'-', (boolean)false, (int)4, null)).append('\n');
                    } else {
                        errors.append((String)underline);
                    }
                }
                errors.append("\n\n");
            }
            if (!inferred) continue;
            v16 = issue.getImplementation().getDetectorClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"issue.implementation.detectorClass.simpleName");
            return new Example(v16, method.getName(), file, CollectionsKt.listOf((Object)exampleFile), errors.toString(), true);
        }
        if (!inferred && ((Collection)exampleFiles).isEmpty() == false) {
            v17 = issue.getImplementation().getDetectorClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"issue.implementation.detectorClass.simpleName");
            return new Example(v17, method.getName(), file, exampleFiles, errors.toString(), false);
        }
        return null;
    }

    private final String evaluateString(UElement element) {
        ConstantEvaluator evaluator = new ConstantEvaluator();
        evaluator.allowUnknowns();
        evaluator.allowFieldInitializers();
        Object object = evaluator.evaluate(element);
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return null;
        }
        String value = string;
        return StringsKt.replace$default((String)StringsKt.trimIndent((String)value), (char)'\uff04', (char)'$', (boolean)false, (int)4, null);
    }

    private final boolean containsSuppress(String source, Issue issue) {
        return StringsKt.contains$default((CharSequence)source, (CharSequence)issue.getId(), (boolean)false, (int)2, null) && (StringsKt.contains$default((CharSequence)source, (CharSequence)"@Suppress", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)source, (CharSequence)":ignore", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)source, (CharSequence)"noinspection", (boolean)false, (int)2, null));
    }

    private final String getLanguage(String path) {
        if (path == null) {
            return "text";
        }
        return StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".kts", (boolean)false, (int)2, null) ? "kotlin" : (StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null) ? "java" : (StringsKt.endsWith$default((String)path, (String)".gradle", (boolean)false, (int)2, null) ? "groovy" : (StringsKt.endsWith$default((String)path, (String)".xml", (boolean)false, (int)2, null) ? "xml" : "")));
    }

    private final StringBuilder appendXml(StringBuilder $this$appendXml, String s) {
        $this$appendXml.append(this.escapeXml(s));
        return $this$appendXml;
    }

    private final String escapeXml(String s) {
        return this.format == DocFormat.MARKDEEP ? StringsKt.replace$default((String)StringsKt.replace$default((String)s, (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null) : s;
    }

    private final Map<String, Map<Integer, List<String>>> computeResultMap(Issue issue, String expected) {
        HashMap map = new HashMap();
        int index = 0;
        while ((index = StringsKt.indexOf$default((CharSequence)expected, (String)("[" + issue.getId() + "]"), (int)(index + 1), (boolean)false, (int)4, null)) != -1) {
            Map map2;
            String sourceLine1;
            String line2;
            int lineBegin = StringsKt.lastIndexOf$default((CharSequence)expected, (char)'\n', (int)index, (boolean)false, (int)4, null) + 1;
            int it = StringsKt.indexOf$default((CharSequence)expected, (char)'\n', (int)index, (boolean)false, (int)4, null);
            boolean bl = false;
            int lineEnd = it == -1 ? expected.length() : it;
            Intrinsics.checkNotNullExpressionValue((Object)expected.substring(lineBegin, lineEnd), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Matcher matcher = MESSAGE_PATTERN.matcher(line2);
            if (!matcher.find()) continue;
            String path = null;
            int lineNumber = 0;
            String location = matcher.group(1);
            Matcher locationMatcher = LOCATION_PATTERN.matcher(location);
            if (locationMatcher.find()) {
                String string = locationMatcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"locationMatcher.group(1)");
                path = string;
                String string2 = locationMatcher.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"locationMatcher.group(2)");
                lineNumber = Integer.parseInt(string2);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location");
                path = location;
                lineNumber = -1;
            }
            int nextStart = lineEnd + 1;
            int it2 = StringsKt.indexOf$default((CharSequence)expected, (char)'\n', (int)nextStart, (boolean)false, (int)4, null);
            boolean bl2 = false;
            int nextEnd = it2 == -1 ? expected.length() : it2;
            Intrinsics.checkNotNullExpressionValue((Object)expected.substring(nextStart, nextEnd), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            ArrayList<String> strings = new ArrayList<String>();
            String string = line2.substring(matcher.start(2));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            strings.add(string);
            if (!MESSAGE_PATTERN.matcher(sourceLine1).matches()) {
                String sourceLine2;
                int nextStart2 = Math.min(expected.length(), nextEnd + 1);
                int it3 = StringsKt.indexOf$default((CharSequence)expected, (char)'\n', (int)nextStart2, (boolean)false, (int)4, null);
                boolean bl3 = false;
                int nextEnd2 = it3 == -1 ? expected.length() : it3;
                Intrinsics.checkNotNullExpressionValue((Object)expected.substring(nextStart2, nextEnd2), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                strings.add(sourceLine1);
                strings.add(sourceLine2);
            }
            if ((map2 = (Map)map.get(path)) == null) {
                HashMap hashMap;
                HashMap it4 = hashMap = new HashMap();
                boolean bl4 = false;
                ((Map)map).put(path, it4);
                map2 = hashMap;
            }
            Map lineNumberMap = map2;
            Integer n = lineNumber;
            lineNumberMap.put(n, strings);
        }
        return map;
    }

    private final boolean canAnalyzeInEditor(Issue issue) {
        boolean bl;
        block1: {
            EnumSet[] allScopes;
            Implementation implementation = issue.getImplementation();
            EnumSet[] enumSetArray = implementation.getAnalysisScopes();
            Intrinsics.checkNotNullExpressionValue((Object)enumSetArray, (String)"implementation.analysisScopes");
            EnumSet[] $this$any$iv = allScopes = (EnumSet[])ArraysKt.plus((Object[])enumSetArray, (Object)implementation.getScope());
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                EnumSet element$iv;
                EnumSet it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!Scope.Companion.checkSingleFile(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final String writeSuppressInfo$listIndent(String s) {
        return SdkUtils.wrap((String)s, (int)70, (String)"  ");
    }

    private static final void findSourceFiles$addSourceFile(List<File> files, File file) {
        block4: {
            block3: {
                if (!file.isFile()) break block3;
                String path = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                if (!StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null)) break block4;
                files.add(file);
                break block4;
            }
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        LintIssueDocGenerator.findSourceFiles$addSourceFile(files, it);
                    }
                }
            }
        }
    }

    private static final int initializeExamples$rank(UMethod $this$initializeExamples_u24rank, Set<String> curated1, Set<String> curated2, Set<String> preferred) {
        String name = $this$initializeExamples_u24rank.getName();
        return curated1.contains(name) ? 1 : (curated2.contains(name) ? 2 : (preferred.contains(name) ? 3 : 4));
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @JvmStatic
    public static final int run(@NotNull String[] args, boolean fromLint) {
        return Companion.run(args, fromLint);
    }

    public static final /* synthetic */ int access$findCopyrightYear(LintIssueDocGenerator $this, File file) {
        return $this.findCopyrightYear(file);
    }

    public static final /* synthetic */ void access$initializeExamples(LintIssueDocGenerator $this, IssueData issueData) {
        $this.initializeExamples(issueData);
    }

    public static final /* synthetic */ int access$initializeExamples$rank(UMethod $receiver, Set curated1, Set curated2, Set preferred) {
        return LintIssueDocGenerator.initializeExamples$rank($receiver, curated1, curated2, preferred);
    }

    public static final /* synthetic */ Example access$findExample(LintIssueDocGenerator $this, File file, Issue issue, UMethod method, UCallExpression node, boolean inferred, boolean suppress) {
        return $this.findExample(file, issue, method, node, inferred, suppress);
    }

    public static final /* synthetic */ boolean access$singleIssueDetector(LintIssueDocGenerator $this, Issue issue) {
        return $this.singleIssueDetector(issue);
    }

    public static final /* synthetic */ String access$evaluateString(LintIssueDocGenerator $this, UElement element) {
        return $this.evaluateString(element);
    }

    public static final /* synthetic */ Example access$findExample(LintIssueDocGenerator $this, File file, UCallExpression node, Map outputMap, Issue issue, UMethod method, boolean inferred, boolean suppress) {
        return $this.findExample(file, node, outputMap, issue, method, inferred, suppress);
    }

    static {
        Pattern pattern = Pattern.compile("(.+): (Error|Warning|Information): (.+) \\[(.+)]");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"\"\"(.+): (Error|\u2026mation): (.+) \\[(.+)]\"\"\")");
        MESSAGE_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("(.+):(\\d+)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(\"\"\"(.+):(\\d+)\"\"\")");
        LOCATION_PATTERN = pattern2;
        YEAR_PATTERN = Pattern.compile("\\b(\\d\\d\\d\\d)\\b");
        ANDROID_SUPPORT_SYMBOL_PATTERN = Pattern.compile("\\b(android.support.[a-zA-Z0-9_.]+)\\b");
        PACKAGE_PATTERN = Pattern.compile("package\\s+([\\S&&[^;]]*)");
        CLASS_PATTERN = Pattern.compile("(\\bclass\\b|\\binterface\\b|\\benum class\\b|\\benum\\b|\\bobject\\b)+?\\s*([^\\s:(]+)", 8);
        NUMBER_PATTERN = Pattern.compile("^\\d+\\. ");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/LintIssueDocGenerator$IndexType;", "", "label", "", "filename", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getFilename", "()Ljava/lang/String;", "getLabel", "ALPHABETICAL", "CATEGORY", "VENDOR", "SEVERITY", "YEAR", "lint-cli"})
    private static final class IndexType
    extends Enum<IndexType> {
        @NotNull
        private final String label;
        @NotNull
        private final String filename;
        public static final /* enum */ IndexType ALPHABETICAL = new IndexType("Alphabetical", "index");
        public static final /* enum */ IndexType CATEGORY = new IndexType("By category", "categories");
        public static final /* enum */ IndexType VENDOR = new IndexType("By vendor", "vendors");
        public static final /* enum */ IndexType SEVERITY = new IndexType("By severity", "severity");
        public static final /* enum */ IndexType YEAR = new IndexType("By year", "year");
        private static final /* synthetic */ IndexType[] $VALUES;

        private IndexType(String label, String filename) {
            this.label = label;
            this.filename = filename;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final String getFilename() {
            return this.filename;
        }

        public static IndexType[] values() {
            return (IndexType[])$VALUES.clone();
        }

        public static IndexType valueOf(String value) {
            return Enum.valueOf(IndexType.class, value);
        }

        static {
            $VALUES = indexTypeArray = new IndexType[]{IndexType.ALPHABETICAL, IndexType.CATEGORY, IndexType.VENDOR, IndexType.SEVERITY, IndexType.YEAR};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001KB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\"\u001a\u00020#2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0%2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0%H\u0002J\u001e\u0010)\u001a\u00020#2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010+\u001a\u00020'H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020'0-2\u0006\u0010.\u001a\u00020\u0007H\u0002J\n\u0010/\u001a\u0004\u0018\u00010'H\u0002J\u0010\u00100\u001a\u0004\u0018\u00010\u00072\u0006\u00101\u001a\u00020\u0007J\u0010\u00102\u001a\u0004\u0018\u00010\u00072\u0006\u00101\u001a\u00020\u0007J(\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u00020'0-2\u0006\u00108\u001a\u000209H\u0002J\u001b\u0010:\u001a\u00020#2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070<H\u0007\u00a2\u0006\u0002\u0010=J=\u0010>\u001a\u00020\u00072.\u0010?\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070@0<\"\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070@H\u0002\u00a2\u0006\u0002\u0010AJ=\u0010B\u001a\u00020\u00072.\u0010?\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070@0<\"\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070@H\u0002\u00a2\u0006\u0002\u0010AJ\u0018\u0010C\u001a\u00020#2\u0006\u0010D\u001a\u0002092\b\b\u0002\u0010E\u001a\u00020FJ%\u0010G\u001a\u00020H2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070<2\b\b\u0002\u0010D\u001a\u000209H\u0007\u00a2\u0006\u0002\u0010IJ\f\u0010J\u001a\u000209*\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0019\u0010\u0002R\u0011\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0016\u0010\u001f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/android/tools/lint/LintIssueDocGenerator$Companion;", "", "()V", "ANDROID_SUPPORT_SYMBOL_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "AOSP_CS", "", "getAOSP_CS$annotations", "ARG_HELP", "ARG_INCLUDE_BUILTINS", "ARG_INCLUDE_STATS", "ARG_ISSUES", "ARG_LINT_JARS", "ARG_MD", "ARG_NO_EXAMPLES", "ARG_NO_INDEX", "ARG_NO_SEVERITY", "ARG_NO_SOURCE_LINKS", "ARG_NO_SUPPRESS_INFO", "ARG_OUTPUT", "ARG_SINGLE_DOC", "ARG_SOURCE_URL", "ARG_TEST_SOURCE_URL", "CLASS_PATTERN", "getCLASS_PATTERN$annotations", "LOCATION_PATTERN", "getLOCATION_PATTERN", "()Ljava/util/regex/Pattern;", "MESSAGE_PATTERN", "getMESSAGE_PATTERN", "NUMBER_PATTERN", "PACKAGE_PATTERN", "YEAR_PATTERN", "addAospUrls", "", "sourcePath", "", "", "Ljava/io/File;", "testPath", "addLintJars", "into", "file", "findLintJars", "", "jarPath", "findStudioSource", "getClassName", "source", "getPackage", "getRegistry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "client", "Lcom/android/tools/lint/LintCliClient;", "jars", "includeBuiltins", "", "main", "args", "", "([Ljava/lang/String;)V", "markdeepTable", "rows", "Lkotlin/Pair;", "([Lkotlin/Pair;)Ljava/lang/String;", "markdownTable", "printUsage", "fromLint", "out", "Ljava/io/PrintWriter;", "run", "", "([Ljava/lang/String;Z)I", "isListItem", "ClassName", "lint-cli"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getMESSAGE_PATTERN() {
            return MESSAGE_PATTERN;
        }

        @NotNull
        public final Pattern getLOCATION_PATTERN() {
            return LOCATION_PATTERN;
        }

        private static /* synthetic */ void getAOSP_CS$annotations() {
        }

        private static /* synthetic */ void getCLASS_PATTERN$annotations() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isListItem(String $this$isListItem) {
            if (StringsKt.startsWith$default((String)$this$isListItem, (String)"- ", (boolean)false, (int)2, null)) return true;
            if (StringsKt.startsWith$default((String)$this$isListItem, (String)"* ", (boolean)false, (int)2, null)) return true;
            if (StringsKt.startsWith$default((String)$this$isListItem, (String)"+ ", (boolean)false, (int)2, null)) return true;
            Character c = StringsKt.firstOrNull((CharSequence)$this$isListItem);
            if (c == null) return false;
            if (!Character.isDigit(c.charValue())) return false;
            boolean bl = true;
            if (!bl) return false;
            if (!NUMBER_PATTERN.matcher($this$isListItem).find()) return false;
            return true;
        }

        private final IssueRegistry getRegistry(LintCliClient client, List<? extends File> jars, boolean includeBuiltins) {
            IssueRegistry issueRegistry;
            if (jars.isEmpty()) {
                return (IssueRegistry)new BuiltinIssueRegistry();
            }
            List registries = CollectionsKt.plus((Collection)JarFileIssueRegistry.Factory.get$default((JarFileIssueRegistry.Factory)JarFileIssueRegistry.Factory, (LintClient)client, (Collection)jars, null, null, (boolean)true, (int)12, null), (Iterable)(includeBuiltins ? CollectionsKt.listOf((Object)new BuiltinIssueRegistry()) : CollectionsKt.emptyList()));
            if (registries.isEmpty()) {
                System.out.println((Object)("Could not find any lint issue registries in " + CollectionsKt.joinToString$default((Iterable)jars, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
                issueRegistry = null;
            } else {
                issueRegistry = registries.size() == 1 ? (IssueRegistry)registries.get(0) : (IssueRegistry)new CompositeIssueRegistry(registries);
            }
            return issueRegistry;
        }

        private final File findStudioSource() {
            String root = System.getenv("ADT_SOURCE_TREE");
            if (root != null) {
                return new File(root);
            }
            CodeSource source = LintIssueDocGenerator.class.getProtectionDomain().getCodeSource();
            if (source != null) {
                URL location = source.getLocation();
                try {
                    for (File dir = new File(location.toURI()); dir != null; dir = dir.getParentFile()) {
                        if (!new File(dir, "tools/base/lint").isDirectory()) continue;
                        return dir;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private final void addAospUrls(Map<String, List<File>> sourcePath, Map<String, List<File>> testPath) {
            if (!LintClient.Companion.isUnitTest()) {
                File lintRoot;
                File file;
                File file2 = this.findStudioSource();
                if (file2 != null) {
                    File it = file2;
                    boolean bl = false;
                    file = new File("tools/base/lint");
                } else {
                    file = lintRoot = null;
                }
                if (lintRoot != null) {
                    Map<String, List<File>> map = testPath;
                    String string = "https://cs.android.com/android-studio/platform/tools/base/+/mirror-goog-studio-main:lint/libs/lint-tests/src/test/java/";
                    Object object = new File[]{new File(lintRoot + "/libs/lint-tests/src/test/java")};
                    object = CollectionsKt.mutableListOf((Object[])object);
                    map.put(string, (List<File>)object);
                    map = sourcePath;
                    string = "https://cs.android.com/android-studio/platform/tools/base/+/mirror-goog-studio-main:lint/libs/lint-checks/src/main/java/";
                    object = new File[]{new File(lintRoot + "/libs/lint-checks/src/main/java", lintRoot + "/studio-checks/src/main/java")};
                    object = CollectionsKt.mutableListOf((Object[])object);
                    map.put(string, (List<File>)object);
                }
            } else {
                sourcePath.put("https://cs.android.com/android-studio/platform/tools/base/+/mirror-goog-studio-main:lint/libs/lint-checks/src/main/java/", new ArrayList());
            }
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            int exitCode = com.android.tools.lint.LintIssueDocGenerator$Companion.run$default(this, args, false, 2, null);
            System.exit(exitCode);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final int run(@NotNull String[] args, boolean fromLint) {
            List list2;
            boolean created;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            DocFormat format = DocFormat.MARKDEEP;
            boolean singleDoc = false;
            Object jarPath = null;
            boolean includeStats = false;
            boolean includeIndices = true;
            String outputPath = null;
            List issues = new ArrayList();
            Map sourcePath = new LinkedHashMap();
            Map testPath = new LinkedHashMap();
            boolean includeSuppressInfo = true;
            boolean includeExamples = true;
            boolean includeSourceLinks = true;
            boolean includeBuiltins = false;
            boolean includeSeverityColor = true;
            for (int index = 0; index < args.length; ++index) {
                switch (args[index]) {
                    case "-?": 
                    case "--help": 
                    case "-h": {
                        com.android.tools.lint.LintIssueDocGenerator$Companion.printUsage$default(this, fromLint, null, 2, null);
                        return 2;
                    }
                    case "--single-doc": {
                        singleDoc = true;
                        includeSuppressInfo = false;
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--builtins": {
                        includeBuiltins = true;
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--md": {
                        format = DocFormat.MARKDOWN;
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--no-severity": {
                        includeSeverityColor = false;
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--include-stats": {
                        includeStats = true;
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--no-index": {
                        includeIndices = false;
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--no-suppress-info": {
                        includeSuppressInfo = false;
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--no-examples": {
                        includeExamples = false;
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--no-links": {
                        includeSourceLinks = false;
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--lint-jars": {
                        if (index == args.length - 1) {
                            System.err.println("Missing lint jar path");
                            return 1;
                        }
                        String path = args[++index];
                        jarPath = jarPath != null ? (String)jarPath + File.pathSeparator + path : path;
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--issues": {
                        if (index == args.length - 1) {
                            System.err.println("Missing list of lint issue id's");
                            return 1;
                        }
                        String issueList = args[++index];
                        String[] stringArray = new String[]{","};
                        issues.addAll(StringsKt.split$default((CharSequence)issueList, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--source-url": {
                        File file;
                        String it;
                        Collection collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ArrayList it2;
                        if (index == args.length - 1) {
                            System.err.println("Missing source URL prefix");
                            return 1;
                        }
                        String it3 = args[++index];
                        boolean $i$a$-let-LintIssueDocGenerator$Companion$run$prefix$32 = false;
                        String prefix = ((CharSequence)it3).length() == 0 ? it3 : (Character.isLetter(StringsKt.last((CharSequence)it3)) ? it3 + "/" : it3);
                        if (index == args.length - 1) {
                            System.err.println("Missing source path");
                            return 1;
                        }
                        String path = args[++index];
                        List list3 = (List)sourcePath.get(prefix);
                        if (list3 == null) {
                            ArrayList arrayList;
                            it2 = arrayList = new ArrayList();
                            boolean bl = false;
                            sourcePath.put(prefix, it2);
                            list3 = arrayList;
                        }
                        List list4 = list3;
                        Iterable $i$a$-let-LintIssueDocGenerator$Companion$run$prefix$32 = Lint.splitPath((String)path);
                        List list5 = list4;
                        boolean $i$f$map = false;
                        it2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            String string = (String)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            file = new File(it);
                            collection.add(file.isAbsolute() ? file : file.getAbsoluteFile());
                        }
                        list5.addAll((List)destination$iv$iv);
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--test-url": {
                        File file;
                        String it;
                        Collection collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ArrayList it2;
                        if (index == args.length - 1) {
                            System.err.println("Missing source URL prefix");
                            return 1;
                        }
                        String it3 = args[++index];
                        boolean $i$a$-let-LintIssueDocGenerator$Companion$run$prefix$42 = false;
                        String prefix = ((CharSequence)it3).length() == 0 ? it3 : (Character.isLetter(StringsKt.last((CharSequence)it3)) ? it3 + "/" : it3);
                        if (index == args.length - 1) {
                            System.err.println("Missing source path");
                            return 1;
                        }
                        String path = args[++index];
                        List list6 = (List)testPath.get(prefix);
                        if (list6 == null) {
                            ArrayList $i$f$map = new ArrayList();
                            it2 = $i$f$map;
                            boolean bl = false;
                            testPath.put(prefix, it2);
                            list6 = $i$f$map;
                        }
                        List list4 = list6;
                        Iterable $i$a$-let-LintIssueDocGenerator$Companion$run$prefix$42 = Lint.splitPath((String)path);
                        List list5 = list4;
                        boolean $i$f$map = false;
                        it2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (String)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            file = new File(it);
                            collection.add(file.isAbsolute() ? file : file.getAbsoluteFile());
                        }
                        list5.addAll((List)destination$iv$iv);
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case "--output": {
                        if (index == args.length - 1) {
                            System.err.println("Missing source path");
                            return 1;
                        }
                        String path = args[++index];
                        if (outputPath != null) {
                            System.out.println((Object)("Only one output expected; found both " + outputPath + " and " + path));
                            return 1;
                        }
                        outputPath = path;
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    default: {
                        String arg;
                        System.out.println((Object)("Unknown flag " + arg));
                        com.android.tools.lint.LintIssueDocGenerator$Companion.printUsage$default(this, fromLint, null, 2, null);
                        return 1;
                    }
                }
            }
            if (outputPath == null) {
                System.out.println((Object)"Must specify an output file or folder");
                com.android.tools.lint.LintIssueDocGenerator$Companion.printUsage$default(this, fromLint, null, 2, null);
                return 1;
            }
            File output = new File(outputPath);
            if (output.exists()) {
                if (!singleDoc) {
                    System.out.println((Object)(output + " already exists"));
                } else if (output.exists()) {
                    output.delete();
                }
            } else if (!singleDoc && !(created = output.mkdirs())) {
                System.out.println((Object)("Couldn't create " + output));
                System.exit(10);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            if (jarPath == null) {
                System.out.println((Object)"Note: No lint jars specified: creating documents for the built-in lint checks instead (--builtins)");
                list2 = CollectionsKt.emptyList();
            } else {
                list2 = this.findLintJars((String)jarPath);
            }
            List jars = list2;
            LintCliClient client = LintClient.Companion.isClientNameInitialized() && LintClient.Companion.isUnitTest() ? new LintCliClient("test") : new LintCliClient("generate-docs");
            IssueRegistry issueRegistry = this.getRegistry(client, jars, includeBuiltins);
            if (issueRegistry == null) {
                return 1;
            }
            IssueRegistry registry = issueRegistry;
            if (sourcePath.isEmpty() && registry instanceof BuiltinIssueRegistry) {
                this.addAospUrls(sourcePath, testPath);
            }
            LintIssueDocGenerator generator = new LintIssueDocGenerator(output, registry, issues, singleDoc, format, includeStats, sourcePath, testPath, includeIndices, includeSuppressInfo, includeExamples, includeSourceLinks, includeSeverityColor);
            generator.generate();
            System.out.println((Object)("Wrote issue docs to " + output + (!singleDoc ? File.separator : "")));
            return 0;
        }

        public static /* synthetic */ int run$default(Companion companion, String[] stringArray, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.run(stringArray, bl);
        }

        private final List<File> findLintJars(String jarPath) {
            List files = new ArrayList();
            Iterable $this$forEach$iv = Lint.splitPath((String)jarPath);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String path = (String)element$iv;
                boolean bl = false;
                File file = new File(path);
                if (file.isFile()) {
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                    if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
                        files.add(file);
                        continue;
                    }
                }
                Companion.addLintJars(files, file);
            }
            return files;
        }

        private final void addLintJars(List<File> into, File file) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        Companion.addLintJars(into, it);
                    }
                }
            } else if (file.isFile() && Intrinsics.areEqual((Object)file.getName(), (Object)"lint.jar")) {
                into.add(file);
            }
        }

        private final String markdownTable(Pair<String, String> ... rows) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            int keyWidth = 0;
            int rhsWidth = 0;
            int n = rows.length;
            for (int i = 0; i < n; ++i) {
                Pair<String, String> row = rows[i];
                String value = (String)row.getSecond();
                if (value == null) continue;
                String key = (String)row.getFirst();
                keyWidth = Math.max(keyWidth, key.length());
                rhsWidth = Math.max(rhsWidth, value.length());
            }
            keyWidth = Math.min(keyWidth, 15);
            String formatString = "%-" + keyWidth + "s | %s\n";
            for (Pair<String, String> row : rows) {
                int i;
                String formatted;
                String value;
                if ((String)row.getSecond() == null) continue;
                String key = (String)row.getFirst();
                Object[] objectArray = new Object[]{key, value};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(formatString, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
                sb.append(formatted);
                if (!first) continue;
                first = false;
                int n2 = keyWidth + 1;
                for (i = 0; i < n2; ++i) {
                    sb.append('-');
                }
                sb.append('|');
                n2 = Math.min(72 - keyWidth - 2, rhsWidth + 1);
                for (i = 0; i < n2; ++i) {
                    sb.append('-');
                }
                sb.append('\n');
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        private final String markdeepTable(Pair<String, String> ... rows) {
            StringBuilder sb = new StringBuilder();
            for (Pair<String, String> row : rows) {
                String value;
                if ((String)row.getSecond() == null) continue;
                String key = (String)row.getFirst();
                sb.append(key + "\n:   " + value + "\n");
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        public final void printUsage(boolean fromLint, @NotNull PrintWriter out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            String command = fromLint ? "lint --generate-docs" : "lint-issue-docs-generator";
            out.println("Usage: " + command + " [flags] --output <directory or file>]");
            out.println();
            out.println("Flags:");
            out.println();
            String[] stringArray = new String[]{LintIssueDocGenerator.ARG_HELP, "This message.", "--output <dir>", "Sets the path to write the documentation to. Normally a directory, unless --single-doc is also specified", LintIssueDocGenerator.ARG_SINGLE_DOC, "Instead of writing one page per issue into a directory, write a single page containing all the issues", LintIssueDocGenerator.ARG_MD, "Write to plain Markdown (.md) files instead of Markdeep (.md.html)", LintIssueDocGenerator.ARG_INCLUDE_BUILTINS, "Generate documentation for the built-in issues. This is implied if --lint-jars is not specified", "--lint-jars <jar-path>", "Read the lint issues from the specific path (separated by " + File.pathSeparator + " of custom jar files", "--issues [issues]", "Limits the issues documented to the specific (comma-separated) list of issue id's", "--source-url <url-prefix> <path>", "Searches for the detector source code under the given source folder or folders separated by semicolons, and if found, prefixes the path with the given URL prefix and includes this source link in the issue documentation.", "--test-url <url-prefix> <path>", "Like --source-url, but for detector unit tests instead. These must be named the same as the detector class, plus `Test` as a suffix.", LintIssueDocGenerator.ARG_NO_INDEX, "Do not include index files", LintIssueDocGenerator.ARG_NO_SUPPRESS_INFO, "Do not include suppression information", LintIssueDocGenerator.ARG_NO_EXAMPLES, "Do not include examples pulled from unit tests, if found", LintIssueDocGenerator.ARG_NO_SOURCE_LINKS, "Do not include hyperlinks to detector source code", LintIssueDocGenerator.ARG_NO_SEVERITY, "Do not include the red, orange or green informational boxes showing the severity of each issue"};
            Main.printUsage(out, stringArray, false);
        }

        public static /* synthetic */ void printUsage$default(Companion companion, boolean bl, PrintWriter printWriter, int n, Object object) {
            if ((n & 2) != 0) {
                PrintStream printStream = System.out;
                Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
                printWriter = LintCliClient.Companion.printWriter(printStream);
            }
            companion.printUsage(bl, printWriter);
        }

        @Nullable
        public final String getPackage(@NotNull String source) {
            String string;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Matcher matcher = PACKAGE_PATTERN.matcher(source);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(1)");
                String $this$trim$iv = string2;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            } else {
                string = null;
            }
            return string;
        }

        @Nullable
        public final String getClassName(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Matcher matcher = CLASS_PATTERN.matcher(StringsKt.replace$default((String)source, (char)'\n', (char)' ', (boolean)false, (int)4, null));
            int start = 0;
            while (matcher.find(start)) {
                String cls = matcher.group(2);
                int groupStart = matcher.start(1);
                if (groupStart == 0 || source.charAt(groupStart - 1) != '.' && source.charAt(groupStart - 1) != ':') {
                    String string;
                    String trimmed;
                    int typeParameter;
                    Intrinsics.checkNotNullExpressionValue((Object)cls, (String)"cls");
                    String $this$trim$iv = cls;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    if ((typeParameter = StringsKt.indexOf$default((CharSequence)(trimmed = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (char)'<', (int)0, (boolean)false, (int)6, null)) != -1) {
                        String string2 = trimmed.substring(0, typeParameter);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    } else {
                        string = trimmed;
                    }
                    return string;
                }
                start = matcher.end(2);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/LintIssueDocGenerator$Companion$ClassName;", "", "source", "", "(Ljava/lang/String;)V", "className", "getClassName", "()Ljava/lang/String;", "packageName", "getPackageName", "relativePath", "extension", "stripComments", "stripLineComments", "", "lint-cli"})
        public static final class ClassName {
            @Nullable
            private final String packageName;
            @Nullable
            private final String className;

            public ClassName(@NotNull String source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                String withoutComments = ClassName.stripComments$default(this, source, false, 2, null);
                this.packageName = Companion.getPackage(withoutComments);
                this.className = Companion.getClassName(withoutComments);
            }

            @Nullable
            public final String getPackageName() {
                return this.packageName;
            }

            @Nullable
            public final String getClassName() {
                return this.className;
            }

            @Nullable
            public final String relativePath(@NotNull String extension) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                return this.className == null ? (Intrinsics.areEqual((Object)".kt", (Object)extension) ? (this.packageName != null ? StringsKt.replace$default((String)this.packageName, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/test.kt" : "test.kt") : null) : (this.packageName != null ? StringsKt.replace$default((String)this.packageName, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + this.className + extension : this.className + extension);
            }

            @NotNull
            public final String stripComments(@NotNull String source, boolean stripLineComments) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                StringBuilder sb = new StringBuilder(source.length());
                int state = 0;
                int INIT = 0;
                int INIT_SLASH = 1;
                int LINE_COMMENT = 2;
                int BLOCK_COMMENT = 3;
                int BLOCK_COMMENT_ASTERISK = 4;
                int IN_STRING = 5;
                int IN_STRING_ESCAPE = 6;
                int IN_CHAR = 7;
                int AFTER_CHAR = 8;
                int n = source.length();
                for (int i = 0; i < n; ++i) {
                    char c;
                    char c2 = source.charAt(i);
                    int n2 = state;
                    if (n2 == 0) {
                        c = c2;
                        if (c == '/') {
                            state = INIT_SLASH;
                            continue;
                        }
                        if (c == '\"') {
                            state = IN_STRING;
                            sb.append(c2);
                            continue;
                        }
                        if (c == '\'') {
                            state = IN_CHAR;
                            sb.append(c2);
                            continue;
                        }
                        sb.append(c2);
                        continue;
                    }
                    if (n2 == INIT_SLASH) {
                        if (c2 == '*') {
                            state = BLOCK_COMMENT;
                            continue;
                        }
                        if (c2 == '/' && stripLineComments) {
                            state = LINE_COMMENT;
                            continue;
                        }
                        state = INIT;
                        sb.append('/');
                        sb.append(c2);
                        continue;
                    }
                    if (n2 == LINE_COMMENT) {
                        if (c2 != '\n') continue;
                        state = INIT;
                        continue;
                    }
                    if (n2 == BLOCK_COMMENT) {
                        if (c2 != '*') continue;
                        state = BLOCK_COMMENT_ASTERISK;
                        continue;
                    }
                    if (n2 == BLOCK_COMMENT_ASTERISK) {
                        c = c2;
                        state = c == '/' ? INIT : (c == '*' ? BLOCK_COMMENT_ASTERISK : BLOCK_COMMENT);
                        continue;
                    }
                    if (n2 == IN_STRING) {
                        c = c2;
                        if (c == '\\') {
                            state = IN_STRING_ESCAPE;
                        } else if (c == '\"') {
                            state = INIT;
                        }
                        sb.append(c2);
                        continue;
                    }
                    if (n2 == IN_STRING_ESCAPE) {
                        sb.append(c2);
                        state = IN_STRING;
                        continue;
                    }
                    if (n2 == IN_CHAR) {
                        if (c2 != '\\') {
                            state = AFTER_CHAR;
                        }
                        sb.append(c2);
                        continue;
                    }
                    if (n2 != AFTER_CHAR) continue;
                    sb.append(c2);
                    if (c2 != '\\') continue;
                    state = INIT;
                }
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                return string;
            }

            public static /* synthetic */ String stripComments$default(ClassName className, String string, boolean bl, int n, Object object) {
                if ((n & 2) != 0) {
                    bl = true;
                }
                return className.stripComments(string, bl);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/LintIssueDocGenerator$ExampleFile;", "", "path", "", "source", "language", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLanguage", "()Ljava/lang/String;", "getPath", "getSource", "lint-cli"})
    public static final class ExampleFile {
        @Nullable
        private final String path;
        @NotNull
        private final String source;
        @NotNull
        private final String language;

        public ExampleFile(@Nullable String path, @NotNull String source, @NotNull String language) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            this.path = path;
            this.source = source;
            this.language = language;
        }

        @Nullable
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @NotNull
        public final String getLanguage() {
            return this.language;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/LintIssueDocGenerator$Example;", "", "testClass", "", "testMethod", "file", "Ljava/io/File;", "files", "", "Lcom/android/tools/lint/LintIssueDocGenerator$ExampleFile;", "output", "inferred", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;Ljava/util/List;Ljava/lang/String;Z)V", "getFile", "()Ljava/io/File;", "getFiles", "()Ljava/util/List;", "getInferred", "()Z", "getOutput", "()Ljava/lang/String;", "getTestClass", "getTestMethod", "lint-cli"})
    public static final class Example {
        @NotNull
        private final String testClass;
        @NotNull
        private final String testMethod;
        @NotNull
        private final File file;
        @NotNull
        private final List<ExampleFile> files;
        @Nullable
        private final String output;
        private final boolean inferred;

        public Example(@NotNull String testClass, @NotNull String testMethod, @NotNull File file, @NotNull List<ExampleFile> files, @Nullable String output, boolean inferred) {
            Intrinsics.checkNotNullParameter((Object)testClass, (String)"testClass");
            Intrinsics.checkNotNullParameter((Object)testMethod, (String)"testMethod");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            this.testClass = testClass;
            this.testMethod = testMethod;
            this.file = file;
            this.files = files;
            this.output = output;
            this.inferred = inferred;
        }

        public /* synthetic */ Example(String string, String string2, File file, List list2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                bl = true;
            }
            this(string, string2, file, list2, string3, bl);
        }

        @NotNull
        public final String getTestClass() {
            return this.testClass;
        }

        @NotNull
        public final String getTestMethod() {
            return this.testMethod;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final List<ExampleFile> getFiles() {
            return this.files;
        }

        @Nullable
        public final String getOutput() {
            return this.output;
        }

        public final boolean getInferred() {
            return this.inferred;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0017\"\u0004\b*\u0010\u0019R\u001c\u0010+\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010%\"\u0004\b-\u0010'\u00a8\u0006."}, d2={"Lcom/android/tools/lint/LintIssueDocGenerator$IssueData;", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "(Lcom/android/tools/lint/detector/api/Issue;)V", "copyrightYear", "", "getCopyrightYear", "()I", "setCopyrightYear", "(I)V", "detectorSource", "Ljava/io/File;", "getDetectorSource", "()Ljava/io/File;", "setDetectorSource", "(Ljava/io/File;)V", "detectorTestSource", "getDetectorTestSource", "setDetectorTestSource", "example", "Lcom/android/tools/lint/LintIssueDocGenerator$Example;", "getExample", "()Lcom/android/tools/lint/LintIssueDocGenerator$Example;", "setExample", "(Lcom/android/tools/lint/LintIssueDocGenerator$Example;)V", "getIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "quickFixable", "", "getQuickFixable", "()Z", "setQuickFixable", "(Z)V", "sourceUrl", "", "getSourceUrl", "()Ljava/lang/String;", "setSourceUrl", "(Ljava/lang/String;)V", "suppressExample", "getSuppressExample", "setSuppressExample", "testUrl", "getTestUrl", "setTestUrl", "lint-cli"})
    public static final class IssueData {
        @NotNull
        private final Issue issue;
        @Nullable
        private File detectorSource;
        @Nullable
        private File detectorTestSource;
        @Nullable
        private String sourceUrl;
        @Nullable
        private String testUrl;
        @Nullable
        private Example example;
        @Nullable
        private Example suppressExample;
        private boolean quickFixable;
        private int copyrightYear;

        public IssueData(@NotNull Issue issue) {
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            this.issue = issue;
            this.copyrightYear = -1;
        }

        @NotNull
        public final Issue getIssue() {
            return this.issue;
        }

        @Nullable
        public final File getDetectorSource() {
            return this.detectorSource;
        }

        public final void setDetectorSource(@Nullable File file) {
            this.detectorSource = file;
        }

        @Nullable
        public final File getDetectorTestSource() {
            return this.detectorTestSource;
        }

        public final void setDetectorTestSource(@Nullable File file) {
            this.detectorTestSource = file;
        }

        @Nullable
        public final String getSourceUrl() {
            return this.sourceUrl;
        }

        public final void setSourceUrl(@Nullable String string) {
            this.sourceUrl = string;
        }

        @Nullable
        public final String getTestUrl() {
            return this.testUrl;
        }

        public final void setTestUrl(@Nullable String string) {
            this.testUrl = string;
        }

        @Nullable
        public final Example getExample() {
            return this.example;
        }

        public final void setExample(@Nullable Example example) {
            this.example = example;
        }

        @Nullable
        public final Example getSuppressExample() {
            return this.suppressExample;
        }

        public final void setSuppressExample(@Nullable Example example) {
            this.suppressExample = example;
        }

        public final boolean getQuickFixable() {
            return this.quickFixable;
        }

        public final void setQuickFixable(boolean bl) {
            this.quickFixable = bl;
        }

        public final int getCopyrightYear() {
            return this.copyrightYear;
        }

        public final void setCopyrightYear(int n) {
            this.copyrightYear = n;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/LintIssueDocGenerator$DocFormat;", "", "extension", "", "header", "footer", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "getFooter", "getHeader", "getFileName", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "issueId", "MARKDEEP", "MARKDOWN", "HTML", "lint-cli"})
    public static final class DocFormat
    extends Enum<DocFormat> {
        @NotNull
        private final String extension;
        @NotNull
        private final String header;
        @NotNull
        private final String footer;
        public static final /* enum */ DocFormat MARKDEEP = new DocFormat(".md.html", "<meta charset=\"utf-8\">\n", "<!-- Markdeep: --><style class=\"fallback\">body{visibility:hidden;white-space:pre;font-family:monospace}</style><script src=\"markdeep.min.js\" charset=\"utf-8\"></script><script src=\"https://morgan3d.github.io/markdeep/latest/markdeep.min.js\" charset=\"utf-8\"></script><script>window.alreadyProcessedMarkdeep||(document.body.style.visibility=\"visible\")</script>");
        public static final /* enum */ DocFormat MARKDOWN = new DocFormat("MARKDOWN", 1, ".md", null, null, 6, null);
        public static final /* enum */ DocFormat HTML = new DocFormat("HTML", 2, ".html", null, null, 6, null);
        private static final /* synthetic */ DocFormat[] $VALUES;

        private DocFormat(String extension, String header, String footer) {
            this.extension = extension;
            this.header = header;
            this.footer = footer;
        }

        /* synthetic */ DocFormat(String string, int n, String string2, String string3, String string4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string3 = "";
            }
            if ((n2 & 4) != 0) {
                string4 = "";
            }
            this(string2, string3, string4);
        }

        @NotNull
        public final String getExtension() {
            return this.extension;
        }

        @NotNull
        public final String getHeader() {
            return this.header;
        }

        @NotNull
        public final String getFooter() {
            return this.footer;
        }

        @NotNull
        public final String getFileName(@NotNull String issueId) {
            Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
            return issueId + this.extension;
        }

        @NotNull
        public final String getFileName(@NotNull Issue issue) {
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            return this.getFileName(issue.getId());
        }

        public static DocFormat[] values() {
            return (DocFormat[])$VALUES.clone();
        }

        public static DocFormat valueOf(String value) {
            return Enum.valueOf(DocFormat.class, value);
        }

        static {
            $VALUES = docFormatArray = new DocFormat[]{DocFormat.MARKDEEP, DocFormat.MARKDOWN, DocFormat.HTML};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Scope.values().length];
            nArray[Scope.ALL_RESOURCE_FILES.ordinal()] = 1;
            nArray[Scope.RESOURCE_FILE.ordinal()] = 2;
            nArray[Scope.BINARY_RESOURCE_FILE.ordinal()] = 3;
            nArray[Scope.RESOURCE_FOLDER.ordinal()] = 4;
            nArray[Scope.ALL_JAVA_FILES.ordinal()] = 5;
            nArray[Scope.JAVA_FILE.ordinal()] = 6;
            nArray[Scope.ALL_CLASS_FILES.ordinal()] = 7;
            nArray[Scope.CLASS_FILE.ordinal()] = 8;
            nArray[Scope.MANIFEST.ordinal()] = 9;
            nArray[Scope.PROGUARD_FILE.ordinal()] = 10;
            nArray[Scope.JAVA_LIBRARIES.ordinal()] = 11;
            nArray[Scope.GRADLE_FILE.ordinal()] = 12;
            nArray[Scope.PROPERTY_FILE.ordinal()] = 13;
            nArray[Scope.TEST_SOURCES.ordinal()] = 14;
            nArray[Scope.OTHER.ordinal()] = 15;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Severity.values().length];
            nArray[Severity.FATAL.ordinal()] = 1;
            nArray[Severity.ERROR.ordinal()] = 2;
            nArray[Severity.WARNING.ordinal()] = 3;
            nArray[Severity.INFORMATIONAL.ordinal()] = 4;
            nArray[Severity.IGNORE.ordinal()] = 5;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

