/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ResultClassInReturnTypeCheckerKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ResultTypeWithNullableOperatorsChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ResultTypeWithNullableOperatorsChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Object resultingDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowNullOperatorsForResult)) {
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowNullOperatorsForResultAndResultReturnTypeByDefault)) {
            return;
        }
        Name name2 = resolvedCall2.getResultingDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"resolvedCall.resultingDescriptor.name");
        Name name3 = name2;
        ASTNode operationNode = resolvedCall2.getCall().getCallOperationNode();
        ASTNode aSTNode = operationNode;
        if (Intrinsics.areEqual((Object)(aSTNode == null ? null : aSTNode.getElementType()), (Object)((Object)KtTokens.SAFE_ACCESS))) {
            Annotated annotated;
            ReceiverParameterDescriptor receiverParameterDescriptor;
            resultingDescriptor = resolvedCall2.getResultingDescriptor();
            ReceiverParameterDescriptor receiverParameterDescriptor2 = resultingDescriptor.getExtensionReceiverParameter();
            if (receiverParameterDescriptor2 == null) {
                ReceiverParameterDescriptor receiverParameterDescriptor3 = resultingDescriptor.getDispatchReceiverParameter();
                if (receiverParameterDescriptor3 == null) {
                    return;
                }
                receiverParameterDescriptor = receiverParameterDescriptor3;
            } else {
                receiverParameterDescriptor = receiverParameterDescriptor2;
            }
            ReceiverParameterDescriptor receiver = annotated = receiverParameterDescriptor;
            annotated = receiver.getType();
            Intrinsics.checkNotNullExpressionValue((Object)annotated, (String)"receiver.type");
            if (ResultClassInReturnTypeCheckerKt.isResultType((KotlinType)annotated)) {
                BindingTrace bindingTrace = context2.getTrace();
                ASTNode aSTNode2 = operationNode;
                Intrinsics.checkNotNull((Object)aSTNode2);
                bindingTrace.report(Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(aSTNode2.getPsi(), "?."));
            }
        } else if (Intrinsics.areEqual((Object)name3, (Object)ControlStructureTypingUtils.ResolveConstruct.EXCL_EXCL.getSpecialFunctionName())) {
            resultingDescriptor = resolvedCall2.getResultingDescriptor().getReturnType();
            if (resultingDescriptor == null ? false : ResultClassInReturnTypeCheckerKt.isResultType(resultingDescriptor)) {
                context2.getTrace().report(Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(reportOn, "!!"));
            }
        } else if (Intrinsics.areEqual((Object)name3, (Object)ControlStructureTypingUtils.ResolveConstruct.ELVIS.getSpecialFunctionName())) {
            KtBinaryExpression receiver;
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            KtBinaryExpression ktBinaryExpression = receiver = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
            if (receiver == null) {
                return;
            }
            KtBinaryExpression elvisBinaryExpression = receiver;
            Object object = elvisBinaryExpression.getLeft();
            if (object == null) {
                return;
            }
            KtElement left = ktElement = object;
            Object object2 = context2.getTrace().getType((KtExpression)left);
            if (object2 == null) {
                return;
            }
            object = object2;
            Object leftType = object;
            if (ResultClassInReturnTypeCheckerKt.isResultType((KotlinType)leftType)) {
                BindingTrace bindingTrace = context2.getTrace();
                object = Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(reportOn, "?:");
                Intrinsics.checkNotNullExpressionValue(object, (String)"RESULT_CLASS_WITH_NULLAB\u2026ERATOR.on(reportOn, \"?:\")");
                DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, (Diagnostic)object);
            }
            if (left instanceof KtBinaryExpression) {
                Object object3 = ((KtBinaryExpression)left).getRight();
                if (object3 == null) {
                    return;
                }
                Object lastExpression = object2 = object3;
                KotlinType kotlinType = context2.getTrace().getType((KtExpression)lastExpression);
                if (kotlinType == null) {
                    return;
                }
                object3 = kotlinType;
                Object lastExpressionType = object3;
                if (ResultClassInReturnTypeCheckerKt.isResultType((KotlinType)lastExpressionType)) {
                    BindingTrace bindingTrace = context2.getTrace();
                    object3 = Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(reportOn, "?:");
                    Intrinsics.checkNotNullExpressionValue(object3, (String)"RESULT_CLASS_WITH_NULLAB\u2026ERATOR.on(reportOn, \"?:\")");
                    DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, (Diagnostic)object3);
                }
            }
        }
    }
}

