/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/AnalyzingUtils;", "", "()V", "WRITE_DEBUG_TRACE_NAMES", "", "checkForSyntacticErrors", "", "root", "Lcom/intellij/psi/PsiElement;", "formDebugNameForBindingTrace", "", "debugName", "resolutionSubjectForMessage", "getSyntaxErrorRanges", "", "Lcom/intellij/psi/PsiErrorElement;", "throwExceptionOnErrors", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "PsiErrorElementVisitor", "frontend"})
public final class AnalyzingUtils {
    @NotNull
    public static final AnalyzingUtils INSTANCE = new AnalyzingUtils();
    private static final boolean WRITE_DEBUG_TRACE_NAMES = false;

    private AnalyzingUtils() {
    }

    @JvmStatic
    public static final void checkForSyntacticErrors(@NotNull PsiElement root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        root2.acceptChildren((PsiElementVisitor)new PsiErrorElementVisitor(){

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                throw new IllegalArgumentException(element.getErrorDescription() + "; looking at " + element.getNode().getElementType() + " '" + element.getText() + PsiDiagnosticUtils.atLocation((PsiElement)element));
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final List<PsiErrorElement> getSyntaxErrorRanges(@NotNull PsiElement root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        List r = new ArrayList();
        root2.acceptChildren((PsiElementVisitor)new PsiErrorElementVisitor(r){
            final /* synthetic */ List<PsiErrorElement> $r;
            {
                this.$r = $r;
            }

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                this.$r.add(element);
            }
        });
        return r;
    }

    public final void throwExceptionOnErrors(@NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Diagnostics diagnostics2 = bindingContext.getDiagnostics();
        Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"bindingContext.diagnostics");
        this.throwExceptionOnErrors(diagnostics2);
    }

    public final void throwExceptionOnErrors(@NotNull Diagnostics diagnostics2) {
        Intrinsics.checkNotNullParameter((Object)diagnostics2, (String)"diagnostics");
        for (Diagnostic diagnostic : diagnostics2) {
            DiagnosticSink.THROW_EXCEPTION.report(diagnostic);
        }
    }

    @JvmStatic
    @NotNull
    public static final String formDebugNameForBindingTrace(@NotNull String debugName, @Nullable Object resolutionSubjectForMessage) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        return "";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/AnalyzingUtils$PsiErrorElementVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "()V", "visitErrorElement", "", "element", "Lcom/intellij/psi/PsiErrorElement;", "frontend"})
    public static abstract class PsiErrorElementVisitor
    extends KtTreeVisitorVoid {
        public abstract void visitErrorElement(@NotNull PsiErrorElement var1);
    }
}

