/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.builders;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014JB\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010\u0017\u001a\u00020\u0006J\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010\u001b\u001a\u00020\u000e2\b\b\u0002\u0010\u001c\u001a\u00020\u000e2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u001d\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/builders/Scope;", "", "scopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)V", "lastTemporaryIndex", "", "getScopeOwnerSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "createTemporaryVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "irExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "nameHint", "", "isMutable", "", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "createTemporaryVariableDeclaration", "startOffset", "endOffset", "getLocalDeclarationParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "getNameForTemporary", "inventNameForTemporary", "prefix", "nextTemporaryIndex", "ir.tree"})
public final class Scope {
    @NotNull
    private final IrSymbol scopeOwnerSymbol;
    private int lastTemporaryIndex;

    public Scope(@NotNull IrSymbol scopeOwnerSymbol) {
        Intrinsics.checkNotNullParameter((Object)scopeOwnerSymbol, (String)"scopeOwnerSymbol");
        this.scopeOwnerSymbol = scopeOwnerSymbol;
    }

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        return this.scopeOwnerSymbol;
    }

    @NotNull
    public final IrDeclarationParent getLocalDeclarationParent() {
        IrDeclarationParent irDeclarationParent;
        if (!this.scopeOwnerSymbol.isBound()) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unbound symbol: ", (Object)this.scopeOwnerSymbol));
        }
        IrSymbolOwner scopeOwnerElement = this.scopeOwnerSymbol.getOwner();
        if (scopeOwnerElement instanceof IrDeclarationParent) {
            irDeclarationParent = (IrDeclarationParent)((Object)scopeOwnerElement);
        } else {
            if (!(scopeOwnerElement instanceof IrDeclaration)) {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"Not a declaration: ", (Object)scopeOwnerElement));
            }
            irDeclarationParent = ((IrDeclaration)scopeOwnerElement).getParent();
        }
        return irDeclarationParent;
    }

    private final int nextTemporaryIndex() {
        Scope scope2 = this;
        int n = scope2.lastTemporaryIndex;
        scope2.lastTemporaryIndex = n + 1;
        return n;
    }

    @NotNull
    public final String inventNameForTemporary(@NotNull String prefix, @Nullable String nameHint) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        int index2 = this.nextTemporaryIndex();
        return nameHint != null ? prefix + index2 + '_' + nameHint : Intrinsics.stringPlus((String)prefix, (Object)index2);
    }

    public static /* synthetic */ String inventNameForTemporary$default(Scope scope2, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "tmp";
        }
        if ((n & 2) != 0) {
            string3 = null;
        }
        return scope2.inventNameForTemporary(string2, string3);
    }

    private final String getNameForTemporary(String nameHint) {
        return this.inventNameForTemporary("tmp", nameHint);
    }

    @NotNull
    public final IrVariable createTemporaryVariableDeclaration(@NotNull IrType irType, @Nullable String nameHint, boolean isMutable, @NotNull IrDeclarationOrigin origin, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Object object = Name.identifier(this.getNameForTemporary(nameHint));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(getNameForTemporary(nameHint))");
        Name name2 = object;
        Object $this$createTemporaryVariableDeclaration_u24lambda_u2d0 = object = new IrVariableImpl(startOffset, endOffset, origin, new IrVariableSymbolImpl(null, 1, null), name2, irType, isMutable, false, false);
        boolean bl = false;
        ((IrVariableImpl)$this$createTemporaryVariableDeclaration_u24lambda_u2d0).setParent(this.getLocalDeclarationParent());
        return (IrVariable)object;
    }

    public static /* synthetic */ IrVariable createTemporaryVariableDeclaration$default(Scope scope2, IrType irType, String string2, boolean bl, IrDeclarationOrigin irDeclarationOrigin, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string2 = null;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            irDeclarationOrigin = IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE;
        }
        if ((n3 & 0x10) != 0) {
            n = -1;
        }
        if ((n3 & 0x20) != 0) {
            n2 = -1;
        }
        return scope2.createTemporaryVariableDeclaration(irType, string2, bl, irDeclarationOrigin, n, n2);
    }

    @NotNull
    public final IrVariable createTemporaryVariable(@NotNull IrExpression irExpression, @Nullable String nameHint, boolean isMutable, @NotNull IrDeclarationOrigin origin, @Nullable IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irExpression, (String)"irExpression");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        IrAnnotationContainer irAnnotationContainer = irType;
        IrAnnotationContainer $this$createTemporaryVariable_u24lambda_u2d1 = irAnnotationContainer = this.createTemporaryVariableDeclaration((IrType)(irAnnotationContainer == null ? irExpression.getType() : irAnnotationContainer), nameHint, isMutable, origin, irExpression.getStartOffset(), irExpression.getEndOffset());
        boolean bl = false;
        ((IrVariable)$this$createTemporaryVariable_u24lambda_u2d1).setInitializer(irExpression);
        return irAnnotationContainer;
    }

    public static /* synthetic */ IrVariable createTemporaryVariable$default(Scope scope2, IrExpression irExpression, String string2, boolean bl, IrDeclarationOrigin irDeclarationOrigin, IrType irType, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            irDeclarationOrigin = IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            irType = null;
        }
        return scope2.createTemporaryVariable(irExpression, string2, bl, irDeclarationOrigin, irType);
    }
}

