/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.scopes.FirCompositeScope;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ScopesKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00018\u0001H\u0014\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0014\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010#J\u001d\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J\u001d\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010+J'\u0010,\u001a\u0002H-\"\b\b\u0002\u0010-*\u00020.2\u0006\u0010/\u001a\u0002H-2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00100J\u001d\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00104J\u001d\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00108J\u001d\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020;2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010<J\u001d\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010@J\u001d\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020B2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010DJ\u001d\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020F2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010HJ\u001d\u0010I\u001a\u00020 2\u0006\u0010J\u001a\u00020K2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010LR\u001a\u0010\t\u001a\u00020\nX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirAbstractAnnotationResolveTransformer;", "D", "S", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "scope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "getScope", "()Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "setScope", "(Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "afterChildren", "", "state", "(Ljava/lang/Object;)V", "beforeChildren", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Object;", "transformAnnotatedDeclaration", "annotatedDeclaration", "data", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "transformAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "transformAnnotationContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "annotationContainer", "(Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "transformConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "(Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "transformProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "transformRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "transformSimpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "simpleFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "transformTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "transformTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "typeRef", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "transformValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "resolve"})
public abstract class FirAbstractAnnotationResolveTransformer<D, S>
extends FirDefaultTransformer<D> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    protected FirScope scope;

    public FirAbstractAnnotationResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        this.session = session2;
        this.scopeSession = scopeSession;
    }

    @NotNull
    protected final FirSession getSession() {
        return this.session;
    }

    @NotNull
    protected final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @Override
    @NotNull
    public abstract FirStatement transformAnnotationCall(@NotNull FirAnnotationCall var1, D var2);

    @NotNull
    protected final FirScope getScope() {
        FirScope firScope = this.scope;
        if (firScope != null) {
            return firScope;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scope");
        return null;
    }

    protected final void setScope(@NotNull FirScope firScope) {
        Intrinsics.checkNotNullParameter((Object)firScope, (String)"<set-?>");
        this.scope = firScope;
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, D data) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.setScope(new FirCompositeScope((Iterable<? extends FirScope>)ScopesKt.createImportingScopes(file2, this.session, this.scopeSession, false)));
        S state = this.beforeChildren(file2);
        file2.transformDeclarations(this, data);
        this.afterChildren(state);
        return (FirFile)this.transformAnnotatedDeclaration(file2, data);
    }

    @Override
    @NotNull
    public FirProperty transformProperty(@NotNull FirProperty property2, D data) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        return (FirProperty)this.transformAnnotatedDeclaration(property2, data);
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, D data) {
        FirAnnotatedDeclaration firAnnotatedDeclaration;
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        FirAnnotatedDeclaration it = firAnnotatedDeclaration = this.transformAnnotatedDeclaration(regularClass, data);
        boolean bl = false;
        S state = this.beforeChildren(regularClass);
        regularClass.transformDeclarations(this, data);
        regularClass.transformCompanionObject(this, data);
        regularClass.transformSuperTypeRefs(this, data);
        this.afterChildren(state);
        return (FirStatement)((Object)firAnnotatedDeclaration);
    }

    @Override
    @NotNull
    public FirSimpleFunction transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, D data) {
        FirAnnotatedDeclaration firAnnotatedDeclaration;
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        FirAnnotatedDeclaration it = firAnnotatedDeclaration = this.transformAnnotatedDeclaration(simpleFunction, data);
        boolean bl = false;
        S state = this.beforeChildren(simpleFunction);
        simpleFunction.transformValueParameters(this, data);
        this.afterChildren(state);
        return (FirSimpleFunction)firAnnotatedDeclaration;
    }

    @Override
    @NotNull
    public FirConstructor transformConstructor(@NotNull FirConstructor constructor2, D data) {
        FirAnnotatedDeclaration firAnnotatedDeclaration;
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        FirAnnotatedDeclaration it = firAnnotatedDeclaration = this.transformAnnotatedDeclaration(constructor2, data);
        boolean bl = false;
        S state = this.beforeChildren(constructor2);
        constructor2.transformValueParameters(this, data);
        this.afterChildren(state);
        return (FirConstructor)firAnnotatedDeclaration;
    }

    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, D data) {
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        return (FirStatement)((Object)this.transformAnnotatedDeclaration(valueParameter2, data));
    }

    @Override
    @NotNull
    public FirTypeAlias transformTypeAlias(@NotNull FirTypeAlias typeAlias, D data) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        return (FirTypeAlias)this.transformAnnotatedDeclaration(typeAlias, data);
    }

    @Override
    @NotNull
    public FirTypeRef transformTypeRef(@NotNull FirTypeRef typeRef, D data) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        return (FirTypeRef)this.transformAnnotationContainer(typeRef, data);
    }

    @Override
    @NotNull
    public FirAnnotatedDeclaration transformAnnotatedDeclaration(@NotNull FirAnnotatedDeclaration annotatedDeclaration, D data) {
        Intrinsics.checkNotNullParameter((Object)annotatedDeclaration, (String)"annotatedDeclaration");
        return (FirAnnotatedDeclaration)this.transformAnnotationContainer(annotatedDeclaration, data);
    }

    @Override
    @NotNull
    public FirAnnotationContainer transformAnnotationContainer(@NotNull FirAnnotationContainer annotationContainer, D data) {
        Intrinsics.checkNotNullParameter((Object)annotationContainer, (String)"annotationContainer");
        return annotationContainer.transformAnnotations(this, data);
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, D data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element;
    }

    @Nullable
    protected S beforeChildren(@NotNull FirAnnotatedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return null;
    }

    protected void afterChildren(@Nullable S state) {
    }
}

