/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.jvm;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractConeCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractConeCallConflictResolver;", "specificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "inferenceComponents", "Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;)V", "areEquivalentTopLevelCallables", "", "first", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "firstCandidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "second", "secondCandidate", "chooseMaximallySpecificCandidates", "", "candidates", "discriminateGenerics", "discriminateAbstracts", "createFlatSignature", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "call", "declaration", "filterOutEquivalentCalls", "", "jvm"})
public final class ConeEquivalentCallConflictResolver
extends AbstractConeCallConflictResolver {
    public ConeEquivalentCallConflictResolver(@NotNull TypeSpecificityComparator specificityComparator, @NotNull InferenceComponents inferenceComponents) {
        Intrinsics.checkNotNullParameter((Object)specificityComparator, (String)"specificityComparator");
        Intrinsics.checkNotNullParameter((Object)inferenceComponents, (String)"inferenceComponents");
        super(specificityComparator, inferenceComponents);
    }

    @Override
    @NotNull
    public Set<Candidate> chooseMaximallySpecificCandidates(@NotNull Set<Candidate> candidates2, boolean discriminateGenerics, boolean discriminateAbstracts) {
        Intrinsics.checkNotNullParameter(candidates2, (String)"candidates");
        return this.filterOutEquivalentCalls((Collection<Candidate>)candidates2);
    }

    private final Set<Candidate> filterOutEquivalentCalls(Collection<Candidate> candidates2) {
        Set result2 = new LinkedHashSet();
        block0: for (Candidate myCandidate : candidates2) {
            Object me = myCandidate.getSymbol().getFir();
            if (me instanceof FirCallableDeclaration && ClassMembersKt.containingClass(((FirCallableDeclaration)me).getSymbol()) == null) {
                for (Candidate otherCandidate : result2) {
                    Object other = otherCandidate.getSymbol().getFir();
                    if (!(other instanceof FirCallableDeclaration) || ClassMembersKt.containingClass(((FirCallableDeclaration)other).getSymbol()) != null || !this.areEquivalentTopLevelCallables((FirCallableDeclaration)me, myCandidate, (FirCallableDeclaration)other, otherCandidate)) continue;
                    continue block0;
                }
            }
            Collection collection = result2;
            collection.add(myCandidate);
        }
        return result2;
    }

    private final boolean areEquivalentTopLevelCallables(FirCallableDeclaration first, Candidate firstCandidate, FirCallableDeclaration second, Candidate secondCandidate) {
        FlatSignature<Candidate> secondSignature;
        if (!Intrinsics.areEqual((Object)first.getSymbol().getCallableId(), (Object)second.getSymbol().getCallableId())) {
            return false;
        }
        FirElement $this$isExpect$iv = first;
        boolean $i$f$isExpect = false;
        boolean bl = $this$isExpect$iv.getStatus().isExpect();
        $this$isExpect$iv = second;
        $i$f$isExpect = false;
        if (bl != $this$isExpect$iv.getStatus().isExpect()) {
            return false;
        }
        $this$isExpect$iv = first.getReceiverTypeRef();
        if (!Intrinsics.areEqual((Object)($this$isExpect$iv == null ? null : FirTypeUtilsKt.getConeType((FirTypeRef)$this$isExpect$iv)), (Object)(($this$isExpect$iv = second.getReceiverTypeRef()) == null ? null : FirTypeUtilsKt.getConeType((FirTypeRef)$this$isExpect$iv)))) {
            return false;
        }
        FlatSignature<Candidate> firstSignature = this.createFlatSignature(firstCandidate, first);
        return this.compareCallsByUsedArguments(firstSignature, secondSignature = this.createFlatSignature(secondCandidate, second), false) && this.compareCallsByUsedArguments(secondSignature, firstSignature, false);
    }

    private final FlatSignature<Candidate> createFlatSignature(Candidate call2, FirCallableDeclaration declaration) {
        FlatSignature<Candidate> flatSignature;
        FirCallableDeclaration firCallableDeclaration = declaration;
        if (firCallableDeclaration instanceof FirSimpleFunction) {
            flatSignature = this.createFlatSignature(call2, (FirSimpleFunction)declaration);
        } else if (firCallableDeclaration instanceof FirConstructor) {
            flatSignature = this.createFlatSignature(call2, (FirConstructor)declaration);
        } else if (firCallableDeclaration instanceof FirVariable) {
            flatSignature = this.createFlatSignature(call2, (FirVariable)declaration);
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Not supported: ", (Object)declaration).toString());
        }
        return flatSignature;
    }
}

