/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u0014\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0005J\b\u0010\u001e\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u001f\u001a\u00020\u0011J\u0006\u0010 \u001a\u00020\u0011J\b\u0010!\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u000eJ\u0006\u0010%\u001a\u00020\u000bJ\u0016\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J'\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00052\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020/0.\u00a2\u0006\u0002\b0J\u001c\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020\u00072\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/03J6\u00104\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\t2\u0006\u00105\u001a\u0002H\u00142\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020/0.\u00a2\u0006\u0002\b0\u00a2\u0006\u0002\u00106J8\u00107\u001a\u0002H\u0014\"\n\b\u0000\u0010\u0014*\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u0002H\u00142\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020/0.\u00a2\u0006\u0002\b0\u00a2\u0006\u0002\u00108J3\u00109\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000e2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u000f2\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020/0.\u00a2\u0006\u0002\b0J)\u0010;\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\b\u0010<\u001a\u0004\u0018\u00010\u00112\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u001403\u00a2\u0006\u0002\u0010=J)\u0010>\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\b\u0010<\u001a\u0004\u0018\u00010\u00112\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u001403\u00a2\u0006\u0002\u0010=R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "", "()V", "classStack", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "containingFirClassStack", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "functionStack", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "parentStack", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "propertyStack", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "safeCallSubjectVariableStack", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "whenSubjectVariableStack", "applyParentFromStackTo", "T", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "containerFirClass", "containingFileIfAny", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "dispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "irClass", "lastClass", "lastSafeCallSubject", "lastWhenSubject", "parent", "parentAccessorOfPropertyFromStack", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "property", "parentFromStack", "returnTarget", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "withClass", "klass", "f", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "withContainingFirClass", "containingFirClass", "Lkotlin/Function0;", "withFunction", "function", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "withParent", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "withProperty", "firProperty", "withSafeCallSubject", "subject", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withWhenSubject", "fir2ir"})
public final class Fir2IrConversionScope {
    @NotNull
    private final List<IrDeclarationParent> parentStack = new ArrayList();
    @NotNull
    private final List<FirClass> containingFirClassStack = new ArrayList();
    @NotNull
    private final List<IrFunction> functionStack = new ArrayList();
    @NotNull
    private final List<Pair<IrProperty, FirProperty>> propertyStack = new ArrayList();
    @NotNull
    private final List<IrClass> classStack = new ArrayList();
    @NotNull
    private final List<IrVariable> whenSubjectVariableStack = new ArrayList();
    @NotNull
    private final List<IrVariable> safeCallSubjectVariableStack = new ArrayList();

    public final <T extends IrDeclarationParent> T withParent(T parent2, @NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (parent2 == null) {
            return parent2;
        }
        Fir2IrConversionScope fir2IrConversionScope = this;
        Collection collection = fir2IrConversionScope.parentStack;
        collection.add(parent2);
        f.invoke(parent2);
        this.parentStack.remove(this.parentStack.size() - 1);
        return parent2;
    }

    @Nullable
    public final IrFile containingFileIfAny() {
        Object object = CollectionsKt.getOrNull(this.parentStack, (int)0);
        return object instanceof IrFile ? (IrFile)object : null;
    }

    public final void withContainingFirClass(@NotNull FirClass containingFirClass, @NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter((Object)containingFirClass, (String)"containingFirClass");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Fir2IrConversionScope fir2IrConversionScope = this;
        Collection collection = fir2IrConversionScope.containingFirClassStack;
        collection.add(containingFirClass);
        f.invoke();
        this.containingFirClassStack.remove(this.containingFirClassStack.size() - 1);
    }

    @NotNull
    public final IrDeclarationParent parentFromStack() {
        return (IrDeclarationParent)CollectionsKt.last(this.parentStack);
    }

    @Nullable
    public final IrSimpleFunction parentAccessorOfPropertyFromStack(@NotNull IrProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        for (IrDeclarationParent parent2 : CollectionsKt.asReversedMutable(this.parentStack)) {
            IrDeclarationParent irDeclarationParent = parent2;
            if (Intrinsics.areEqual((Object)irDeclarationParent, (Object)property2.getGetter())) {
                return property2.getGetter();
            }
            if (!Intrinsics.areEqual((Object)irDeclarationParent, (Object)property2.getSetter())) continue;
            return property2.getSetter();
        }
        return null;
    }

    @NotNull
    public final <T extends IrDeclaration> T applyParentFromStackTo(@NotNull T declaration) {
        Intrinsics.checkNotNullParameter(declaration, (String)"declaration");
        declaration.setParent((IrDeclarationParent)CollectionsKt.last(this.parentStack));
        return declaration;
    }

    @Nullable
    public final FirClass containerFirClass() {
        return (FirClass)CollectionsKt.lastOrNull(this.containingFirClassStack);
    }

    @NotNull
    public final <T extends IrFunction> T withFunction(@NotNull T function2, @NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkNotNullParameter(function2, (String)"function");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Fir2IrConversionScope fir2IrConversionScope = this;
        Collection collection = fir2IrConversionScope.functionStack;
        collection.add(function2);
        f.invoke(function2);
        this.functionStack.remove(this.functionStack.size() - 1);
        return function2;
    }

    @NotNull
    public final IrProperty withProperty(@NotNull IrProperty property2, @Nullable FirProperty firProperty, @NotNull Function1<? super IrProperty, Unit> f) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Fir2IrConversionScope fir2IrConversionScope = this;
        ((Collection)fir2IrConversionScope.propertyStack).add(TuplesKt.to((Object)property2, (Object)firProperty));
        f.invoke((Object)property2);
        this.propertyStack.remove(this.propertyStack.size() - 1);
        return property2;
    }

    public static /* synthetic */ IrProperty withProperty$default(Fir2IrConversionScope fir2IrConversionScope, IrProperty irProperty2, FirProperty firProperty, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            firProperty = null;
        }
        return fir2IrConversionScope.withProperty(irProperty2, firProperty, (Function1<? super IrProperty, Unit>)function1);
    }

    @NotNull
    public final IrClass withClass(@NotNull IrClass klass, @NotNull Function1<? super IrClass, Unit> f) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Fir2IrConversionScope fir2IrConversionScope = this;
        Collection collection = fir2IrConversionScope.classStack;
        collection.add(klass);
        f.invoke((Object)klass);
        this.classStack.remove(this.classStack.size() - 1);
        return klass;
    }

    public final <T> T withWhenSubject(@Nullable IrVariable subject, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (subject != null) {
            Fir2IrConversionScope fir2IrConversionScope = this;
            Collection collection = fir2IrConversionScope.whenSubjectVariableStack;
            collection.add(subject);
        }
        Object result2 = f.invoke();
        if (subject != null) {
            this.whenSubjectVariableStack.remove(this.whenSubjectVariableStack.size() - 1);
        }
        return (T)result2;
    }

    public final <T> T withSafeCallSubject(@Nullable IrVariable subject, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (subject != null) {
            Fir2IrConversionScope fir2IrConversionScope = this;
            Collection collection = fir2IrConversionScope.safeCallSubjectVariableStack;
            collection.add(subject);
        }
        Object result2 = f.invoke();
        if (subject != null) {
            this.safeCallSubjectVariableStack.remove(this.safeCallSubjectVariableStack.size() - 1);
        }
        return (T)result2;
    }

    @NotNull
    public final IrFunction returnTarget(@NotNull FirReturnExpression expression2, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        IrFunction irFunction2;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)declarationStorage, (String)"declarationStorage");
        FirFunction firTarget = expression2.getTarget().getLabeledElement();
        if (firTarget instanceof FirConstructor) {
            irFunction2 = Fir2IrDeclarationStorage.getCachedIrConstructor$default(declarationStorage, (FirConstructor)firTarget, null, 2, null);
        } else if (firTarget instanceof FirPropertyAccessor) {
            IrFunction answer = null;
            for (Pair pair : CollectionsKt.asReversedMutable(this.propertyStack)) {
                IrProperty property2 = (IrProperty)pair.component1();
                FirProperty firProperty = (FirProperty)pair.component2();
                FirProperty firProperty2 = firProperty;
                if ((firProperty2 == null ? null : firProperty2.getGetter()) == firTarget) {
                    answer = property2.getGetter();
                    continue;
                }
                firProperty2 = firProperty;
                if ((firProperty2 == null ? null : firProperty2.getSetter()) != firTarget) continue;
                answer = property2.getSetter();
            }
            irFunction2 = answer;
        } else {
            irFunction2 = declarationStorage.getCachedIrFunction(firTarget);
        }
        IrFunction irTarget = irFunction2;
        for (IrFunction potentialTarget : CollectionsKt.asReversedMutable(this.functionStack)) {
            if (!Intrinsics.areEqual((Object)potentialTarget, (Object)irTarget)) continue;
            return potentialTarget;
        }
        return (IrFunction)CollectionsKt.last(this.functionStack);
    }

    @Nullable
    public final IrDeclarationParent parent() {
        return (IrDeclarationParent)CollectionsKt.lastOrNull(this.parentStack);
    }

    @Nullable
    public final IrValueParameter dispatchReceiverParameter(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        for (IrFunction function2 : CollectionsKt.asReversedMutable(this.functionStack)) {
            IrValueParameter irValueParameter;
            IrValueParameter irValueParameter2;
            if (!Intrinsics.areEqual((Object)IrUtilsKt.getParentClassOrNull(function2), (Object)irClass2)) continue;
            if (function2 instanceof IrConstructor && irClass2.isInner() && (irValueParameter2 = irClass2.getThisReceiver()) != null) {
                IrValueParameter irValueParameter3;
                IrValueParameter it = irValueParameter3 = irValueParameter2;
                boolean bl = false;
                return it;
            }
            irValueParameter2 = function2.getDispatchReceiverParameter();
            if (irValueParameter2 == null) continue;
            IrValueParameter it = irValueParameter = irValueParameter2;
            boolean bl = false;
            return it;
        }
        return irClass2.getThisReceiver();
    }

    @Nullable
    public final IrClass lastClass() {
        return (IrClass)CollectionsKt.lastOrNull(this.classStack);
    }

    @NotNull
    public final IrVariable lastWhenSubject() {
        return (IrVariable)CollectionsKt.last(this.whenSubjectVariableStack);
    }

    @NotNull
    public final IrVariable lastSafeCallSubject() {
        return (IrVariable)CollectionsKt.last(this.safeCallSubjectVariableStack);
    }
}

