/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnderscoreUsageWithoutBackticks;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnderscoreChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "singleUnderscore", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkResolvedToUnderscoreNamedCatchParameter", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "checkers"})
public final class FirUnderscoreChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirUnderscoreChecker INSTANCE = new FirUnderscoreChecker();
    @NotNull
    private static final Name singleUnderscore;

    private FirUnderscoreChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirStatement firStatement = expression2;
        if (firStatement instanceof FirResolvable) {
            FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(((FirResolvable)((Object)expression2)).getCalleeReference().getSource(), context2, reporter2, true);
            this.checkResolvedToUnderscoreNamedCatchParameter((FirResolvable)((Object)expression2), context2, reporter2);
        } else if (firStatement instanceof FirResolvedQualifier) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ((FirResolvedQualifier)expression2).getNonFatalDiagnostics();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ConeUnderscoreUsageWithoutBackticks)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (ConeUnderscoreUsageWithoutBackticks reservedUnderscoreDiagnostic : (List)destination$iv$iv) {
                DiagnosticReporterKt.reportOn$default(reporter2, reservedUnderscoreDiagnostic.getSource(), FirErrors.INSTANCE.getUNDERSCORE_USAGE_WITHOUT_BACKTICKS(), context2, null, 8, null);
            }
        }
    }

    private final void checkResolvedToUnderscoreNamedCatchParameter(FirResolvable expression2, CheckerContext context2, DiagnosticReporter reporter2) {
        SourceNavigator sourceNavigator;
        FirReference calleeReference = expression2.getCalleeReference();
        FirCallableSymbol<?> symbol2 = FirExpressionUtilKt.toResolvedCallableSymbol(calleeReference);
        SourceNavigator $this$checkResolvedToUnderscoreNamedCatchParameter_u24lambda_u2d0 = sourceNavigator = SourceNavigator.Companion.forElement(expression2);
        boolean bl = false;
        if (symbol2 instanceof FirValueParameterSymbol && $this$checkResolvedToUnderscoreNamedCatchParameter_u24lambda_u2d0.isCatchElementParameter((FirValueParameterSymbol)symbol2) && Intrinsics.areEqual((Object)symbol2.getName(), (Object)singleUnderscore)) {
            DiagnosticReporterKt.reportOn$default(reporter2, calleeReference.getSource(), FirErrors.INSTANCE.getRESOLVED_TO_UNDERSCORE_NAMED_CATCH_PARAMETER(), context2, null, 8, null);
        }
    }

    static {
        Name name2 = Name.identifier("_");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"_\")");
        singleUnderscore = name2;
    }
}

