/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory2;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirOperationNameConventions;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAssignmentOperatorCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirAssignmentOperatorCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirAssignmentOperatorCallChecker INSTANCE = new FirAssignmentOperatorCallChecker();

    private FirAssignmentOperatorCallChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        FirBasedSymbol<?> firBasedSymbol;
        FirResolvedNamedReference firResolvedNamedReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        Object object = expression2.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference resolvedCallee = firResolvedNamedReference;
        FirBasedSymbol<?> firBasedSymbol2 = resolvedCallee.getResolvedSymbol();
        Object object2 = object = firBasedSymbol2 instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firBasedSymbol2 : null;
        if (object == null) {
            return;
        }
        Object resolvedCalleeSymbol = object;
        Name resolvedCalleeName = ((FirCallableSymbol)resolvedCalleeSymbol).getName();
        if (expression2.getOrigin() != FirFunctionCallOrigin.Operator || !(firBasedSymbol = (firBasedSymbol2 = FirOperationNameConventions.INSTANCE.getASSIGNMENT_NAMES())).containsKey(resolvedCalleeName)) {
            return;
        }
        if (!ConeTypeUtilsKt.isUnit(FirTypeUtilsKt.getConeType(expression2.getTypeRef()))) {
            FirSourceElement firSourceElement = expression2.getSource();
            FirDiagnosticFactory2<FirNamedFunctionSymbol, String> firDiagnosticFactory2 = FirErrors.INSTANCE.getASSIGNMENT_OPERATOR_SHOULD_RETURN_UNIT();
            FirOperation firOperation = FirOperationNameConventions.INSTANCE.getASSIGNMENT_NAMES().get(resolvedCalleeName);
            Intrinsics.checkNotNull((Object)((Object)firOperation));
            DiagnosticReporterKt.reportOn$default(reporter2, firSourceElement, firDiagnosticFactory2, resolvedCalleeSymbol, (Object)firOperation.getOperator(), context2, null, 32, null);
        }
    }
}

