/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAbstractSuperCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirAbstractSuperCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirAbstractSuperCallChecker INSTANCE = new FirAbstractSuperCallChecker();

    private FirAbstractSuperCallChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        FirElement firElement;
        FirCallableSymbol<?> $this$findClosest_u24default$iv;
        FirPureAbstractElement $this$safeAs$iv;
        block13: {
            FirSuperReference firSuperReference;
            FirQualifiedAccessExpression firQualifiedAccessExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
            FirExpression $this$safeAs$iv2 = expression2.getExplicitReceiver();
            boolean $i$f$safeAs = false;
            FirExpression firExpression2 = $this$safeAs$iv2;
            if (!(firExpression2 instanceof FirQualifiedAccessExpression)) {
                firExpression2 = null;
            }
            $this$safeAs$iv = (firQualifiedAccessExpression = (FirQualifiedAccessExpression)firExpression2) == null ? null : firQualifiedAccessExpression.getCalleeReference();
            boolean $i$f$safeAs2 = false;
            FirPureAbstractElement firPureAbstractElement = $this$safeAs$iv;
            if (!(firPureAbstractElement instanceof FirSuperReference)) {
                firPureAbstractElement = null;
            }
            if ((firSuperReference = (FirSuperReference)firPureAbstractElement) == null) {
                return;
            }
            $this$findClosest_u24default$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed(((CheckerContext)((Object)$this$findClosest_u24default$iv)).getContainingDeclarations())) {
                FirElement firElement2;
                FirElement firElement3;
                FirElement firElement4;
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirRegularClass)) {
                    firDeclaration = null;
                }
                if ((firElement4 = (FirElement)((FirRegularClass)firDeclaration)) == null) {
                    firElement3 = null;
                } else {
                    FirElement firElement5;
                    FirElement firElement6;
                    FirElement it = firElement6 = (firElement5 = firElement4);
                    firElement3 = firElement2 = true ? firElement5 : null;
                }
                if (firElement2 == null) continue;
                firElement = firElement2;
                break block13;
            }
            firElement = null;
        }
        $this$safeAs$iv = (FirRegularClass)firElement;
        if ($this$safeAs$iv == null) {
            return;
        }
        FirPureAbstractElement closestClass = $this$safeAs$iv;
        if (((FirRegularClass)closestClass).getClassKind() == ClassKind.CLASS) {
            FirRegularClassSymbol $i$f$safeAs;
            $this$findClosest_u24default$iv = FirExpressionUtilKt.toResolvedCallableSymbol(expression2);
            if ($this$findClosest_u24default$iv == null) {
                return;
            }
            FirCallableSymbol<?> declarationSymbol = $this$findClosest_u24default$iv;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(declarationSymbol);
            FirClassLikeSymbol<?> $i$f$findClosest = coneClassLikeLookupTag == null ? null : LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession());
            FirRegularClassSymbol firRegularClassSymbol = $i$f$safeAs = $i$f$findClosest instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)$i$f$findClosest : null;
            if ($i$f$safeAs == null) {
                return;
            }
            FirRegularClassSymbol containingClassSymbol = $i$f$safeAs;
            Object $this$isAbstract$iv = containingClassSymbol;
            boolean $i$f$isAbstract = false;
            if (((FirRegularClassSymbol)$this$isAbstract$iv).getResolvedStatus().getModality() == Modality.ABSTRACT) {
                $this$isAbstract$iv = declarationSymbol;
                $i$f$isAbstract = false;
                if (((FirCallableSymbol)$this$isAbstract$iv).getResolvedStatus().getModality() == Modality.ABSTRACT) {
                    DiagnosticReporterKt.reportOn$default(reporter2, expression2.getCalleeReference().getSource(), FirErrors.INSTANCE.getABSTRACT_SUPER_CALL(), context2, null, 8, null);
                }
            }
        }
    }
}

