/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.ClassSymbolAndProjections;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMap;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a8\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u001a\u0010\u0004\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u001aD\u0010\u000b\u001a\u00020\f2\u001a\u0010\u0004\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"buildDeepSubstitutionMultimap", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ClassSymbolAndProjections;", "firTypeRefClasses", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "checkInconsistentTypeParameters", "", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "isValues", "", "checkers"})
public final class FirInconsistentTypeParameterHelpersKt {
    public static final void checkInconsistentTypeParameters(@NotNull List<? extends Pair<? extends FirTypeRef, FirRegularClassSymbol>> firTypeRefClasses, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2, @Nullable FirSourceElement source, boolean isValues) {
        Intrinsics.checkNotNullParameter(firTypeRefClasses, (String)"firTypeRefClasses");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        Map<FirTypeParameterSymbol, ClassSymbolAndProjections> result2 = FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap(firTypeRefClasses, context2);
        for (Map.Entry<FirTypeParameterSymbol, ClassSymbolAndProjections> entry : result2.entrySet()) {
            FirTypeParameterSymbol typeParameterSymbol = entry.getKey();
            ClassSymbolAndProjections typeAndProjections = entry.getValue();
            List<ConeKotlinType> projections = typeAndProjections.getProjections();
            if (projections.size() <= 1) continue;
            if (isValues) {
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getINCONSISTENT_TYPE_PARAMETER_VALUES(), (Object)typeParameterSymbol, (Object)typeAndProjections.getClassSymbol(), projections, context2, null, 64, null);
                continue;
            }
            DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getINCONSISTENT_TYPE_PARAMETER_BOUNDS(), (Object)typeParameterSymbol, (Object)typeAndProjections.getClassSymbol(), projections, context2, null, 64, null);
        }
    }

    private static final Map<FirTypeParameterSymbol, ClassSymbolAndProjections> buildDeepSubstitutionMultimap(List<? extends Pair<? extends FirTypeRef, FirRegularClassSymbol>> firTypeRefClasses, CheckerContext context2) {
        Map result2 = new LinkedHashMap();
        Map substitution = new LinkedHashMap();
        FirSession session2 = context2.getSession();
        ConeInferenceContext typeContext = SessionUtilsKt.getTypeContext(session2);
        for (Pair<? extends FirTypeRef, FirRegularClassSymbol> pair : firTypeRefClasses) {
            ConeTypeProjection[] coneTypeProjectionArray;
            FirTypeRef firTypeRef = (FirTypeRef)pair.getFirst();
            if (firTypeRef == null) {
                coneTypeProjectionArray = null;
            } else {
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(firTypeRef);
                ConeKotlinType coneKotlinType2 = TypeExpansionUtilsKt.fullyExpandedType(coneKotlinType, session2);
                coneTypeProjectionArray = coneKotlinType2.getTypeArguments();
            }
            FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap$fillInDeepSubstitutor(substitution, session2, result2, context2, typeContext, coneTypeProjectionArray, (FirRegularClassSymbol)pair.getSecond());
        }
        return result2;
    }

    private static final void buildDeepSubstitutionMultimap$fillInDeepSubstitutor(Map<FirTypeParameterSymbol, ConeKotlinType> substitution, FirSession session2, Map<FirTypeParameterSymbol, ClassSymbolAndProjections> result2, CheckerContext $context, ConeInferenceContext typeContext, ConeTypeProjection[] typeArguments2, FirRegularClassSymbol classSymbol) {
        if (typeArguments2 != null) {
            List<FirTypeParameterSymbol> typeParameterSymbols = classSymbol.getTypeParameterSymbols();
            int n = typeArguments2.length;
            int n2 = typeParameterSymbols.size();
            int count = Math.min(n, n2);
            n = 0;
            while (n < count) {
                boolean bl;
                List projections;
                ConeKotlinType substitutedType;
                block11: {
                    int index2;
                    ConeTypeProjection typeArgument;
                    ConeTypeProjection coneTypeProjection;
                    ConeTypeProjection substitutedArgument;
                    ConeKotlinType coneKotlinType;
                    if ((coneKotlinType = ConeTypesKt.getType(substitutedArgument = (coneTypeProjection = new ConeSubstitutorByMap(substitution, session2).substituteArgument(typeArgument = typeArguments2[index2 = n++])) == null ? typeArgument : coneTypeProjection)) == null) continue;
                    substitutedType = coneKotlinType;
                    FirTypeParameterSymbol typeParameterSymbol = typeParameterSymbols.get(index2);
                    Map<FirTypeParameterSymbol, ConeKotlinType> map = substitution;
                    map.put(typeParameterSymbol, substitutedType);
                    ClassSymbolAndProjections classSymbolAndProjections = result2.get(typeParameterSymbol);
                    projections = null;
                    if (classSymbolAndProjections == null) {
                        projections = new ArrayList();
                        classSymbolAndProjections = new ClassSymbolAndProjections(classSymbol, projections);
                        Map<FirTypeParameterSymbol, ClassSymbolAndProjections> map2 = result2;
                        map2.put(typeParameterSymbol, classSymbolAndProjections);
                    } else {
                        projections = classSymbolAndProjections.getProjections();
                    }
                    Iterable $this$all$iv = projections;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            ConeKotlinType it = (ConeKotlinType)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)substitutedType) && !AbstractTypeChecker.equalTypes$default(AbstractTypeChecker.INSTANCE, typeContext, it, substitutedType, false, 8, null)) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                projections.add(substitutedType);
            }
        }
        for (FirResolvedTypeRef superTypeRef : classSymbol.getResolvedSuperTypeRefs()) {
            FirRegularClassSymbol superClassSymbol;
            ConeKotlinType fullyExpandedType2;
            boolean bl;
            CheckerContext it;
            List<String> list2;
            FirAnnotationContainer firAnnotationContainer;
            boolean $i$f$withSuppressedDiagnostics = false;
            FirAnnotationContainer firAnnotationContainer2 = firAnnotationContainer = (FirElement)superTypeRef instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)superTypeRef) : null;
            if (firAnnotationContainer == null) {
                list2 = null;
            } else {
                FirAnnotationContainer firAnnotationContainer3;
                FirAnnotationContainer it$iv = firAnnotationContainer3 = firAnnotationContainer;
                boolean bl3 = false;
                list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
            }
            List<String> arguments$iv = list2;
            if (arguments$iv != null) {
                it = $context.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                bl = false;
                fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(superTypeRef), session2);
                superClassSymbol = FirHelpersKt.toRegularClassSymbol(fullyExpandedType2, session2);
                if (ConeTypeUtilsKt.isEnum(fullyExpandedType2) || superClassSymbol == null) continue;
                FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap$fillInDeepSubstitutor(substitution, session2, result2, $context, typeContext, fullyExpandedType2.getTypeArguments(), superClassSymbol);
                continue;
            }
            it = $context;
            bl = false;
            fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(superTypeRef), session2);
            superClassSymbol = FirHelpersKt.toRegularClassSymbol(fullyExpandedType2, session2);
            if (ConeTypeUtilsKt.isEnum(fullyExpandedType2) || superClassSymbol == null) continue;
            FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap$fillInDeepSubstitutor(substitution, session2, result2, $context, typeContext, fullyExpandedType2.getTypeArguments(), superClassSymbol);
        }
    }
}

