/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackValue;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005\u001a,\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u001a\u001e\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a.\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0012\u001a\u001e\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a)\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u001e*\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\u0006\u0010 \u001a\u00020\u0012\u00a2\u0006\u0002\u0010!\u001a*\u0010\"\u001a\n\u0012\u0004\u0012\u0002H\u001d\u0018\u00010\u0014\"\b\b\u0000\u0010\u001d*\u00020\u001e*\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\u0006\u0010#\u001a\u00020\u0012\u001a2\u0010\"\u001a\n\u0012\u0004\u0012\u0002H\u001d\u0018\u00010\u0014\"\b\b\u0000\u0010\u001d*\u00020\u001e*\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012\u001a<\u0010&\u001a\u00020\u0012\"\b\b\u0000\u0010\u001d*\u00020\u001e*\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u001d0(2\u0006\u0010#\u001a\u00020\u00122\b\b\u0002\u0010)\u001a\u00020\u0012H\u0002\u001a!\u0010\u000b\u001a\u0004\u0018\u0001H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u001e*\b\u0012\u0004\u0012\u0002H\u001d0\u001f\u00a2\u0006\u0002\u0010*\u00a8\u0006+"}, d2={"generateLoadInstructions", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "location", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "savedStackDescriptor", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "generateStoreInstructions", "getPopInstruction", "Lorg/jetbrains/org/objectweb/asm/tree/InsnNode;", "top", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "removeAlwaysFalseIfeq", "node", "replaceAlwaysTrueIfeqWithGoto", "replaceMarkerWithPops", "expectedStackSize", "", "stackContent", "", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackValue;", "restoreStack", "restoreStackWithReturnValue", "nodeToReplace", "returnValue", "returnValueLocalVarIndex", "saveStack", "peek", "V", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "offset", "(Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;I)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "peekWords", "size", "size1", "size2", "peekWordsTo", "dest", "", "offset0", "(Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "backend"})
public final class StackTransformationUtilsKt {
    @Nullable
    public static final <V extends Value> V top(@NotNull Frame<V> $this$top) {
        Intrinsics.checkNotNullParameter($this$top, (String)"<this>");
        return StackTransformationUtilsKt.peek($this$top, 0);
    }

    @Nullable
    public static final <V extends Value> V peek(@NotNull Frame<V> $this$peek, int offset2) {
        Intrinsics.checkNotNullParameter($this$peek, (String)"<this>");
        return (V)($this$peek.getStackSize() > offset2 ? $this$peek.getStack($this$peek.getStackSize() - offset2 - 1) : null);
    }

    private static final <V extends Value> int peekWordsTo(Frame<V> $this$peekWordsTo, List<V> dest, int size, int offset0) {
        int totalSize;
        V value2;
        int offset2 = offset0;
        for (totalSize = 0; totalSize < size; totalSize += value2.getSize()) {
            int n = offset2;
            offset2 = n + 1;
            V v = StackTransformationUtilsKt.peek($this$peekWordsTo, n);
            if (v == null) {
                return -1;
            }
            value2 = v;
            dest.add(value2);
        }
        if (totalSize > size) {
            return -1;
        }
        return offset2;
    }

    static /* synthetic */ int peekWordsTo$default(Frame frame, List list2, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return StackTransformationUtilsKt.peekWordsTo(frame, list2, n, n2);
    }

    @Nullable
    public static final <V extends Value> List<V> peekWords(@NotNull Frame<V> $this$peekWords, int size) {
        Intrinsics.checkNotNullParameter($this$peekWords, (String)"<this>");
        ArrayList result2 = new ArrayList(size);
        return StackTransformationUtilsKt.peekWordsTo$default($this$peekWords, result2, size, 0, 4, null) < 0 ? null : (List)result2;
    }

    @Nullable
    public static final <V extends Value> List<V> peekWords(@NotNull Frame<V> $this$peekWords, int size1, int size2) {
        Intrinsics.checkNotNullParameter($this$peekWords, (String)"<this>");
        ArrayList result2 = new ArrayList(size1 + size2);
        int offset2 = StackTransformationUtilsKt.peekWordsTo$default($this$peekWords, result2, size1, 0, 4, null);
        if (offset2 < 0) {
            return null;
        }
        if (StackTransformationUtilsKt.peekWordsTo($this$peekWords, result2, size2, offset2) < 0) {
            return null;
        }
        return result2;
    }

    public static final void saveStack(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode nodeToReplace, @NotNull SavedStackDescriptor savedStackDescriptor) {
        InsnList insnList;
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)nodeToReplace, (String)"nodeToReplace");
        Intrinsics.checkNotNullParameter((Object)savedStackDescriptor, (String)"savedStackDescriptor");
        InsnList $this$saveStack_u24lambda_u2d0 = insnList = methodNode.instructions;
        boolean bl = false;
        StackTransformationUtilsKt.generateStoreInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        $this$saveStack_u24lambda_u2d0.remove(nodeToReplace);
    }

    public static final void restoreStack(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location2, @NotNull SavedStackDescriptor savedStackDescriptor) {
        InsnList insnList;
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)savedStackDescriptor, (String)"savedStackDescriptor");
        InsnList $this$restoreStack_u24lambda_u2d1 = insnList = methodNode.instructions;
        boolean bl = false;
        StackTransformationUtilsKt.generateLoadInstructions(methodNode, location2, savedStackDescriptor);
        $this$restoreStack_u24lambda_u2d1.remove(location2);
    }

    public static final void restoreStackWithReturnValue(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode nodeToReplace, @NotNull SavedStackDescriptor savedStackDescriptor, @NotNull FixStackValue returnValue, int returnValueLocalVarIndex) {
        InsnList insnList;
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)nodeToReplace, (String)"nodeToReplace");
        Intrinsics.checkNotNullParameter((Object)savedStackDescriptor, (String)"savedStackDescriptor");
        Intrinsics.checkNotNullParameter((Object)((Object)returnValue), (String)"returnValue");
        InsnList $this$restoreStackWithReturnValue_u24lambda_u2d2 = insnList = methodNode.instructions;
        boolean bl = false;
        $this$restoreStackWithReturnValue_u24lambda_u2d2.insertBefore(nodeToReplace, (AbstractInsnNode)new VarInsnNode(returnValue.getStoreOpcode(), returnValueLocalVarIndex));
        StackTransformationUtilsKt.generateLoadInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        $this$restoreStackWithReturnValue_u24lambda_u2d2.insertBefore(nodeToReplace, (AbstractInsnNode)new VarInsnNode(returnValue.getLoadOpcode(), returnValueLocalVarIndex));
        $this$restoreStackWithReturnValue_u24lambda_u2d2.remove(nodeToReplace);
    }

    public static final void generateLoadInstructions(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location2, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)savedStackDescriptor, (String)"savedStackDescriptor");
        int localVarIndex = savedStackDescriptor.getFirstLocalVarIndex();
        for (FixStackValue value2 : savedStackDescriptor.getSavedValues()) {
            methodNode.instructions.insertBefore(location2, (AbstractInsnNode)new VarInsnNode(value2.getLoadOpcode(), localVarIndex));
            localVarIndex += value2.getSize();
        }
    }

    public static final void generateStoreInstructions(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location2, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)savedStackDescriptor, (String)"savedStackDescriptor");
        int localVarIndex = savedStackDescriptor.getFirstUnusedLocalVarIndex();
        for (FixStackValue value2 : CollectionsKt.asReversed(savedStackDescriptor.getSavedValues())) {
            methodNode.instructions.insertBefore(location2, (AbstractInsnNode)new VarInsnNode(value2.getStoreOpcode(), localVarIndex -= value2.getSize()));
        }
    }

    @NotNull
    public static final InsnNode getPopInstruction(@NotNull BasicValue top) {
        int n;
        Intrinsics.checkNotNullParameter((Object)top, (String)"top");
        int n2 = top.getSize();
        switch (n2) {
            case 1: {
                n = 87;
                break;
            }
            case 2: {
                n = 88;
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected value type size");
            }
        }
        return new InsnNode(n);
    }

    public static final void removeAlwaysFalseIfeq(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node) {
        InsnList insnList;
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        InsnList $this$removeAlwaysFalseIfeq_u24lambda_u2d3 = insnList = methodNode.instructions;
        boolean bl = false;
        $this$removeAlwaysFalseIfeq_u24lambda_u2d3.remove(node.getNext());
        $this$removeAlwaysFalseIfeq_u24lambda_u2d3.remove(node);
    }

    public static final void replaceAlwaysTrueIfeqWithGoto(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node) {
        InsnList insnList;
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        InsnList $this$replaceAlwaysTrueIfeqWithGoto_u24lambda_u2d4 = insnList = methodNode.instructions;
        boolean bl = false;
        AbstractInsnNode abstractInsnNode = node.getNext();
        if (abstractInsnNode == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        }
        JumpInsnNode next = (JumpInsnNode)abstractInsnNode;
        $this$replaceAlwaysTrueIfeqWithGoto_u24lambda_u2d4.insertBefore(node, (AbstractInsnNode)new JumpInsnNode(167, next.label));
        $this$replaceAlwaysTrueIfeqWithGoto_u24lambda_u2d4.remove(node);
        $this$replaceAlwaysTrueIfeqWithGoto_u24lambda_u2d4.remove((AbstractInsnNode)next);
    }

    public static final void replaceMarkerWithPops(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node, int expectedStackSize, @NotNull List<? extends FixStackValue> stackContent) {
        InsnList insnList;
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(stackContent, (String)"stackContent");
        InsnList $this$replaceMarkerWithPops_u24lambda_u2d5 = insnList = methodNode.instructions;
        boolean bl = false;
        for (FixStackValue fixStackValue : stackContent.subList(expectedStackSize, stackContent.size())) {
            $this$replaceMarkerWithPops_u24lambda_u2d5.insert(node, (AbstractInsnNode)new InsnNode(fixStackValue.getPopOpcode()));
        }
        $this$replaceMarkerWithPops_u24lambda_u2d5.remove(node);
    }
}

